<?php
use \Firebase\JWT\JWT; 

class Api_model extends CI_model {

    private $role;

    function __construct() {
        parent::__construct();
        $this->load->helper('date');

        if (ENVIRONMENT == 'production') {
            $this->db->save_queries = FALSE;
        }
        date_default_timezone_set('Asia/Kolkata');
		$date = date('Y-m-d H:i:s', time());
        
        $this->role 		= $this->session->userdata('role');
        $this->user_name 	= $this->session->userdata('user_name');
        
        require(APPPATH . 'libraries/php_jwt/ExpiredException.php');
		require(APPPATH . 'libraries/php_jwt/BeforeValidException.php');
		require(APPPATH . 'libraries/php_jwt/SignatureInvalidException.php');
       	require(APPPATH . 'libraries/php_jwt/JWT.php'); 
		require(APPPATH . 'libraries/constants.php'); 
		
		
		
		/**
		* The function generates jwt token,accept two parameter phone number and institute code.
		* If it is needed we can make it reusable. 
		* 
		* @param undefined $user_id
		* 
		* @return
		*/
		function generateJWT($user_id,$user_name,$key=JWT_KEY){
			
			$tokenId    = base64_encode(mcrypt_create_iv(32));
			$issuedAt   = time();
			$notBefore  = $issuedAt;            
			$expire     = $notBefore + (1*60*30);            // Adding 60 seconds 
			$serverName = "server";
			$data = [
					'iat'  => $issuedAt,         // Issued at: time when the token was generated
					'jti'  => $tokenId,          // Json Token Id: an unique identifier for the token
					'iss'  => $serverName,       // Issuer
					'nbf'  => $notBefore,        // Not before
					'exp'  => $expire,           // Expire
					'data' => [                  // Data related to the signer user
						'id'   => $user_id, // userid from the users table
						'ins'=>$user_name
					]
				];
			$secretKey = $key;

			$jwt = JWT::encode(
					$data,      //Data to be encoded in the JWT
					$secretKey, // The signing key
					'HS512'     // Algorithm used to sign the token, see https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40#section-3
			);
			//print_r($jwt);die();
			return $jwt;
		}
    }
	
	

    public function diff_in_month($from, $to) {
        $frmDate = date_create($from);
        $toDate = date_create($to);
        $difference = date_diff($toDate, $frmDate, true);
        $month = $difference->format("%a") / 30;
        return $month;
    }
	//to get group data
	public function group_data(){
        $this->db->select('*');
		$this->db->from('group_master');
		$this->db->where('group_code',$this->session->userdata('group_code'));
		$this->db->where('record_status',1);
		$result = $this->db->get();
		$row = $result->result_array();
		$operation_tbl = $row[0]['operation_tbl'];
		$operation_col = $row [0]['operation_col'];
		$exicution_col = $row [0]['exicution_col'];
		$this->db->select('d.'.$exicution_col.' as id');
		$this->db->from('group_master gm');
		$this->db->join('group_mapping gmap','gm.group_code = gmap.group_code','inner');
		$this->db->join($operation_tbl.' as d','gmap.map_value_code = d.'.$operation_col,'inner');
		$this->db->where('gm.record_status',1);
		$this->db->where('gm.group_code',$this->session->userdata('group_code'));
		$result1 = $this->db->get();
		$row_val = $result1->result_array();
		$id = '';
		foreach($row_val as $row1 ){
			$id = $id."'".$row1['id']."',";
		}
		$id=rtrim($id,", ");
		return $id;
	}
    /**
     * 	Generate random registration_no 
     */
    public function rand_number($length) {
        $chars = "0123456789";
        return substr(str_shuffle($chars), 0, $length);
    }
	
    public function technician($data, $op, $stage = null) {
        date_default_timezone_set('Asia/Kolkata');
		$date = date('Y-m-d H:i:s', time());
		
        switch ($op) {
			case 'Technician_login':
				//echo "entered";
				$user_name = $data['username'];
				$password  = $data['password'];
				
				$login_check_Qry = $this->db->query("SELECT user_code,user_display_name,email,phone_number,primary_role,record_status FROM user_master WHERE user_name='$user_name' AND PASSWORD= SHA2(CONCAT('$user_name','#','$password'),512)");
	            $result = $login_check_Qry->result_array();
				
				return $result;
			break;
			
			case 'get_profile_details_data':
			
				$data_tech_phone_no = $data['tech_phone_no'];
				
				$this->db->from('technician_master');
				$this->db->select('phone_no,name,mail_id,address');
				$this->db->where('phone_no',$data_tech_phone_no);
				
				$result = $this->db->get()->result_array();
				return $result;
			
			break;
			
			case 'update_profile_details':
			
				$technician_name = $data[0]['tech_name'];
				$technician_mobile_no = $data[0]['mobile_no'];
				$technician_email_id = $data[0]['email_id'];
				$technician_address = $data[0]['address'];
				
				$tech_profile_update_data = array(
					"name"		=>$technician_name,
					"phone_no"	=>$technician_mobile_no,
					"mail_id"	=>$technician_email_id,
					"address"	=>$technician_address,
				);
				$this->db->where('phone_no',$technician_mobile_no);
				$inserted_profile_update_data = $this->db->update('technician_master',$tech_profile_update_data);
				
				if($inserted_profile_update_data){
					
					$dbstatus = TRUE;
				   	$dbmessage = 'Profile Data Updated Successfully';
					
				}else{
					
					$dbstatus = false;
				   	$dbmessage = 'Failed to update data.';
				}
				
				return array('status'=>$dbstatus,'msg'=>$dbmessage);
			
			
			break;
			
			case 'Technician_installation_data':
				$data_tech_phone_no = $data['tech_phone_no'];
				
				$get_installation_count_qry = $this->db->query("SELECT MAX(CASE WHEN STATUS='open' THEN cnt ELSE 0 END) AS open_status,MAX(CASE WHEN STATUS='closed' THEN cnt ELSE 0 END) AS closed_status
													FROM(
													SELECT COUNT(*) AS cnt,STATUS FROM sup_tech_map WHERE technician_mobile_number = '$data_tech_phone_no' GROUP BY STATUS) a");
	            $result = $get_installation_count_qry->result_array();
				return $result;
			break;
			
			
			
				// Modified On 24-06-2019
			case 'get_total_ticket_count_data':
				$data_tech_phone_no = $data['tech_phone_no'];
				
				$get_installation_count_qry = $this->db->query("SELECT s_cnt,c_cnt
																FROM  (SELECT COUNT(*) AS s_cnt FROM schedule_ticket WHERE technician_id = '$data_tech_phone_no' AND tkt_status='OPEN' ) a,
																(SELECT COUNT(*) AS c_cnt FROM raise_ticket WHERE technician_id = '$data_tech_phone_no' AND ticket_status='OPEN' )b");
	            $result = $get_installation_count_qry->result_array();
				return $result;
			break;
			
			case 'installation_details':
				$data_status = $data['status'];
				$data_tech_phone_no = $data['tech_phone_no'];
				
				$this->db->from('sup_tech_map sm');
				$this->db->select('sm.*,th.tr_customer_id,c.name1,c.name2,c.name3,th.habitation,th.landmark,th.date_of_installation,IFNULL(d.gp_name,"NA") AS gp_name,IFNULL(e.village_name,"NA") AS village_name,dis.district_name,IFNULL(blk.block_name,"NA") AS block_name,sch.scheme_name');
				$this->db->join('transaction_header th','sm.transaction_header_id=th.id','Left');
				$this->db->join('customer c',' th.tr_customer_id=c.id','Left');
				$this->db->join('district_master dis',' th.district=dis.district_code','Left');
				$this->db->join('block_master blk',' th.cd_block = blk.block_code','Left');
				$this->db->join('scheme_header sch',' th.tr_scheme_id = sch.pk_scheme_code','Left');
				$this->db->join('gp_master d',' th.gp=d.pk_gp_code','Left');
				$this->db->join('village_master e',' th.revenue_village=e.pk_village_code','Left');
				$this->db->where('sm.technician_mobile_number',$data_tech_phone_no);
				$this->db->where('sm.status',$data_status);
				
				$result = $this->db->get()->result_array();
				return $result;
			break;
			
			
			case 'open_installation_details_data':
			
				$data_trans_header_id = $data['trans_header_id'];
				
				$this->db->from('transaction_header a');
				$this->db->select('a.id,a.tr_scheme_id,b.state_name,c.district_name,d.block_name,e.gp_name,f.village_name,CONCAT(g.name1,g.name2,g.name3) AS customer_name,g.phone1,g.mobile1,h.instal_cls_name,i.scheme_name');
				$this->db->join('state_master b','a.state = b.state_code','Left');
				$this->db->join('district_master c','a.district = c.district_code','Left');
				$this->db->join('block_master d','a.cd_block = d.block_code','Left');
				$this->db->join('gp_master e','a.gp = e.pk_gp_code','Left');
				$this->db->join('village_master f','a.revenue_village = f.pk_village_code','Left');
				$this->db->join('customer g','a.tr_customer_id = g.id','Left');
				$this->db->join('installation_class_header h','a.tr_instal_id = h.id','Left');
				$this->db->join('scheme_header i','a.tr_scheme_id = i.pk_scheme_code','Left');
				
				$this->db->where('a.id',$data_trans_header_id);
				
				$result = $this->db->get()->result_array();
				return $result;
			break;
			
			case 'component_details_data':
				$data_trans_header_id = $data['trans_header_id'];
				
				$component_details_Qry = $this->db->query("SELECT tcv.sl_no, c.component_name, c.id component_id,GROUP_CONCAT(CONCAT(cd.attribute,'_',gcd.description,'_',tcv.id)) attribute_name, 
															GROUP_CONCAT(tcv.attribute_values) attribute_value,  
															GROUP_CONCAT(cd.id) component_details_id 
															FROM transaction_details td 
															INNER JOIN transaction_component_value tcv ON td.id = tcv.transaction_details_id AND td.tr_header_id = '".$data_trans_header_id."'
															INNER JOIN components_details cd ON tcv.components_detail_id = cd.attribute AND td.tr_component_id=cd.components_id
															INNER JOIN gen_code_desc gcd ON gcd.gen_code = cd.attribute AND gen_code_group = 'ATTRIBUTE'
															INNER JOIN components c ON c.id = td.tr_component_id
															GROUP BY tcv.sl_no, c.component_name, c.id
															ORDER BY c.id,tcv.sl_no ASC");
	            $result = $component_details_Qry->result_array();
				
				return $result;
			
			
			break;
			
			
			case 'component_details_image_data':
				$data_trans_header_id = $data['trans_header_id'];
				
				$this->db->from('image_upload_master a');
				$this->db->select('id,image_name');
				//$this->db->where('a.id',$data_trans_header_id);
				
				$result = $this->db->get()->result_array();
				return $result;
				
				return $result;
			
			
			break;
			
			case 'submit_component_details_data':
				
				$tempData1 = html_entity_decode($data['componentData']);
				$tempData2 = html_entity_decode($data['attributeData']);
				$component_data = json_decode($tempData1);
				$attribute_data = json_decode($tempData2);
				
				$land_line_no = $component_data[0]->land_line_no;
				$mobile1 = $component_data[0]->mobile1;
				$adharCard_no = $component_data[0]->adharCard_no;
				$alternateIdNo = $component_data[0]->alternateIdNo;
				$trans_header_id = $component_data[0]->trans_header_id;
				$customer_image = $component_data[0]->customer_image;
				$customer_id_photo = $component_data[0]->customer_id_photo;
				$installation_image = $component_data[0]->installation_image;
				$fatherName = $component_data[0]->fatherName;
				$Email = $component_data[0]->Email;
				$area = $component_data[0]->area;
				$landmark = $component_data[0]->landmark;
				$plot_no = $component_data[0]->plotNo;
				$pinCode = $component_data[0]->pinCode;
				//$censusCode = $component_data[0]->censusCode;
				$gps_cordinates = $component_data[0]->gpsCordinates;
				
				
				$customer_pic_file_move_path  = FCPATH.'public/upload/mobile_upload/customer_pic/'.$trans_header_id;
				$customer_id_photo_file_move_path  = FCPATH.'public/upload/mobile_upload/customer_id_pic/'.$trans_header_id;
				$installation_image_file_move_path  = FCPATH.'public/upload/mobile_upload/installation_image/'.$trans_header_id;
				
				
				$customer_pic_file_url = rawurldecode($customer_image);
	
				$image_parts = explode(";base64,", $customer_pic_file_url);
				$image_type_aux = explode("image/", $image_parts[0]);
				$image_type = $image_type_aux[1];
				$image_base64 = base64_decode($image_parts[1]);
				
				if(!is_dir($customer_pic_file_move_path)){
					mkdir($customer_pic_file_move_path,0777,true);
				}
				
				$customer_pic_store_path  = 'public/upload/mobile_upload/customer_pic/'.$trans_header_id. '.png' ;
				$upload_customer_pic_image = file_put_contents($customer_pic_store_path,$image_base64);
				
				$customer_id_photo_file_url = rawurldecode($customer_id_photo);
	
				$image_parts = explode(";base64,", $customer_id_photo_file_url);
				$image_type_aux = explode("image/", $image_parts[0]);
				$image_type = $image_type_aux[1];
				$image_base64 = base64_decode($image_parts[1]);
				
				
				if(!is_dir($customer_id_photo_file_move_path)){
					mkdir($customer_id_photo_file_move_path,0777,true);
				}
				
				$customer_id_pic_store_path  = 'public/upload/mobile_upload/customer_id_pic/'.$trans_header_id. '.png' ;
				$upload_customer_id_pic_image = file_put_contents($customer_id_pic_store_path,$image_base64);
				
				
				$installation_image_file_url = rawurldecode($installation_image);
	
				$image_parts = explode(";base64,", $installation_image_file_url);
				$image_type_aux = explode("image/", $image_parts[0]);
				$image_type = $image_type_aux[1];
				$image_base64 = base64_decode($image_parts[1]);
				
				
				if(!is_dir($installation_image_file_move_path)){
					mkdir($installation_image_file_move_path,0777,true);
				}
				
				$installation_image_pic_store_path  = 'public/upload/mobile_upload/installation_image/'.$trans_header_id. '.png' ;
				$upload_installation_image = file_put_contents($installation_image_pic_store_path,$image_base64);
				
				
				
				
				
				$customer_details_upload = $this->db->query("UPDATE customer a LEFT JOIN transaction_header b
										ON a.id=b.tr_customer_id
										SET a.phone1='".$land_line_no."' ,a.mobile1='".$mobile1."',a.photo='".$customer_pic_store_path."',a.id_proof='".$customer_id_pic_store_path."',a.installation_photo='".$installation_image_pic_store_path."',a.aadhar_no='".$adharCard_no."',a.father_name='".$fatherName."',a.cu_email='".$Email."',
										a.alternate_id='".$alternateIdNo."',b.plot_no='".$plot_no."',b.pincode='".$pinCode."',b.id_proof='".$customer_id_pic_store_path."',b.installation_photo='".$installation_image_pic_store_path."',b.tr_gps_code='".$gps_cordinates."',b.landmark='".$landmark."'
										WHERE a.id=b.tr_customer_id AND b.id='".$trans_header_id."'");
	            
	            if($customer_details_upload){
	            	foreach ($attribute_data as $key=>$value){
	            		
	            		$value_array = (array) $value;
						$array_value = reset($value_array);
						$splitted_value = explode('_', $key);
						
						$update_attribute_details = $this->db->query("UPDATE  transaction_component_value SET attribute_values='".$array_value."' WHERE id='".$splitted_value[2]."'");
						
					}
	            	
				}
				
				return array('status'=>true, 'msg'=>'Component Data Uploaded Successfully');
			break;
			
			
			case 'submit_component_image_details_data':
				
				$result = array_unique($data, SORT_REGULAR);
				$this->db->trans_begin();
				try{
					foreach ($result as $single_data){
						
							$trans_header_id = $single_data['trans_header_id'];
							$component_id 	 = $single_data['component_id'];
							$file_move_path  = FCPATH.'public/upload/mobile_upload/'.$trans_header_id;
							
							
							$file_url = rawurldecode($single_data['component_image']);
				
							$image_parts = explode(";base64,", $file_url);
							$image_type_aux = explode("image/", $image_parts[0]);
							$image_type = $image_type_aux[1];
							$image_base64 = base64_decode($image_parts[1]);
							
							if(!is_dir($file_move_path)){
								mkdir($file_move_path,0777,true);
							}
							$store_path  = 'public/upload/mobile_upload/'.$trans_header_id.'/'.$component_id. '.png' ;
							$upload_component_details_image = file_put_contents($store_path,$image_base64);

							if($upload_component_details_image){
								
								
								$insert_image_uploaded_path = array(
									"tr_header_id" 	=> $trans_header_id,
									"component_id"  => $component_id,
									"img_path"      => $store_path,
									"created_by"	=>$this->user_name,
									"created_on"	=>$date,
									
								);
								
								
								$inserted_image_upload_path = $this->db->insert('transaction_image',$insert_image_uploaded_path);
								
								$update_status_trans_header_data=array(
								
									"transaction_status" =>'submitted',
								);
								
								$this->db->where('id',$trans_header_id);
								$update_trans_header_table = $this->db->update('transaction_header',$update_status_trans_header_data);
								
								$update_sup_tech_map = array(
								
									'status'=>'Closed',
								
								);
								
								$this->db->where('transaction_header_id',$trans_header_id);
								$update_sup_tech_map = $this->db->update('sup_tech_map',$update_sup_tech_map);
								
								
								
								
								if($inserted_image_upload_path && $update_trans_header_table && $update_sup_tech_map){
									
									$this->db->trans_commit();
									$dbstatus = TRUE;
				        			$dbmessage = 'Image Uploaded successfully';
				        			
								}else{
									
									$this->db->trans_rollback();
									$dbstatus = FALSE;
									$dbmessage = 'Error While Saving';
								}
								
								
							}else{
								
								$dbstatus = false;
								$dbmessage = 'Invalid Image format.It should not contain multiple dot(.) or 0)';
							}
							
					}
					return array('status'=>$dbstatus,'msg'=>$dbmessage);
				}catch(Exception $e){
			      	$this->db->trans_rollback();
			      	$dbstatus = FALSE;
			      	$dbmessage = $e->getMessage();
			    }
				
				
			break;
			
			case 'submit_scheduled_ticket_feedback_details':
				
				$tempData1 = html_entity_decode($data['imgAttributeData']);
				$tempData2 = html_entity_decode($data['selectedQuestionData']);
				$feedback_data = json_decode($tempData1);
				$selected_question_data = json_decode($tempData2);
				
				$this->db->trans_begin();
				try{
					$scheduled_ticket_id = $feedback_data[0]->scheduled_ticket_id;
					$witness_name 		= $feedback_data[0]->witness_name;
					$witness_number		= $feedback_data[0]->witness_number;
					$witness_remark 	= $feedback_data[0]->witness_remark;
					$witness_image_path = $feedback_data[0]->witness_image_path;
					$visit_purpose		= $feedback_data[0]->visit_purpose;
					
					
					$file_move_path  = FCPATH.'public/upload/mobile_upload/scheduled_ticket_evidence_pic/'.$scheduled_ticket_id;
							
							
					$file_url = rawurldecode($witness_image_path);
		
					$image_parts = explode(";base64,", $file_url);
					$image_type_aux = explode("image/", $image_parts[0]);
					$image_type = $image_type_aux[1];
					$image_base64 = base64_decode($image_parts[1]);
					
					if(!is_dir($file_move_path)){
						mkdir($file_move_path,0777,true);
					}
					$store_path  = 'public/upload/mobile_upload/scheduled_ticket_evidence_pic/'.$scheduled_ticket_id.'/'.$scheduled_ticket_id. '.png' ;
					$upload_evidence_pic_image = file_put_contents($store_path,$image_base64);

					if($upload_evidence_pic_image){
					
						$scheduled_ticket_update_data = array(
							"visit_purpose"	=>$visit_purpose,
							"evidence_pic"	=>$store_path,
							"witness_name"	=>$witness_name,
							"witness_no"	=>$witness_number,
							"remarks"		=>$witness_remark,
							"tkt_status"	=>"RESOLVE",
						);
						$this->db->where('ticket_id',$scheduled_ticket_id);
						$scheduled_ticket_update_data_update = $this->db->update('schedule_ticket',$scheduled_ticket_update_data);
						if($scheduled_ticket_update_data_update){
							
							foreach ($selected_question_data as $key => $value){
								$converting_object_to_array = get_object_vars($value);
								$user_name = $this->user_name;
								
								$insert_feedback_qa = $this->db->query("INSERT INTO feedback_qa (ticket_id, question_id,created_by,created_on,updated_by, updated_on)
																		VALUES('".$converting_object_to_array['ticket_id']."','".$converting_object_to_array['question_id']."','".$user_name."', '$date', '".$user_name."', '$date')");
																	
							}
				
							
									
							$this->db->trans_commit();
							$dbstatus = TRUE;
		        			$dbmessage = 'Data Uploaded Successfully';
		        			
						}else{
							
							$this->db->trans_rollback();
							$dbstatus = FALSE;
							$dbmessage = 'Error While Saving';
						}
					}else{
						
						$dbstatus = false;
						$dbmessage = 'Invalid Image format.It should not contain multiple dot(.) or 0)';
					}
					
					return array('status'=>$dbstatus,'msg'=>$dbmessage);
				}catch(Exception $e){
			      	$this->db->trans_rollback();
			      	$dbstatus = FALSE;
			      	$dbmessage = $e->getMessage();
			    }
			
			
			break;
			
			case 'submit_corrective_ticket_feedback_details':
				$this->db->trans_begin();
				try{
					$corrective_ticket_id = $data[0]['scheduled_ticket_id'];
					$witness_name = $data[0]['witness_name'];
					$witness_number = $data[0]['witness_number'];
					$witness_remark = $data[0]['witness_remark'];
					$witness_image_path = $data[0]['witness_image_path'];
					$visit_purpose = $data[0]['visit_purpose'];
					
					
					$file_move_path  = FCPATH.'public/upload/mobile_upload/corrective_ticket_evidence_pic/'.$corrective_ticket_id;
							
							
					$file_url = rawurldecode($witness_image_path);
		
					$image_parts = explode(";base64,", $file_url);
					$image_type_aux = explode("image/", $image_parts[0]);
					$image_type = $image_type_aux[1];
					$image_base64 = base64_decode($image_parts[1]);
					
					if(!is_dir($file_move_path)){
						mkdir($file_move_path,0777,true);
					}
					$store_path  = 'public/upload/mobile_upload/corrective_ticket_evidence_pic/'.$corrective_ticket_id.'/'.$corrective_ticket_id. '.png' ;
					$upload_evidence_pic_image = file_put_contents($store_path,$image_base64);

					if($upload_evidence_pic_image){
					
						$corrective_ticket_update_data = array(
							"visit_purpose"		=>$visit_purpose,
							"evidence_pic"		=>$store_path,
							"witness_name"		=>$witness_name,
							"witness_no"		=>$witness_number,
							"resolve_remarks"	=>$witness_remark,
							"ticket_status"		=>"RESOLVE",
							"resolved_on"		=>$date,
						);
						$this->db->where('ticket_id',$corrective_ticket_id);
						$corrective_ticket_update_data_update = $this->db->update('raise_ticket',$corrective_ticket_update_data);
						if($corrective_ticket_update_data_update){
									
							$this->db->trans_commit();
							$dbstatus = TRUE;
		        			$dbmessage = 'Data Uploaded Successfully';
		        			
						}else{
							
							$this->db->trans_rollback();
							$dbstatus = FALSE;
							$dbmessage = 'Error While Saving';
						}
					}else{
						
						$dbstatus = false;
						$dbmessage = 'Invalid Image format.It should not contain multiple dot(.) or 0)';
					}
					
					return array('status'=>$dbstatus,'msg'=>$dbmessage);
				}catch(Exception $e){
			      	$this->db->trans_rollback();
			      	$dbstatus = FALSE;
			      	$dbmessage = $e->getMessage();
			    }
			
			
			break;
			
			case 'Technician_scheduled_ticket_data':
				$data_status = "OPEN";
				$data_tech_phone_no = $data['tech_phone_no'];

				$this->db->from('schedule_ticket st');
				$this->db->select('st.ticket_id,st.transaction_id,st.created_on,c.name1,c.name2,c.name3,dm.district_name,IFNULL(bm.block_name,"NA") as block_name ,IFNULL(gm.gp_name,"NA") as gp_name,sh.scheme_name');
				$this->db->join('transaction_header th','st.transaction_id=th.id','Left');
				$this->db->join('customer c','th.tr_customer_id=c.id','Left');
				$this->db->join('district_master dm','st.dist_code = dm.district_code','Left');
				$this->db->join('block_master bm','st.block_code = bm.block_code','Left');
				$this->db->join('gp_master gm','st.gp_code = gm.pk_gp_code','Left');
				$this->db->join('scheme_header sh','st.scheme_id = sh.scheme_code','Left');
				$this->db->where('technician_id',$data_tech_phone_no);
				$this->db->where('tkt_status',$data_status);
				$result = $this->db->get()->result_array();
				return $result;
				break;
			
			
			case 'Technician_scheduled_ticket_details_data':
				$data_scheduled_ticket_id = $data['scheduledTicketId'];
				
				$this->db->from('schedule_ticket a');
				$this->db->select('a.tkt_type,i.description,a.address,b.district_name,c.block_name,d.gp_name,e.scheme_name,f.instal_cls_name,g.tr_customer_id,h.name1,h.name2,h.name3,h.mobile1,h.mobile2');
				$this->db->join('district_master b','a.dist_code = b.district_code','Left');
				$this->db->join('block_master c','a.block_code = c.block_code','Left');
				$this->db->join('gp_master d','a.gp_code = d.pk_gp_code','Left');
				$this->db->join('scheme_header e','a.scheme_id = e.id','Left');
				$this->db->join('installation_class_header f','a.instal_id = f.id','Left');
				$this->db->join('transaction_header g','a.transaction_id = g.id','Left');
				$this->db->join('customer h','g.tr_customer_id = h.id','Left');
				$this->db->join('gen_code_desc i','i.gen_code_group = "TICKET_TYPE" AND a.tkt_type = i.gen_code','Left');
				$this->db->where('a.ticket_id',$data_scheduled_ticket_id);
				$result = $this->db->get()->result_array();
				return $result;
			break;
			
			case 'Technician_corrective_ticket_details_data':
				$data_status = "OPEN";
				$data_corrective_ticket_id = $data['correctiveTicketId'];
				
				$this->db->from('raise_ticket a');
				$this->db->select('a.ticket_id,a.ticket_type,a.ticket_category,a.priority_code,a.costomer_name,a.address,a.mobile_no,g.description,c.district_name,d.block_name,e.gp_name,f.village_name,h.scheme_name');
				$this->db->join('transaction_header b','a.req_by = b.tr_customer_id','Left');
				$this->db->join('district_master c','b.district = c.district_code','Left');
				$this->db->join('block_master d','b.cd_block = d.block_code','Left');
				$this->db->join('gp_master e','b.gp = e.pk_gp_code','Left');
				$this->db->join('village_master f','b.revenue_village = f.pk_village_code','Left');
				$this->db->join('gen_code_desc g','g.gen_code_group = "RRI" AND a.ticket_issue = g.gen_code','Left');
				$this->db->join('scheme_header h','b.tr_scheme_id = h.pk_scheme_code','Left');
				$this->db->where('a.ticket_id',$data_corrective_ticket_id);
				$this->db->where('a.ticket_status',$data_status);
				$result = $this->db->get()->result_array();
				return $result;
			break;
			
			case 'Technician_corrective_ticket_data':
				$data_status = "OPEN";
				$data_tech_phone_no = $data['tech_phone_no'];
				
				$this->db->from('raise_ticket a');
				$this->db->select('a.ticket_id,a.ticket_status,a.remarks,nature_of_service,a.actual_issue_date,a.costomer_name,c.district_name,d.block_name,e.gp_name,f.village_name,g.scheme_name,a.mobile_no as raised_by_phone_no');
				$this->db->join('transaction_header b','a.req_by = b.tr_customer_id','Left');
				$this->db->join('district_master c','b.district = c.district_code','Left');
				$this->db->join('block_master d','b.cd_block = d.block_code','Left');
				$this->db->join('gp_master e','b.gp = e.pk_gp_code','Left');
				$this->db->join('village_master f','b.revenue_village = f.pk_village_code','Left');
				$this->db->join('scheme_header g','b.tr_scheme_id = g.pk_scheme_code','Left');
				$this->db->where('a.technician_id',$data_tech_phone_no);
				$this->db->where('a.ticket_status =',$data_status);
				$result = $this->db->get()->result_array();
				return $result;
			break;
			
			case 'get_questions_mapped_against_schedule_ticket':
				$data_scheduled_ticket_id = $data['scheduled_ticket_id'];
				
				$question_details_query = $this->db->query("SELECT id,installation, component,task_desc FROM 
														(SELECT b.id,c.`description`AS installation ,d.`description` AS component,task_desc,CASE WHEN tkt_type='Y' THEN annual WHEN tkt_type='H' THEN semi_annual WHEN tkt_type='Q' THEN quarterly END AS qsn
														FROM schedule_ticket a LEFT JOIN schedule_question b ON a.instal_id=b.installation_class_id
														LEFT JOIN gen_code_desc c ON c.`gen_code_group`='S_INSTALLATION' AND b.`s_installation_id`=c.gen_code
														LEFT JOIN gen_code_desc d ON d.`gen_code_group`='S_COMPONENT' AND b.`s_component_id`=d.gen_code
														WHERE a.`ticket_id`= '$data_scheduled_ticket_id' ORDER BY c.sl_no,d.sl_no ASC) a WHERE qsn=1");
	            $result = $question_details_query->result_array();
				
				return $result;
			break;
			
			
			
			
			
			
			
        	default :
            	return array('status' => FALSE, 'msg' =>'Unable to load.Contact Support');
        }
        
    }
    
      public function syncData($data, $op, $stage = null) {
     	date_default_timezone_set('Asia/Kolkata');
		$date = date('Y-m-d H:i:s', time());
		
        switch ($op) {
        	
        	case 'get_master_data_from_server':
        		
        		$sync_time= $date;
        		
        		$data_tech_phone_no = $data['tech_phone_no'];
        		
        		
				$query_user_master_query = $this->db->query("SELECT * from user_master WHERE phone_number='".$data_tech_phone_no."'");
				
				$query_tech_master_query = $this->db->query("SELECT * from technician_master WHERE phone_no='".$data_tech_phone_no."'");
				
				$query_sup_tech_map_query = $this->db->query("SELECT * from sup_tech_map WHERE technician_mobile_number='".$data_tech_phone_no."'");
				
				$query_transaction_header_query = $this->db->query("SELECT  th.* FROM  transaction_header th 
																	WHERE tr_supplier_id IN (SELECT supp_code FROM technician_master WHERE phone_no='".$data_tech_phone_no."')");
				
				$query_customer_query = $this->db->query("SELECT  c.* FROM transaction_header th 
															LEFT JOIN customer c ON th.tr_customer_id=c.id 
															WHERE tr_supplier_id IN (SELECT `supp_code` FROM `technician_master` WHERE `phone_no`='".$data_tech_phone_no."')");
				
				$query_state_master_query = $this->db->query("SELECT * from state_master");
				
				$query_district_master_query = $this->db->query("SELECT * FROM  district_master ");
				
				$query_block_master_query = $this->db->query("SELECT distinct blk.*
																FROM  transaction_header th 
																LEFT JOIN block_master blk ON th.cd_block = blk.block_code 
																WHERE  tr_supplier_id IN (SELECT supp_code FROM technician_master WHERE phone_no='".$data_tech_phone_no."') AND  blk.block_code IS NOT NULL");
				
				$query_gp_master_query = $this->db->query("SELECT DISTINCT d.*
															FROM  transaction_header th  
															LEFT JOIN gp_master d ON th.gp=d.pk_gp_code 
															WHERE  tr_supplier_id IN (SELECT supp_code FROM technician_master WHERE phone_no='".$data_tech_phone_no."')  AND d.pk_gp_code IS NOT NULL");
				
				$query_village_master_query = $this->db->query("SELECT DISTINCT e.*
																FROM  transaction_header th  
																LEFT JOIN village_master e ON th.revenue_village=e.pk_village_code 
																WHERE  tr_supplier_id IN (SELECT supp_code FROM technician_master WHERE phone_no='".$data_tech_phone_no."') AND e.pk_village_code IS NOT NULL");
				
				$query_installation_class_header_query = $this->db->query("SELECT * FROM installation_class_header");
				
				
				$query_transaction_component_value_query = $this->db->query("SELECT tcv.*
																			FROM sup_tech_map sm 
																			LEFT JOIN transaction_header th ON sm.transaction_header_id=th.id 
																			INNER JOIN transaction_details td ON th.id=td.tr_header_id 
																			INNER JOIN transaction_component_value tcv ON td.id = tcv.transaction_details_id
																			WHERE sm.technician_mobile_number='".$data_tech_phone_no."'");

				//modified on 04-07-2019
				
				$query_components_details_query = $this->db->query("SELECT * from components_details");
				
				
				$query_scheme_header_query = $this->db->query("SELECT * FROM scheme_header");
				$query_image_upload_master_query = $this->db->query("SELECT * FROM image_upload_master");
				$query_gen_code_desc_query = $this->db->query("SELECT * FROM gen_code_desc");
				
				$query_raise_ticket_query = $this->db->query("SELECT * FROM raise_ticket WHERE technician_id='".$data_tech_phone_no."'");
				$query_components_query = $this->db->query("SELECT * FROM components");
				$query_transaction_details_query = $this->db->query("SELECT td.*
																			FROM sup_tech_map sm 
																			LEFT JOIN transaction_header th ON sm.transaction_header_id=th.id 
																			INNER JOIN transaction_details td ON th.id=td.tr_header_id
																			WHERE sm.technician_mobile_number='".$data_tech_phone_no."'");
				$query_schedule_ticket_query = $this->db->query("SELECT * FROM schedule_ticket WHERE technician_id='".$data_tech_phone_no."'");
				
				$query_schedule_question_query = $this->db->query("SELECT * FROM schedule_question");

				$query_user_master_query_result =  $query_user_master_query->result_array();
				$query_tech_master_query_result =  $query_tech_master_query->result_array();
				$query_sup_tech_map_query_result = $query_sup_tech_map_query->result_array();
				$query_transaction_header_query_result = $query_transaction_header_query->result_array();
				$query_customer_query_result = $query_customer_query->result_array();
				$query_state_master_query_result = $query_state_master_query->result_array();
				$query_district_master_query_result = $query_district_master_query->result_array();
				$query_block_master_query_result = $query_block_master_query->result_array();
				$query_gp_master_query_result = $query_gp_master_query->result_array();
				$query_village_master_query_result = $query_village_master_query->result_array();
				$query_installation_class_header_query_result = $query_installation_class_header_query->result_array();
				$query_transaction_component_value_query_result = $query_transaction_component_value_query->result_array();
				$query_components_query_result = $query_components_query->result_array();
				//modified on 04-07-2019
				$query_components_details_query_result = $query_components_details_query->result_array();
				$query_scheme_header_query_result = $query_scheme_header_query->result_array();
				$query_image_upload_master_query_result = $query_image_upload_master_query->result_array();
				$query_gen_code_desc_query_result = $query_gen_code_desc_query->result_array();
				$query_raise_ticket_query_result = $query_raise_ticket_query->result_array();
				$query_transaction_details_query_result = $query_transaction_details_query->result_array();
				$query_schedule_ticket_query_result = $query_schedule_ticket_query->result_array();
				
				$query_scheduled_ticket_question_query_result = $query_schedule_question_query->result_array();
				
				$result_user_master_query =array();
				$result_tech_master_query =array();
				$result_sup_tech_map_query =array();
				$result_transaction_header_query =array();
				$result_customer_query =array();
				$result_state_master_query =array();
				$result_district_master_query =array();
				$result_block_master_query =array();
				$result_gp_master_query =array();
				$result_village_master_query =array();
				$result_installation_class_header_query =array();
				$result_transaction_component_value_query =array();
				$result_components_details_query =array();
				$result_scheme_header_query =array();
				$result_image_upload_master_query =array();
				$result_gen_code_desc_query =array();
				$result_raise_ticket_query =array();
				$result_components_query =array();
				$result_transaction_details_query =array();
				$result_schedule_ticket_query =array();
				$result_schedule_question_query =array();
				
				array_push($result_user_master_query,$query_user_master_query_result);
				array_push($result_tech_master_query,$query_tech_master_query_result);
				array_push($result_sup_tech_map_query,$query_sup_tech_map_query_result);
				array_push($result_transaction_header_query,$query_transaction_header_query_result);
				array_push($result_customer_query,$query_customer_query_result);
				array_push($result_state_master_query,$query_state_master_query_result);
				array_push($result_district_master_query,$query_district_master_query_result);
				array_push($result_block_master_query,$query_block_master_query_result);
				array_push($result_gp_master_query,$query_gp_master_query_result);
				array_push($result_village_master_query,$query_village_master_query_result);
				array_push($result_installation_class_header_query,$query_installation_class_header_query_result);
				array_push($result_transaction_component_value_query,$query_transaction_component_value_query_result);
				array_push($result_components_details_query,$query_components_details_query_result);
				array_push($result_scheme_header_query,$query_scheme_header_query_result);
				array_push($result_image_upload_master_query,$query_image_upload_master_query_result);
				array_push($result_gen_code_desc_query,$query_gen_code_desc_query_result);
				array_push($result_raise_ticket_query,$query_raise_ticket_query_result);
				array_push($result_components_query,$query_components_query_result);
				array_push($result_transaction_details_query,$query_transaction_details_query_result);
				array_push($result_schedule_ticket_query,$query_schedule_ticket_query_result);
				array_push($result_schedule_question_query,$query_scheduled_ticket_question_query_result);
				
				
				$result_data_array = array( 
								'user_master_query'=>$result_user_master_query,
								'technician_master_query'=>$result_tech_master_query,
							 	'sup_tech_map_query'=>$result_sup_tech_map_query,
								'transaction_header_query'=>$result_transaction_header_query,
							 	'customer_query'=>$result_customer_query,
							 	'state_master_query'=>$result_state_master_query,
							 	'district_master_query'=>$result_district_master_query,
							 	'block_master_query'=>$result_block_master_query,
							 	'gp_master_query'=>$result_gp_master_query,
							 	'village_master_query'=>$result_village_master_query,
							 	'installation_class_header_query'=>$result_installation_class_header_query,
							 	'transaction_component_value_query'=>$result_transaction_component_value_query,
							 	'components_details_query'=>$result_components_details_query,
							 	'scheme_header_query'=>$result_scheme_header_query,
							 	'image_upload_master_query'=>$result_image_upload_master_query,
							 	'gen_code_desc_query'=>$result_gen_code_desc_query,
							 	'raise_ticket_query'=>$result_raise_ticket_query,
							 	'components_query'=>$result_components_query,
							 	'transaction_details_query'=>$result_transaction_details_query,
							 	'schedule_ticket_query'=>$result_schedule_ticket_query,
							 	'schedule_question_query'=>$result_schedule_question_query,
						);
				
				if(!empty($result_data_array)){
					$dbstatus = true;
					$data = $result_data_array;
				}else{
					$dbstatus = false;
					$data ="";
				}
				
				
				return array('status'=>$dbstatus,'data'=>$data);
				
        	break;  
        	
        	case "upload_images_from_mobile":
        	
					$file_move_path  = FCPATH.'public/upload/mobile_upload/component_pics';
					if(!is_dir($file_move_path)){
						mkdir($file_move_path,0777,true);
					}	
						
					$file_url = $data['img_path'];
		
					$image_parts = explode(";base64,", $file_url);
					$image_type_aux = explode("image/", $image_parts[0]);
					$image_type = $image_type_aux[1];
					$image_base64 = base64_decode($image_parts[1]);
					$image_name = $data['trans_header_id'].'_'.$data['component_id'];
					
					$store_path  = 'public/upload/mobile_upload/component_pics/'.$image_name. '.png' ;
					
					$upload_component_image = file_put_contents($store_path,$image_base64);
					
					if($upload_component_image){
						$insert_trans_image_data = array(
							"tr_header_id"	=>$data['trans_header_id'],
							"component_id"	=>$data['component_id'],
							"img_path"		=>$store_path,
							"created_by"	=>$data['created_by'],
							"created_on"	=>$data['created_on']
						);
						
						$insert_trans_image_data = $this->db->insert('transaction_image',$insert_trans_image_data);
						
					}
					
							
					$dbstatus = TRUE;
        			$dbmessage = 'Data Uploaded Successfully';
					
					return array('status'=>$dbstatus,'msg'=>$dbmessage);
				
        	
        	break;  
        	
        	case "upload_customer_photo":
        	
        			if(!empty($data)){
        				
        				$customer_pic = $data['customer_pic_img_data'];
        				$customer_id_pic = $data['customer_id_img_data'];
        				$customer_installation_pic = $data['customer_installation_img_data'];
						$image_name = $data['tr_header_id'];
						
						$file_move_path_customer_pic  = FCPATH.'public/upload/mobile_upload/customer_pic';
						if(!is_dir($file_move_path_customer_pic)){
							mkdir($file_move_path_customer_pic,0777,true);
						}	
						$customer_pic_image_parts = explode(";base64,", $customer_pic);
						$customer_pic_image_type_aux = explode("image/", $customer_pic_image_parts[0]);
						$customer_pic_image_type = $customer_pic_image_type_aux[1];
						$customer_pic_image_base64 = base64_decode($customer_pic_image_parts[1]);
						
						$customer_pic_store_path  = 'public/upload/mobile_upload/customer_pic/'.$image_name. '.png' ;
						
						$customer_pic_upload = file_put_contents($customer_pic_store_path,$customer_pic_image_base64);
						
						// The below section is for customer id pic
						
						$customer_id_pic_image_parts = explode(";base64,", $customer_id_pic);
						$customer_id_pic_image_type_aux = explode("image/", $customer_id_pic_image_parts[0]);
						$customer_id_pic_image_type = $customer_id_pic_image_type_aux[1];
						$customer_id_pic_image_base64 = base64_decode($customer_id_pic_image_parts[1]);
						
						$customer_id_pic_store_path  = 'public/upload/mobile_upload/customer_id_pic/'.$image_name. '.png' ;
						
						$customer_id_pic_upload = file_put_contents($customer_id_pic_store_path,$customer_id_pic_image_base64);
							
						
						// The below section is used for installation pic
						
						$customer_installation_pic_image_parts = explode(";base64,", $customer_installation_pic);
						$customer_installation_pic_image_type_aux = explode("image/", $customer_installation_pic_image_parts[0]);
						$customer_installation_pic_image_type = $customer_installation_pic_image_type_aux[1];
						$customer_installation_pic_image_base64 = base64_decode($customer_installation_pic_image_parts[1]);
						
						$customer_installation_pic_store_path  = 'public/upload/mobile_upload/installation_image/'.$image_name. '.png' ;
						
						$customer_installation_pic_upload = file_put_contents($customer_installation_pic_store_path,$customer_installation_pic_image_base64);
						
						$dbstatus = TRUE;
	        			$dbmessage = 'Data Uploaded Successfully';
						
					}else{
						$dbstatus = FALSE;
	        			$dbmessage = 'Failed To upload data';
						
					}
        			
					
					return array('status'=>$dbstatus,'msg'=>$dbmessage);
        	
        	
        	break;
        	
        	case "upload_scheduled_ticket_evidence_photo":
        	
        			if(!empty($data)){
        				
        				$evidence_pic = $data['evidence_pic_img_data'];
						$image_name = $data['scheduled_ticket_id'];
						
						$file_move_path_evidence_pic  = FCPATH.'public/upload/mobile_upload/scheduled_ticket_evidence_pic';
						if(!is_dir($file_move_path_evidence_pic)){
							mkdir($file_move_path_evidence_pic,0777,true);
						}	
						$evidence_pic_image_parts = explode(";base64,", $evidence_pic);
						$evidence_pic_image_type_aux = explode("image/", $evidence_pic_image_parts[0]);
						$evidence_pic_image_type = $customer_pic_image_type_aux[1];
						$evidence_pic_image_base64 = base64_decode($evidence_pic_image_parts[1]);
						
						$evidence_pic_store_path  = 'public/upload/mobile_upload/customer_pic/'.$image_name. '.png' ;
						
						$evidence_pic_upload = file_put_contents($evidence_pic_store_path,$evidence_pic_image_base64);
						
						
						
						$dbstatus = TRUE;
	        			$dbmessage = 'Data Uploaded Successfully';
						
					}else{
						$dbstatus = FALSE;
	        			$dbmessage = 'Failed To upload data';
						
					}
        			
					
					return array('status'=>$dbstatus,'msg'=>$dbmessage);
        	
        	
        	break;
        	
        	
        	case "upload_corrective_ticket_evidence_photo":
        	
        			if(!empty($data)){
        				
        				$evidence_pic = $data['evidence_pic_img_data'];
						$image_name = $data['corrective_ticket_id'];
						
						$file_move_path_evidence_pic  = FCPATH.'public/upload/mobile_upload/corrective_ticket_evidence_pic';
						if(!is_dir($file_move_path_evidence_pic)){
							mkdir($file_move_path_evidence_pic,0777,true);
						}	
						$evidence_pic_image_parts = explode(";base64,", $evidence_pic);
						$evidence_pic_image_type_aux = explode("image/", $evidence_pic_image_parts[0]);
						$evidence_pic_image_type = $customer_pic_image_type_aux[1];
						$evidence_pic_image_base64 = base64_decode($evidence_pic_image_parts[1]);
						
						$evidence_pic_store_path  = 'public/upload/mobile_upload/customer_pic/'.$image_name. '.png' ;
						
						$evidence_pic_upload = file_put_contents($evidence_pic_store_path,$evidence_pic_image_base64);
						
						
						
						$dbstatus = TRUE;
	        			$dbmessage = 'Data Uploaded Successfully';
						
					}else{
						$dbstatus = FALSE;
	        			$dbmessage = 'Failed To upload data';
						
					}
        			
					
					return array('status'=>$dbstatus,'msg'=>$dbmessage);
        	
        	
        	break;
        	
        	
        	case "upload_data_from_mobile":
        		
        	 	$customer_data = $data['customerTableData'];
        	 	$raise_ticket_data = $data['raiseTicketTableData'];
        	 	$scheduled_ticket_data = $data['scheduledTicketTableData'];
        	 	$technician_master_data = $data['technicianMasterTableData'];
        	 	$transaction_component_value_data = $data['transactionComponentValueTableData'];
        	 	$transaction_header_data = $data['transactionHeaderTableData'];
        	 	$feedback_qa_data = $data['feedbackQaValueData'];
        	 	
        	 	//Update Customer Table 
        	 	if(!empty($customer_data)){
	        	 	foreach ($customer_data as $single_customer_data){
						$customer_table_update_data = array(
							"photo"					=>"public/upload/mobile_upload/customer_pic/".$single_customer_data['tr_header_id'].".png",
							"id_proof"				=>"public/upload/mobile_upload/customer_id_pic/".$single_customer_data['tr_header_id'].".png",
							"installation_photo"	=>"public/upload/mobile_upload/installation_image/".$single_customer_data['tr_header_id'].".png",
							"aadhar_no"				=>$single_customer_data['aadhar_no'],
							"alternate_id"			=>$single_customer_data['alternate_id'],
							"cu_email"				=>$single_customer_data['cu_email'],
							"phone1"				=>$single_customer_data['phone1'],
							"mobile1"				=>$single_customer_data['mobile1'],
							"father_name"			=>$single_customer_data['father_name'],
						);
						$this->db->where('id',$single_customer_data['customer_id']);
						$customer_table_update = $this->db->update('customer',$customer_table_update_data);
					}
				}
				
				// Update Transaction_Header Table
				if(!empty($transaction_header_data)){ 
					foreach ($transaction_header_data as $single_transaction_header_data){
						$transaction_header_table_update_data = array(
							"habitation"			=>$single_transaction_header_data['habitation'],
							"landmark"				=>$single_transaction_header_data['landmark'],
							"plot_no"				=>$single_transaction_header_data['plot_no'],
							"pincode"				=>$single_transaction_header_data['pincode'],
							"transaction_status"	=>"submitted",
							"id_proof"				=>"public/upload/mobile_upload/customer_id_pic/".$single_transaction_header_data['trans_header_id'].".png",
							"installation_photo"	=>"public/upload/mobile_upload/installation_image/".$single_transaction_header_data['trans_header_id'].".png",
							
						);
						$this->db->where('id',$single_transaction_header_data['+3']);
						$transaction_header_table_update = $this->db->update('transaction_header',$transaction_header_table_update_data);
					}
				}
				
				// Update Scheduled Ticket Table
				if(!empty($scheduled_ticket_data)){
					foreach ($scheduled_ticket_data as $single_scheduled_ticket_data){
						$scheduled_ticket_table_update_data = array(
							"tkt_status"			=>$single_scheduled_ticket_data['tkt_status'],
							"visit_purpose"			=>$single_scheduled_ticket_data['visit_purpose'],
							"evidence_pic"			=>"public/upload/mobile_upload/scheduled_ticket_evidence_pic/".$single_scheduled_ticket_data['ticket_id'].".png",
							"witness_name"			=>$single_scheduled_ticket_data['witness_name'],
							"witness_no"			=>$single_scheduled_ticket_data['witness_no'],
							"remarks"				=>$single_scheduled_ticket_data['remarks'],
							
						);
						$this->db->where('ticket_id',$single_scheduled_ticket_data['ticket_id']);
						$scheduled_ticket_table_update = $this->db->update('schedule_ticket',$scheduled_ticket_table_update_data);
					}
				}
				
				
				// Update Raise_Ticket Table
				if(!empty($raise_ticket_data)){
					foreach ($raise_ticket_data as $single_raise_ticket_data){
						$raise_ticket_table_update_data = array(
							"ticket_status"			=>$single_raise_ticket_data['ticket_status'],
							"visit_purpose"			=>$single_raise_ticket_data['visit_purpose'],
							"witness_name"			=>$single_raise_ticket_data['witness_name'],
							"witness_no"			=>$single_raise_ticket_data['witness_no'],
							"resolve_remarks"		=>$single_raise_ticket_data['resolve_remarks'],
							"evidence_pic"			=>"public/upload/mobile_upload/scheduled_ticket_evidence_pic/".$single_raise_ticket_data['ticket_id'].".png",
							
						);
						$this->db->where('ticket_id',$single_raise_ticket_data['ticket_id']);
						$scheduled_ticket_table_update = $this->db->update('raise_ticket',$raise_ticket_table_update_data);
					}
				}
				
				// Update Technician_Master Table
				if(!empty($technician_master_data)){
					foreach ($technician_master_data as $single_technician_master_data){
						$technician_master_table_update_data = array(
							"name"			=>$single_technician_master_data['name'],
							"mail_id"		=>$single_technician_master_data['mail_id'],
							"address"		=>$single_technician_master_data['address'],
						);
						$this->db->where('phone_no',$single_technician_master_data['phone_no']);
						$technician_master_table_update = $this->db->update('technician_master',$technician_master_table_update_data);
					}
				}
				// Update Transaction_Component_Value Table
				if(!empty($transaction_component_value_data)){
					
					foreach ($transaction_component_value_data as $single_transaction_component_value_data){
						$transaction_component_value_table_update_data = array(
							"attribute_values"=>$single_transaction_component_value_data['attribute_values'],
						);
						$this->db->where('transaction_details_id',$single_transaction_component_value_data['transaction_details_id']);
						$this->db->where('components_detail_id',$single_transaction_component_value_data['components_detail_id']);
						$transaction_component_values_table_update = $this->db->update('transaction_component_value',$transaction_component_value_table_update_data);
					}
				}
				
				// Insert Feedback qa table
				
				if(!empty($feedback_qa_data)) {
					foreach ($feedback_qa_data as $single_feedback_qa_data){
						$insert_feedback_qa_data = array(
							"ticket_id"=>$single_feedback_qa_data['ticket_id'],
							"question_id"=>$single_feedback_qa_data['question_id'],
							"created_by"=>$single_feedback_qa_data['created_by'],
							"created_on"=>$single_feedback_qa_data['created_on'],
							"updated_by"=>$single_feedback_qa_data['updated_by'],
							"updated_on"=>$single_feedback_qa_data['updated_on'],
						);
						
						$transaction_component_values_table_update = $this->db->insert('feedback_qa',$insert_feedback_qa_data);
					}
					
				}
        	 	$dbstatus = TRUE;
        		$dbmessage = 'Data Synced Successfully';
        	 	return array('status'=>$dbstatus,'msg'=>$dbmessage);
        	
        	
        	break;    	
        	
        }
     	
     	
     	
     	
    }
}
