<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

   	class Component_model extends CI_Model{
  		function __construct(){
    		// Call the Model constructor
    		parent::__construct();
    		
    		$this->load->helper('date');
	        if (ENVIRONMENT == 'production') {
	            $this->db->save_queries = FALSE;
	        }
	        date_default_timezone_set('Asia/Kolkata');
			$date = date('Y-m-d H:i:s', time());
	        
	        $this->role 		= $this->session->userdata('role');
	        $this->user_name 	= $this->session->userdata('user_name');
 	 	}
 	 	public function get($data ,$op){
			date_default_timezone_set('Asia/Kolkata');
			$date = date('Y-m-d H:i:s', time());
			switch($op){
				case 'get_all_component':
					$order = '';
	                $Ocolumn = '';
	                $Odir = '';
	                $order = $this->input->post('order');
	                if ($order) {
	                    foreach ($order as $row) {
	                        $Ocolumn = $row['column'];
	                        $Odir = $row['dir'];
	                    }
	                    $this->db->order_by($Ocolumn, $Odir);
	                } else {
	                    $this->db->order_by(1, "ASC");
	                }
	                $search = $this->input->post('search');
	                $header = array('component_name');//search filter will work on this column
	                if ($search['value'] != '') {
	                    for ($i = 0; $i < count($header); $i++) {
	                        $this->db->or_like($header[$i], $search['value']);
	                    }
	                }

	                $iDisplayLength = $this->input->post('length');//to shw number of record to be shown
	                $iDisplayStart = $this->input->post('start');//to start from that position (ex: offset)

	                $this->db->limit($iDisplayLength, $iDisplayStart);
	               	$this->db->from('components');
	               	$this->db->select('component_name,short_name,description,id');
	               	$this->db->order_by('updated_at','DESC');
	                $query = $this->db->get()->result_array();
	                $output = array("aaData" => array());
	                /*----FOR PAGINATION-----*/
	                if ($search['value'] != '') {
	                    for ($i = 0; $i < count($header); $i++) {
	                        $this->db->or_like($header[$i], $search['value']);
	                    }
	                }
	                $this->db->from('components');
	               	$this->db->select('component_name,short_name,description,id');
	               	$this->db->order_by('updated_at','DESC');
	                $res1 = $this->db->get();
	                $output["draw"] = intval($this->input->post('draw'));
	                $output['iTotalRecords'] = $res1->num_rows();
	                $output['iTotalDisplayRecords'] = $res1->num_rows();
	                $slno = $iDisplayStart+1;
	                foreach ($query as $aRow) {
	                    $row[0] = $slno;
	                    $row['sl_no'] = $slno;
	                    $i = 1;
	                    foreach ($aRow as $key => $value) {
	                        $row[$i] = $value;
	                        $row[$key] = $value;
	                        $i++;
	                    }
	                    $output['aaData'][] = $row;
	                    $slno++;
	                    unset($row);
	                }
	                return $output;
	            break; 
	            case 'get_component_view':
	            	$this->db->from('components');
	            	$this->db->select('component_name,short_name,description,id,created_by,DATE_FORMAT(created_at, "%d-%m-%Y %h:%m:%s") as created_at ,updated_by,updated_at');
	            	$this->db->where('id',$data['id']);
	            	return $this->db->get()->row_array();
	            break;
	            case 'get_attribute':
	            	$this->db->from('components_details a');
	            	$this->db->select('a.attribute, b.description AS value, a.created_by, a.created_at, a.updated_by, a.updated_at');
	            	$this->db->join('gen_code_desc b','a.attribute = b.gen_code','left');
	            	$this->db->where('b.gen_code_group','ATTRIBUTE');
	            	$this->db->where('a.components_id',$data['components_id']);
	            	return $this->db->get()->result_array();
	            break;
	            case 'get_edit_component_list':
	            	$this->db->from('installation_class_detail');
	            	$this->db->select('component_id');
	            	$this->db->where('installation_header_id',$data['header_id']);
	            	return $this->db->get()->result_array();
	            break;
	            default :
	            	return array('status' => FALSE, 'msg' =>'Unable to load.Contact Support');
			}
		}
 	 	public function post($data ,$op){
			date_default_timezone_set('Asia/Kolkata');
			$date = date('Y-m-d H:i:s', time());
			switch($op){
				case 'ADD_COMPONENT':
					$this->db->trans_begin();
					try{
						$insert_component = array(
							"component_name" => $this->security->xss_clean($data['txtComponent']),
							"description" => $this->security->xss_clean($data['txtCDescription']),
							"short_name" => $this->security->xss_clean($data['txtCShortName']),
							"created_by" => $this->user_name,
							"created_at" => $date,
							"updated_by" => $this->user_name,
							"updated_at" => $date
						);
						//print_r($insert_component);die();
						$component = $this->db->insert('components',$insert_component);
						$component_id = $this->db->insert_id();
						if($component){
							$attribute = $this->security->xss_clean($this->input->post('cmb_attributes'));
							for($j = 0; $j< sizeof($attribute);$j++ ){
								$insert_component_details[] = array(
									"components_id" => $component_id,
									"attribute"     =>$attribute[$j],
									"created_by"	=>$this->user_name,
									"created_at"	=>$date,
									"updated_by"	=>$this->user_name,
									"updated_at"	=>$date
								);
							}
							//print_r($insert_component_details);die();
							$component_details = $this->db->insert_batch('components_details',$insert_component_details);
							if($component_details){
								$this->db->trans_commit();
								$dbstatus = TRUE;
			        			$dbmessage = 'data Save successfully';
							}else{
								$this->db->trans_rollback();
								$dbstatus = FALSE;
								$dbmessage = 'Error While Saving';
							}
						}else{
							$this->db->trans_rollback();
							$dbstatus = FALSE;
							$dbmessage = 'Error While Saving1';
						}
					}catch(Exception $e){
						$this->db->trans_rollback();
				      	$dbstatus = FALSE;
				      	$dbmessage = $e->getMessage();
					}
				return array('status'=>$dbstatus,'msg'=>$dbmessage);
				break;
				case 'UPDATE_COMPONENT':
					$this->db->trans_begin();
					$component_id = $this->security->xss_clean($this->input->post('hid_component_id'));
					try{
						$update_component = array(
							"component_name"  => $this->security->xss_clean($data['txtComponent']),
							"description" 	 => $this->security->xss_clean($data['txtCDescription']),
							"short_name"  	=> 	$this->security->xss_clean($data['txtCShortName']),
							"updated_by"	=>	$this->user_name,
							"updated_at"	=>	$date
						);
						$this->db->where('id',$component_id);
						$result_component = $this->db->update('components',$update_component);
						if($result_component){
							$this -> db -> where('components_id', $component_id);
  							$res_delete = $this -> db -> delete('components_details');
							if($res_delete){
								$attribute = $this->security->xss_clean($this->input->post('cmb_attributes'));
								for($j = 0; $j< sizeof($attribute);$j++ ){
									$insert_component_details[] = array(
										"components_id" => $component_id,
										"attribute"     =>$attribute[$j],
										"created_by"	=>$this->user_name,
										"created_at"	=>$date
									);
								}
								$component_details = $this->db->insert_batch('components_details',$insert_component_details);
								if($component_details){
									$this->db->trans_commit();
									$dbstatus = TRUE;
				        			$dbmessage = 'Data Update successfully';
								}else{
									$this->db->trans_rollback();
									$dbstatus = FALSE;
									$dbmessage = 'Error While Saving';
								}
							}else{
								$this->db->trans_rollback();
								$dbstatus = FALSE;
								$dbmessage = 'Error While delete Record';
							}
						}else{
							$this->db->trans_rollback();
							$dbstatus = FALSE;
							$dbmessage = 'Error While Saving';
						}
					}catch(Exception $e){
				      	$this->db->trans_rollback();
				      	$dbstatus = FALSE;
				      	$dbmessage = $e->getMessage();
			    	}
			    	return array('status'=>$dbstatus,'msg'=>$dbmessage);
				break;
			default:
            	return array('status' => false, 'msg' =>'Unable to load.Contact Support');	
			}
		}
  	}