
<?php defined('BASEPATH') OR exit('No direct script access allowed');
	class Vendor_controller extends CI_Controller  {
  		public function __construct(){
    		parent::__construct();
    		
    		# libraries
			$this->load->library('form_validation');
			$this->load->library('user_agent');
			
			# libraries
			$this->load->helper('custom_page');
			
			# models
			$this->load->model('getter_model');
			$this->load->model('vendor_model');
			
			# views
			$data['title'] = $this->getter_model->get(null,'get_title');
			$this->load->view('templates/header',$data);
   		}
   		public function page_not_found(){
			$this->load->view('templates/404');
			$this->load->view('templates/footer');
		}
		public function _remap($method){
			$class = $this->router->class;
			$role = $this->session->userdata('role');
			$check_user = $this->getter_model->get(null,'get_user_check');
			$role_action_auth = array( 
				'CRCADMIN'=>array('vendor','add_vendor_data','edit_vendor_data','vendor_technician_mapping','link_vendor_village','link_view_vendor_village','link_edit_vendor_village','vendor_against_tech_details','task_assigned_tech_details','task_against_technician_details'),
				'VENDOR'=>array('vendor_technician_mapping','link_vendor_village','link_view_vendor_village','link_edit_vendor_village','vendor_against_tech_details','task_assigned_tech_details','task_against_technician_details','edit_vendor_account'),
				'CRCAGENT'=>array('vendor_technician_mapping','link_vendor_village','link_view_vendor_village','link_edit_vendor_village','vendor_against_tech_details','task_assigned_tech_details','task_against_technician_details'),
				'ODA'=>array('vendor','add_vendor_data','edit_vendor_data','link_vendor_village','link_view_vendor_village','link_edit_vendor_village')
				
			);
			if( $role == false || !isset($role_action_auth[$role]) || !in_array($method, $role_action_auth[$role]) || !$check_user){
				redirect('logout');
			}else{
				if (in_array(strtolower($method), array_map('strtolower', get_class_methods($this)))){
					$uri = $this->uri->segment_array();
					unset($uri[1]);
					unset($uri[2]);
					call_user_func_array(array($this, $method), $uri);
				}else{
					self::page_not_found();
				}
			}
		}
		
		public function vendor(){
			$sidebar['menu_item'] = 'Vendor';
			$sidebar['menu_group'] = 'Masters';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('vendor/vendor');
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function vendor_report(){
			$sidebar['menu_item'] = 'Vendor Report';
			$sidebar['menu_group'] = 'Vendor Report';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('vendor/vendor_report');
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function add_vendor_data(){
			$sidebar['menu_item'] = 'Vendor';
			$sidebar['menu_group'] = 'Masters';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('vendor/add_vendor');
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		
		
		public function edit_vendor_data(){
			$decode_id      = $this->uri->segment(2);
		    $smth 			= preg_replace("/%u([0-9a-f]{3,4})/i","&#x\\1;",urldecode($decode_id)); 
		    $smth_id 	    = html_entity_decode($smth,null,'UTF-8');
		    $data['supplier_code']     = base64_decode($smth_id);
		    $data['vendor_details_data'] =$this->vendor_model->get(array('supplier_code'=>$data['supplier_code']),'get_vendor_view_details');
			$sidebar['menu_item'] = 'Vendor';
			$sidebar['menu_group'] = 'Masters';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('vendor/edit_vendor',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		
		public function edit_vendor_account(){
			$decode_id      = $this->uri->segment(2);
		    $smth 			= preg_replace("/%u([0-9a-f]{3,4})/i","&#x\\1;",urldecode($decode_id)); 
		    $smth_id 	    = html_entity_decode($smth,null,'UTF-8');
		    $data['supplier_code']     = base64_decode($smth_id);
		    $data['vendor_details_data'] =$this->vendor_model->get(array('supplier_code'=>$data['supplier_code']),'get_vendor_view_details');
			$sidebar['menu_item'] 	= '';
			$sidebar['menu_group'] 	= '';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
	  		$this->load->view('templates/side_menu',$sidebar);
			$this->load->view('vendor/edit_vendor',$data);
			$this->load->view('templates/footer');
		}
		/*
		Created by : Ashutosh Mishra
		Created On : 13-05-2019
		purpose : The below function is used for showing village details against selected vendor
		*/
		public function link_vendor_village(){
			$sidebar['menu_item'] = 'Link Vendor to Village';
			$sidebar['menu_group'] = 'Project Management';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			$data['scheme_details'] = $this->getter_model->get(null,'get_all_scheme_list');
			$data['vendor_details'] = $this->getter_model->get(null,'get_supplier_list');
		
			if($page_status!= 0) {
				$this->load->view('vendor/link_vendor_village',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		
		
		/*
		Created by : Ashutosh Mishra
		Created On : 13-05-2019
		purpose : The below function is used for showing technician details against selected vendor
		*/
		public function vendor_against_tech_details(){
			$decode_id      = $this->uri->segment(2);
		    $smth 			= preg_replace("/%u([0-9a-f]{3,4})/i","&#x\\1;",urldecode($decode_id)); 
		    $smth_id 	    = html_entity_decode($smth,null,'UTF-8');
		    $data['supplier_id']     = base64_decode($smth_id);
			$sidebar['menu_item'] = 'Link Vendor to Technician';
			$sidebar['menu_group'] = 'Project Management';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			$data['technician_against_vendor_data'] = $this->vendor_model->get(array('supplier_id'=>$data['supplier_id']),'get_technician_against_vendor_data');
			if($page_status!= 0) {
				$this->load->view('vendor/vendor_against_tech_details',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		/*
		Created by : Ashutosh Mishra
		Created On : 13-05-2019
		purpose : The below function is used for showing technician details against selected vendor
		*/
		
		public function task_against_technician_details(){
			$decode_id      = $this->uri->segment(2);
		    $smth 			= preg_replace("/%u([0-9a-f]{3,4})/i","&#x\\1;",urldecode($decode_id)); 
		    $smth_id 	    = html_entity_decode($smth,null,'UTF-8');
		    $url_data     	= base64_decode($smth_id);
		    $explode        = explode("/",$url_data);
		    $data['supplier_id'] = $explode[0];
		    $data['tech_mob_no'] = $explode[1];
			$sidebar['menu_item'] = 'Link Vendor to Technician';
			$sidebar['menu_group'] = 'Project Management';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			$data['vendor_name_data'] = $this->getter_model->get( $data['supplier_id'],'get_vendor_against_supplier');
			$data['technician_task_details_data'] = $this->vendor_model->get(array('supplier_id'=>$data['supplier_id'],'tech_mobile_no'=> $data['tech_mob_no']),'get_technician_task_data');
			if($page_status!= 0) {
				$this->load->view('vendor/task_assigned_tech_details',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function vendor_technician_mapping(){
			$sidebar['menu_item'] = 'Link Vendor to Technician';
			$sidebar['menu_group'] = 'Project Management';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			//$data['all_scheme_list']  = $this->getter_model->get(null,'get_all_scheme_list');
			$data['all_scheme_list']  = $this->getter_model->get(null,'get_scheme');
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('vendor/vendor_technician_mapping',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		/*
			The below function is used for showing vendor village details 
			Created On : 24-05-2019
			Created By : Ashutosh Mishra
		*/
		public function link_view_vendor_village(){
			$decode_supplier_id = $this->uri->segment(2);
			$decode_scheme_id   = $this->uri->segment(3);
			$supplier_id_smth   = preg_replace("/%u([0-9a-f]{3,4})/i","&#x\\1;",urldecode($decode_supplier_id)); 
			$scheme_id_smth   = preg_replace("/%u([0-9a-f]{3,4})/i","&#x\\1;",urldecode($decode_scheme_id)); 
			$smth_supplier_id 	= html_entity_decode($supplier_id_smth,null,'UTF-8');
			$smth_scheme_id 	= html_entity_decode($scheme_id_smth,null,'UTF-8');
			$data['supplier_id']= base64_decode($smth_supplier_id);
			$data['scheme_id']= base64_decode($smth_scheme_id);
			$sidebar['menu_item'] = 'Link Vendor to Village';
			$sidebar['menu_group'] = 'Project Management';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			$data['vendor_village_view_data'] = $this->vendor_model->get(array('supplier_id'=>$data['supplier_id'],'scheme_id'=> $data['scheme_id']),'get_vendor_village_details');
			if($page_status!= 0) {
				$this->load->view('vendor/view_vendor_against_village_details',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function link_edit_vendor_village(){
			$decode_supplier_id = $this->uri->segment(2);
			$decode_scheme_id   = $this->uri->segment(3);
			$supplier_id_smth   = preg_replace("/%u([0-9a-f]{3,4})/i","&#x\\1;",urldecode($decode_supplier_id)); 
			$scheme_id_smth   = preg_replace("/%u([0-9a-f]{3,4})/i","&#x\\1;",urldecode($decode_scheme_id)); 
			$smth_supplier_id 	= html_entity_decode($supplier_id_smth,null,'UTF-8');
			$smth_scheme_id 	= html_entity_decode($scheme_id_smth,null,'UTF-8');
			$data['supplier_id']= base64_decode($smth_supplier_id);
			$data['scheme_id']= base64_decode($smth_scheme_id);
			$sidebar['menu_item'] = 'Link Vendor to Village';
			$sidebar['menu_group'] = 'Project Management';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			$data['vendor_village_view_data'] = $this->vendor_model->get(array('supplier_id'=>$data['supplier_id'],'scheme_id'=> $data['scheme_id']),'get_vendor_village_details');
			$data['vendor_village_data'] = $this->vendor_model->get(array('supplier_id'=>$data['supplier_id'],'scheme_id'=> $data['scheme_id']),'get_vendor_village_data');
			if($page_status!= 0) {
				$this->load->view('vendor/edit_vendor_against_village_details',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
	}	