
<?php defined('BASEPATH') OR exit('No direct script access allowed');
	class Technician_controller extends CI_Controller  {
  		public function __construct(){
    		parent::__construct();
    		
    		# libraries
			$this->load->library('form_validation');
			$this->load->library('user_agent');
			
			# libraries
			$this->load->helper('custom_page');
			
			# models
			$this->load->model(array('transaction_model','getter_model'));
			//$this->load->model('technician_model');
			
			# views
			$data['title'] = $this->getter_model->get(null,'get_title');
			$this->load->view('templates/header',$data);
   		}
   		public function page_not_found(){
			$this->load->view('templates/404');
			$this->load->view('templates/footer');
		}
   		public function _remap($method){
			$class 	= $this->router->class;
			$role = $this->session->userdata('role');
			$check_user = $this->getter_model->get(null,'get_user_check');
			if( !in_array($role, array('CRCADMIN','TECHNICIAN','ODA')) || !$check_user){
				redirect('logout');
			}
			if (in_array(strtolower($method), array_map('strtolower', get_class_methods($this)))){
				$uri = $this->uri->segment_array();
				unset($uri[1]);
				unset($uri[2]);
				call_user_func_array(array($this, $method), $uri);
			}else{
				self::page_not_found();
			}
		}
		
		public function technician_master(){
			$sidebar['menu_item'] = 'Technician Master';
			$sidebar['menu_group'] = 'Masters';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$data['supplier_list'] = $this->getter_model->get(null,'get_supplier_list');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('technician/technician_master',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function open_installation_view(){
			$sidebar['menu_item'] = 'Dashboard';
			$sidebar['menu_group'] = 'Dashboard';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('technician/installation_view');
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function installation_view_details(){
			$decode_id      = $this->uri->segment(2);
		    $smth 			= preg_replace("/%u([0-9a-f]{3,4})/i","&#x\\1;",urldecode($decode_id)); 
		    $smth_id 	    = html_entity_decode($smth,null,'UTF-8');
		    $data['trans_id']     = base64_decode($smth_id);
		    $data['header_data'] = $this->transaction_model->get(array('trans_id'=>$data['trans_id']),'get_header_data');
		    $data['details_data'] = $this->transaction_model->get(array('trans_id'=>$data['trans_id']),'get_trans_details_data');
		    $sidebar['menu_item'] = 'Dashboard';
			$sidebar['menu_group'] = 'Dashboard';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('transaction/view_transaction_details',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
	}	