<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	class Service extends CI_Controller {
		public function __construct(){
			parent::__construct();
			# helpers
			$this->load->helper(array('form'));
			# library
			$this->load->library('form_validation');
			#models
			$this->load->model(array('superadmin_model','admin_model','crc_model','department_model',
			'getter_model','transaction_model','scheme_model','component_model','installation_model',
			'technician_model','vendor_model','raise_ticket_model','schedule_model','dashboard_model',
			'scoring_model','attribute_model','service_request_model','mis_model'));
		}
	
		/*
		*	purpose : if request is not an ajax request then show error
		*/
		public function _remap($method){
			self::$method();		
		}
		
		/**
		*	purpose : get extension 
		*/
		private function getExtension($pFileName = null) {
			 $i = strrpos($pFileName,".");
			 if( !$i ) {
				return false;
			 }			 
			 $nameLength = strlen($pFileName) - $i;
			 return substr($pFileName,$i+1,$nameLength);
		}

		/**
		*	purpose : Generate unique id
		*/
		private function get_unique_id(){
			return $id = md5(strtotime(date('Y-m-d H:i:s'))).uniqid();
		}
		/**
		* For Admin setup
		* Author   		: Debashish Jyotish
		* Function 		: get_datatable_data
		* purpose  		: Get Resource data
		* Date     		: 18/05/2018
		* Remark   		:  Get data from model and forward data as JSON   
		*/
		public function logout_all_system(){
			echo json_encode($this->getter_model->get($_POST, 'logout_all_system'));
		}
	    public function get_logindetails_data(){
	    	$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_login_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken, 'dtblLoginDetails' ) ) {
			    	echo json_encode($this->superadmin_model->superadmin($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => 'FALSE',
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		 
		public function forgot_password(){
	    	$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$config = array(
					array(
		                 'field'   => 'txtUsername',
		                 'label'   => 'User Id',
		                 'rules'   => 'required|xss_clean'
		            ),
		            array(
		                 'field'   => 'txtEmailId',
		                 'label'   => 'Email',
		                 'rules'   => 'required|regex_match[/^([\w-]+(?:\.[\w-]+)*)@((?:[\w-]+\.)*\w[\w-]{0,66})\.([com net org]{3}(?:\.[a-z]{6})?)$/i]|xss_clean'
		            )
		        );
				
		  		$this->form_validation->set_rules($config);
				if ($this->form_validation->run() == FALSE) {
					$data = array(
		                'status' => 'validationerror',
		                'msg' => validation_errors()
		            );
		            echo json_encode($data);
				}else{
					echo json_encode($this->superadmin_model->superadmin($_POST, 'op_type_mail_link'));
				} 
			}	
		}
		public function reset_password(){
			$config = array(
	            array(
	                'field'   => 'txtPass',
	                'label'   => 'Password',
	                'rules'   => 'required|xss_clean'
	            ),
	            array(
	                'field'   => 'txtConPassword',
	                'label'   => 'Confirm Password',
	                'rules'   => 'required|matches[txtPass]|xss_clean'
	            )
	        );
			
			$this->form_validation->set_rules($config); 
			
		    if ($this->form_validation->run() == FALSE) {
				$data = array(
	                'status' => 'validationerror',
	                'msg' => validation_errors()
	            );
	            echo json_encode($data);
			    
			}else{
				echo json_encode($this->superadmin_model->superadmin($_POST, 'op_type_reset_password'));
			} 
		}
		public function set_password(){
			$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_setpassword_token'];
				if(!empty($input_csrf_token)){
					if(checkToken( $input_csrf_token, 'setPasswordForm')){
						$config = array(
				            array(
				                'field'   => 'txtPassword',
				                'label'   => 'Password',
				                'rules'   => 'required|xss_clean'
				            ),
				            array(
				                'field'   => 'txtConPassword',
				                'label'   => 'Confirm Password',
				                'rules'   => 'required|matches[txtPassword]|xss_clean'
				            )
		        		);
						$this->form_validation->set_rules($config); 
					    if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						    
						}else{
							echo json_encode($this->superadmin_model->superadmin($_POST, 'op_type_set_password'));
						}			        	
			    	}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
						echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
					echo json_encode($data);
				}
			}
		}
		public function user_register(){
			$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['hidCsrfToken'];
				if(!empty($input_csrf_token)){
					if(checkToken( $input_csrf_token, 'user_register_form')){
						$config = array(
				            array(
				                'field'   => 'txtFirstName',
				                'label'   => 'First Name',
				                'rules'   => 'required|xss_clean'
				            ),
				            array(
				                'field'   => 'txtLastName',
				                'label'   => 'Last Name',
				                'rules'   => 'required|xss_clean'
				            ),
				            array(
				                'field'   => 'txtEmailId',
				                'label'   => 'Email',
				                'rules'   => 'required|regex_match[/^([\w-]+(?:\.[\w-]+)*)@((?:[\w-]+\.)*\w[\w-]{0,66})\.([com net org]{3}(?:\.[a-z]{6})?)$/i]|xss_clean'
				            ),
				            array(
			                     'field'   => 'txtMobileNo',
			                     'label'   => 'Mobile Number',
			                     'rules'   => 'required|regex_match[/^[1-9][0-9]{0,9}$/]|xss_clean'
			                ),
			                array(
			                     'field'   => 'txtDOB',
			                     'label'   => 'Date of Birth',
			                     'rules'   => 'required|xss_clean'
			                ),
			                array(
			                     'field'   => 'txtPanCard',
			                     'label'   => 'Pan Card',
			                     'rules'   => 'required|xss_clean'
			                ),
			                array(
			                     'field'   => 'txtAadhaarNumber',
			                     'label'   => 'Aadhaar Number',
			                     'rules'   => 'required|xss_clean'
			                )
		        		);
						$this->form_validation->set_rules($config); 
					    if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						    
						}else{
							echo json_encode($this->superadmin_model->superadmin($_POST, 'new_user_register'));
						}			        	
			    	}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
						echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
					echo json_encode($data);
				}
			}
		}
		/**
		* Author   		: Debashish Jyotish
		* Function 		: get_dept_details
		* purpose  		: Get Profile Setup
		* Date     		: 10/07/2018
		* Remark   		: Get data from model and forward data as JSON   
		*/
		public function get_account_details(){
			$user_code = $this->uri->segment(3);
			echo json_encode($this->superadmin_model->superadmin($user_code,'GET_ACCOUNT_DETAILS'));	
		}
		public function operation_profile_details(){
			$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_profile_token'];
				if(!empty($input_csrf_token)){
					if(checkToken( $input_csrf_token, 'frm_profile_modification')){
			    		$config = array(
			    			array(
				                'field'   => 'dept_desc',
				                'label'   => 'Profile Description',
				                'rules'   => 'xss_clean'
				            ),
				            array(
				                'field'   => 'txt_dept_address',
				                'label'   => 'Address',
				                'rules'   => 'xss_clean'
				            ),
				            array(
				                'field'   => 'txt_email',
				                'label'   => 'Email',
				                'rules'   => 'required|regex_match[/^([\w-]+(?:\.[\w-]+)*)@((?:[\w-]+\.)*\w[\w-]{0,66})\.([com net org]{3}(?:\.[a-z]{6})?)$/i]|xss_clean'
				            ),
				            array(
				                'field'   => 'txt_contact',
				                'label'   => 'contact',
				                'rules'   => 'required|regex_match[/^[0-9]{10}$/]|xss_clean'
				            )
			        	);
			        	$this->form_validation->set_rules($config); 
					
					    if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						    
						}else{
							echo json_encode($this->superadmin_model->superadmin($_POST,'OPERATION_PROFILE_DETAILS'));	
						}
			    	}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
						echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
					echo json_encode($data);
				}
			}
		}
		public function operation_change_password(){
			$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_cp_token'];
				if(!empty($input_csrf_token)){
					if(checkToken( $input_csrf_token, 'frm_change_password')){
			    		$config = array(
				            array(
				                'field'   => 'txt_old_password',
				                'label'   => 'old password',
				                'rules'   => 'trim|required|xss_clean'
				            ),
				            array(
				                'field'   => 'txt_confrim_password',
				                'label'   => 'confrim password',
				                'rules'   => 'trim|required|matches[txt_new_password]|xss_clean'
				            ),
				            array(
				                'field'   => 'txt_new_password',
				                'label'   => 'new password',
				                'rules'   => 'trim|required|xss_clean'
				            )
			        	);
						$this->form_validation->set_rules($config); 
						
					    if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						    
						}else{
							echo json_encode($this->superadmin_model->superadmin($_POST,'OPERATION_CHANGE_PASSWORD'));	
						}
			    	}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
						echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
					echo json_encode($data);
				}
			}
		}
		/**
		* Author   		: Debashish Jyotish
		* Function 		: get_datatable_data
		* purpose  		: Get Resource data
		* Date     		: 18/05/2018
		* Remark   		:  Get data from model and forward data as JSON   
		*/
	    public function get_datatable_data(){
	    	$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['hidCsrfToken'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken, 'dtblresourcemaster' ) ) {
			    	echo json_encode($this->superadmin_model->superadmin($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => 'FALSE',
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		 
		public function operation_resourcedata(){
			$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_token'];
				if(!empty($input_csrf_token)){
					if(checkToken( $input_csrf_token, 'frm_resource')){
			    		$config = array(
				           	array(
				               	'field'   => 'txtresourcelink',
				                'label'   => 'Resource Link',
				                'rules'   => 'required|xss_clean'
				            ),
				           	array(
				                'field'   => 'txtresourceName',
				                'label'   => 'Resource Name',
				                'rules'   => 'required|xss_clean'
				            )
				        );
						$this->form_validation->set_rules($config); 
					    if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						}else{
							echo json_encode($this->superadmin_model->superadmin($_POST, $_POST['op_type_resource']));
						}
			    	}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
						echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
					echo json_encode($data);
				}
			} 
		}

		public function get_datatable_role_data(){
			$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['hidroleCsrfToken'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dtblrolemaster')){
			    	echo json_encode($this->superadmin_model->superadmin($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => 'FALSE',
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function get_dropdown_data(){
			echo json_encode($this->superadmin_model->superadmin($_POST, $_POST['op_type']));
		}
		
		public function operation_roledata(){
			$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_role_token'];
				if(!empty($input_csrf_token)){
					if(checkToken( $input_csrf_token, 'frm_role')){
						if($_POST['op_type_role'] == 'edit_role'){
							$config = array(
				               	array(
				                    'field'   => 'txtroleName',
				                    'label'   => 'Role Name',
				                    'rules'   => 'required|xss_clean'
				                ),
				               array(
				                    'field'   => 'txtLandingPage',
				                    'label'   => 'Landing Page',
				                    'rules'   => 'required|xss_clean'
				                )
				            );
						}else{
							$config = array(
				               	array(
				                    'field'   => 'txtrolecode',
				                    'label'   => 'Role Code',
				                    'rules'   => 'trim|required|is_unique[role_master.role_code]|xss_clean'
				                ),
				               	array(
				                    'field'   => 'txtroleName',
				                    'label'   => 'Role Name',
				                    'rules'   => 'required|xss_clean'
				                 ),
				               	array(
				                    'field'   => 'txtLandingPage',
				                    'label'   => 'Landing Page',
				                    'rules'   => 'required|xss_clean'
				                 )
				            );
						}
						$this->form_validation->set_rules($config); 
					    if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						}else{
							echo json_encode($this->superadmin_model->superadmin($_POST, $_POST['op_type_role']));
						}
					}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
						echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
		        }
			}
		}
		public function delete_data(){
			echo json_encode($this->superadmin_model->superadmin($_POST, $_POST['op_type']));
		}
		
		
		/**
		* Author   		: Debashish Jyotish
		* Function 		: get_manage_user_data
		* purpose  		: Get Manage User Data
		* Date     		: 18/05/2018
		* Remark   		: Get data from model and forward data as JSON   
		*/
	    public function get_manage_user_data(){
	    	$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_user_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken, 'user_table' ) ) {
			    	echo json_encode($this->superadmin_model->superadmin($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => 'FALSE',
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
	    public function operation_userdata(){
	    	$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_add_user_token'];
				if(!empty($input_csrf_token)){
					if(checkToken( $input_csrf_token, 'frm_user')){
				    	if($_POST['hiduser_name'] == $_POST['txtUserName'] && $_POST['op_type'] == 'edit_user'){
							$config = array(
				               array(
				                    'field'   => 'txtDisplayName',
				                    'label'   => 'Display Name',
				                    'rules'   => 'required|xss_clean'
				                )
				            );
						}else{
							$config = array(
				               	array(
				                     'field'   => 'txtUserName',
				                     'label'   => 'User Name',
				                     'rules'   => 'trim|required|is_unique[user_master.user_name]|xss_clean'
				                ),
				               	array(
				                     'field'   => 'txtDisplayName',
				                     'label'   => 'Display Name',
				                     'rules'   => 'required|xss_clean'
				                ),
				                array(
				                     'field'   => 'txtEmailId',
				                     'label'   => 'Email',
				                     'rules'   => 'required|xss_clean'
				                ),
				                array(
				                     'field'   => 'txtPhoneNumber',
				                     'label'   => 'Mobile Number',
				                     'rules'   => 'required|regex_match[/^[1-9][0-9]{0,9}$/]|xss_clean'
				                )
				            );
						}
				  		$this->form_validation->set_rules($config);
						if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						}else{
							echo json_encode($this->superadmin_model->superadmin($_POST, $_POST['op_type']));
						}
					}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
						echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
					echo json_encode($data);
				}
			}
		} 
		
		/* Author   		: Debashish Jyotish
		* Function 		: get_group_setup
		* purpose  		: Get Resource data
		* Date     		: 18/05/2018
		* Remark   		:  Get data from model and forward data as JSON   
		*/
	    public function get_group_setup(){
	    	$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_group_setup_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken, 'dtblgroupmaster' ) ) {
			    	echo json_encode($this->superadmin_model->superadmin($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => 'FALSE',
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function get_tablevalue(){
			echo json_encode($this->superadmin_model->superadmin($_POST, 'get_tablevalue'));
		}
		public function get_mapping_dept(){
			echo json_encode($this->superadmin_model->superadmin($_POST, 'get_mapping_dept'));
		}
		public function operation_groupdata(){
			$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_add_group_token'];
				if(!empty($input_csrf_token)){
					if(checkToken( $input_csrf_token, 'frm_group')){
				    	$config = array(
				           array(
				                'field'   => 'txtGroupName',
				                'label'   => 'User Name',
				                'rules'   => 'trim|required|xss_clean'
				            ),
				           	array(
				                'field'   => 'cmbtable',
				                'label'   => 'Display Name',
				                'rules'   => 'trim|required|xss_clean'
				            ),
				            array(
				                'field'   => 'txtoperTable',
				                'label'   => 'Operational Table',
				                'rules'   => 'trim|xss_clean'
				            ),
				            array(
				                'field'   => 'txtoperColumn',
				                'label'   => 'Operational Column',
				                'rules'   => 'trim|xss_clean'
				            ),
				            array(
				                'field'   => 'txtExColumn',
				                'label'   => 'Exicution Column',
				                'rules'   => 'trim|required|xss_clean'
				            )
				        );
					
				  		$this->form_validation->set_rules($config);
						if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						    //echo validation_errors();
						}else{
							echo json_encode($this->superadmin_model->superadmin($_POST, $_POST['op_type_group']));
						} 
					}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
						echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
					echo json_encode($data);
				}
			}
		}
		public function get_editgroup_data(){
			$type = $this->uri->segment(3);
			echo json_encode($this->Superadmin_model->superadmin($_POST, $type));
		} 
		public function get_mapgroupdata_data(){
	    	$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_group_mapping_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken, 'dtblgroupmapping' ) ) {
			    	echo json_encode($this->superadmin_model->superadmin($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => 'FALSE',
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function get_rolegroupmapping_data(){
	    	$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_role_group_mapping_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken, 'dtblrolegroupmapping' ) ) {
			    	echo json_encode($this->superadmin_model->superadmin($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => 'FALSE',
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function operation_role_group_data(){
			$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_role_group_token'];
				if(!empty($input_csrf_token)){
					if(checkToken( $input_csrf_token, 'frm_role_group')){
				    	$config = array(
			               	array(
			                    'field'   => 'cmbrolecode',
			                    'label'   => 'Role Name',
			                    'rules'   => 'required|xss_clean'
			            	),
			               	array(
			                    'field'   => 'cmbgroupcode',
			                    'label'   => 'Group Name',
			                    'rules'   => 'required|xss_clean'
			                ),
			               	array(
			                    'field'   => 'txtRoleGroup',
			                    'label'   => 'Role Group Name',
			                    'rules'   => 'required|xss_clean'
			                )
			            );
						
						$this->form_validation->set_rules($config); 
					    if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						    //echo validation_errors();
						}else{
							echo json_encode($this->superadmin_model->superadmin($_POST, $_POST['op_type_role_group']));
						} 
					}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
						echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
					echo json_encode($data);
				}
			}
		}
		public function get_user_rolegroup_mapping_data(){
	    	$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_userrole_group_mapping_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken, 'dtblUser_Role_group_mapping' ) ) {
			    	echo json_encode($this->superadmin_model->superadmin($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => 'FALSE',
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function operation_user_rolegroup_data(){
			$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_userrolegroup_token'];
				if(!empty($input_csrf_token)){
					if(checkToken( $input_csrf_token, 'frm_userrolegroup')){
				    	$config = array(
			               array(
			                    'field'   => 'txtrole_group',
			                    'label'   => 'Role-Group Name',
			                    'rules'   => 'required|xss_clean'
			            	),
			            );
						
						$this->form_validation->set_rules($config); 
					    if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						}else{
							echo json_encode($this->superadmin_model->superadmin($_POST, $_POST['op_type_user_role_group']));
						}  
					}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
						echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
					echo json_encode($data);
				}
			}
		}
		
		/* Author   	: Debashish Jyotish
		* Function 		: get_title_setup
		* purpose  		: Get Title Setup
		* Date     		: 09/07/2018
		* Remark   		:  Get data from model and forward data as JSON   
		*/
		public function get_title_setup(){
	    	$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_title_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken, 'dtbl_title_setup' ) ) {
			    	echo json_encode($this->superadmin_model->superadmin($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => 'FALSE',
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function operation_titlesetup(){
			$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_title_setup_token'];
				if(!empty($input_csrf_token)){
					if(checkToken( $input_csrf_token, 'frm_title_setup')){
				    	$config = array(
			               	array(
			                    'field'   => 'txt_title_name',
			                    'label'   => 'Title Name',
			                    'rules'   => 'required|xss_clean'
			            	),
			            	array(
			                    'field'   => 'txt_title_img',
			                    'label'   => 'Title Image',
			                    'rules'   => 'xss_clean'
			            	),
			            	array(
			                    'field'   => 'txt_desc',
			                    'label'   => 'Title Description',
			                    'rules'   => 'xss_clean'
			            	),
			            	array(
			                    'field'   => 'title_status',
			                    'label'   => 'Title Status',
			                    'rules'   => 'xss_clean'
			            	)
			            );
						
						$this->form_validation->set_rules($config); 
					    if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						}else{
							echo json_encode($this->superadmin_model->superadmin($_POST, $_POST['op_title_type']));
						}  
					}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
						echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
					echo json_encode($data);
				}
			}
		}
		/*
			@This below function is used for inserting and updating the menu setup data
			@Author : Ashutosh Mishra
			@Date	 :10-07-2018
		*/
		
		public function get_datatable_menu_data(){
			$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['hidmenuCsrfToken'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dtblMenu')){
			    	echo json_encode($this->superadmin_model->superadmin($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function sa_reset_password(){
			echo json_encode($this->superadmin_model->superadmin($_POST, $_POST['op_type']));
		}
		public function operation_menudata(){
			$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['hidmenuInsertCsrfToken'];
				if(!empty($input_csrf_token)){
					if(checkToken($input_csrf_token, 'frmMenu')){
						if($_POST['op_type'] == 'edit_menu'){
							$config = array(
				               array(
				                     'field'   => 'txtmenulinktext',
				                     'label'   => 'Link Text',
				                     'rules'   => 'trim|required'
				                  ),
				               array(
				                     'field'   => 'cmbMenuLinkURL',
				                     'label'   => 'Link Url',
				                     'rules'   => 'trim|required'
				                  ),
				               array(
				                     'field'   => 'cmbMenuParent',
				                     'label'   => 'Parent',
				                     'rules'   => 'trim|required'
				                  ),
				               array(
				                     'field'   => 'txtMenuslno',
				                     'label'   => 'Menu Sl No',
				                     'rules'   => 'trim|required'
				                  )
				            );
						}else{
							$config = array(
				               array(
				                     'field'   => 'txtmenulinktext',
				                     'label'   => 'Link Text',
				                     'rules'   => 'trim|required'
				                  ),
				               array(
				                     'field'   => 'cmbMenuLinkURL',
				                     'label'   => 'Link Url',
				                     'rules'   => 'trim|required'
				                  ),
				               array(
				                     'field'   => 'cmbMenuParent',
				                     'label'   => 'Parent',
				                     'rules'   => 'trim|required'
				                  ),
				               array(
				                     'field'   => 'txtMenuslno',
				                     'label'   => 'Menu Sl No',
				                     'rules'   => 'trim|required'
				                  )
				            );
						}
						$this->form_validation->set_rules($config); 
					    if ($this->form_validation->run(
					    ) == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						}else{
							echo json_encode($this->superadmin_model->superadmin($_POST, $_POST['op_type']));
						}
					}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
						echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
		        }
			}
		} 
		public function get_all_department_list(){
	    	$inputCsrfToken = $_POST['hidDeptCsrfToken'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dtblDepartmentMaster')){
			    	echo json_encode($this->superadmin_model->superadmin($_POST, $_POST['op_type']));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function get_all_vendor_list(){
	    	$inputCsrfToken = $_POST['hidVendorCsrfToken'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dtblVendorMaster')){
			    	echo json_encode($this->superadmin_model->superadmin($_POST, $_POST['op_type']));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function get_all_technician_list(){
	    	$inputCsrfToken = $_POST['hidTechCsrfToken'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dtblTechnicianMaster')){
			    	echo json_encode($this->superadmin_model->superadmin($_POST, $_POST['op_type']));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function ApprovalUserCreate(){
			echo json_encode($this->superadmin_model->superadmin($_POST, $_POST['op_type']));
		}
		/*
			@For Admin setup
			@This below function is used for inserting and updating the menu setup data
			@Date	 :17-07-2018
		*/
		
		public function get_gencode_data(){
			$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_gencode_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'gen_code_table')){
			    	echo json_encode($this->admin_model->admin($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function operation_gencode_data(){
			$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
		   		$input_csrf_token = $_POST['csrf_op_gencode_token'];
				if(!empty($input_csrf_token)){
					if(checkToken($input_csrf_token, 'frm_gen_code')){
						if( $_POST['op_type'] == 'edit_gen_code'){
							$config = array(
								array(
				                     'field'   => 'hid_id',
				                     'label'   => 'GenCode Id',
				                     'rules'   => 'required|xss_clean'
				                ),
				               	array(
				                    'field'   => 'description',
				                    'label'   => 'GenCode Description',
				                    'rules'   => 'required|xss_clean'
				                ),
				               	array(
				                    'field'   => 'sl_no',
				                    'label'   => 'Serial Number',
				                    'rules'   => 'required|xss_clean'
				                ),
				               	array(
				                    'field'   => 'status',
				                    'label'   => 'Status',
				                    'rules'   => 'required|xss_clean'
				                )
				            );
						}else{
							$config = array(
				               	array(
				                     'field'   => 'gen_code_group',
				                     'label'   => 'GenCode Group',
				                     'rules'   => 'required|xss_clean'
				                  ),
				               	array(
				                     'field'   => 'gen_code',
				                     'label'   => 'GenCode',
				                     'rules'   => 'required|xss_clean'
				                  ),
				               	array(
				                     'field'   => 'description',
				                     'label'   => 'GenCode Description',
				                     'rules'   => 'required|xss_clean'
				                  ),
				               array(
				                     'field'   => 'sl_no',
				                     'label'   => 'Serial Number',
				                     'rules'   => 'required|xss_clean'
				                  ),
				               array(
				                     'field'   => 'status',
				                     'label'   => 'Status',
				                     'rules'   => 'required|xss_clean'
				                  )
				            );
						}
				  		$this->form_validation->set_rules($config);
						if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						}else{
							echo json_encode($this->admin_model->admin($_POST, $_POST['op_type']));
						}
					}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
						echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
		        }
			}
		}
		public function delete_genCode(){
			echo json_encode($this->admin_model->admin($_POST, $_POST['op_type']));
		}
		public function get_country_data(){
			$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_country_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'country_table')){
			    	echo json_encode($this->admin_model->admin($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function operation_countrydata(){
			$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_op_country_token'];
				if(!empty($input_csrf_token)){
					if(checkToken($input_csrf_token, 'frm_country')){
						if( $_POST['op_type'] == 'edit_country'){
							$config = array(
				               	array(
				                    'field'   => 'country_name',
				                    'label'   => 'Country Name',
				                    'rules'   => 'required|xss_clean'
				                ),
				               	array(
				                    'field'   => 'country_status',
				                    'label'   => 'Status',
				                    'rules'   => 'required|xss_clean'
				                )
				            );
						}else{
							$config = array(
				               	array(
				                    'field'   => 'country_code',
				                    'label'   => 'Country Code',
				                    'rules'   => 'trim|required|is_unique[country_master.country_code]|xss_clean'
				                ),
				               	array(
				                    'field'   => 'country_name',
				                    'label'   => 'Country Name',
				                    'rules'   => 'required|xss_clean'
				                ),
				               	array(
				                    'field'   => 'country_status',
				                    'label'   => 'Status',
				                    'rules'   => 'required|xss_clean'
				                )
				            );
						}
				  		$this->form_validation->set_rules($config);
						if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						}else{
							echo json_encode($this->admin_model->admin($_POST, $_POST['op_type']));
						} 	
					}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
						echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
		        }
			}
		}
		public function delete_data_country(){
			echo json_encode($this->admin_model->admin($_POST, $_POST['op_type']));
		}
		public function get_statemaster_data(){
			$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_state_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dtblState')){
			    	echo json_encode($this->admin_model->admin($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		
		public function op_state_master(){	
		 	$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_op_state_token'];
				if(!empty($input_csrf_token)){
					if(checkToken($input_csrf_token, 'form_state')){
						if(!empty($_POST['op_type'])){
							$config = array(
				               	array(
				                     'field'   => 'state_code',
				                     'label'   => 'State Code',
				                     'rules'   => 'required|xss_clean'
				                ),
				                array(
				                     'field'   => 'state_name',
				                     'label'   => 'State Name',
				                     'rules'   => 'required|xss_clean'
				                ),
				                array(
				                     'field'   => 'cmb_country',
				                     'label'   => 'Country Name',
				                     'rules'   => 'required|xss_clean'
				                ),
				                array(
				                     'field'   => 'state_status',
				                     'label'   => 'State Status',
				                     'rules'   => 'required|xss_clean'
				                )
				            );
						}else{
							$data = array(
				                'status' => false,
				                'msg' => 'Operation Type is blank'
				            );
			            	echo json_encode($data);
						}
			  			$this->form_validation->set_rules($config);
						if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
			            	echo json_encode($data);
						}else{
							echo json_encode($this->admin_model->admin($_POST, $_POST['op_type']));
						} 
					}else{
						$data = array(
					        'status' => false,
					        'msg' => 'Invalid Security Token'
					    );
						echo json_encode($data);
					}
				}else{
					$data = array(
				        'status' => false,
				        'msg' => 'Empty Security Token'
				    );
				}
			}
		}
		
		public function delete_state_data(){
			echo json_encode($this->admin_model->admin($_POST, $_POST['op_type']));
		}
 		public function get_country_dropdown(){
			echo json_encode($this->getter_model->get($_POST, $_POST['op_type']));
		}
		public function get_state_dropdown(){
			echo json_encode($this->getter_model->get($_POST, $_POST['op_type']));
		}
		public function get_dist_dropdown(){
			echo json_encode($this->getter_model->get($_POST, $_POST['op_type']));
		}
		public function get_block_dropdown(){
			echo json_encode($this->getter_model->get($_POST, $_POST['op_type']));
		}
		public function get_gp_dropdown(){
			echo json_encode($this->getter_model->get($_POST, $_POST['op_type']));
		}
		public function get_village_dropdown(){
			echo json_encode($this->getter_model->get($_POST, $_POST['op_type']));
		}
		public function check_duplicate_village_data(){
			echo json_encode($this->getter_model->get($_POST, $_POST['op_type']));
		}
			
		public function get_form_type(){
			echo json_encode($this->getter_model->get($_POST, $_POST['op_type']));
		}
		public function get_approval_status(){
			echo json_encode($this->getter_model->get($_POST, $_POST['op_type']));
		}
		public function get_area_type(){
			echo json_encode($this->getter_model->get(null, $_POST['op_type']));
		}
		public function get_gp_master(){
			$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_Gp_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dtblGp')){
			    	echo json_encode($this->admin_model->admin($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function operation_gpdata(){	
		 	$temp_rule = Array("&lt","&gt","<",">","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_op_circle_token'];
				if(!empty($input_csrf_token)){
					if(checkToken($input_csrf_token, 'form_circle')){
						if(!empty($_POST['op_type'])){
							$config = array(
				               	array(
				                     'field'   => 'gp_code',
				                     'label'   => 'Gram Panchayat Code',
				                     'rules'   => 'required|xss_clean'
				                ),
				                array(
				                     'field'   => 'gp_name',
				                     'label'   => 'Gram Panchayat Name',
				                     'rules'   => 'required|xss_clean'
				                ),
				                array(
				                     'field'   => 'cmb_country',
				                     'label'   => 'Country Name',
				                     'rules'   => 'required|xss_clean'
				                ),
				                array(
				                     'field'   => 'cmb_state',
				                     'label'   => 'State Name',
				                     'rules'   => 'required|xss_clean'
				                ), 
				                array(
				                     'field'   => 'cmb_dist',
				                     'label'   => 'District Name',
				                     'rules'   => 'required|xss_clean'
				                ),
				                array(
				                     'field'   => 'cmb_block',
				                     'label'   => 'Block Name',
				                     'rules'   => 'required|xss_clean'
				                ),
				                array(
				                     'field'   => 'gp_status',
				                     'label'   => 'Gram Panchayat Status',
				                     'rules'   => 'required|xss_clean'
				                )
				            );
						}else{
							$data = array(
				                'status' => false,
				                'msg' => 'Operation Type is blank'
				            );
			            	echo json_encode($data);
						}
			  			$this->form_validation->set_rules($config);
						if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
			            	echo json_encode($data);
						}else{
							echo json_encode($this->admin_model->admin($_POST, $_POST['op_type']));
						} 
					}else{
						$data = array(
					        'status' => false,
					        'msg' => 'Invalid Security Token'
					    );
						echo json_encode($data);
					}
				}else{
					$data = array(
				        'status' => false,
				        'msg' => 'Empty Security Token'
				    );
				}
			}
		}
		public function delete_gp(){
			echo json_encode($this->admin_model->admin($_POST, $_POST['op_type']));
		}
		public function get_village_master(){
			$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_village_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dtblVillage')){
			    	echo json_encode($this->admin_model->admin($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function operation_villagedata(){	
		 	$temp_rule = Array("&lt","&gt","<",">","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_op_village_token'];
				if(!empty($input_csrf_token)){
					if(checkToken($input_csrf_token, 'form_village')){
						if(!empty($_POST['op_type'])){
							$config = array(
				               	array(
				                     'field'   => 'txtCensusCode',
				                     'label'   => 'Census Code',
				                     'rules'   => 'required|xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'txtVillageName',
				                     'label'   => 'Village Name',
				                     'rules'   => 'required|xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'cmb_state',
				                     'label'   => 'State Name',
				                     'rules'   => 'required|xss_clean|trim'
				                ), 
				                array(
				                     'field'   => 'cmb_dist',
				                     'label'   => 'District Name',
				                     'rules'   => 'required|xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'cmb_block',
				                     'label'   => 'Block Name',
				                     'rules'   => 'required|xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'cmb_gp',
				                     'label'   => 'Gram Panchayat Name',
				                     'rules'   => 'required|xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'village_status',
				                     'label'   => 'Village Status',
				                     'rules'   => 'required|xss_clean|trim'
				                )
				            );
						}else{
							$data = array(
				                'status' => false,
				                'msg' => 'Operation Type is blank'
				            );
			            	echo json_encode($data);
						}
			  			$this->form_validation->set_rules($config);
						if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
			            	echo json_encode($data);
						}else{
							echo json_encode($this->admin_model->admin($_POST, $_POST['op_type']));
						} 
					}else{
						$data = array(
					        'status' => false,
					        'msg' => 'Invalid Security Token'
					    );
						echo json_encode($data);
					}
				}else{
					$data = array(
				        'status' => false,
				        'msg' => 'Empty Security Token'
				    );
				}
			}
		}
		public function delete_village(){
			echo json_encode($this->admin_model->admin($_POST, $_POST['op_type']));
		}
		public function get_district_master(){
			$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_district_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'district_table')){
			    	echo json_encode($this->admin_model->admin($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function operation_districtdata(){	
		 	$temp_rule = Array("&lt","&gt","<",">","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_op_district_token'];
				if(!empty($input_csrf_token)){
					if(checkToken($input_csrf_token, 'form_district')){
						if(!empty($_POST['op_type'])){
							$config = array(
				               	array(
				                     'field'   => 'district_code',
				                     'label'   => 'District Code',
				                     'rules'   => 'required|xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'txtDistCensusCode',
				                     'label'   => 'Census Code',
				                     'rules'   => 'required|xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'district_name',
				                     'label'   => 'District Name',
				                     'rules'   => 'required|xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'cmb_country',
				                     'label'   => 'Country Name',
				                     'rules'   => 'required|xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'cmb_state',
				                     'label'   => 'State Name',
				                     'rules'   => 'required|xss_clean|trim'
				                ), 
				                array(
				                     'field'   => 'district_status',
				                     'label'   => 'District Status',
				                     'rules'   => 'required|xss_clean|trim'
				                )
				            );
						}else{
							$data = array(
				                'status' => false,
				                'msg' => 'Operation Type is blank'
				            );
			            	echo json_encode($data);
						}
			  			$this->form_validation->set_rules($config);
						if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
			            	echo json_encode($data);
						}else{
							echo json_encode($this->admin_model->admin($_POST, $_POST['op_type']));
						} 
					}else{
						$data = array(
					        'status' => false,
					        'msg' => 'Invalid Security Token'
					    );
						echo json_encode($data);
					}
				}else{
					$data = array(
				        'status' => false,
				        'msg' => 'Empty Security Token'
				    );
				}
			}
		}
		public function delete_district(){
			echo json_encode($this->admin_model->admin($_POST, $_POST['op_type']));
		}
		public function get_block_master(){
			$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_block_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'block_table')){
			    	echo json_encode($this->admin_model->admin($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function operation_blockdata(){	
		 	$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_op_block_token'];
				if(!empty($input_csrf_token)){
					if(checkToken($input_csrf_token, 'form_block')){
						if(!empty($_POST['op_type'])){
							$config = array(
				               	array(
				                    'field'   => 'block_code',
				                    'label'   => 'Block Code',
				                    'rules'   => 'required|xss_clean'
				                ),
				                array(
				                    'field'   => 'block_name',
				                    'label'   => 'Block Name',
				                    'rules'   => 'required|xss_clean'
				                ),
				                array(
				                    'field'   => 'cmb_country',
				                    'label'   => 'Country Name',
				                    'rules'   => 'required|xss_clean'
				                ),
				                array(
				                    'field'   => 'cmb_state',
				                    'label'   => 'State Name',
				                    'rules'   => 'required|xss_clean'
				                ),
				                array(
				                    'field'   => 'cmb_district',
				                    'label'   => 'District Name',
				                    'rules'   => 'required|xss_clean'
				                ),  
				                array(
				                    'field'   => 'block_status',
				                    'label'   => 'Block Status',
				                    'rules'   => 'required|xss_clean'
				                )
				            );
						}else{
							$data = array(
				                'status' => false,
				                'msg' => 'Operation Type is blank'
				            );
			            	echo json_encode($data);
						}
			  			$this->form_validation->set_rules($config);
						if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
			            	echo json_encode($data);
						}else{
							echo json_encode($this->admin_model->admin($_POST, $_POST['op_type']));
						} 
					}else{
						$data = array(
					        'status' => false,
					        'msg' => 'Invalid Security Token'
					    );
						echo json_encode($data);
					}
				}else{
					$data = array(
				        'status' => false,
				        'msg' => 'Empty Security Token'
				    );
				}
			}
		}
		public function delete_block(){
			echo json_encode($this->admin_model->admin($_POST, $_POST['op_type']));
		}
		public function get_amount_data(){
			$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_amount_setup_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'amount_setup_table')){
			    	echo json_encode($this->admin_model->admin($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function operation_amount_setup(){
			$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_op_gencode_token'];
				if(!empty($input_csrf_token)){
					if(checkToken($input_csrf_token, 'form_amt_setup')){
						if($_POST['op_type'] == 'add_amount_setup'){
							$config = array(
				               	array(
				                    'field'   => 'cmb_licence_for',
				                    'label'   => 'Licence For',
				                    'rules'   => 'trim|required|xss_clean'
				                ),
				                array(
				                    'field'   => 'cmb_appl_type',
				                    'label'   => 'Application Type',
				                    'rules'   => 'trim|required|xss_clean'
				                ),
				                array(
				                    'field'   => 'cmb_applied_for',
				                    'label'   => 'Applied For',
				                    'rules'   => 'trim|required|xss_clean'
				                ),
				                array(
				                    'field'   => 'cmb_area_type',
				                    'label'   => 'Area Type',
				                    'rules'   => 'trim|required|xss_clean'
				                ),
				                array(
				                    'field'   => 'txt_amount',
				                    'label'   => 'Amount',
				                    'rules'   => 'trim|required|xss_clean'
				                ),  
				                array(
				                    'field'   => 'status',
				                    'label'   => 'Status',
				                    'rules'   => 'trim|required|xss_clean'
				                )
				            );
						}else{
							$config = array(
				               	array(
				                    'field'   => 'hidden_licence_for',
				                    'label'   => 'Licence For',
				                    'rules'   => 'trim|required|xss_clean'
				                ),
				                array(
				                    'field'   => 'hidden_appl_type',
				                    'label'   => 'Application Type',
				                    'rules'   => 'trim|required|xss_clean'
				                ),
				                array(
				                    'field'   => 'hidden_applied_for',
				                    'label'   => 'Applied For',
				                    'rules'   => 'trim|required|xss_clean'
				                ),
				                array(
				                    'field'   => 'hidden_area_type',
				                    'label'   => 'Area Type',
				                    'rules'   => 'trim|required|xss_clean'
				                ),
				                array(
				                    'field'   => 'txt_amount',
				                    'label'   => 'Amount',
				                    'rules'   => 'trim|required|xss_clean'
				                ),  
				                array(
				                    'field'   => 'status',
				                    'label'   => 'Status',
				                    'rules'   => 'trim|required|xss_clean'
				                )
				            );
						}
			  			$this->form_validation->set_rules($config);
						if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
			            	echo json_encode($data);
						}else{
							echo json_encode($this->admin_model->admin($_POST, $_POST['op_type']));
						} 
					}else{
						$data = array(
					        'status' => false,
					        'msg' => 'Invalid Security Token'
					    );
						echo json_encode($data);
					}
				}else{
					$data = array(
				        'status' => false,
				        'msg' => 'Empty Security Token'
				    );
				}
			}
		}
		public function delete_amount_setup(){
			echo json_encode($this->admin_model->admin($_POST, $_POST['op_type']));
		}
		/**
		* Author   		: Debashish Jyotish
		* Function 		: get_emailsetup_data,
		* purpose  		: To show data in datatable, 
		* List of data 	: User, Menu, Role, Resource, Group
		* Date     		: 19-07-2018
		* Remark   		: Get data from model and forward data as JSON 
		*/
	
	    public function get_emailsetup_data(){
			$type = $this->uri->segment(3);
			$inputCsrfToken = $_POST['hidemailCsrfToken'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dtblprovidermaster')){
			    	echo json_encode($this->admin_model->admin($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function operation_providerdata(){
			$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_provider_token'];
				if(!empty($input_csrf_token)){
					if(checkToken($input_csrf_token, 'frm_provider')){
						if($_POST['op_type'] == 'edit_provider'){
							$config = array(
				               	array(
				                     'field'   => 'txtProvidername',
				                     'label'   => 'Provider Name',
				                     'rules'   => 'required|trim|xss_clean'
				                ),
				               	array(
				                     'field'   => 'txtHostName',
				                     'label'   => 'Host Name',
				                     'rules'   => 'required|trim|xss_clean'
				                ),
				               	array(
				                     'field'   => 'txtPort',
				                     'label'   => 'Port',
				                     'rules'   => 'required|trim|xss_clean'
				                ),
				              	 array(
				                     'field'   => 'txt_Email',
				                     'label'   => 'Email',
				                     'rules'   => 'required|trim|xss_clean'
				                ),
				                array(
				                     'field'   => 'txt_password',
				                     'label'   => 'Password',
				                     'rules'   => 'required|trim|xss_clean'
				                ),
				                  
				                array(
				                     'field'   => 'cmb_smptauth',
				                     'label'   => 'SMTP',
				                     'rules'   => 'required|trim|xss_clean'
				                ),
				                array(
				                     'field'   => 'cmb_smptsecure',
				                     'label'   => 'SMTP',
				                     'rules'   => 'required|trim|xss_clean'
				                ),
				                array(
				                     'field'   => 'cmbStatus',
				                     'label'   => 'SMTP',
				                     'rules'   => 'required|trim|xss_clean'
				                )
				                
				            );
						}else{
							$config = array(
				              array(
				                    'field'   => 'txtProvidername',
				                    'label'   => 'Provider Name',
				                    'rules'   => 'required|trim|xss_clean'
				                ),
				               	array(
				                    'field'   => 'txtHostName',
				                    'label'   => 'Host Name',
				                    'rules'   => 'required|trim|xss_clean'
				                ),
				               	array(
				                    'field'   => 'txtPort',
				                    'label'   => 'Port',
				                    'rules'   => 'required|trim|xss_clean'
				                ),
				              	 array(
				                    'field'   => 'txt_Email',
				                    'label'   => 'Email',
				                    'rules'   => 'required|trim|xss_clean'
				                ),
				                array(
				                    'field'   => 'txt_password',
				                    'label'   => 'Password',
				                    'rules'   => 'required|trim|xss_clean'
				                ),
				                  
				                array(
				                    'field'   => 'cmb_smptauth',
				                    'label'   => 'SMTP',
				                    'rules'   => 'required|trim|xss_clean'
				                ),
				                array(
				                    'field'   => 'cmb_smptsecure',
				                    'label'   => 'SMTP',
				                    'rules'   => 'required|trim|xss_clean'
				                ),
				                array(
				                    'field'   => 'cmbStatus',
				                    'label'   => 'SMTP',
				                    'rules'   => 'required|trim|xss_clean'
				                ),
				            );
						}
						$this->form_validation->set_rules($config); 
					    if ($this->form_validation->run(
					    ) == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						}else{
							echo json_encode($this->admin_model->admin($_POST, $_POST['op_type']));
						}
					}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
						echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
		        }
			}
		}
		public function delete_provider(){
			echo json_encode($this->admin_model->admin($_POST, $_POST['op_type']));
		} 
		public function get_setupemail_data(){
			$type = $this->uri->segment(3);
			$inputCsrfToken = $_POST['emailSetupCsrfToken'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dtblemailsetup')){
			    	echo json_encode($this->admin_model->admin($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		} 
		public function operation_emaildata(){
			$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_email_token'];
				if(!empty($input_csrf_token)){
					if(checkToken($input_csrf_token, 'frm_email')){
						if($_POST['op_type_email'] == 'edit_email'){
							$config = array(
				               	array(
				                     'field'   => 'txtMailType',
				                     'label'   => 'Provider Name',
				                     'rules'   => 'required|trim|xss_clean'
				                ),
				               	array(
				                     'field'   => 'txtSubject',
				                     'label'   => 'Host Name',
				                     'rules'   => 'required|trim|xss_clean'
				                ),
				               	array(
				                     'field'   => 'txtContent',
				                     'label'   => 'Port',
				                     'rules'   => 'required|trim|xss_clean'
				                ),
				              	 array(
				                     'field'   => 'txtProvider',
				                     'label'   => 'Email',
				                     'rules'   => 'required|trim|xss_clean'
				                ),
				                array(
				                     'field'   => 'cmbEmailStatus',
				                     'label'   => 'Password',
				                     'rules'   => 'required|trim|xss_clean'
				                )
				            );
						}else{
							$config = array(
				              	array(
				                     'field'   => 'txtMailType',
				                     'label'   => 'Provider Name',
				                     'rules'   => 'required|trim|xss_clean'
				                ),
				               	array(
				                     'field'   => 'txtSubject',
				                     'label'   => 'Host Name',
				                     'rules'   => 'required|trim|xss_clean'
				                ),
				               	array(
				                     'field'   => 'txtContent',
				                     'label'   => 'Port',
				                     'rules'   => 'required|trim|xss_clean'
				                ),
				              	 array(
				                     'field'   => 'txtProvider',
				                     'label'   => 'Email',
				                     'rules'   => 'required|trim|xss_clean'
				                ),
				                array(
				                     'field'   => 'cmbEmailStatus',
				                     'label'   => 'Password',
				                     'rules'   => 'required|trim|xss_clean'
				                )
				            );
						}
						$this->form_validation->set_rules($config); 
					    if ($this->form_validation->run(
					    ) == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						}else{
							echo json_encode($this->admin_model->admin($_POST, $_POST['op_type_email']));
						}
					}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
						echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
		        }
			}
		} 
		public function delete_emailsetup(){
			echo json_encode($this->admin_model->admin($_POST, $_POST['op_type']));
		} 
		public function get_smsprovider_data(){
			$type = $this->uri->segment(3);
			$inputCsrfToken = $_POST['hidsmsCsrfToken'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dtblsmsmaster')){
			    	echo json_encode($this->admin_model->admin($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}  
		public function operation_smsproviderdata(){
			$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_smsprovider_token'];
				if(!empty($input_csrf_token)){
					if(checkToken($input_csrf_token, 'frm_smsprovider')){
						if($_POST['op_type'] == 'edit_smsprovider'){
							$config = array(
				               	 array(
					                'field'   => 'txtProviderName',
					                'label'   => 'Provider Name',
					                'rules'   => 'required'
					            ),
				           		array(
				                 	'field'   => 'txtSMSUrl',
				                 	'label'   => 'SMS Url Name',
				                 	'rules'   => 'required'
				              	),
				          		array(
					            	'field'   => 'txt_UserName',
					            	'label'   => 'User Name',
					            	'rules'   => 'required'
				          		),
				            	array(
				                	'field'   => 'txt_password',
				                	'label'   => 'Password',
				                	'rules'   => 'required'
				            	),
				            	array(
				                	'field'   => 'txt_Sender',
				                	'label'   => 'SMPT Authentication',
				                	'rules'   => 'required'
				            	),
				            	array(
				                	'field'   => 'cmbSMSProviderstatus',
				                	'label'   => 'SMS Provider Status',
				                	'rules'   => 'required'
				            	)
				            );
						}else{
							$config = array(
				              	 array(
					                'field'   => 'txtProviderName',
					                'label'   => 'Provider Name',
					                'rules'   => 'required'
						        ),
				           		array(
				                 	'field'   => 'txtSMSUrl',
				                 	'label'   => 'SMS Url Name',
				                 	'rules'   => 'required'
				              	),
				          		array(
					            	'field'   => 'txt_UserName',
					            	'label'   => 'User Name',
					            	'rules'   => 'required'
				          		),
				            	array(
				                	'field'   => 'txt_password',
				                	'label'   => 'Password',
				                	'rules'   => 'required'
				            	),
				            	array(
				                	'field'   => 'txt_Sender',
				                	'label'   => 'SMPT Authentication',
				                	'rules'   => 'required'
				            	),
				            	array(
				                	'field'   => 'cmbSMSProviderstatus',
				                	'label'   => 'SMS Provider Status',
				                	'rules'   => 'required'
			            		)
				            );
						}
						$this->form_validation->set_rules($config); 
					    if ($this->form_validation->run(
					    ) == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						}else{
							echo json_encode($this->admin_model->admin($_POST, $_POST['op_type']));
						}
					}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
						echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
		        }
			}
		}
		public function delete_smsprovider(){
			echo json_encode($this->admin_model->admin($_POST, $_POST['op_type']));
		} 
		public function get_smssetup_data(){
			$type = $this->uri->segment(3);
			$inputCsrfToken = $_POST['hidsmsSetupCsrfToken'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dtblsmssetup')){
			    	echo json_encode($this->admin_model->admin($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function operation_smsdata(){
			$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_smssetup_token'];
				if(!empty($input_csrf_token)){
					if(checkToken($input_csrf_token, 'frm_sms_setup')){
						if($_POST['op_type_sms'] == 'edit_smssetup'){
							$config = array(
								array(
					                'field'   => 'txtSMSType',
					                'label'   => 'SMS Type',
					                'rules'   => 'trim|required|xss_clean'
					            ),
					            array(
					                'field'   => 'txtSubject',
					                'label'   => 'Subject',
					                'rules'   => 'trim|required|xss_clean'
					            ),
					            array(
					                'field'   => 'txtSMSContent',
					                'label'   => 'SMS Content',
					                'rules'   => 'trim|required|xss_clean'
					            ),
					            array(
					                'field'   => 'txtSMSProvider',
					                'label'   => 'SMS Provider',
					                'rules'   => 'trim|required|xss_clean'
					            ),
					            array(
					                'field'   => 'cmbSMSstatus',
					                'label'   => 'SMS status',
					                'rules'   => 'trim|required|xss_clean'
					            ),
				            );
						}else{
							$config = array(
				              	 array(
					                'field'   => 'txtSMSType',
					                'label'   => 'SMS Type',
					                'rules'   => 'trim|required|xss_clean'
					            ),
					            array(
					                'field'   => 'txtSubject',
					                'label'   => 'Subject',
					                'rules'   => 'trim|required|xss_clean'
					            ),
					            array(
					                'field'   => 'txtSMSContent',
					                'label'   => 'SMS Content',
					                'rules'   => 'trim|required|xss_clean'
					            ),
					            array(
					                'field'   => 'txtSMSProvider',
					                'label'   => 'SMS Provider',
					                'rules'   => 'trim|required|xss_clean'
					            ),
					            array(
					                'field'   => 'cmbSMSstatus',
					                'label'   => 'SMS status',
					                'rules'   => 'trim|required|xss_clean'
					            ),
				            );
						}
						$this->form_validation->set_rules($config); 
					    if ($this->form_validation->run(
					    ) == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						}else{
							echo json_encode($this->admin_model->admin($_POST, $_POST['op_type_sms']));
						}
					}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
						echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
		        }
			}
		}
		public function delete_smssetup(){
			echo json_encode($this->admin_model->admin($_POST, $_POST['op_type']));
		}
		/**
		* 
		* purpose  		: Page Creation, 
		* Date     		: 25-07-2018
		* Remark   		: Create Contoller,Model and View Page
		*/
		public function get_controller_data(){
			$type = $this->uri->segment(3);
			$inputCsrfToken = $_POST['hidControllerCsrfToken'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dtblControllerMaster')){
			    	echo json_encode($this->superadmin_model->superadmin($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function operation_controller(){
			$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_controller_token'];
				if(!empty($input_csrf_token)){
					if(checkToken($input_csrf_token, 'form_controller')){
						if($_POST['op_controller'] == 'add_controller'){
							$config = array(
								array(
					                'field'   => 'txt_controller_code',
					                'label'   => 'Controller Code',
					                'rules'   => 'trim|required|xss_clean'
					            ),
					            array(
					                'field'   => 'txt_controller_name',
					                'label'   => 'Controller Name',
					                'rules'   => 'trim|required|xss_clean'
					            )
				            );
						}else{
			                $data = array(
				                'status' => false,
			                	'msg' => 'Operation Type Error'
				            );
							echo json_encode($data);
						}
						$this->form_validation->set_rules($config); 
					    if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						}else{
							echo json_encode($this->superadmin_model->superadmin($_POST, $_POST['op_controller']));
						}
					}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
						echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
		        }
			}
		}
		public function get_model_data(){
			$type = $this->uri->segment(3);
			$inputCsrfToken = $_POST['hidmodelCsrfToken'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dtblmodelmaster')){
			    	echo json_encode($this->superadmin_model->superadmin($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function operation_model(){
			$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_model_token'];
				if(!empty($input_csrf_token)){
					if(checkToken($input_csrf_token, 'form_model')){
						if($_POST['op_type_model'] == 'add_model'){
							$config = array(
								array(
					                'field'   => 'txt_model_code',
					                'label'   => 'Model Code',
					                'rules'   => 'trim|required|xss_clean'
					            ),
					            array(
					                'field'   => 'txtModelName',
					                'label'   => 'Model Name',
					                'rules'   => 'trim|required|xss_clean'
					            )
				            );
						}else{
			                $data = array(
				                'status' => false,
			                	'msg' => 'Operation Type Error'
				            );
							echo json_encode($data);
						}
						
						$this->form_validation->set_rules($config); 
					    if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						}else{
							echo json_encode($this->superadmin_model->superadmin($_POST, $_POST['op_type_model']));
						}
					}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
						echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
		        }
			}
		}
		public function get_view_data(){
			$type = $this->uri->segment(3);
			$inputCsrfToken = $_POST['hidViewCsrfToken'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dtblviewmaster')){
			    	echo json_encode($this->superadmin_model->superadmin($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function operation_view(){
			$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_view_token'];
				if(!empty($input_csrf_token)){
					if(checkToken($input_csrf_token, 'form_view')){
						if($_POST['op_view'] == 'add_view'){
							$config = array(
								array(
					                'field'   => 'cmb_view_path',
					                'label'   => 'View path',
					                'rules'   => 'trim|required|xss_clean'
					            ),
					            array(
					                'field'   => 'txt_view_code',
					                'label'   => 'View Code',
					                'rules'   => 'trim|required|xss_clean'
					            ),
					            array(
					                'field'   => 'txt_view_name',
					                'label'   => 'View Name',
					                'rules'   => 'trim|required|xss_clean'
					            )
				            );
						}else{
			                $data = array(
				                'status' => false,
			                	'msg' => 'Operation Type Error'
				            );
							echo json_encode($data);
						}
						$this->form_validation->set_rules($config); 
					    if ($this->form_validation->run(
					    ) == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						}else{
							echo json_encode($this->superadmin_model->superadmin($_POST, $_POST['op_view']));
						}
					}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
						echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
		        }
			}
		}
		/**Page Creation end**/
		/**
		* Function 		: import_countrydata,
		* purpose  		: Upload the country excel data to database, 
		* Date     		: 20-07-2018
		* Remark   		: Get data from excel and Insert into the database
		*/
		public function import_countrydata() {
			require_once APPPATH.'/third_party/phpexcel/PHPExcel.php';
	        $data = '';
	       
        	if ($this->input->post('importfile')) {
	            $path = FCPATH.'public/upload/excel_files/';
	            $config['upload_path'] = $path;
	            $config['allowed_types'] = 'xlsx|xls';
	            $config['remove_spaces'] = TRUE;
	            $this->load->library('upload', $config);
	            if (!empty($this->input->post('importfile'))) {
	                $import_xls_file = $this->input->post('importfile');
	            } else {
	                $import_xls_file = 0;
	            }
	            $inputFileName = $import_xls_file;
	            try {
	                $inputFileType = PHPExcel_IOFactory::identify($inputFileName);
	                $objReader = PHPExcel_IOFactory::createReader($inputFileType);
	                $objPHPExcel = $objReader->load($inputFileName);
	            } catch (Exception $e) {
	                die('Error loading file "' . pathinfo($inputFileName, PATHINFO_BASENAME).'": ' . $e->getMessage());
	            }
            	$allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
            
	            $arrayCount = count($allDataInSheet);
	            $flag = 0;
	            $createArray = array('country_code','country_name');
	            $makeArray = array('country_code' => 'country_code','country_name'=>'country_name');  
	            $SheetDataKey = array();
	            
	            foreach ($allDataInSheet as $dataInSheet) {
	                foreach ($dataInSheet as $key => $value) {
	                	$value = preg_replace('/\s+/', '', $value);
	                    if (in_array($value, $createArray)) {
	                        $value = preg_replace('/\s+/', '', $value);
	                        $SheetDataKey[$value] = $key;
	                    }else{
	                        
	                    }
	                }
	            }
	            $data = array_diff_key($makeArray, $SheetDataKey);
	            if (empty($data)) {
	                $flag = 1;
	            }
	            if ($flag == 1) {
	                for ($i = 2; $i <= $arrayCount; $i++) {
	                    $addresses = array();
	                    $country_code = $SheetDataKey['country_code'];
	                    $country_name = $SheetDataKey['country_name'];
	                    $country_code = filter_var(trim($allDataInSheet[$i][$country_code]), FILTER_SANITIZE_STRING);
	                    $country_name = filter_var(trim($allDataInSheet[$i][$country_name]), FILTER_SANITIZE_STRING);
						$fetchData[] = array('country_code' => $country_code,'country_name' => $country_name);
	                }
	                $data['employeeInfo'] = $fetchData;
	                $this->admin_model->setBatchImport($fetchData);
	                echo json_encode($this->admin_model->importData('COUNTRY_DATA'));	
            	}else{
                	echo "Error in excel  file";
            	}
        	}
    	}
    	
    	/**
		* Function 		: import_Statedata,
		* purpose  		: Upload the state excel data to database, 
		* Date     		: 20-07-2018
		* Remark   		: Get data from excel and Insert into the database
		*/
		public function import_statedata() {
			require_once APPPATH.'/third_party/phpexcel/PHPExcel.php';
	        $data = '';
	       
        	if ($this->input->post('importfile')) {
	            $path = FCPATH.'public/upload/excel_files/';
	            $config['upload_path'] = $path;
	            $config['allowed_types'] = 'xlsx|xls';
	            $config['remove_spaces'] = TRUE;
	            $this->load->library('upload', $config);
	            if (!empty($this->input->post('importfile'))) {
	                $import_xls_file = $this->input->post('importfile');
	            } else {
	                $import_xls_file = 0;
	            }
	            $inputFileName = $import_xls_file;
	            try {
	                $inputFileType = PHPExcel_IOFactory::identify($inputFileName);
	                $objReader = PHPExcel_IOFactory::createReader($inputFileType);
	                $objPHPExcel = $objReader->load($inputFileName);
	            } catch (Exception $e) {
	                die('Error loading file "' . pathinfo($inputFileName, PATHINFO_BASENAME).'": ' . $e->getMessage());
	            }
            	$allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
            
	            $arrayCount = count($allDataInSheet);
	            $flag = 0;
	            $createArray = array('state_code','state_name','country_code');
	            $makeArray = array('state_code' => 'state_code','state_name'=>'state_name','country_code'=>'country_code');  
	            $SheetDataKey = array();
	            
	            foreach ($allDataInSheet as $dataInSheet) {
	                foreach ($dataInSheet as $key => $value) {
	                	$value = preg_replace('/\s+/', '', $value);
	                    if (in_array($value, $createArray)) {
	                        $value = preg_replace('/\s+/', '', $value);
	                        $SheetDataKey[$value] = $key;
	                    }else{
	                        
	                    }
	                }
	            }
	            $data = array_diff_key($makeArray, $SheetDataKey);
	            if (empty($data)) {
	                $flag = 1;
	            }
	            if ($flag == 1) {
	                for ($i = 2; $i <= $arrayCount; $i++) {
	                    $addresses = array();
	                    $state_code = $SheetDataKey['state_code'];
	                    $state_name = $SheetDataKey['state_name'];
	                    $country_code = $SheetDataKey['country_code'];
	                    $state_code = filter_var(trim($allDataInSheet[$i][$state_code]), FILTER_SANITIZE_STRING);
	                    $state_name = filter_var(trim($allDataInSheet[$i][$state_name]), FILTER_SANITIZE_STRING);
	                    $country_code = filter_var(trim($allDataInSheet[$i][$country_code]), FILTER_SANITIZE_STRING);
						$fetchData[] = array('state_code' => $state_code,'state_name' => $state_name,'country_code'=>$country_code);
	                }
	                $data['employeeInfo'] = $fetchData;
	                $this->admin_model->setBatchImport($fetchData);
	                echo json_encode($this->admin_model->importData('STATE_DATA'));	
            	}else{
                	echo "Error in excel  file";
            	}
        	}
    	}
		/**
		* Function 		: import_districtdata,
		* purpose  		: Upload the District excel data to database, 
		* Date     		: 21-07-2018
		* Remark   		: Get data from excel and Insert into the database
		*/
		public function import_districtdata() {
			require_once APPPATH.'/third_party/phpexcel/PHPExcel.php';
	        $data = '';
	       
        	if ($this->input->post('importfile')) {
	            $path = FCPATH.'public/upload/excel_files/';
	            $config['upload_path'] = $path;
	            $config['allowed_types'] = 'xlsx|xls';
	            $config['remove_spaces'] = TRUE;
	            $this->load->library('upload', $config);
	            if (!empty($this->input->post('importfile'))) {
	                $import_xls_file = $this->input->post('importfile');
	            } else {
	                $import_xls_file = 0;
	            }
	            $inputFileName = $import_xls_file;
	            try {
	                $inputFileType = PHPExcel_IOFactory::identify($inputFileName);
	                $objReader = PHPExcel_IOFactory::createReader($inputFileType);
	                $objPHPExcel = $objReader->load($inputFileName);
	            } catch (Exception $e) {
	                die('Error loading file "' . pathinfo($inputFileName, PATHINFO_BASENAME).'": ' . $e->getMessage());
	            }
            	$allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
            
	            $arrayCount = count($allDataInSheet);
	            $flag = 0;
	            $createArray = array('district_code','district_name','state_code','country_code','dist_census_code');
			    $makeArray = array('district_code' => 'district_code','district_name'=>'district_name','state_code'=>'state_code','country_code'=>'country_code','dist_census_code'=>'dist_census_code');
	            $SheetDataKey = array();
	            
	            foreach ($allDataInSheet as $dataInSheet) {
	                foreach ($dataInSheet as $key => $value) {
	                	$value = preg_replace('/\s+/', '', $value);
	                    if (in_array($value, $createArray)) {
	                        $value = preg_replace('/\s+/', '', $value);
	                        $SheetDataKey[$value] = $key;
	                    }else{
	                        
	                    }
	                }
	            }
	            $data = array_diff_key($makeArray, $SheetDataKey);
	            if (empty($data)) {
	                $flag = 1;
	            }
	            if ($flag == 1) {
	                for ($i = 2; $i <= $arrayCount; $i++) {
	                    $addresses = array();
	                    $district_code = $SheetDataKey['district_code'];
			            $district_name = $SheetDataKey['district_name'];
			            $state_code = $SheetDataKey['state_code'];
			            $country_code = $SheetDataKey['country_code'];
			            $dist_census_code = $SheetDataKey['dist_census_code'];
	                    $district_code = filter_var(trim($allDataInSheet[$i][$district_code]), FILTER_SANITIZE_STRING);
	                    $district_name = filter_var(trim($allDataInSheet[$i][$district_name]), FILTER_SANITIZE_STRING);
	                    $state_code = filter_var(trim($allDataInSheet[$i][$state_code]), FILTER_SANITIZE_STRING);
	                    $country_code = filter_var(trim($allDataInSheet[$i][$country_code]), FILTER_SANITIZE_STRING);
			            $dist_census_code = filter_var(trim($allDataInSheet[$i][$dist_census_code]), FILTER_SANITIZE_STRING);       
						$fetchData[] = array('district_code' => $district_code,'district_name' => $district_name,'state_code'=>$state_code,'country_code'=>$country_code,'dist_census_code'=>$dist_census_code);
	                }
	                $data['employeeInfo'] = $fetchData;
	                $this->admin_model->setBatchImport($fetchData);
	                echo json_encode($this->admin_model->importData('DISTRICT_DATA'));	
            	}else{
                	echo "Error in excel  file";
            	}
        	}
    	}
    	/**
		* Function 		: import_blockdata,
		* purpose  		: Upload the Circle excel data to database, 
		* Date     		: 21-07-2018
		* Remark   		: Get data from excel and Insert into the database
		*/
    	public function import_blockdata() {
			require_once APPPATH.'/third_party/phpexcel/PHPExcel.php';
	        $data = '';
	       
        	if ($this->input->post('importfile')) {
	            $path = FCPATH.'public/upload/excel_files/';
	            $config['upload_path'] = $path;
	            $config['allowed_types'] = 'xlsx|xls';
	            $config['remove_spaces'] = TRUE;
	            $this->load->library('upload', $config);
	            if (!empty($this->input->post('importfile'))) {
	                $import_xls_file = $this->input->post('importfile');
	            } else {
	                $import_xls_file = 0;
	            }
	            $inputFileName = $import_xls_file;
	            try {
	                $inputFileType = PHPExcel_IOFactory::identify($inputFileName);
	                $objReader = PHPExcel_IOFactory::createReader($inputFileType);
	                $objPHPExcel = $objReader->load($inputFileName);
	            } catch (Exception $e) {
	                die('Error loading file "' . pathinfo($inputFileName, PATHINFO_BASENAME).'": ' . $e->getMessage());
	            }
            	$allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
            
	            $arrayCount = count($allDataInSheet);
	            $flag = 0;
	            $createArray = array('block_code','block_name','district_code','state_code','country_code');
			    $makeArray = array('block_code' => 'block_code','block_name'=>'block_name','district_code'=>'district_code','state_code'=>'state_code','country_code'=>'country_code');
	            $SheetDataKey = array();
	            
	            foreach ($allDataInSheet as $dataInSheet) {
	                foreach ($dataInSheet as $key => $value) {
	                	$value = preg_replace('/\s+/', '', $value);
	                    if (in_array($value, $createArray)) {
	                        $value = preg_replace('/\s+/', '', $value);
	                        $SheetDataKey[$value] = $key;
	                    }else{
	                        
	                    }
	                }
	            }
	            $data = array_diff_key($makeArray, $SheetDataKey);
	            if (empty($data)) {
	                $flag = 1;
	            }
	            if ($flag == 1) {
	                for ($i = 2; $i <= $arrayCount; $i++) {
	                    $addresses = array();
	                    $block_code = $SheetDataKey['block_code'];
			                    $block_name = $SheetDataKey['block_name'];
			                    $district_code = $SheetDataKey['district_code'];
			                    $state_code = $SheetDataKey['state_code'];
			                    $country_code = $SheetDataKey['country_code'];
			                    
			                    $block_code = filter_var(trim($allDataInSheet[$i][$block_code]), FILTER_SANITIZE_STRING);
			                    $block_name = filter_var(trim($allDataInSheet[$i][$block_name]), FILTER_SANITIZE_STRING);
			                    $district_code = filter_var(trim($allDataInSheet[$i][$district_code]), FILTER_SANITIZE_STRING);
			                    $state_code = filter_var(trim($allDataInSheet[$i][$state_code]), FILTER_SANITIZE_STRING);
			                    $country_code = filter_var(trim($allDataInSheet[$i][$country_code]), FILTER_SANITIZE_STRING);
								$fetchData[] = array('importFileName' => $inputFileName,'block_code' => $block_code,'block_name' => $block_name,'district_code'=>$district_code,'state_code'=>$state_code,'country_code'=>$country_code);
	                }
	                $data['employeeInfo'] = $fetchData;
	                $this->admin_model->setBatchImport($fetchData);
	                echo json_encode($this->admin_model->importData('BLOCK_DATA'));	
            	}else{
                	echo "Error in excel  file";
            	}
        	}
    	}
    	/**
		* Function 		: import_gpdata,
		* purpose  		: Upload the Circle excel data to database, 
		* Date     		: 21-07-2018
		* Remark   		: Get data from excel and Insert into the database
		*/
		public function import_gpdata() {
			require_once APPPATH.'/third_party/phpexcel/PHPExcel.php';
	        $data = '';
        	if ($this->input->post('importfile')) {
	            $path = FCPATH.'public/upload/excel_files/';
	            $config['upload_path'] = $path;
	            $config['allowed_types'] = 'xlsx|xls';
	            $config['remove_spaces'] = TRUE;
	            $this->load->library('upload', $config);
	            if (!empty($this->input->post('importfile'))) {
	                $import_xls_file = $this->input->post('importfile');
	            } else {
	                $import_xls_file = 0;
	            }
	            $inputFileName = $import_xls_file;
	            try {
	                $inputFileType = PHPExcel_IOFactory::identify($inputFileName);
	                $objReader = PHPExcel_IOFactory::createReader($inputFileType);
	                $objPHPExcel = $objReader->load($inputFileName);
	            } catch (Exception $e) {
	                die('Error loading file "' . pathinfo($inputFileName, PATHINFO_BASENAME).'": ' . $e->getMessage());
	            }
            	$allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
            
	            $arrayCount = count($allDataInSheet);
	            $flag = 0;
	            $createArray = array('gp_code','gp_name','block_code','district_census_code','district_code','state_code','country_code');
			    $makeArray = array('gp_code' => 'gp_code','gp_name'=>'gp_name','block_code'=>'block_code','district_census_code'=>'district_census_code','district_code'=>'district_code','state_code'=>'state_code','country_code'=>'country_code');
	            $SheetDataKey = array();
	            
	            foreach ($allDataInSheet as $dataInSheet) {
	                foreach ($dataInSheet as $key => $value) {
	                	$value = preg_replace('/\s+/', '', $value);
	                    if (in_array($value, $createArray)) {
	                        $value = preg_replace('/\s+/', '', $value);
	                        $SheetDataKey[$value] = $key;
	                    }else{
	                        
	                    }
	                }
	            }
	            $data = array_diff_key($makeArray, $SheetDataKey);
	            if (empty($data)) {
	                $flag = 1;
	            }
	            if ($flag == 1) {
	                for ($i = 2; $i <= $arrayCount; $i++) {
	                    $addresses = array();
	                    $gp_code = $SheetDataKey['gp_code'];
	                    $gp_name = $SheetDataKey['gp_name'];
	                    $block_code = $SheetDataKey['block_code'];
	                    $district_census_code = $SheetDataKey['district_census_code'];
	                    $district_code = $SheetDataKey['district_code'];
	                    $state_code = $SheetDataKey['state_code'];
	                    $country_code = $SheetDataKey['country_code'];
	                    
	                    $gp_code = filter_var(trim($allDataInSheet[$i][$gp_code]), FILTER_SANITIZE_STRING);
	                    $gp_name = filter_var(trim($allDataInSheet[$i][$gp_name]), FILTER_SANITIZE_STRING);
	                    $block_code = filter_var(trim($allDataInSheet[$i][$block_code]), FILTER_SANITIZE_STRING);
	                    $district_census_code = filter_var(trim($allDataInSheet[$i][$district_census_code]), FILTER_SANITIZE_STRING);
	                    $district_code = filter_var(trim($allDataInSheet[$i][$district_code]), FILTER_SANITIZE_STRING);
	                    $state_code = filter_var(trim($allDataInSheet[$i][$state_code]), FILTER_SANITIZE_STRING);
	                    $country_code = filter_var(trim($allDataInSheet[$i][$country_code]), FILTER_SANITIZE_STRING);
						$fetchData[] = array('importFileName' => $inputFileName,'gp_code' => $gp_code,'gp_name' => $gp_name,'block_code'=>$block_code,'district_census_code'=>$district_census_code,'district_code'=>$district_code,'state_code'=>$state_code,'country_code'=>$country_code);
	                }
	                $data['employeeInfo'] = $fetchData;
	                $this->admin_model->setBatchImport($fetchData);
	                echo json_encode($this->admin_model->importData('GP_DATA'));	
            	}else{
                	echo "Error in excel  file";
            	}
        	}
    	}
    	/**
		* Function 		: import_villagedata,
		* purpose  		: Upload the Village excel data to database, 
		* Date     		: 13-04-2019
		* Remark   		: Get data from excel and Insert into the database
		*/
		public function import_villagedata() {
			require_once APPPATH.'/third_party/phpexcel/PHPExcel.php';
	        $data = '';
        	if ($this->input->post('importfile')) {
	            $path = FCPATH.'public/upload/excel_files/';
	            $config['upload_path'] = $path;
	            $config['allowed_types'] = 'xlsx|xls';
	            $config['remove_spaces'] = TRUE;
	            $this->load->library('upload', $config);
	            if (!empty($this->input->post('importfile'))) {
	                $import_xls_file = $this->input->post('importfile');
	            } else {
	                $import_xls_file = 0;
	            }
	            $inputFileName = $import_xls_file;
	            try {
	                $inputFileType = PHPExcel_IOFactory::identify($inputFileName);
	                $objReader = PHPExcel_IOFactory::createReader($inputFileType);
	                $objPHPExcel = $objReader->load($inputFileName);
	            } catch (Exception $e) {
	                die('Error loading file "' . pathinfo($inputFileName, PATHINFO_BASENAME).'": ' . $e->getMessage());
	            }
            	$allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
            
	            $arrayCount = count($allDataInSheet);
	            $flag = 0;
	            $createArray = array('pk_village_code','village_name','gp_code');
			    $makeArray = array('pk_village_code' => 'pk_village_code','village_name'=>'village_name','gp_code'=>'gp_code');
	            $SheetDataKey = array();
	            
	            foreach ($allDataInSheet as $dataInSheet) {
	                foreach ($dataInSheet as $key => $value) {
	                	$value = preg_replace('/\s+/', '', $value);
	                    if (in_array($value, $createArray)) {
	                        $value = preg_replace('/\s+/', '', $value);
	                        $SheetDataKey[$value] = $key;
	                    }else{
	                        
	                    }
	                }
	            }
	            $data = array_diff_key($makeArray, $SheetDataKey);
	            if (empty($data)) {
	                $flag = 1;
	            }
	            if ($flag == 1) {
	                for ($i = 2; $i <= $arrayCount; $i++) {
	                    $addresses = array();
	                    $pk_village_code = $SheetDataKey['pk_village_code'];
	                    $village_name = $SheetDataKey['village_name'];
	                    $gp_code = $SheetDataKey['gp_code'];
	                    
	                    $pk_village_code = filter_var(trim($allDataInSheet[$i][$pk_village_code]), FILTER_SANITIZE_STRING);
	                    $village_name = filter_var(trim($allDataInSheet[$i][$village_name]), FILTER_SANITIZE_STRING);
	                    $gp_code = filter_var(trim($allDataInSheet[$i][$gp_code]), FILTER_SANITIZE_STRING);
						$fetchData[] = array('importFileName' => $inputFileName,'pk_village_code' => $pk_village_code,'village_name' => $village_name,'gp_code'=>$gp_code);
	                }
	                $data['employeeInfo'] = $fetchData;
	                $this->admin_model->setBatchImport($fetchData);
	                echo json_encode($this->admin_model->importData('VILLAGE_DATA'));	
            	}else{
                	echo "Error in excel  file";
            	}
        	}
    	}
    	
    	/**
		* Name : Subhashree Jena
		* Date :02-04-2019
		* Purpose : Insert Admin Department
		*/
    	
    	public function operation_admin_department(){
			$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_admin_department'];
				if(!empty($input_csrf_token)){
					if(checkToken( $input_csrf_token, 'form_admin_department')){
						$config = array(
				            array(
				                'field'   => 'txtDepartmentCode',
				                'label'   => 'Department Code',
				                'rules'   => 'trim|required|xss_clean'
				            ),
				            array(
				                'field'   => 'txtDepartmentName',
				                'label'   => 'Department Name',
				                'rules'   => 'trim|required|xss_clean'
				            ),
				            array(
				                'field'   => 'txtContactName',
				                'label'   => 'Contact Name',
				                'rules'   => 'trim|required|xss_clean'
				            ),
				            array(
				                'field'   => 'txtAddressOne',
				                'label'   => 'Address 1',
				                'rules'   => 'trim|required|xss_clean'
				            ),
				            array(
				                'field'   => 'txtPinCode',
				                'label'   => 'PinCode',
				                'rules'   => 'trim|xss_clean'
				            ),
				            array(
				                'field'   => 'txtEmail',
				                'label'   => 'Email',
				                'rules'   => 'trim|required|xss_clean'
				            ),
				            array(
				                'field'   => 'txtPhoneOne',
				                'label'   => 'Phone 1',
				                'rules'   => 'trim|required|xss_clean'
				            ),
				            array(
				                'field'   => 'txtStateContactName',
				                'label'   => 'Contact Name',
				                'rules'   => 'trim|required|xss_clean'
				            ),
				            array(
				                'field'   => 'txtStateAddressOne',
				                'label'   => 'Address One',
				                'rules'   => 'trim|required|xss_clean'
				            ),
				            array(
				                'field'   => 'txtStateEmail',
				                'label'   => 'Contact Name',
				                'rules'   => 'trim|required|xss_clean'
				            ),
				            array(
				                'field'   => 'txtStatePhoneOne',
				                'label'   => 'Phone 1',
				                'rules'   => 'trim|required|xss_clean'
				            ),
				            
		        		);
		        		
						$this->form_validation->set_rules($config);
					    if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						     
						}else{
							echo json_encode($this->department_model->post($_POST,$_POST['op_type']));
						}			        	
			    	}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
						echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
					echo json_encode($data);
				}
			}
		}
    	/**
		* Name: Subhashree Jena
		* Date: 03-04-2019
		* Purpose: Get Admin Department
		*/
		
		public function get_admin_department(){
			$type = $this->uri->segment(3);
			$inputCsrfToken = $_POST['csrf_admindepartmentToken'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dataTableAdmin')){
			    	echo json_encode($this->department_model->get($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		
		/**
		* Name : Subhashree Jena
		* Date : 03-04-2019
		* Purpose : View Admin Departemnt Details
		*/
		
		public function view_admindepartemnt_details(){
			$department_id =$this->uri->segment(3);
			$admin_department= "";
			$get_data = $this->department_model->get(array('pk_dept_code'=>$department_id),'get_admindepartment_details');
			$dbStatus = true;
			if(!empty($get_data)){
				$admin_department.="<fieldset style='width:95%;margin-left:2%;margin-top:4%'>
						<div class='col-md-12' style='padding-top:1%;'>
							<div class='col-md-6'>
								<label class='col-md-6'>Department Code : </label>
								<span  class='col-md-6'>".$get_data['admin_dept_code']."</span>
							</div>
							<div class='col-md-6'>
								<label class='col-md-6'>Admin Department : </label>
								<span class='col-md-6'>".$get_data['dept_name']."</span>
							</div>
						</div>
						<div class='col-md-12'>
							<div class='col-md-6'>
								<label class='col-md-6'>Created By: </label>
								<span class='col-md-6'>".$get_data['created_by']."</span>
							</div>
							<div class='col-md-6'>
								<label class='col-md-6'>Created On: </label>
								<span class='col-md-6'>".$get_data['created_at']."</span>
							</div>
						</div>
					</fieldset>
					<fieldset style='width:95%;margin-left:2%'>
						<legend>Registration Office</legend>
						<div class='col-md-12' style='padding-top:1%';>
							<div class='col-md-6'>
								<label class='col-md-6'>Contact Name:</label>
								<span class='col-md-6'>".$get_data['reg_contact_name']."</span>
							</div>
							<div class='col-md-6'>
								<label class='col-md-6'>Email:</label>
								<span class='col-md-6'>".$get_data['reg_email']."</span>
							</div>
						</div>	
						<div class='col-md-12'>
							<div class='col-md-6'>
								<label class='col-md-6'>Phone1:</label>
								<span class='col-md-6'>".$get_data['reg_ph1']."</span>
							</div>
							<div class='col-md-6'>
								<label class='col-md-6'>Phone2:</label>
								<span class='col-md-6'>".$get_data['reg_ph2']."</span>
							</div>
						</div>
						<div class='col-md-12'>
						<div class='col-md-6'>
								<label class='col-md-6'>Phone3:</label>
								<span class='col-md-6'>".$get_data['reg_ph3']."</span>
							</div>
							<div class='col-md-6'>
								<label class='col-md-6'>Pin Code:</label>
								<span class='col-md-6'>".$get_data['reg_pin']."</span>
							</div>
						</div>
						<div class='col-md-12' >
							<div class='col-md-6'>
								<label class='col-md-6'>Website:</label>
								<span class='col-md-6'>".$get_data['reg_www']."</span>
							</div>
							<div class='col-md-6'>
								<label class='col-md-6'>Address1:</label>
								<span class='col-md-6'>".$get_data['reg_add1']."</span>
							</div>
						</div>
						<div class='col-md-12'>
							<div class='col-md-6'>
								<label class='col-md-6'>Address2:</label>
								<span class='col-md-6'>".$get_data['reg_add2']."</span>
							</div>
							<div class='col-md-6'>
								<label class='col-md-6'>Address3:</label>
								<span class='col-md-6'>".$get_data['reg_add3']."</span>
							</div>
						</div>
					</fieldset>
					<fieldset style='width:95%;margin-left:2%;'>
						<legend>State Office</legend>
						<div class='col-md-12' style='padding-top:1%';>
							<div class='col-md-6'>
								<label class='col-md-6'>Contact Name:</label>
								<span class='col-md-6'>".$get_data['st_contact_name']."</span>
							</div>
							<div class='col-md-6'>
								<label class='col-md-6'>Pin Code:</label>
								<span class='col-md-6'>".$get_data['st_pin']."</span>
							</div>
						</div>
						
						<div class='col-md-12'>
							<div class='col-md-6'>
								<label class='col-md-6'>Website:</label>
								<span class='col-md-6'>".$get_data['st_www']."</span>
							</div>
							<div class='col-md-6'>
								<label class='col-md-6'>Email:</label>
								<span class='col-md-6'>".$get_data['st_email']."</span>
							</div>
						</div>
						<div class='col-md-12' >
							<div class='col-md-6'>
								<label class='col-md-6'>Phone1:</label>
								<span class='col-md-6'>".$get_data['st_ph1']."</span>
							</div>
							<div class='col-md-6'>
								<label class='col-md-6'>Phone2:</label>
								<span class='col-md-6'>".$get_data['st_ph2']."</span>
							</div>
						</div>
						<div class='col-md-12'>
							<div class='col-md-6'>
								<label class='col-md-6'>Phone3:</label>
								<span class='col-md-6'>".$get_data['st_ph3']."</span>
							</div>
							<div class='col-md-6'>
								<label class='col-md-6'>Address1:</label>
								<span class='col-md-6'>".$get_data['st_add1']."</span>
							</div>
						</div>
						<div class='col-md-12'>
							<div class='col-md-6'>
								<label class='col-md-6'>Address2:</label>
								<span class='col-md-6'>".$get_data['st_add2']."</span>
							</div>
							<div class='col-md-6'>
								<label class='col-md-6'>Address3:</label>
								<span class='col-md-6'>".$get_data['st_add3']."</span>
							</div>
						</div>
					</fieldset>
					 <div class='modal-footer'>
					 </div>";
			}	
			echo json_encode(array('status'=>$dbStatus,'data'=>$admin_department));
		}
		
		/**
		* Name : Subhashree Jena
		* Date : 04-04-2019
		* Purpose : Get Installation Class
		*/
		
		public function get_all_installation(){
			echo json_encode($this->scheme_model->get($_POST,$_POST['op_type']));
		}
		
		/**
		* Name : Subhashree Jena
		* Date : 05-04-2019
		* Purpose : Get Source Finance
		*/
		
		public function get_all_source_finance(){
			echo json_encode($this->scheme_model->get($_POST,$_POST['op_type']));
		}
		
		/**
		* Name : Subhashree Jena
		* Date : 05-04-2019
		* Purpose : Insert Scheme
		*/
		
		public function operation_scheme(){
			$temp_rule = Array("&lt","&gt","<",">","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_scheme'];
				if(!empty($input_csrf_token)){
					if(checkToken( $input_csrf_token, 'form_add_scheme')){
						$config = array(
				            array(
				                'field'   => 'txtShortCode',
				                'label'   => 'Short Code',
				                'rules'   => 'trim|required|xss_clean'
				            ),
				            array(
				                'field'   => 'txtSchemeName',
				                'label'   => 'Department Name',
				                'rules'   => 'trim|required|xss_clean'
				            ),
				            array(
				                'field'   => 'cmbType',
				                'label'   => 'Type',
				                'rules'   => 'trim|required|xss_clean'
				            ),
				            array(
				                'field'   => 'cmbAdministerDept',
				                'label'   => 'Administer Department',
				                'rules'   => 'trim|required|xss_clean'
				            ),
				            array(
				                'field'   => 'txtSchemeDescription',
				                'label'   => 'Scheme Description',
				                'rules'   => 'trim|xss_clean'
				            )
		        		);
						$this->form_validation->set_rules($config);
					    if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						     
						}else{
							echo json_encode($this->scheme_model->post($_POST,$_POST['op_type']));
						}			        	
			    	}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
						echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
					echo json_encode($data);
				}
			}
		}
		
		/**
		* Name : Subhashree Jena
		* Date : 08-04-2019
		* Purpose : Insert Installation Class
		*/
		
		public function operation_installation_class(){
			$temp_rule = Array("&lt","&gt","<",">","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_add_installation_class'];
				if(!empty($input_csrf_token)){
					if(checkToken( $input_csrf_token, 'form_add_installation_class')){
						$config = array(
				            array(
				                'field'   => 'txtClassName',
				                'label'   => 'Short Code',
				                'rules'   => 'trim|required|xss_clean'
				            ),
				            array(
				                'field'   => 'txtDescription',
				                'label'   => 'Department Name',
				                'rules'   => 'trim|required|xss_clean'
				            ),
				            array(
				                'field'   => 'txtShortName',
				                'label'   => 'Type',
				                'rules'   => 'trim|required|xss_clean'
				            ),
				            array(
				                'field'   => 'cmbType',
				                'label'   => 'Administer Department',
				                'rules'   => 'trim|required|xss_clean'
				            )
		        		);
						$this->form_validation->set_rules($config);
					    if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						     
						}else{
							echo json_encode($this->installation_model->post($_POST,$_POST['op_type']));
						}			        	
			    	}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
						echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
					echo json_encode($data);
				}
			}
		}
		/**
		* Name : Subhashree Jena
		* Date : 08-04-2019
		* Purpose : Get Component List
		*/
		
		public function get_all_component(){
			echo json_encode($this->getter_model->get($_POST,$_POST['op_type']));
		}
		
		/**
		* Name : Subhashree jena
		* Date : 08-04-2019
		* Purpose : Get Installation list
		*/
		public function get_installation(){
			$type = $this->uri->segment(3);
			$inputCsrfToken = $_POST['csrf_installationToken'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dataTableInstallation')){
			    	echo json_encode($this->installation_model->get($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		/**
		* Name : Subhashree Jena
		* Date : 08-04-2019
		* Purpose : View INstallation Class
		*/
		
		public function view_installation_details(){
			$installtion_id =$_POST['installtion_id'];
			$installation_class= "";
			$component ="";
			$get_data = $this->installation_model->get(array('installtion_id'=>$installtion_id),'get_installation_view');
			$get_component = $this->installation_model->get(array('installation_header_id' =>$installtion_id),'get_component');
			$dbStatus = true;
			if(!empty($get_data && !empty($get_component))){
				$installation_class.="<fieldset style='width:95%;margin-left:2%;margin-top:4%'>
						<div class='col-md-12' style='padding-top:1%;'>
							<div class='col-md-6'>
								<label class='col-md-6'>Class Name: </label>
								<span class='col-md-6'>".$get_data['instal_cls_name']."</span>
							</div>
							<div class='col-md-6'>
								<label class='col-md-6'>Short Name: </label>
								<span class='col-md-6'>".$get_data['short_name']."</span>
							</div>
						</div>
						<div class='col-md-12'>
							<div class='col-md-6'>
								<label class='col-md-6'>Type: </label>
								<span class='col-md-6'>".$get_data['type']."</span>
							</div>
							<div class='col-md-6'>
								<label class='col-md-6'>Description: </label>
								<span class='col-md-6'>".$get_data['description']."</span>
							</div>
						</div>
						<div class='col-md-12'>
							<div class='col-md-6'>
								<label class='col-md-6'>Created By: </label>
								<span class='col-md-6'>".$get_data['created_by']."</span>
							</div>
							<div class='col-md-6'>
								<label class='col-md-6'>Created On: </label>
								<span class='col-md-6'>".$get_data['created_at']."</span>
							</div>
						</div>
					</fieldset>";
				foreach($get_component as $cmp){
					$component.="<tr>
						<td>".$cmp['component_name']."</td>
						<td>".$cmp['created_by']."</td>
						<td>".$cmp['created_at']."</td>
					</tr>
					<div class='modal-footer'>";
				}
			}	
			echo json_encode(array('status'=>$dbStatus,'data'=>$installation_class,'data1'=>$component));
		}
		/**
		* Name : Subhashree Jena
		* Date : 08-04-2019
		* Purpose : Add Component
		*/
		
		public function operation_component(){
			$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_component'];
				if(!empty($input_csrf_token)){
					if(checkToken( $input_csrf_token, 'form_add_component')){
						$config = array(
				            array(
				                'field'   => 'txtComponent',
				                'label'   => 'Component',
				                'rules'   => 'trim|required|xss_clean'
				            ),
				            array(
				                'field'   => 'txtCShortName',
				                'label'   => 'Short Name',
				                'rules'   => 'trim|required|xss_clean'
				            )
		        		);
						$this->form_validation->set_rules($config);
					    if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						     
						}else{
							echo json_encode($this->component_model->post($_POST,$_POST['op_type']));
						}			        	
			    	}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
						echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
					echo json_encode($data);
				}
			}
		}
		
		/**
		* Name : Subhashree Jena
		* Date :09-04-2019
		* Purpose : Get All Attributes
		*/
		
		public function get_all_attributes(){
			echo json_encode($this->getter_model->get($_POST,$_POST['op_type']));
		}
		/**
		* Name : Subhashree Jena
		* Date : 09-04-2019
		* Purpose : Get All Component
		*/
		
		public function get_component_data(){
			$type = $this->uri->segment(3);
			$inputCsrfToken = $_POST['csrf_component'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dataTableComponent')){
			    	echo json_encode($this->component_model->get($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		
		public function get_scheme(){
			$type = $this->uri->segment(3);
			$inputCsrfToken = $_POST['csrf_scheme'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dataTableScheme')){
			    	echo json_encode($this->scheme_model->get($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		/**
		* Name : Subhashree Jena
		* Date : 09-04-2019
		* Purpose : View Component Details  
		*/
		
		public function view_component_details(){
			$component_id =$this->uri->segment(3);
			$component= "";
			$attribute ="";
			$get_data = $this->component_model->get(array('id'=>$component_id),'get_component_view');
			$get_attribute = $this->component_model->get(array('components_id' =>$component_id),'get_attribute');
			$dbStatus = true;
			if(!empty($get_data && !empty($get_attribute))){
				$component.="<fieldset style='width:95%;margin-left:2%;margin-top:4%'>
						<div class='col-md-12' style='padding-top:1%;'>
							<div class='col-md-6'>
								<label class='col-md-6'>Component Name: </label>
								<span class='col-md-6'>".$get_data['component_name']."</span>
							</div>
							<div class='col-md-6'>
								<label class='col-md-6'>Short Name: </label>
								<span class='col-md-6'>".$get_data['short_name']."</span>
							</div>
							<div class='col-md-6'>
								<label class='col-md-6'>Description: </label>
								<span class='col-md-6'>".$get_data['description']."</span>
							</div>
						</div>
						<div class='col-md-12' style='padding-top:1%;'>
							<div class='col-md-6'>
								<label class='col-md-6'>Created By: </label>
								<span class='col-md-6'>".$get_data['created_by']."</span>
							</div>
							<div class='col-md-6'>
								<label class='col-md-6'>Created On: </label>
								<span class='col-md-6'>".$get_data['created_at']."</span>
							</div>
						</div>
					</fieldset>
				</div>";
				foreach($get_attribute as $cmp){
					$attribute.="<tr>
						<td>".$cmp['value']."</td>
						<td>".$cmp['created_by']."</td>
						<td>".$cmp['created_at']."</td>
					</tr>
					<div class='modal-footer'>";
				}
			}	
			echo json_encode(array('status'=>$dbStatus,'data'=>$component,'data1'=>$attribute));
		}
		
		public function get_edit_component_data(){
			$header_id =$this->uri->segment(3);
			//echo $header_id;die();
			echo json_encode($this->crc_model->get($header_id,$_POST['op_type']));
		}
		/**
		* Name : Pragyan
		* Date :8-04-2019
		* Purpose: Get Vendor Data
		* @return
		*/
		public function retrieve_vendor_data(){
			$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_dataTableVendor_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dataTableVendor')){
			    	$x = $this->vendor_model->get($_POST, $type);			    
			    	echo json_encode($x);
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		
		/**
		* Name : Pragyan
		* Date : 8-04-2019
		* Purpose : Insert Vendor Data
		*/
		
		public function operation_vendor(){
			//print_r($_POST);die();
			$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_vendor'];
				
				if(!empty($input_csrf_token)){
					if(checkToken($input_csrf_token, 'form_add_vendor')){
						$config = array(
							array(
			                    'field'   => 'txtVendorCode',
			                    'label'   => 'please select code',
			                    'rules'   => 'trim|xss_clean'
			                ),
			                array(
			                    'field'   => 'txtVendorName',
			                    'label'   => 'please select name',
			                    'rules'   => 'trim|xss_clean'
			                ),
			                array(
			                    'field'   => 'txtContactName',
			                    'label'   => 'please select name',
			                    'rules'   => 'trim|xss_clean'
			                ),
			                array(
			                    'field'   => 'txtAddressOne',
			                    'label'   => 'please select address',
			                    'rules'   => 'trim|xss_clean'
			                ),
			                array(
			                    'field'   => 'txtPinCode',
			                    'label'   => 'please select pincode',
			                    'rules'   => 'trim|xss_clean'
			                ),
			                array(
			                    'field'   => 'txtWww',
			                    'label'   => 'please select www',
			                    'rules'   => 'trim|xss_clean'
			                ),
			                array(
			                    'field'   => 'txtEmail',
			                    'label'   => 'please select email',
			                    'rules'   => 'trim|xss_clean'
			                ),
			                array(
			                    'field'   => 'txtPhoneOne',
			                    'label'   => 'Phone Number',
			                    'rules'   => 'required|regex_match[/^[1-9][0-9]{0,9}$/]|xss_clean'
			                ),
			                array(
			                    'field'   => 'txtPhoneTwo',
			                    'label'   => 'Phone Number',
			                    'rules'   => 'regex_match[/^[1-9][0-9]{0,9}$/]|xss_clean'
			                ),
			                 array(
			                    'field'   => 'txtPhoneThree',
			                    'label'   => 'Phone Number',
			                    'rules'   => 'regex_match[/^[1-9][0-9]{0,9}$/]|xss_clean'
			                ),
			                array(
			                    'field'   => 'txtStateContactName',
			                    'label'   => 'please select name',
			                    'rules'   => 'trim|xss_clean'
			                ),
			                array(
			                    'field'   => 'txtStateAddressOne',
			                    'label'   => 'please select address',
			                    'rules'   => 'trim|xss_clean'
			                ),
			                array(
			                    'field'   => 'txtStateAddressTwo',
			                    'label'   => 'please select email',
			                    'rules'   => 'trim|xss_clean'
			                ),
			                 array(
			                    'field'   => 'txtStateAddressThree',
			                    'label'   => 'please select email',
			                    'rules'   => 'trim|xss_clean'
			                ),
			                 array(
			                    'field'   => 'txtStatePinCode',
			                    'label'   => 'please select email',
			                    'rules'   => 'trim|xss_clean'
			                ),
			                 array(
			                    'field'   => 'txtStateWww',
			                    'label'   => 'please select www',
			                    'rules'   => 'trim|xss_clean'
			                ),
			                array(
			                    'field'   => 'txtStateEmail',
			                    'label'   => 'please select email',
			                    'rules'   => 'trim|xss_clean'
			                ),
			                array(
			                    'field'   => 'txtStatePhoneOne',
			                    'label'   => 'Phone Number Required',
			                    'rules'   => 'required|regex_match[/^[1-9][0-9]{0,9}$/]|xss_clean'
			                ),
			                array(
			                    'field'   => 'txtStatePhoneTwo',
			                    'label'   => 'Phone Number Required',
			                    'rules'   => 'regex_match[/^[1-9][0-9]{0,9}$/]|xss_clean'
			                ),
			                 array(
			                    'field'   => 'txtStatePhoneThree',
			                    'label'   => 'Phone Number Required',
			                    'rules'   => 'regex_match[/^[1-9][0-9]{0,9}$/]|xss_clean'
			                )
			            );
						$this->form_validation->set_rules($config); 
					    if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						}else{
							echo json_encode($this->vendor_model->post($_POST, $_POST['op_type']));
						}
					}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
			            echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
		            echo json_encode($data);
		        }
			}
		}
		/**
		* Name : Subhashree Jena
		* Date :10-04-2019
		* Purpose : View Vendor Details
		*/
		
		public function view_vendor_details(){
			$vendor= "";
			$get_data = $this->vendor_model->get(array('supplier_code'=>$_POST['vendor_id']),$_POST['op_type']);
			$dbStatus = true;
			if(!empty($get_data)){
				$vendor.="
				<fieldset style='width:95%;margin-left:2%;margin-top:4%'>
					<div class='col-md-12' style='padding-top:1%;'>
						<div class='col-md-6'>
							<label class='col-md-6'>Supplier Code: </label>
							<span class='col-md-6'>".$get_data['supplier_code']."</span>
						</div>
						<div class='col-md-6'>
							<label class='col-md-6'>Supplier Name: </label>
							<span class='col-md-6'>".$get_data['supplier_name']."</span>
						</div>
					</div>
				</fieldset>
				<fieldset style='width:95%;margin-left:2%'>
					<legend>Registration Office</legend>
					<div class='col-md-12'>
						<div class='col-md-6'>
							<label class='col-md-6'>Contact Name:</label>
							<span class='col-md-6'>".$get_data['reg_contact_name']."</span>
						</div>
						<div class='col-md-6'>
							<label class='col-md-6'>Phone1:</label>
							<span class='col-md-6'>".$get_data['reg_ph1']."</span>
						</div>
					</div>
					<div class='col-md-12'>
						<div class='col-md-6'>
							<label class='col-md-6'>Phone2:</label>
							<span class='col-md-6'>".$get_data['reg_ph2']."</span>
						</div>
						<div class='col-md-6'>
							<label class='col-md-6'>Phone3:</label>
							<span class='col-md-6'>".$get_data['reg_ph3']."</span>
						</div>
					</div>
					<div class='col-md-12'>
						<div class='col-md-6'>
							<label class='col-md-6'>Pin Code:</label>
							<span class='col-md-6'>".$get_data['reg_pin']."</span>
						</div>
						<div class='col-md-6'>
							<label class='col-md-6'>Website:</label>
							<span class='col-md-6'>".$get_data['reg_www']."</span>
						</div>
					</div>
					<div class='col-md-12' >
						<div class='col-md-6'>
							<label class='col-md-6'>Email:</label>
							<span class='col-md-6'>".$get_data['reg_email']."</span>
						</div>
						<div class='col-md-6'>
							<label class='col-md-6'>Address1:</label>
							<span class='col-md-6'>".$get_data['reg_add1']."</span>
						</div>
					</div>
					<div class='col-md-12'>
						<div class='col-md-6'>
							<label class='col-md-6'>Address2:</label>
							<span class='col-md-6'>".$get_data['reg_add2']."</span>
						</div>
						<div class='col-md-6'>
							<label class='col-md-6'>Address3:</label>
							<span class='col-md-6'>".$get_data['reg_add3']."</span>
						</div>
					</div>
				</fieldset>
				<fieldset style='width:95%;margin-left:2%;'>
					<legend>State Office</legend>
					<div class='col-md-12' style='padding-top:1%;'>
						<div class='col-md-6'>
							<label class='col-md-6'>Contact Name:</label>
							<span class='col-md-6'>".$get_data['st_contact_name']."</span>
						</div>
						<div class='col-md-6'>
							<label class='col-md-6'>Phone1:</label>
							<span class='col-md-6'>".$get_data['st_ph1']."</span>
						</div>
					</div>
					<div class='col-md-12' >
						<div class='col-md-6'>
							<label class='col-md-6'>Phone2:</label>
							<span class='col-md-6'>".$get_data['st_ph2']."</span>
						</div>
						<div class='col-md-6'>
							<label class='col-md-6'>Phone3:</label>
							<span class='col-md-6'>".$get_data['st_ph3']."</span>
						</div>
					</div>
					<div class='col-md-12'>
						<div class='col-md-6'>
							<label class='col-md-6'>Pin Code:</label>
							<span class='col-md-6'>".$get_data['st_pin']."</span>
						</div>
						<div class='col-md-6'>
							<label class='col-md-6'>Website:</label>
							<span class='col-md-6'>".$get_data['st_www']."</span>
						</div>
					</div>
					<div class='col-md-12'>
						<div class='col-md-6'>
							<label class='col-md-6'>Email:</label>
							<span class='col-md-6'>".$get_data['st_email']."</span>
						</div>
						<div class='col-md-6'>
							<label class='col-md-6'>Address1:</label>
							<span class='col-md-6'>".$get_data['st_add1']."</span>
						</div>
					</div>
					<div class='col-md-12'>
						<div class='col-md-6'>
							<label class='col-md-6'>Address2:</label>
							<span class='col-md-6'>".$get_data['st_add2']."</span>
						</div>
						<div class='col-md-6'>
							<label class='col-md-6'>Address3:</label>
							<span class='col-md-6'>".$get_data['st_add3']."</span>
						</div>
					</div>
				</fieldset>
				<div class='modal-footer'>
				</div>";
			}	
			echo json_encode(array('status'=>$dbStatus,'data'=>$vendor));
		}
		/**
		* Name : Pragyan 
		* Date :09-04-2019
		* Purpose : Get Technician List
		*/
		
		public function retrieve_technician_data(){
			$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_technician_table_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dataTableTechnicianMaster')){
			    	echo json_encode($this->technician_model->get($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		
		public function operation_technician(){
			$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_technician_master'];
				
				if(!empty($input_csrf_token)){
					if(checkToken($input_csrf_token, 'form_add_technician_master')){
						if($_POST['op_type'] == 'UPDATE_TECHNICIAN_DATA'){
							$config = array(
								array(
								'field' => 'cmb_vendor',
								'label' => 'please select vendor',
								'rules' => 'trim|xss_clean'
							),
							array(
								'field' => 'txtPhoneNo',
								'label' => 'Phone Number Required',
								'rules' => 'required|regex_match[/^[1-9][0-9]{0,9}$/]|xss_clean'
							),
							array(
								'field' => 'txtTechnicianName',
								'label' => 'please select name',
								'rules' => 'trim|xss_clean'
							),
							array(
								'field' => 'txtEmailId',
								'label' => 'please select emailid',
								'rules' => 'trim|xss_clean'
							),
							array(
							'field' => 'txtAddress',
							'label' => 'please select name',
							'rules' => 'trim|xss_clean'
							)
						);
						}else{
						$config = array(
							array(
								'field' => 'cmb_vendor',
								'label' => 'please select vendor',
								'rules' => 'trim|xss_clean'
							),
							array(
								'field' => 'txtPhoneNo',
								'label' => 'Phone Number Required',
								'rules' => 'required|regex_match[/^[1-9][0-9]{0,9}$/]|xss_clean|is_unique[technician_master.phone_no]'
							),
							array(
								'field' => 'txtTechnicianName',
								'label' => 'please select name',
								'rules' => 'trim|xss_clean'
							),
							array(
								'field' => 'txtEmailId',
								'label' => 'please select emailid',
								'rules' => 'trim|xss_clean'
							),
							array(
								'field' => 'txtAddress',
								'label' => 'please select name',
								'rules' => 'trim|xss_clean'
							)
						);
						}
						$this->form_validation->set_rules($config); 
					    if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						}else{
							echo json_encode($this->technician_model->post($_POST, $_POST['op_type']));
						}
					}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
			            echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
		            echo json_encode($data);
		        }
			}
		}
		public function get_technician_status(){
			echo json_encode($this->technician_model->post($_POST,$_POST['op_type'])); 
		}
		public function get_technician_search_list(){
			echo json_encode($this->crc_model->get($_POST,$_POST['op_type'])); 
		}
		
		public function get_all_scheme(){
			echo json_encode($this->getter_model->get($_POST,$_POST['op_type']));
		}
		
		public function get_technician_no(){
			echo json_encode($this->vendor_model->get($_POST,$_POST['op_type']));
		}
		
		public function get_transaction_list(){
			echo json_encode($this->vendor_model->get($_POST,$_POST['op_type']));
		}
		public function get_sanction_data(){
			echo json_encode($this->getter_model->get($_POST,$_POST['op_type']));
		}
		public function get_vendor_data(){
			echo json_encode($this->getter_model->get($_POST,$_POST['op_type']));
		}
		public function get_technician_data(){
			echo json_encode($this->getter_model->get($_POST,$_POST['op_type']));
		}
		public function get_all_ticket(){
			echo json_encode($this->getter_model->get($_POST,$_POST['op_type']));
		}
		public function get_install_data(){
			echo json_encode($this->getter_model->get($_POST,$_POST['op_type']));
		}
		public function get_dist_vendorwise(){
			echo json_encode($this->getter_model->get($_POST, $_POST['op_type']));
		}
		public function get_filter_village_data(){
			echo json_encode($this->transaction_model->get($_POST, $_POST['op_type']));
		}
		public function get_parent_customer_dropdown(){
			echo json_encode($this->transaction_model->get($_POST, $_POST['op_type']));
		}
		public function get_work_order_data(){
			echo json_encode($this->getter_model->get($_POST,$_POST['op_type']));
		}
		public function get_all_transaction_details(){
			ini_set('memory_limit','-1');
			$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_trans_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dataTableTransaction')){
			    	echo json_encode($this->transaction_model->get($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function get_all_scheme_category(){
			$type = $this->uri->segment(3);
			$inputCsrfToken = $_POST['csrf_dtbleSchemeCategory_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'datableSchemeCategory')){
			    	echo json_encode($this->scheme_model->get($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function operation_scheme_category(){
			$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_scheme_category'];
				if(!empty($input_csrf_token)){
					if(checkToken( $input_csrf_token, 'form_add_scheme_category')){
						$config = array(
				            array(
				                'field'   => 'txtCategoryName',
				                'label'   => 'Category Name',
				                'rules'   => 'trim|required|xss_clean'
				            ),
			                array(
			                    'field'   => 'txtCategoryShortCode',
			                    'label'   => 'Category Short Code Required',
			                    'rules'   => 'trim|required|xss_clean'
			                )
		        		);
						$this->form_validation->set_rules($config);
					    if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						     
						}else{
							echo json_encode($this->scheme_model->post($_POST,$_POST['op_type']));
						}			        	
			    	}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
						echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
					echo json_encode($data);
				}
			}
		}
		public function get_customer_data(){
			$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_customer_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dataTableCustomer')){
			    	echo json_encode($this->raise_ticket_model->get($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		/**
		* Name : Siddhartha Mishra
		* Date : 10-05-2019
		* Purpose : Get Issue List
		*/
		
		public function get_all_issue(){
			echo json_encode($this->getter_model->get($_POST,$_POST['op_type']));
		}
		public function get_all_email(){
			echo json_encode($this->getter_model->get($_POST, $_POST['op_type']));
		}
		public function operation_mail(){
			$input_csrf_token = $_POST['csrf_mail'];
			if(!empty($input_csrf_token)){
				if(checkToken( $input_csrf_token, 'form_add_mail')){
					$config = array(
			            array(
			                'field'   => 'txtto',
			                'label'   => 'To',
			                'rules'   => 'trim|required|xss_clean'
			            ),
			            array(
			                'field'   => 'txtsubject',
			                'label'   => 'Subject',
			                'rules'   => 'trim|required|xss_clean'
			            )
	        		);
					$this->form_validation->set_rules($config);
				    if ($this->form_validation->run() == FALSE) {
						$data = array(
			                'status' => 'validationerror',
			                'msg' => validation_errors()
			            );
			            echo json_encode($data);
					     
					}else{
						echo json_encode($this->raise_ticket_model->post($_POST,$_POST['op_type']));
					}			        	
		    	}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		/**
		* Name : Siddhartha Mishra
		* Date : 16-05-2019
		* Purpose : Get All Manage Request
		*/
		
		public function get_manage_request(){
			$type = $this->uri->segment(3);
			$inputCsrfToken = $_POST['csrf_manage_request'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dataTableManageRequest')){
			    	echo json_encode($this->raise_ticket_model->get($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		/*
		The below function is used for showing technician against vendor datatable
		Created By : Ashutosh Mishra
		Created On : 11-05-2019
		*/
		
		public function get_vendor_tech_map_data(){
			$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_vendorMap_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dataTablevendorTechMap')){
			    	echo json_encode($this->vendor_model->get($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		
		/*
		The below function is used for fetching technician details against the selected vendor
		Created By : Ashutosh Mishra
		Created On : 15-05-2019
		*/
		public function get_techinician_details_against_selected_vendor(){
			echo json_encode($this->getter_model->get($_POST,$_POST['op_type']));
		}
		/*
		The below function is used for showing technician details against vendor datatable
		Created By : Ashutosh Mishra
		Created On : 15-05-2019
		*/
		public function get_vendor_transaction_details(){
			echo json_encode($this->getter_model->get($_POST,$_POST['op_type']));
		}
		/* 
		The below function is used for unmapping task against technician
		Created By : Ashutosh Mishra
		Created On : 15-05-2019
		*/
		public function unmap_task_against_technician(){
			$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['techCsrfToken'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dataTableTechTaskDetails')){
			    	$post_data = $this->vendor_model->post($_POST['unmapIds'], $type);			    
			    	echo json_encode($post_data);
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		
		/* 
		The below function is used for adding mapping data against vendor
		Created By : Ashutosh Mishra
		Created On : 16-05-2019
		*/
		public function operation_vendor_tech_map(){
	    	$inputCsrfToken = $_POST['csrf_vendorTechMap'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'form_vendor_tech_map')){
			    	echo json_encode($this->vendor_model->post($_POST, $_POST['op_type']));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function getAttributeList(){
			echo json_encode($this->component_model->get($_POST,$_POST['op_type']));
		}
		public function getComponentList(){
			echo json_encode($this->installation_model->get($_POST,$_POST['op_type']));
		}
		public function get_category_scheme_list(){
			$type = $this->uri->segment(3);
			//print_r($_POST);die();
			$inputCsrfToken = $_POST['csrf_category_scheme_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dataTableCategoryScheme')){
			    	echo json_encode($this->scheme_model->get($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		
		/**
		* Modify By: Subhashree jena
		* Date: 29-08-2019
		* 
		* @return
		*/
		public function view_scheme_details(){
			$pk_scheme_code =$this->uri->segment(3);
			$scheme= "";
			$installation_class = "";
			$scheme_upload = "";
			$get_data = $this->scheme_model->get(array('pk_scheme_code'=>$pk_scheme_code),'get_scheme_details');
			$get_installation = $this->scheme_model->get(array('scheme_header_id' => $pk_scheme_code),'get_scheme_installation');
			$get_scheme_upload = $this->scheme_model->get(array('scheme_header_id' => $pk_scheme_code),'get_scheme_upload');
			$dbStatus = true;
			if(!empty($get_data)){
				$scheme.="<fieldset style='width:95%;margin-left:2%;margin-top:4%'>
							<div class='col-md-12' style='padding-top:1%;'>
								<div class='col-md-6'>
									<label class='col-md-6'>Project Code: </label>
									<span class='col-md-6'>".$get_data['scheme_code']."</span>
								</div>
								<div class='col-md-6'>
									<label class='col-md-6'>Type: </label>
									<span class='col-md-6'>".$get_data['value']."</span>
								</div>
								
							</div>
							<div class='col-md-12'>
							    <div class='col-md-6'>
									<label class='col-md-6'>Project Name: </label>
									<span class='col-md-6'>".$get_data['scheme_name']."</span>
								</div>
								<div class='col-md-6'>
									<label class='col-md-6'>Administer Department: </label>
									<span class='col-md-6'>".$get_data['dept_name']."</span>
								</div>
							</div>
							<div class='col-md-12'>
								<div class='col-md-6'>
									<label class='col-md-6'>Description: </label>
									<span class='col-md-6'>".$get_data['description']."</span>
								</div>
								<div class='col-md-6'>
									<label class='col-md-6'>Project Category: </label>
									<span class='col-md-6'>".$get_data['category_name']."</span>
								</div>
							</div>
							<div class='col-md-12'>
								<div class='col-md-6'>
									<label class='col-md-6'>Created By: </label>
									<span class='col-md-6'>".$get_data['created_by']."</span>
								</div>
								<div class='col-md-6'>
									<label class='col-md-6'>Created On: </label>
									<span class='col-md-6'>".$get_data['created_at']."</span>
								</div>
							</div>
							<div class='col-md-12'>
								<div class='col-md-6'>
									<label class='col-md-6'>Updated On: </label>
									<span class='col-md-6'>".$get_data['updated_at']."</span>
								</div>
								<div class='col-md-6'>
									<label class='col-md-6'>Updated By: </label>
									<span class='col-md-6'>".$get_data['updated_by']."</span>
								</div>
							</div>
						</fieldset>";
				foreach($get_installation as $cmp){
					$installation_class.="<tr>
						<td>".$cmp['instal_cls_name']."</td>
						<td>".$cmp['created_by']."</td>
						<td>".$cmp['created_at']."</td>
					</tr> ";
				}
				foreach($get_scheme_upload as $gsu){
					$explode_files = basename($gsu['files']);
					$scheme_upload .="<tr>
						<td>".$gsu['sanction_order_no']."</td>
						<td>".$gsu['sanction_letter_date']."</td>
						<td>".$gsu['financial_year']."</td>
						<td>".$gsu['finance_source_val']."</td>
						<td>".$gsu['amount']."</td>
						<td>".$gsu['installation']."</td>
						<td><a href = '".base_url($gsu['files'])."'>".$explode_files."</a></td>
						<td>".$gsu['created_by']."</td>
						<td>".$gsu['created_at']."</td>
					</tr>";
				}
				echo json_encode(array('status'=>$dbStatus,'data'=>$scheme,'data1'=>$installation_class,'data2' => $scheme_upload));
			}
		}
		public function getSelectInstallationClass(){
			echo json_encode($this->scheme_model->get($_POST, $_POST['op_type']));
		}
		
		public function get_scheme_upload_details(){
			echo json_encode($this->scheme_model->get($_POST, $_POST['op_type']));
		}
		/**
		* Name : Siddhartha Mishra
		* Date : 18-05-2019
		* Purpose : Get All Generated Ticket
		*/
		
		public function get_generated_ticket(){
			$type = $this->uri->segment(3);
			$inputCsrfToken = $_POST['csrf_generated_ticket'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dataTableGeneratedTicket')){
			    	echo json_encode($this->schedule_model->get($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		
		/**
		* Name : Siddhartha Mishra
		* Date : 18-05-2019
		* Purpose : Get All Resolve Ticket
		*/
		
		public function get_resolve_ticket(){
			$type = $this->uri->segment(3);
			$inputCsrfToken = $_POST['csrf_resolve_ticket'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dataTableResolveTicket')){
			    	echo json_encode($this->schedule_model->get($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		
		/**
		* Name : Siddhartha Mishra
		* Date : 18-05-2019
		* Purpose : Get All Closed Ticket
		*/
		
		public function get_closed_ticket(){
			$type = $this->uri->segment(3);
			$inputCsrfToken = $_POST['csrf_closed_ticket'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dataTableRejectedClosed')){
			    	echo json_encode($this->schedule_model->get($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		
		/**
		* Name : Siddhartha Mishra
		* Date : 20-05-2019
		* Purpose : Map Technician
		*/
		
		public function operation_technician_mapping(){
			$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_map_technician'];
				if(!empty($input_csrf_token)){
					if(checkToken( $input_csrf_token, 'form_map_technician')){
						$config = array(
				            array(
				                'field'   => 'cmb_scheme_list',
				                'label'   => 'Scheme',
				                'rules'   => 'trim|required|xss_clean'
				            ),
				            array(
				                'field'   => 'cmb_vendor_list',
				                'label'   => 'Vendor',
				                'rules'   => 'trim|required|xss_clean'
				            ),
				            array(
				                'field'   => 'cmb_technician',
				                'label'   => 'Technician',
				                'rules'   => 'trim|required|xss_clean'
				            ),
				            array(
				                'field'   => 'cmb_ticket',
				                'label'   => 'Ticket List',
				                'rules'   => 'trim|xss_clean'
				            )
		        		);
						$this->form_validation->set_rules($config);
					    if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						     
						}else{
							echo json_encode($this->schedule_model->post($_POST,$_POST['op_type']));
						}			        	
			    	}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
						echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
					echo json_encode($data);
				}
			}
		}
		
		/**
		* Name : Siddhartha Mishra
		* Date : 21-05-2019
		* Purpose : Get Ticket score
		*/
		
		public function get_ticket_score(){
			$type = $this->uri->segment(3);
			$inputCsrfToken = $_POST['csrf_ticket_score'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dtbleTicketScore')){
			    	echo json_encode($this->scoring_model->get($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		
		/**
		* Name : Siddhartha Mishra
		* Date : 21-05-2019
		* Purpose : Get Ticket Report
		*/
		
		public function get_ticket_report(){
			$type = $this->uri->segment(3);
			$inputCsrfToken = $_POST['csrf_ticket_report'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dataTableTicketReport')){
			    	echo json_encode($this->scoring_model->get($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		/**
		* Name : Subhashree Jena
		* Date : 20-05-2019
		* Purpose: View all vendor wise transaction
		* @return
		*/
		public function get_transaction_details(){
			$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_trans_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dataTableTransaction')){
			    	$x = $this->transaction_model->get($_POST, $type);			    
			    	echo json_encode($x);
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function operation_approval_process(){
			$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_approvalinfo_token'];
				if(!empty($input_csrf_token)){
					if(checkToken( $input_csrf_token, 'form_approval_information')){
						$config = array(
				            array(
				                'field'   => 'cmb_approval_status',
				                'label'   => 'Approval Status',
				                'rules'   => 'trim|required|xss_clean'
				            ),
				            array(
				                'field'   => 'txt_remarks',
				                'label'   => 'Vendor',
				                'rules'   => 'trim|xss_clean'
				            )
		        		);
						$this->form_validation->set_rules($config);
					    if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						     
						}else{
							echo json_encode($this->transaction_model->post($_POST,$_POST['op_type']));
						}			        	
			    	}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
						echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
					echo json_encode($data);
				}
			}
		}
		/**
		* Name : Siddhartha Mishra
		* Date : 22-05-2019
		* Purpose : View Ticket Details
		*/
		
		public function view_ticket_details(){
			$ticket_id =$this->uri->segment(3);
			$ticket_details= "";
			$table_question= "";
			$get_data = $this->schedule_model->get(array('ticket_id'=>$ticket_id),'get_ticket_details');
			$get_ticket_data = $this->schedule_model->get(array('ticket_id'=>$ticket_id),'get_ticket_data');
			//print_r($get_ticket_data);
			$get_qstn = $this->getter_model->get(array('ticket_id'=>$ticket_id),'get_ticket_component');
			$dbStatus = true;
			if(!empty($get_data)){
				if(file_exists($get_ticket_data['evidence_pic'])){
					$image_path = base_url($get_ticket_data['evidence_pic']);
				}else{
					$image_path = 'public/custom/photos/no_image.png';
				}
				$ticket_details.="<fieldset>
		            		    	<legend>Ticket Details</legend>
		            		    	<input type='hidden' id='ticket' name='ticket' value=".$get_data['ticket_id'].">
		            		    	<div class='col-md-12'>
		            		    		<div class='col-md-6'>
											<label class='col-md-6'>Technician Name:</label>
											<span class='col-md-6'>".$get_data['name']."</span>
										</div>
		            		    		<div class='col-md-6'>
											<label class='col-md-6'>Ticket Id:</label>
											<span class='col-md-6'>".$get_data['ticket_id']."</span>
										</div>
		            		    	</div>
		            		    	<div class='col-md-12'>
		            		    	    <div class='col-md-6'>
											<label class='col-md-6'>Scheme Name</label>
											<span class='col-md-6'>".$get_data['scheme_name']."</span>
										</div>
										<div class='col-md-6'>
											<label class='col-md-6'>Vendor Name:</label>
											<span class='col-md-6'>".$get_data['supplier_name']."</span>
										</div>
		            		    	</div>
		            		    	<div class='col-md-12'>
		            		    		<div class='col-md-6'>
											<label class='col-md-6'>District Name:</label>
											<span class='col-md-6'>".$get_data['district_name']."</span>
										</div>
										<div class='col-md-6'>
											<label class='col-md-6'>Block Name</label>
											<span class='col-md-6'>".$get_data['block_name']."</span>
										</div>
		            		    	</div>
		            		    	<div class='col-md-12'>
		            		    		<div class='col-md-6'>
											<label class='col-md-6'>Address:</label>
											<span class='col-md-6'>".$get_data['address']."</span>
										</div>
		            		    		<div class='col-md-6'>
											<label class='col-md-6'>MC:</label>
											<span class='col-md-6'>".$get_data['mc']."</span>
										</div>
		            		    	</div>
		            		    </fieldset>
		            		    <fieldset>
		            		    	<div class='col-md-12'>
		            		    		<div class='col-md-6'>
											<label class='col-md-6'>Witness Name</label>
											<span class='col-md-6'>".$get_ticket_data['witness_name']."</span>
										</div>
										<div class='col-md-6'>
											<label class='col-md-6'>Witness Number:</label>
											<span class='col-md-6'>".$get_ticket_data['witness_no']."</span>
										</div>
		            		    	</div>
		            		    	<div class='col-md-12'>
		            		    		<div class='col-md-6'>
											<label class='col-md-6'>Ticket Purpose:</label>
											<span class='col-md-6'>".$get_ticket_data['visit']."</span>
										</div>
										<div class='col-md-6'>
											<label class='col-md-6'>Remarks:</label>
											<span class='col-md-6'>".$get_ticket_data['remarks']."</span>
										</div>
		            		    	</div>
		            		    	<div class='col-md-12'>
		            		    		<div class='col-md-6'>
											<label class='col-md-6'>Evidence Pic:</label>
											<img id='myImg3' class='img-rounded img-thumbnail zoom-img' src='".$image_path."' alt='instal_photo' width='50'>
										</div>
		            		    	</div>
		            		    </fieldset>
					 <div class='modal-footer'>
					 </div>";
					  foreach($get_qstn as $key => $qst){
					                    	if($qst['question_id'] == $qst['id']){
												$cheak_box = "<input type='checkbox' class = 'checkbox1' value='".$qst['id']."' checked disabled>";
											}else{
												$cheak_box = "<input type='checkbox' class = 'checkbox1' value='".$qst['id']."' disabled>";
											}		
											$table_question.= "<tr>
												<td width='5%'>".$cheak_box."</td>
												<td width='10%'>".$qst['installation']."</td>
												<td width='10%'>".$qst['component']."</td>
												<td width='40%'>".$qst['task_desc']."</td>
											</tr>";
				}	
			}
			echo json_encode(array('status'=>$dbStatus,'data'=>$ticket_details,'data1'=>$table_question));
		}
		
		
			public function get_all_status(){
			echo json_encode($this->getter_model->get($_POST,$_POST['op_type']));
		}
		
		/**
		* Name : Siddhartha Mishra
		* Date : 22-05-2019
		* Purpose : Ticket Status Update
		*/
		
		public function operation_ticket_status(){
			$input_csrf_token = $_POST['csrf_ticket_status'];
				if(!empty($input_csrf_token)){
					if(checkToken( $input_csrf_token, 'form_ticket_status')){
						$config = array(
				            array(
				                'field'   => 'cmb_status',
				                'label'   => 'Status',
				                'rules'   => 'trim|required|xss_clean'
				            )
		        		);
						$this->form_validation->set_rules($config);
					    if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						     
						}else{
							echo json_encode($this->schedule_model->post($_POST,$_POST['op_type']));
						}			        	
			    	}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
						echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
					echo json_encode($data);
				}
			/*$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				
			}*/
		}
		function get_components_data(){
			$record = '<h4>Components</h4>';
			$cm_val = array();
			$data['components_details'] = $this->transaction_model->get($_POST,'get_components_details');
			for($i=0;$i<count($data['components_details']) ; $i++){
				$data['all_attribute_details'] = $this->transaction_model->get(array('component_id'=>$data['components_details'][$i]['component_id']),$_POST['op_type']);
				$data['trans_component_header']  = $this->transaction_model->get(array('trans_details_id'=>$data['components_details'][$i]['transdetails_id'],'component_id'=>$data['components_details'][$i]['component_id']),'get_trans_component_data_header');
				$data['trans_component_value']  = $this->transaction_model->get(array('trans_details_id'=>$data['components_details'][$i]['transdetails_id'],'component_id'=>$data['components_details'][$i]['component_id']),'get_trans_component_data');
				if(!empty($data['all_attribute_details'])){
					array_push($cm_val,$data['all_attribute_details']);
				}
				if($_POST['div'] == 'div'){
					$div = 'hidden';
				}else{
					$div = '';
				}
				$record.="<fieldset><legend>".$data['components_details'][$i]['component_name']."</legend><div style='float:right;' $div><button type='button' class='btn btn-info' id='btnAddAttribute' value=".$data['components_details'][$i]['component_id']."><i class='fa fa-plus'></i></button></div>";
				$record.="<table class='table table-bordered table-hover tablesorter' ><input type='hidden'  id='hid_trans_details_id_".$data['components_details'][$i]['component_id']."' value ='".$data['components_details'][$i]['transdetails_id']."'/><thead><tr>";
				$record.="<thead><tr>";
				$m=0;
				foreach ($data['trans_component_header']->list_fields() as $field){
					if($field=='transaction_details_id'){
						$record.='<th style="text-align: center" hidden> '. $field.'</th>';
					}else{
						$record.='<th style="text-align: center"> '. $field.'</th>';
						$m++;
					}
				}
				$record.="<th>Action</th></tr>	</thead><tbody>";
				if(!empty($data['trans_component_value'])){
					foreach($data['trans_component_value'] as $row){
						$record.="<tr>";
						foreach ($data['trans_component_header']->list_fields() as $field){
							if($field=='transaction_details_id'){
								$trans_details_id = $row[$field];
								$record.='<td style="text-align: center" hidden>'.$row[$field].'</td>';
							}else{
								$record.='<td style="text-align: center">'.$row[$field].'</td>';
							}
							if($field=='#'){
								$sl_no = $row[$field];
							}
						}
						$record.="<td><button type='button' class='btn btn-info btn-circle tooltipTable' align='center' onclick='editAttributeData($trans_details_id,$sl_no);' title='Edit' ><i class='fa fa-pencil-square-o'></i></button></td></tr>";
					}
				}else{
					$record.="<tr><td style='text-align:center'colspan='".$m."' >No data available in table</td></tr>";
				}
				
				$record.="</tbody></table>";
				$record .="</fieldset>";
			}
			echo json_encode(array('status'=>TRUE,'data'=>$record));
		}
		public function get_attribute_details(){
			$attribute = "";
			$attribute_details = $this->transaction_model->get(array('component_id'=>$_POST['component_id']),'get_attribute_details');
			if(!empty($attribute_details)){
				$attribute .= "<input type='hidden' name ='trans_details_id' value='".$_POST['trans_details_id']."' />";
				for($k = 0;$k <count($attribute_details) ;$k++){
					$attribute .="<div class='form-group col-md-6'>
							<label>".$attribute_details[$k]['attribute_name'].":</label>
							<input type='text' class='form-control' name='".$attribute_details[$k]['components_id']."-".$attribute_details[$k]['id']."' id='txt_attribute_name'  value='' required=''  maxlength='50'>
						</div>";
				}
			}
			echo json_encode(array('status'=>TRUE,'data'=>$attribute));
		}
		public function op_attribute_details(){
			echo json_encode($this->transaction_model->post($_POST,$_POST['oper_type']));
		}
		public function get_trans_header_data(){
			echo json_encode($this->transaction_model->get($_POST,$_POST['opType']));
		}
		public function get_edit_attribute_details(){
			//print_r($_POST);die();
			$attribute = "";
			$attribute_list = $this->transaction_model->get($_POST,$_POST['op_type']);
			if(!empty($attribute_list)){
				for($k = 0;$k <count($attribute_list) ;$k++){
					$attribute .="<div class='form-group col-md-6'>
							<label>".$attribute_list[$k]['attr_header'].":</label>
							<input type='hidden' name='hsl' value='".$attribute_list[$k]['sl_no']."'/><input type='hidden' name='hid_transaction_details_id' value='".$attribute_list[$k]['transaction_details_id']."' />
							<input type='text' class='form-control' name='".$attribute_list[$k]['components_detail_id']."'  value='".$attribute_list[$k]['attribute_values']."'' required=''  maxlength='50'>
						</div>";
				}
			}
			echo json_encode(array('status'=>TRUE,'data'=>$attribute));
		}
		/**
		* Name : Subhashree Jena
		* Date : 27-05-2019
		* Purpose : Update closure request status
		*/
		public function operation_closure_request(){	
	 	
			$input_csrf_token = $_POST['csrf_closureRequest_token'];
			if(!empty($input_csrf_token)){
				if(checkToken($input_csrf_token, 'form_closure_request')){
					if(!empty($_POST['op_type'])){
						$config = array(
			               	array(
			                     'field'   => 'cmbChangeStatusClose',
			                     'label'   => 'Status',
			                     'rules'   => 'required|xss_clean|trim'
			                ),
			                array(
			                     'field'   => 'txtDescriptionClose',
			                     'label'   => 'Description',
			                     'rules'   => 'required|xss_clean|trim'
			                )
			            );
					}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Operation Type is blank'
			            );
		            	echo json_encode($data);
					}
		  			$this->form_validation->set_rules($config);
					if ($this->form_validation->run() == FALSE) {
						$data = array(
			                'status' => 'validationerror',
			                'msg' => validation_errors()
			            );
		            	echo json_encode($data);
					}else{
						echo json_encode($this->raise_ticket_model->post($_POST, $_POST['op_type']));
					} 
				}else{
					$data = array(
				        'status' => false,
				        'msg' => 'Invalid Security Token'
				    );
					echo json_encode($data);
				}
			}else{
				$data = array(
			        'status' => false,
			        'msg' => 'Empty Security Token'
			    );
			}
		}
		
		/**
		* Name : Subhashree jena
		* Date : 28-05-2019
		* Purpose : Update Conformation Customer 
		* 
		* @return
		*/
		public function operation_conformation_customer(){	
		 	
			$input_csrf_token = $_POST['csrf_conformation_token'];
			if(!empty($input_csrf_token)){
				if(checkToken($input_csrf_token, 'form_conformation_customer')){
					if(!empty($_POST['op_type'])){
						$config = array(
			               	array(
			                     'field'   => 'txt_phone',
			                     'label'   => 'Phone',
			                     'rules'   => 'required|xss_clean|trim'
			                ),
			                array(
			                     'field'   => 'txtDescription',
			                     'label'   => 'Description',
			                     'rules'   => 'required|xss_clean|trim'
			                )
			            );
					}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Operation Type is blank'
			            );
		            	echo json_encode($data);
					}
		  			$this->form_validation->set_rules($config);
					if ($this->form_validation->run() == FALSE) {
						$data = array(
			                'status' => 'validationerror',
			                'msg' => validation_errors()
			            );
		            	echo json_encode($data);
					}else{
						echo json_encode($this->raise_ticket_model->post($_POST, $_POST['op_type']));
					} 
				}else{
					$data = array(
				        'status' => false,
				        'msg' => 'Invalid Security Token'
				    );
					echo json_encode($data);
				}
			}else{
				$data = array(
			        'status' => false,
			        'msg' => 'Empty Security Token'
			    );
			}
		}
		/**
		* Name : Subhashree Jena
		* Date :29-05-2019
		* Purpose : Get Closed Suspended Ticket
		*/
		
		public function get_closed_suspended(){
			$type = $this->uri->segment(3);
			$inputCsrfToken = $_POST['csrf_closeSuspend_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dataTableCloseSuspend')){
			    	echo json_encode($this->raise_ticket_model->get($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		/**
		* Name : Subhashree Jena
		* Date : 29-05-2019
		* Purpose : Add Transaction
		*/
		
		function operation_transaction(){
			$temp_rule = Array("&lt","&gt","<",">","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_trans_token'];
				if(!empty($input_csrf_token)){
					if(checkToken($input_csrf_token, 'form_add_transaction')){
						if(!empty($_POST['op_type'])){
							$config = array(
				               	array(
				                     'field'   => 'cmb_scheme',
				                     'label'   => 'Scheme',
				                     'rules'   => 'required|xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'cmb_sanctionletter',
				                     'label'   => 'Sanction Letter No',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'cmb_finance_source',
				                     'label'   => 'Finance Source',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'cmb_vendorname',
				                     'label'   => 'Vendor Name',
				                     'rules'   => 'required|xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'cmb_installationClass',
				                     'label'   => 'Installation Class',
				                     'rules'   => 'required|xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'cmb_work',
				                     'label'   => 'Work Order/Purchase Order',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'checkbox_powerplant',
				                     'label'   => 'Power Plant',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'cmb_district',
				                     'label'   => 'District',
				                     'rules'   => 'required|xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'cmb_cdblock',
				                     'label'   => 'CD Block',
				                     'rules'   => 'required|xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'cmb_grampanchayat',
				                     'label'   => 'Gram Panchayat',
				                     'rules'   => 'required|xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'cmb_revenuevillage',
				                     'label'   => 'Revenue Village',
				                     'rules'   => 'required|xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'txt_plotno',
				                     'label'   => 'Plot No',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'txt_area',
				                     'label'   => 'Area',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'txt_landmark',
				                     'label'   => 'Landmark',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'txt_pincode',
				                     'label'   => 'Pincode',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'txt_censuscode',
				                     'label'   => 'Census Code',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'txt_gpscode',
				                     'label'   => 'GPS Code',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'cmb_districtcluster',
				                     'label'   => 'District Cluster',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'cmb_maintenanceCluster',
				                     'label'   => 'Maintenance Cluster',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'cmb_scheduled_week',
				                     'label'   => 'Scheduled Week',
				                     'rules'   => 'required|xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'txt_firstName',
				                     'label'   => 'First Name',
				                     'rules'   => 'required|xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'txt_LastName',
				                     'label'   => 'Last Name',
				                     'rules'   => 'required|xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'txt_fatherSpouse',
				                     'label'   => 'Name of Father/Spouse',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'cmb_casteCategory',
				                     'label'   => 'Caste/Category',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'txt_MobileOne',
				                     'label'   => 'Mobile1',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'txt_email',
				                     'label'   => 'Email',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'cmb_gender',
				                     'label'   => 'Gender',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'txt_Aadhar',
				                     'label'   => 'Aadhar Card No',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'txt_Alternate',
				                     'label'   => 'Alternate Id No',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'cmb_acs',
				                     'label'   => 'ACS',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'cmb_parentcustomer',
				                     'label'   => 'Parent Customer',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'file_customerphoto',
				                     'label'   => 'Customer Photo',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'file_idproof',
				                     'label'   => 'ID Proof',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'file_installationphoto',
				                     'label'   => 'Installation Photo',
				                     'rules'   => 'xss_clean|trim'
				                )
				            );
						}else{
							$data = array(
				                'status' => false,
				                'msg' => 'Operation Type is blank'
				            );
			            	echo json_encode($data);
						}
			  			$this->form_validation->set_rules($config);
						if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
			            	echo json_encode($data);
						}else{
							echo json_encode($this->transaction_model->post($_POST, $_POST['op_type']));
						} 
					}else{
						$data = array(
					        'status' => false,
					        'msg' => 'Invalid Security Token'
					    );
						echo json_encode($data);
					}
				}else{
					$data = array(
				        'status' => false,
				        'msg' => 'Empty Security Token'
				    );
				}
			}
		}
		function operation_view_transaction(){
			$temp_rule = Array("&lt","&gt","<",">","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_trans_token'];
				if(!empty($input_csrf_token)){
					if(checkToken($input_csrf_token, 'form_add_transaction')){
						if(!empty($_POST['op_type'])){
							$config = array(
				                array(
				                     'field'   => 'cmb_work',
				                     'label'   => 'Work Order/Purchase Order',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'checkbox_powerplant',
				                     'label'   => 'Power Plant',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'cmb_district',
				                     'label'   => 'District',
				                     'rules'   => 'required|xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'cmb_cdblock',
				                     'label'   => 'CD Block',
				                     'rules'   => 'required|xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'cmb_grampanchayat',
				                     'label'   => 'Gram Panchayat',
				                     'rules'   => 'required|xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'txt_plotno',
				                     'label'   => 'Plot No',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'txt_area',
				                     'label'   => 'Area',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'txt_landmark',
				                     'label'   => 'Landmark',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'txt_pincode',
				                     'label'   => 'Pincode',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'txt_censuscode',
				                     'label'   => 'Census Code',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'txt_gpscode',
				                     'label'   => 'GPS Code',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'cmb_districtcluster',
				                     'label'   => 'District Cluster',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'cmb_maintenanceCluster',
				                     'label'   => 'Maintenance Cluster',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'cmb_scheduled_week',
				                     'label'   => 'Scheduled Week',
				                     'rules'   => 'required|xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'txt_firstName',
				                     'label'   => 'First Name',
				                     'rules'   => 'required|xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'txt_LastName',
				                     'label'   => 'Last Name',
				                     'rules'   => 'required|xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'txt_fatherSpouse',
				                     'label'   => 'Name of Father/Spouse',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'cmb_casteCategory',
				                     'label'   => 'Caste/Category',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'txt_MobileOne',
				                     'label'   => 'Mobile1',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'txt_email',
				                     'label'   => 'Email',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'cmb_gender',
				                     'label'   => 'Gender',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'txt_Aadhar',
				                     'label'   => 'Aadhar Card No',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'txt_Alternate',
				                     'label'   => 'Alternate Id No',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'cmb_acs',
				                     'label'   => 'ACS',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'cmb_parentcustomer',
				                     'label'   => 'Parent Customer',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'file_customerphoto',
				                     'label'   => 'Customer Photo',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'file_idproof',
				                     'label'   => 'ID Proof',
				                     'rules'   => 'xss_clean|trim'
				                ),
				                array(
				                     'field'   => 'file_installationphoto',
				                     'label'   => 'Installation Photo',
				                     'rules'   => 'xss_clean|trim'
				                )
				            );
						}else{
							$data = array(
				                'status' => false,
				                'msg' => 'Operation Type is blank'
				            );
			            	echo json_encode($data);
						}
			  			$this->form_validation->set_rules($config);
						if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
			            	echo json_encode($data);
						}else{
							echo json_encode($this->transaction_model->post($_POST, $_POST['op_type']));
						} 
					}else{
						$data = array(
					        'status' => false,
					        'msg' => 'Invalid Security Token'
					    );
						echo json_encode($data);
					}
				}else{
					$data = array(
				        'status' => false,
				        'msg' => 'Empty Security Token'
				    );
				}
			}
		}
		/**
		* Name : Subhashree Jena
		* Date : 31-05-2019
		* Purpose : Operation Beyond Scope
		*/
		
		public function operation_beyond_scope(){	
			$input_csrf_token = $_POST['csrf_beyondScope_token'];
			if(!empty($input_csrf_token)){
				if(checkToken($input_csrf_token, 'form_beyond_scope')){
					if(!empty($_POST['op_type'])){
						$config = array(
			               	array(
			                    'field'   => 'txtBeyondTo',
			                    'label'   => 'To Mail',
			                    'rules'   => 'required|xss_clean|trim'
			                ),
			                array(
			                    'field'   => 'txtBeyondcc',
			                    'label'   => 'CC',
			                    'rules'   => 'xss_clean|trim'
			                ),
			                array(
			                    'field'   => 'txtBeyondBcc',
			                    'label'   => 'Bcc',
			                    'rules'   => 'xss_clean|trim'
			                ),
			                array(
			                    'field'   => 'txtBeyondSubject',
			                    'label'   => 'Subject',
			                    'rules'   => 'xss_clean|trim'
			                ),
			                array(
			                    'field'   => 'txtBeyondMobileto',
			                    'label'   => 'Mobile',
			                    'rules'   => 'required|xss_clean|trim'
			                )
			            );
					}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Operation Type is blank'
			            );
		            	echo json_encode($data);
					}
		  			$this->form_validation->set_rules($config);
					if ($this->form_validation->run() == FALSE) {
						$data = array(
			                'status' => 'validationerror',
			                'msg' => validation_errors()
			            );
		            	echo json_encode($data);
					}else{
						echo json_encode($this->raise_ticket_model->post($_POST, $_POST['op_type']));
					} 
				}else{
					$data = array(
				        'status' => false,
				        'msg' => 'Invalid Security Token'
				    );
					echo json_encode($data);
				}
			}else{
				$data = array(
			        'status' => false,
			        'msg' => 'Empty Security Token'
			    );
			}
		}
		
		/**
		* Name : Subhashree Jena
		* Date : 31-05-2019
		* Purpose : Operation Escalation Mail
		*/
		
		public function operation_escalation_mail(){	
			$input_csrf_token = $_POST['csrf_escalationMail_token'];
			if(!empty($input_csrf_token)){
				if(checkToken($input_csrf_token, 'form_escalation_mail')){
					if(!empty($_POST['op_type'])){
						$config = array(
			               	array(
			                    'field'   => 'txtto',
			                    'label'   => 'To Mail',
			                    'rules'   => 'required|xss_clean|trim'
			                ),
			                array(
			                    'field'   => 'txtcc',
			                    'label'   => 'CC',
			                    'rules'   => 'xss_clean|trim'
			                ),
			                array(
			                    'field'   => 'txtbcc',
			                    'label'   => 'Bcc',
			                    'rules'   => 'xss_clean|trim'
			                ),
			                array(
			                    'field'   => 'txtsubject',
			                    'label'   => 'Subject',
			                    'rules'   => 'xss_clean|trim'
			                )
			            );
					}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Operation Type is blank'
			            );
		            	echo json_encode($data);
					}
		  			$this->form_validation->set_rules($config);
					if ($this->form_validation->run() == FALSE) {
						$data = array(
			                'status' => 'validationerror',
			                'msg' => validation_errors()
			            );
		            	echo json_encode($data);
					}else{
						echo json_encode($this->raise_ticket_model->post($_POST, $_POST['op_type']));
					} 
				}else{
					$data = array(
				        'status' => false,
				        'msg' => 'Invalid Security Token'
				    );
					echo json_encode($data);
				}
			}else{
				$data = array(
			        'status' => false,
			        'msg' => 'Empty Security Token'
			    );
			}
		}

		/**
		* Name : Subhashree Jena
		* Date : 31-05-2019
		* Purpose : Operation Follow Up Mail And SMS
		*/
		
		public function operation_followup_mail_sms(){	
			$input_csrf_token = $_POST['csrf_followup_mail_sms_token'];
			if(!empty($input_csrf_token)){
				if(checkToken($input_csrf_token, 'form_followup_mail_sms')){
					if(!empty($_POST['op_type'])){
						$config = array(
			               	array(
			                    'field'   => 'txtFollowUpMailto',
			                    'label'   => 'To Mail',
			                    'rules'   => 'required|xss_clean|trim'
			                ),
			                array(
			                    'field'   => 'txtFollowUpMailcc',
			                    'label'   => 'CC',
			                    'rules'   => 'xss_clean|trim'
			                ),
			                array(
			                    'field'   => 'txtFollowUpMailbcc',
			                    'label'   => 'Bcc',
			                    'rules'   => 'xss_clean|trim'
			                ),
			                array(
			                    'field'   => 'txtFollowUpMailsubject',
			                    'label'   => 'Subject',
			                    'rules'   => 'xss_clean|trim'
			                )
			            );
					}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Operation Type is blank'
			            );
		            	echo json_encode($data);
					}
		  			$this->form_validation->set_rules($config);
					if ($this->form_validation->run() == FALSE) {
						$data = array(
			                'status' => 'validationerror',
			                'msg' => validation_errors()
			            );
		            	echo json_encode($data);
					}else{
						echo json_encode($this->raise_ticket_model->post($_POST, $_POST['op_type']));
					} 
				}else{
					$data = array(
				        'status' => false,
				        'msg' => 'Invalid Security Token'
				    );
					echo json_encode($data);
				}
			}else{
				$data = array(
			        'status' => false,
			        'msg' => 'Empty Security Token'
			    );
			}
		}

		/**
		* Name : Subhashree Jena
		* Date : 31-05-2019
		* Purpose : Operation Follow Up Mail And SMS
		*/
		
		public function operation_followup_call_vendor(){	
			$input_csrf_token = $_POST['csrf_followup_call_vendor_token'];
			if(!empty($input_csrf_token)){
				if(checkToken($input_csrf_token, 'form_followup_calltovendor_request')){
					if(!empty($_POST['op_type'])){
						$config = array(
			               	array(
			                    'field'   => 'txtFCVPhone',
			                    'label'   => 'Phone No.',
			                    'rules'   => 'required|xss_clean|trim'
			                ),
			                array(
			                    'field'   => 'cmbFCVstatus',
			                    'label'   => 'CC',
			                    'rules'   => 'required|xss_clean|trim'
			                ),
			                array(
			                    'field'   => 'txtFCVDescription',
			                    'label'   => 'Bcc',
			                    'rules'   => 'xss_clean|trim'
			                )
			            );
					}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Operation Type is blank'
			            );
		            	echo json_encode($data);
					}
		  			$this->form_validation->set_rules($config);
					if ($this->form_validation->run() == FALSE) {
						$data = array(
			                'status' => 'validationerror',
			                'msg' => validation_errors()
			            );
		            	echo json_encode($data);
					}else{
						echo json_encode($this->raise_ticket_model->post($_POST, $_POST['op_type']));
					} 
				}else{
					$data = array(
				        'status' => false,
				        'msg' => 'Invalid Security Token'
				    );
					echo json_encode($data);
				}
			}else{
				$data = array(
			        'status' => false,
			        'msg' => 'Empty Security Token'
			    );
			}
		}
		
		
		/*
		
			The below function is used for showing vendor against Village data  datatable
			Created By : Ashutosh Mishra
			Created On : 17-05-2019
		*/
		
		public function get_village_against_vendor_data(){
			$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_vendorVillage_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dataTableLinkVendorVillage')){
			    	echo json_encode($this->vendor_model->get($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		/*
		
			The below function is used for mapping vendor against village 
			Created By : Ashutosh Mishra
			Created On : 03-06-2019
		*/
		
		public function operation_vendor_against_village(){
			echo json_encode($this->vendor_model->post($_POST, $_POST['op_type']));
	    	/*$inputCsrfToken = $_POST['csrf_linkVendorVillage'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'form_link_vendor_village')){
			    	echo json_encode($this->vendor_model->post($_POST, $_POST['op_type']));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}*/
		}

	    /**
		* Name : Siddhartha Mishra
		* Date : 14-06-2019
		* Purpose : Technician Ticket mapping
		*/
		
		public function operation_ticket_technician(){
			$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_technician'];
				if(!empty($input_csrf_token)){
					if(checkToken( $input_csrf_token, 'form_add_technician')){
						$config = array(
				            array(
				                'field'   => 'cmb_technician',
				                'label'   => 'Technician',
				                'rules'   => 'trim|required|xss_clean'
				            ),
				        );
						$this->form_validation->set_rules($config);
					    if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						     
						}else{
							echo json_encode($this->raise_ticket_model->post($_POST,$_POST['op_type']));
						}			        	
			    	}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
						echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
					echo json_encode($data);
				}
			}
		}
			/**
		* Name : Subhashree Jena
		* Date : 18-06-2019
		* Purpose : Delete Scheme Upload Data
		*/
		
		public function delete_scheme_upload(){
			echo json_encode($this->scheme_model->get($_POST, $_POST['op_type']));
		}
		/**
		* Name : Subhashree Jena
		* Date :19-06-2019
		* Purpose : Get Vendor and Scheme Wise Installation  
		* @return
		*/
		public function get_schedule_installation(){
			echo json_encode($this->getter_model->get($_POST,$_POST['op_type']));
		}
		
		/**
		* Name : Subhashree Jena
		* Date :20-06-2019
		* Purpose : Insert Schedule Controller 
		*/
		
		public function operation_schedule_controller(){
			$input_csrf_token = $_POST['csrf_schedule_approval_token'];
			if(!empty($input_csrf_token)){
				if(checkToken($input_csrf_token, 'form_schedule_approval')){
					if(!empty($_POST['op_type'])){
						$config = array(
			               	array(
			                    'field'   => 'txtMonth',
			                    'label'   => 'Month',
			                    'rules'   => 'required|xss_clean|trim'
			                ),
			                array(
			                    'field'   => 'txtYear',
			                    'label'   => 'Year',
			                    'rules'   => 'required|xss_clean|trim'
			                ),
			                array(
			                    'field'   => 'cmb_vendor',
			                    'label'   => 'vendor',
			                    'rules'   => 'xss_clean|trim'
			                ),
			                array(
			                    'field'   => 'cmb_schemes',
			                    'label'   => 'scheme',
			                    'rules'   => 'xss_clean|trim'
			                )
			            );
					}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Operation Type is blank'
			            );
		            	echo json_encode($data);
					}
		  			$this->form_validation->set_rules($config);
					if ($this->form_validation->run() == FALSE) {
						$data = array(
			                'status' => 'validationerror',
			                'msg' => validation_errors()
			            );
		            	echo json_encode($data);
					}else{
						echo json_encode($this->schedule_model->post($_POST, $_POST['op_type']));
					} 
				}else{
					$data = array(
				        'status' => false,
				        'msg' => 'Invalid Security Token'
				    );
					echo json_encode($data);
				}
			}else{
				$data = array(
			        'status' => false,
			        'msg' => 'Empty Security Token'
			    );
			}
		}
		/**
		* Name : Subhashree Jena
		* Date : 20-06-2019
		* Purpose : Get Schedule Ticket Count
		*/
		
		public function get_schedule_ticket_count(){
			echo json_encode($this->service_request_model->get($_POST,$_POST['op_type']));
		} 
		
		/**
		* Name : Subhashree Jena
		* Date :20-06-2019
		* Purpose : Operation Of Ticket Approval
		*/
		
		public function operation_ticket_approval(){
			$input_csrf_token = $_POST['csrf_ticket_approval_token'];
			if(!empty($input_csrf_token)){
				if(checkToken($input_csrf_token, 'form_ticket_approval')){
					if(!empty($_POST['op_type'])){
						$config = array(
			               	array(
			                    'field'   => 'txtTicketDate',
			                    'label'   => 'Date',
			                    'rules'   => 'required|xss_clean|trim'
			                ),
			                array(
			                    'field'   => 'txtTicketTime',
			                    'label'   => 'Time',
			                    'rules'   => 'required|xss_clean|trim'
			                ),
			                array(
			                    'field'   => 'txtComments',
			                    'label'   => 'Comments',
			                    'rules'   => 'xss_clean|trim'
			                )
			            );
					}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Operation Type is blank'
			            );
		            	echo json_encode($data);
					}
		  			$this->form_validation->set_rules($config);
					if ($this->form_validation->run() == FALSE) {
						$data = array(
			                'status' => 'validationerror',
			                'msg' => validation_errors()
			            );
		            	echo json_encode($data);
					}else{
						echo json_encode($this->service_request_model->post($_POST, $_POST['op_type']));
					} 
				}else{
					$data = array(
				        'status' => false,
				        'msg' => 'Invalid Security Token'
				    );
					echo json_encode($data);
				}
			}else{
				$data = array(
			        'status' => false,
			        'msg' => 'Empty Security Token'
			    );
			}
		}
		/**
		* Name : Subhashree Jena
		* Date :21-06-2019
		* Purpose : Operation Attribute
		*/
		public function operation_attribute(){	
		 	$input_csrf_token = $_POST['csrf_attribute_token'];
			if(!empty($input_csrf_token)){
				if(checkToken($input_csrf_token, 'form_attribute_master')){
					if(!empty($_POST['op_type'])){
						$config = array(
			               	array(
			                    'field'   => 'txtAttributeCode',
			                    'label'   => 'Attribute Code',
			                    'rules'   => 'required|xss_clean'
			                ),
			                array(
			                    'field'   => 'txtAttributeName',
			                    'label'   => 'Attribute Name',
			                    'rules'   => 'required|xss_clean'
			                )
			            );
					}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Operation Type is blank'
			            );
		            	echo json_encode($data);
					}
		  			$this->form_validation->set_rules($config);
					if ($this->form_validation->run() == FALSE) {
						$data = array(
			                'status' => 'validationerror',
			                'msg' => validation_errors()
			            );
		            	echo json_encode($data);
					}else{
						echo json_encode($this->attribute_model->post($_POST, $_POST['op_type']));
					} 
				}else{
					$data = array(
				        'status' => false,
				        'msg' => 'Invalid Security Token'
				    );
					echo json_encode($data);
				}
			}else{
				$data = array(
			        'status' => false,
			        'msg' => 'Empty Security Token'
			    );
			}
		}
		/**
		* Name : Subhashree Jena
		* Date :21-06-2019
		* Purpose : Get Attribute Master
		*/
		public function get_attribute_master(){
			$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_attribute_table_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dtblAttributeMaster')){
			    	echo json_encode($this->attribute_model->get($_POST, $_POST['Op_Type']));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		/**
		* Name : Subhashree Jena
		* Date :21-06-2019
		* Purpose : Get Ticket Generation Validation 
		*/
		public function get_ticket_gen_validation(){
	    	$inputCsrfToken = $_POST['csrf_ticket_gen_validation_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dbtlTicketGenValidation')){
			    	echo json_encode($this->service_request_model->get($_POST, $_POST['Op_Type']));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		/**
		* Name : Subhashree Jena
		* Date :21-06-2019
		* Purpose : operation ticket validation 
		*/
		 
		 public function operation_ticket_validation(){	
		 	$input_csrf_token = $_POST['csrf_ticket_validation_token'];
			if(!empty($input_csrf_token)){
				if(checkToken($input_csrf_token, 'form_ticket_validation_status')){
					if(!empty($_POST['op_type'])){
						$config = array(
			               	array(
			                    'field'   => 'cmb_ticketStatus',
			                    'label'   => 'Status',
			                    'rules'   => 'required|xss_clean'
			                ),
			                array(
			                    'field'   => 'txtRemarks',
			                    'label'   => 'Remarks',
			                    'rules'   => 'required|xss_clean'
			                )
			            );
					}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Operation Type is blank'
			            );
		            	echo json_encode($data);
					}
		  			$this->form_validation->set_rules($config);
					if ($this->form_validation->run() == FALSE) {
						$data = array(
			                'status' => 'validationerror',
			                'msg' => validation_errors()
			            );
		            	echo json_encode($data);
					}else{
						echo json_encode($this->service_request_model->post($_POST, $_POST['op_type']));
					} 
				}else{
					$data = array(
				        'status' => false,
				        'msg' => 'Invalid Security Token'
				    );
					echo json_encode($data);
				}
			}else{
				$data = array(
			        'status' => false,
			        'msg' => 'Empty Security Token'
			    );
			}
		}
		/**
		* Name: Siddhartha Mishra
		* Date: 21-06-2019
		* Purpose: Get AMC Validation Details
		*/
		public function get_amc_validation(){
			$type = $this->uri->segment(3);
			$inputCsrfToken = $_POST['csrf_amc_validation_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dbtlAmcValidation')){
			    	echo json_encode($this->service_request_model->get($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		/**
		* Name : Siddhartha Mishra
		* Date :21-06-2019
		* Purpose : AMC Renewal
		*/
    	public function operation_amc_renew(){
			$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_add_amc'];
				if(!empty($input_csrf_token)){
					if(checkToken( $input_csrf_token, 'form_add_amc')){
						$config = array(
				            array(
				                'field'   => 'txtConsumerId',
				                'label'   => 'Consumer Id',
				                'rules'   => 'trim|required|xss_clean'
				            ),
				            array(
				                'field'   => 'txtLetterNo',
				                'label'   => 'Letter No',
				                'rules'   => 'trim|required|xss_clean'
				            ),
				            array(
				                'field'   => 'txtvalidfrom',
				                'label'   => 'Valid From',
				                'rules'   => 'trim|required|xss_clean'
				            ),
				            array(
				                'field'   => 'txtvalidtill',
				                'label'   => 'Valid Till',
				                'rules'   => 'trim|xss_clean'
				            )
		        		);
		        		
						$this->form_validation->set_rules($config);
					    if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						     
						}else{
							echo json_encode($this->service_request_model->post($_POST,$_POST['op_type']));
						}			        	
			    	}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
						echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
					echo json_encode($data);
				}
			}
		}
		/**
		* Name: Siddhartha Mishra
		* Date: 21-06-2019
		* Purpose: Get AMC History Details
		*/
		public function get_amc_history(){
			$type = $this->uri->segment(3);
			//$id = $this->uri->segment(4);
			$inputCsrfToken = $_POST['csrf_amc_history_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dbtlAmcHistory')){
			    	echo json_encode($this->service_request_model->get($_POST,$type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		/**
		* Name : Subhashree Jena
		* Date : 06-06-2019
		* Purpose : Get Raise Ticket in dashboard
		*/
		public function get_raise_ticket_cases(){
			$get_data = $this->dashboard_model->get($_POST,$_POST['op_type']);
			$view_ticket="";
			$sl = 1;
			if(!empty($get_data)){
				foreach($get_data as $key =>$value){
					$view_ticket.="<tr>
	    				<td style='text-align: center;'>".$sl."</td>
	    				<td><a href='Javascript:void(0)' onclick='transactionReport(".$value['id'].",".$value['req_by'].")'>".$value['ticket_id']."</a></td>
	    				<td>".$value['district_name'].','.$value['block_name'].','.$value['gp_name'].','.$value['village_name'].','.$value['habitation']."</td>
	    				<td  style='text-align: center;'>".date("d-m-Y", strtotime($value['actual_issue_date']))."</td>
	    				<td style='text-align: right;'>".$value['ageing']."</td>
	    				
	    			</tr>";
	    			$sl++;
				}
			}else{
				$view_ticket.= "<tr><td colspan='5' style='text-align: center'>No Records Found</td></tr>";
			}
			echo json_encode(array('status'=>true,'data1'=>$view_ticket));
		}
		/**
		* Name: Siddhartha Mishra
		* Date: 27-06-2019
		* Purpose: Update link vendor village
		*/
		public function operation_edit_vendor_against_village(){
			//print_r($_POST);die();
	    	$inputCsrfToken = $_POST['csrf_edit_link_vendor_village'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'form_edit_link_vendor_village')){
			    	$type = $_POST['op_type'];
			    	echo json_encode($this->vendor_model->post($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
				/**
		* Name: Siddhartha Mishra
		* Date: 03-07-2019
		* Purpose: Get Sm Control Panel
		*/
		
		public function get_sm_control(){
			$type = $this->uri->segment(3);
			$inputCsrfToken = $_POST['csrf_smcontrolpanel'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dataTableSmControlPanel')){
			    	echo json_encode($this->service_request_model->get($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function schedule_mail(){
			echo json_encode($this->schedule_model->post($_POST, $_POST['op_type']));
		}
		public function get_chart1_data(){
			echo json_encode($this->getter_model->get($_POST, $_POST['op_type']));
		}
		public function get_chart_totaldata(){
			echo json_encode($this->getter_model->get($_POST, $_POST['op_type']));
		}
		public function get_chart_projectsdata(){
			echo json_encode($this->getter_model->get($_POST, $_POST['op_type']));
		}
		public function get_chart2_data(){
			echo json_encode($this->getter_model->get($_POST, $_POST['op_type']));
		}
		public function get_chart2_vendor(){
			echo json_encode($this->getter_model->get($_POST, $_POST['op_type']));
		}
		public function get_chart2_projects(){
			echo json_encode($this->getter_model->get($_POST, $_POST['op_type']));
		}
		public function get_chart3_data(){
			echo json_encode($this->getter_model->get($_POST, $_POST['op_type']));
		}
		public function get_chart4_data(){
			echo json_encode($this->getter_model->get($_POST, $_POST['op_type']));
		}
		public function operation_sm_resolution_form(){	
			$input_csrf_token = $_POST['csrf_ticket_form_token'];
			if(!empty($input_csrf_token)){
				if(checkToken($input_csrf_token, 'Resolution_form')){
					if(!empty($_POST['op_type'])){
						$config = array(
			               	array(
			                     'field'   => 'check_reason',
			                     'label'   => 'Check Box',
			                     'rules'   => 'required|xss_clean|trim'
			                ),
			                array(
			                     'field'   => 'txt_witness_name',
			                     'label'   => 'Witness Name',
			                     'rules'   => 'required|xss_clean|trim'
			                ),
			                array(
			                     'field'   => 'txt_witness_number',
			                     'label'   => 'Witness Number',
			                     'rules'   => 'required|xss_clean|trim'
			                ),
			                array(
			                     'field'   => 'txt_remarks',
			                     'label'   => 'Remarks',
			                     'rules'   => 'required|xss_clean|trim'
			                )
			            );
					}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Operation Type is blank'
			            );
		            	echo json_encode($data);
					}
		  			$this->form_validation->set_rules($config);
					if ($this->form_validation->run() == FALSE) {
						$data = array(
			                'status' => 'validationerror',
			                'msg' => validation_errors()
			            );
		            	echo json_encode($data);
					}else{
						echo json_encode($this->schedule_model->post($_POST, $_POST['op_type']));
					} 
				}else{
					$data = array(
				        'status' => false,
				        'msg' => 'Invalid Security Token'
				    );
					echo json_encode($data);
				}
			}else{
				$data = array(
			        'status' => false,
			        'msg' => 'Empty Security Token'
			    );
			}
		}
		
		public function operation_cm_resolution_form(){	
			$input_csrf_token = $_POST['csrf_ticket_form_token'];
			if(!empty($input_csrf_token)){
				if(checkToken($input_csrf_token, 'CM_Resolution_form')){
					if(!empty($_POST['op_type'])){
						$config = array(
			               	array(
			                     'field'   => 'check_reason',
			                     'label'   => 'Check Box',
			                     'rules'   => 'required|xss_clean|trim'
			                ),
			                array(
			                     'field'   => 'txt_witness_name',
			                     'label'   => 'Witness Name',
			                     'rules'   => 'required|xss_clean|trim'
			                ),
			                array(
			                     'field'   => 'txt_witness_number',
			                     'label'   => 'Witness Number',
			                     'rules'   => 'required|xss_clean|trim'
			                ),
			                array(
			                     'field'   => 'txt_remarks',
			                     'label'   => 'Remarks',
			                     'rules'   => 'required|xss_clean|trim'
			                )
			            );
					}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Operation Type is blank'
			            );
		            	echo json_encode($data);
					}
		  			$this->form_validation->set_rules($config);
					if ($this->form_validation->run() == FALSE) {
						$data = array(
			                'status' => 'validationerror',
			                'msg' => validation_errors()
			            );
		            	echo json_encode($data);
					}else{
						echo json_encode($this->raise_ticket_model->post($_POST, $_POST['op_type']));
					} 
				}else{
					$data = array(
				        'status' => false,
				        'msg' => 'Invalid Security Token'
				    );
					echo json_encode($data);
				}
			}else{
				$data = array(
			        'status' => false,
			        'msg' => 'Empty Security Token'
			    );
			}
		}
	/**
		* Name : Subhashree Jena
		* Date: 31-08-2019
		* Purpose : View Amc Validation Expiry Report
		*/
		
		public function view_amc_expiry_detail(){
			$type = $this->uri->segment(3);
			$inputCsrfToken = $_POST['csrf_amc_report_details_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dtblAMCReportDetails')){
			    	echo json_encode($this->service_request_model->get($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function get_vendor_asset_project_list(){
	    	$inputCsrfToken = $_POST['csrf_asset'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken, 'dtableAssetStatus' ) ) {
			    	echo json_encode($this->dashboard_model->get($_POST, $_POST['op_type']));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => 'FALSE',
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function get_list_of_open_cases(){
			$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_open_case_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken, 'dbtblOpenCaselist' ) ) {
			    	echo json_encode($this->mis_model->get($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => 'FALSE',
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function get_dist_abstract_open(){
			$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_district_abstract_open_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken, 'dbtblDistAbstractOpen' ) ) {
			    	echo json_encode($this->mis_model->get($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => 'FALSE',
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function get_supplier_analysis(){
			$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_supplier_analysis_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken, 'dbtblSupplierAnalysis' ) ) {
			    	echo json_encode($this->mis_model->get($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => 'FALSE',
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function get_cm_scheme_performance_one(){
			$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_cm_receipt_status_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken, 'dbtblSchemePerformanace' ) ) {
			    	echo json_encode($this->mis_model->get($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => 'FALSE',
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function get_cm_supplier_performance_two(){
			$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_cm_supplier_performance_token'];
			if($inputCsrfToken != ''){
			    if(checkToken( $inputCsrfToken, 'dbtblSupplierPerformanace')) {
			    	echo json_encode($this->mis_model->get($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => 'FALSE',
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		/**
		* Name: Siddhartha Mishra
		* Date: 2-09-2019
		* Purpose: Mis report CM Receipt Redressal Status
		* 
		* 
		*/
		public function get_cm_receipt_redressal_status(){
			$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_cm_receipt_status_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken, 'dbtblCMReceiptStatus' ) ) {
			    	echo json_encode($this->mis_model->get($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => 'FALSE',
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		/**
		* Name: Siddhartha Mishra
		* Date: 2-09-2019
		* Purpose: Mis report CM Frequency Received
		* 
		* 
		*/
		public function get_cm_frequency_received(){
			$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_cm_frequency_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken, 'dbtblCMFrequency' ) ) {
			    	echo json_encode($this->mis_model->get($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => 'FALSE',
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		/**
		* Name: Siddhartha Mishra
		* Date: 2-09-2019
		* Purpose: Mis report SM Complaince Statement
		* 
		* 
		*/
		public function get_sm_complaince_statement(){
			$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_sm_complaince_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken, 'dbtblSMComplainceStatment' ) ) {
			    	echo json_encode($this->mis_model->get($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => 'FALSE',
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function get_cmc_management_report(){
			echo json_encode($this->service_request_model->get($_POST, $_POST['op_type']));
		}
		/**
		* Name : Subhashree Jena
		* Date: 03-09-2019
		* Purpose : View Amc Validation Expiry Report
		*/
		
		public function view_cmc_expiry_report(){
			$type = $this->uri->segment(3);
			$inputCsrfToken = $_POST['csrf_cmc_report_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken,'dbtlCMCExpiryReport')){
			    	echo json_encode($this->service_request_model->get($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => false,
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		/**
		* Name :Subhashree Jena
		* Date :03-09-2019
		* Purpose : Get Age Analysis Open Case List
		*/
		
		public function get_age_analysis_open_case_list(){
			$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_age_analysis_open_case_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken, 'dbtblAgeAnalysis' ) ) {
			    	echo json_encode($this->mis_model->get($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => 'FALSE',
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		/**
		* Name :Subhashree Jena
		* Date :03-09-2019
		* Purpose : Get Trend CM request
		*/
		
		public function get_trend_cm_list(){
			$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_trend_cm_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken, 'dbtblCMRequestTrend' ) ) {
			    	echo json_encode($this->mis_model->get($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => 'FALSE',
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		
		/**
		* Name :Subhashree Jena
		* Date :03-09-2019
		* Purpose : Get Trend New Customer Registration
		*/
		
		public function get_trend_new_cm_list(){
			$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_new_cm_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken, 'dbtblNewCMRequestTrend' ) ) {
			    	echo json_encode($this->mis_model->get($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => 'FALSE',
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		/**
		* Name: Siddhartha Mishra
		* Date: 4-09-2019
		* Purpose: Sm Control Modal Data
		* 
		* 
		*/
		public function view_install_details(){
			$month_code =$this->uri->segment(3);
			$installation="";
			$installation_list 	= $this->service_request_model->get(array('month_code'=>$month_code),'get_exclude_install_list');
			if(!empty($installation_list)){
				foreach($installation_list as $install){
					$installation.="<tr>
						<td>".$install['MONTH']."</td>
						<td>".$install['s_year']."</td>
						<td>".$install['supplier']."</td>
						<td>".$install['scheme_name']."</td>
						<td>".$install['instal_cls_name']."</td>
					</tr>";
				}
				echo json_encode(array('status'=>'true','data'=>$installation));
			}
		}
		
		/**
		* Name : Subhashree Jena
		* Date : 17-09-2019
		* Purpose : Get User details
		*/
		public function get_username_details(){
			echo json_encode($this->getter_model->get($_POST,$_POST['op_type']));
		}
		/**
		* Name : Subhashree Jena
		* Date : 17-09-2019
		* Purpose : Operation IMEI Setup
		*/
		public function operation_imei_setup(){
			$temp_rule = Array("&lt","&gt","<",">","(","=");
			if (hasXSS($_POST,$temp_rule)){
				$data = array(
	                'status' => false,
	                'msg' => 'Special chararacters like <,>,=,(,),&lt;,&gt; are not allowed'
	            );
				echo json_encode($data);
			}else{
				$input_csrf_token = $_POST['csrf_imei_setup'];
				if(!empty($input_csrf_token)){
					if(checkToken($input_csrf_token, 'form_imei_setup')){
						$config = array(
							array(
			                    'field'   => 'cmb_username',
			                    'label'   => 'Please select user name',
			                    'rules'   => 'trim|xss_clean'
			                ),
			                array(
			                    'field'   => 'txt_role',
			                    'label'   => 'required role',
			                    'rules'   => 'trim|xss_clean'
			                ),
			                array(
			                    'field'   => 'txt_imeiOne',
			                    'label'   => 'please fill IMEI One',
			                    'rules'   => 'trim|xss_clean'
			                )
			            );
						$this->form_validation->set_rules($config); 
					    if ($this->form_validation->run() == FALSE) {
							$data = array(
				                'status' => 'validationerror',
				                'msg' => validation_errors()
				            );
				            echo json_encode($data);
						}else{
							echo json_encode($this->admin_model->admin($_POST, $_POST['op_type']));
						}
					}else{
						$data = array(
			                'status' => false,
			                'msg' => 'Invalid Security Token'
			            );
			            echo json_encode($data);
					}
				}else{
					$data = array(
		                'status' => false,
		                'msg' => 'Empty Security Token'
		            );
		            echo json_encode($data);
		        }
			}
		}
		/**
		* Name : Subhashree Jena
		* Date :17-09-2019
		* Purpose : Get all user list
		*/
		
		public function get_imei_setup(){
			$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_imeiToken'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken, 'dataTableIMEI' ) ) {
			    	echo json_encode($this->admin_model->admin($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => 'FALSE',
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function operation_installation_track(){
	    	$inputCsrfToken = $_POST['csrf_track_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken, 'form_installation_track' ) ) {
			    	echo json_encode($this->transaction_model->post($_POST, $_POST['op_type']));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => 'FALSE',
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function get_admin_user_data(){
	    	$type = $this->uri->segment(3);
	    	$inputCsrfToken = $_POST['csrf_user_token'];
			if($inputCsrfToken != ''){
			    if( checkToken( $inputCsrfToken, 'user_table' ) ) {
			    	echo json_encode($this->admin_model->admin($_POST, $type));
			    }else{
					$data = array(
		                'status' => false,
		                'msg' => 'Invalid Security Token'
		            );
					echo json_encode($data);
				}
			}else{
				$data = array(
	                'status' => 'FALSE',
	                'msg' => 'Empty Security Token'
	            );
				echo json_encode($data);
			}
		}
		public function get_finance_source(){
			echo json_encode($this->getter_model->get($_POST,$_POST['op_type']));
		}
	}
	