<?php defined('BASEPATH') OR exit('No direct script access allowed');
	class Scoring_controller extends CI_Controller  {
  		public function __construct(){
    		parent::__construct();
    		
    		# libraries
			$this->load->library('form_validation');
			$this->load->library('user_agent');
			# libraries
			$this->load->helper('custom_page');
			# models
			$this->load->model('getter_model');
			$this->load->model('scoring_model');
			# views
			$data['title'] = $this->getter_model->get(null,'get_title');
			$this->load->view('templates/header',$data);
   		}
		public function _remap($method){
			$class = $this->router->class;
			$role = $this->session->userdata('role');
			$check_user = $this->getter_model->get(null,'get_user_check');
			$role_action_auth = array( 
				'CRCADMIN'=>array('cm_itemized_score','sm_itemized_score','energy_performance','scoring_performance'),
				'OCE'=>array('cm_itemized_score','sm_itemized_score','energy_performance'),
				'ODR'=>array('cm_itemized_score','sm_itemized_score','energy_performance'),
				'ODH'=>array('cm_itemized_score','sm_itemized_score','energy_performance'),
				'ODA'=>array('cm_itemized_score','sm_itemized_score','energy_performance'),
				'VENDOR'=>array('cm_itemized_score','sm_itemized_score','energy_performance'),
				'TECHNICIAN'=>array('sm_itemized_score')
			);
			if( $role == false || !isset($role_action_auth[$role]) || !in_array($method, $role_action_auth[$role]) || !$check_user){
				redirect('logout');
			}else{
				if (in_array(strtolower($method), array_map('strtolower', get_class_methods($this)))){
					$uri = $this->uri->segment_array();
					unset($uri[1]);
					unset($uri[2]);
					call_user_func_array(array($this, $method), $uri);
				}else{
					self::page_not_found();
				}
			}
		}
		public function page_not_found(){
			$this->load->view('templates/404');
			$this->load->view('templates/footer');
		}
		public function cm_itemized_score(){
			$sidebar['menu_item'] = 'CM Itemized Score';
			$sidebar['menu_group'] = 'Performance Monitor';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$data['scheme_list'] 	  = $this->getter_model->get(null,'get_supplier_list');
			$data['cm_itemized_score_record']= $this->scoring_model->get(null,'get_cm_itemized_score');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('scoring/cm_itemized_score',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function sm_itemized_score(){
			$sidebar['menu_item'] = 'SM Itemized Score';
			$sidebar['menu_group'] = 'Performance Monitor';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('scoring/sm_itemized_score');
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function energy_performance(){
			$sidebar['menu_item'] = 'Energy Performance';
			$sidebar['menu_group'] = 'Performance Monitor';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('scoring/energy_performance');
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function scoring_performance(){
			$sidebar['menu_item'] = 'Scoring Performance';
			$sidebar['menu_group'] = 'Performance Monitor';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			$data['scheduler_maintenance_score'] =$this->scoring_model->get(null,'get_scheduler_maintenance_score');
			$data['corrective_maintenance_score'] =$this->scoring_model->get(null,'get_corrective_maintenance_score');
			if($page_status!= 0) {
				$this->load->view('scoring/scoring_performance',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
	}