<?php defined('BASEPATH') OR exit('No direct script access allowed');
include APPPATH . 'third_party'.DIRECTORY_SEPARATOR.'dompdf'.DIRECTORY_SEPARATOR.'vendor'.DIRECTORY_SEPARATOR.'autoload.php';
use Dompdf\Dompdf;

class System_controller extends CI_Controller
{
	public function __construct() 
	{
		parent::__construct();
		
		date_default_timezone_set('Asia/Kolkata');
		
		# libraries
		$this->load->library('form_validation');
		$this->load->library('user_agent');
		
		# models
		$this->load->model(array('dashboard_model','scoring_model','scheme_model','vendor_model','schedule_model'));
	}	


	/*
	*	purpose : to check whether the method is correct or not
	*/
	public function _remap($method)
	{
		$class 	= $this->router->class;
		$role = $this->session->userdata('role');

		$role_action_auth = array(
			'ADMIN'=>array('index', 'op_print'),
			'CRCADMIN'=>array('index', 'op_print'),
			'CRCAGENT'=>array('index', 'op_print'),
			'OCE'=>array('index', 'op_print'),
			'ODR'=>array('index', 'op_print'),
			'ODH'=>array('index', 'op_print'),
			'ODA'=>array('index', 'op_print'),
			'OTO'=>array('index', 'op_print'),
			'ADEPT'=>array('index', 'op_print'),
			'USER'=>array('index', 'op_print'),
			'ADO'=>array('index', 'op_print'),
			'DA'=>array('index', 'op_print'),
			'SI'=>array('index', 'op_print'),
			'DDA'=>array('index', 'op_print'),
			'JDA'=>array('index', 'op_print'),
			'VENDOR'=>array('index', 'op_print'),
			'TECHNICIAN'=>array('index', 'op_print')
		);

		if( $role == false || !isset($role_action_auth[$role]) || !in_array($method, $role_action_auth[$role]) )
		{
			self::page_not_found();
		}
		else
		{
			if (in_array(strtolower($method), array_map('strtolower', get_class_methods($this))))
			{
				$uri = $this->uri->segment_array();
				unset($uri[1]);
				unset($uri[2]);
				call_user_func_array(array($this, $method), $uri);
			}
			else
			{
				self::page_not_found();
			}
		}
	}

	/*
	*	purpose : Handle page not found
	*/
	public function page_not_found(){
		$this->load->view('templates/404.php');
		$this->load->view('templates/footer');
	}
	
	
	
	public function op_print(){
		$type = $this->uri->segment(2);
		$month_code = $this->uri->segment(3);
		$data = array();
		$view = '';
		switch($type){
			case 'schedule_ticket_generation_report':
				$data['cohorts'] = $this->schedule_model->get(null,'get_cohorts');
				$data['total_ticket_type'] = $this->schedule_model->get(array('month'=>$month_code),'get_total_ticket_type');
				$data['total_vendor_data'] = $this->schedule_model->get(array('month'=>$month_code),'get_total_vendor_data');
				$data['total_installation_data'] = $this->schedule_model->get(array('month'=>$month_code),'get_total_installation_data');
				$msg = $this->load->view('system/schedule_ticket_view_pdf',$data,true);
				$dompdf = new Dompdf();
				$dompdf->set_option('isHtml5ParserEnabled', true);
				$dompdf->loadHtml($msg);
				//$dompdf->setPaper('A4', 'landscape');
				$dompdf->render();
				$today_date = date('d-m-Y');
				$dompdf->stream("Orissa Renewable Energy Development Agency".$today_date, array("Attachment" => false));
			break;
			case 'print_company_view_pdf':
				if($this->session->userdata('role') == 'VENDOR'){
					$data['company_view'] = $this->dashboard_model->get(null,'get_company_view_vendorwise');
				}else{
					$data['company_view'] = $this->dashboard_model->get(null,'get_company_view');
				}
				$msg = $this->load->view('system/company_view_pdf',$data,true);
				$dompdf = new Dompdf();
				$dompdf->set_option('isHtml5ParserEnabled', true);
				$dompdf->loadHtml($msg);
				$dompdf->render();
				$today_date = date('d-m-Y');
				$dompdf->stream("Orissa Renewable Energy Development Agency".$today_date, array("Attachment" => false));
			break;
			case 'print_total_scheme_view_pdf':
				if($this->session->userdata('role') == 'VENDOR'){
					$data['total_statistics_all_schemes'] = $this->dashboard_model->get(null,'get_total_statistics_schemes_vendorwise');
				}else{
					$data['total_statistics_all_schemes'] = $this->dashboard_model->get(null,'get_total_statistics_all_schemes');
				}
				$msg = $this->load->view('system/total_scheme_view_pdf',$data,true);
				$dompdf = new Dompdf();
				$dompdf->set_option('isHtml5ParserEnabled', true);
				$dompdf->loadHtml($msg);
				$dompdf->render();
				$today_date = date('d-m-Y');
				$dompdf->stream("Orissa Renewable Energy Development Agency".$today_date, array("Attachment" => false));
			break;
			case 'print_total_vendor_view_pdf':
				$data['scheme_id']	 = $this->uri->segment(3);
				$data['scheme_list'] 		= $this->dashboard_model->get(array('scheme_id'=>$data['scheme_id']),'get_scheme_list');
				if($this->session->userdata('role') == 'VENDOR'){
					$data['schemes_wise_statistics']= $this->dashboard_model->get(array('scheme_id'=>$data['scheme_id'],'scheme_code'=>$data['scheme_list']['scheme_code']),'get_vendor_wise_schemes_statistics');
				}else{
					$data['schemes_wise_statistics']= $this->dashboard_model->get(array('scheme_id'=>$data['scheme_id'],'scheme_code'=>$data['scheme_list']['scheme_code']),'get_schemes_wise_statistics');
				}
				$msg = $this->load->view('system/total_vendor_view_pdf',$data,true);
				$dompdf = new Dompdf();
				$dompdf->set_option('isHtml5ParserEnabled', true);
				$dompdf->loadHtml($msg);
				$dompdf->render();
				$today_date = date('d-m-Y');
				$dompdf->stream("Orissa Renewable Energy Development Agency".$today_date, array("Attachment" => false));
			break;
			case 'print_vendor_ticket_pdf':
				$decode_scheme_code = $this->uri->segment(3);
				$smth 			= preg_replace("/%u([0-9a-f]{3,4})/i","&#x\\1;",urldecode($decode_scheme_code)); 
				$smth_scheme_code 	= html_entity_decode($smth,null,'UTF-8');
				$scheme_code		= base64_decode($smth_scheme_code);
				$explode_value = explode("#",$scheme_code);
				$supplier_code = $explode_value[0];
				$scheme_code = $explode_value[1];
				$data['suplier_name'] = $explode_value[2];
				$data['get_ticket_data'] = $this->dashboard_model->get(array('supplier_code' =>$supplier_code ,'scheme_code' =>$scheme_code),'get_raise_ticket_cases');
				$msg = $this->load->view('system/vendor_ticket_view_pdf',$data,true);
				$dompdf = new Dompdf();
				$dompdf->set_option('isHtml5ParserEnabled', true);
				$dompdf->loadHtml($msg);
				$dompdf->render();
				$today_date = date('d-m-Y');
				$dompdf->stream("Orissa Renewable Energy Development Agency".$today_date, array("Attachment" => false));
			break;
			/**
			* Name : Subhashree Jena
			* Date :22-08-2019
			* Purpose : project status scheme pdf
			*/
			case 'print_project_status_scheme':
				$data['status_list'] = $this->dashboard_model->get(null,'get_status_projects');
				$data['scheme_list'] = $this->dashboard_model->get(null,'get_scheme_list');
				$msg = $this->load->view('system/project_status_scheme_pdf',$data,true);
				$dompdf = new Dompdf();
				$dompdf->set_option('isHtml5ParserEnabled', true);
				$dompdf->loadHtml($msg);
				$dompdf->setPaper('A4', 'landscape');
				$dompdf->render();
				$today_date = date('d-m-Y');
				$dompdf->stream("Orissa Renewable Energy Development Agency".$today_date, array("Attachment" => false));
			break;
			
			/**
			* Name : Subhashree Jena
			* Date :22-08-2019
			* Purpose : project vendor status  pdf
			*/
			case 'print_project_vendor_status':
				$scheme_id 	=urldecode($this->uri->segment(3));
				$data['vendor_list'] = $this->dashboard_model->get(array('scheme_id' =>$scheme_id),'get_vendor_status_list');
				$data['scheme_name'] = $this->scheme_model->get(array('pk_scheme_code' =>$scheme_id),'get_scheme_details');
				$data['scheme_id'] = $scheme_id;
				$msg = $this->load->view('system/project_vendor_status_pdf',$data,true);
				$dompdf = new Dompdf();
				$dompdf->set_option('isHtml5ParserEnabled', true);
				$dompdf->loadHtml($msg);
				$dompdf->render();
				$today_date = date('d-m-Y');
				$dompdf->stream("Orissa Renewable Energy Development Agency".$today_date, array("Attachment" => false));
			break;
			
			/**
			* Name : Subhashree Jena
			* Date :22-08-2019
			* Purpose : project vendor wise  pdf
			*/
			case 'print_projects_vendor_wise_list':
				$expload_data = explode("#",urldecode($this->uri->segment(3)));
				$supplier_code = $expload_data[0];
				$scheme_id 	  = $expload_data[1];
				$data['vendor_list'] = $this->dashboard_model->get(array('supplier_code'=>$supplier_code,'scheme_id' =>$scheme_id),'get_vendor_wise_status_list');
				$data['scheme_name'] = $this->scheme_model->get(array('pk_scheme_code' =>$scheme_id),'get_scheme_details');
				$data['vendor_name'] = $this->vendor_model->get(array('supplier_code' =>$supplier_code),'get_vendor_view_details');
				$data['scheme_id'] = $scheme_id;
				$data['supplier_code'] = $supplier_code;
				$msg = $this->load->view('system/projects_vendor_wise_list_pdf',$data,true);
				$dompdf = new Dompdf();
				$dompdf->set_option('isHtml5ParserEnabled', true);
				$dompdf->setPaper('A4','landscape');
				$dompdf->loadHtml($msg);
				$dompdf->render();
				$today_date = date('d-m-Y');
				$dompdf->stream("Orissa Renewable Energy Development Agency".$today_date, array("Attachment" => false));
			break;
			
			/**
			* Name : Subhashree Jena
			* Date :22-08-2019
			* Purpose : project Asset Status
			*/
			case 'print_project_asset_status':
				$data['asset_status'] = $this->dashboard_model->get(null,'project_asset_status');
				$msg = $this->load->view('system/project_asset_status_pdf',$data,true);
				$dompdf = new Dompdf();
				$dompdf->set_option('isHtml5ParserEnabled', true);
				$dompdf->loadHtml($msg);
				$dompdf->render();
				$today_date = date('d-m-Y');
				$dompdf->stream("Orissa Renewable Energy Development Agency".$today_date, array("Attachment" => false));
			break;
			
			/**
			* Name : Subhashree Jena
			* Date :22-08-2019
			* Purpose : project Wise  Asset Status
			*/
			case 'print_project_wise_asset_status':
				$data['asset_status_projectwise'] = $this->dashboard_model->get(null,'projectwise_asset_status');
				$msg = $this->load->view('system/project_wise_asset_status_pdf',$data,true);
				$dompdf = new Dompdf();
				$dompdf->set_option('isHtml5ParserEnabled', true);
				$dompdf->loadHtml($msg);
				$dompdf->render();
				$today_date = date('d-m-Y');
				$dompdf->stream("Orissa Renewable Energy Development Agency".$today_date, array("Attachment" => false));
			break;
			
			/**
			* Name : Subhashree Jena
			* Date :22-08-2019
			* Purpose : Scheme  Wise  Asset Status
			*/
			case 'print_scheme_wise_asset_status':
				$scheme_id 	=urldecode($this->uri->segment(3));
				$data['asset_status_schemewise'] = $this->dashboard_model->get(array('scheme_id' =>$scheme_id),'schemewise_asset_status');
				$data['scheme_name'] = $this->scheme_model->get(array('pk_scheme_code' =>$scheme_id),'get_scheme_details');
				$data['scheme_id'] = $scheme_id;
			
				$msg = $this->load->view('system/scheme_wise_asset_status_pdf',$data,true);
				$dompdf = new Dompdf();
				$dompdf->set_option('isHtml5ParserEnabled', true);
				$dompdf->loadHtml($msg);
				$dompdf->render();
				$today_date = date('d-m-Y');
				$dompdf->stream("Orissa Renewable Energy Development Agency".$today_date, array("Attachment" => false));
			break;
			
			/**
			* Name : Subhashree Jena
			* Date :22-08-2019
			* Purpose : Assets Vendor Count
			*/
			case 'print_assets_vendor_count_view':
				$data['vendor_count'] = $this->dashboard_model->get(null,'get_asset_vendor_count');
			
				$msg = $this->load->view('system/assets_vendor_count_pdf',$data,true);
				$dompdf = new Dompdf();
				$dompdf->set_option('isHtml5ParserEnabled', true);
				$dompdf->loadHtml($msg);
				$dompdf->render();
				$today_date = date('d-m-Y');
				$dompdf->stream("Orissa Renewable Energy Development Agency".$today_date, array("Attachment" => false));
			break;
			
			/**
			* Name : Subhashree Jena
			* Date :22-08-2019
			* Purpose : Assets Vendor Wise Status
			*/
			case 'print_assets_vendor_wise_view':
				$data['vendor_list'] = $this->dashboard_model->get(null,'get_vendor_asset_status_list');
			
				$msg = $this->load->view('system/assets_vendor_wise_pdf',$data,true);
				$dompdf = new Dompdf();
				$dompdf->set_option('isHtml5ParserEnabled', true);
				$dompdf->loadHtml($msg);
				$dompdf->render();
				$today_date = date('d-m-Y');
				$dompdf->stream("Orissa Renewable Energy Development Agency".$today_date, array("Attachment" => false));
			break;
			
			/**
			* Name : Subhashree Jena
			* Date :22-08-2019
			* Purpose : Print schedule maintenance
			*/
			case 'print_schedule_maintenance':
				$supplier_code 	=urldecode($this->uri->segment(3));
				$data['vendor_name'] = $this->vendor_model->get(array('supplier_code'=>$supplier_code),'get_vendor_view_details');
				$data['sm_data'] 		= $this->dashboard_model->get(null,'get_sm_data');
				$msg = $this->load->view('system/schedule_maintenance_pdf',$data,true);
				$dompdf = new Dompdf();
				$dompdf->set_option('isHtml5ParserEnabled', true);
				$dompdf->loadHtml($msg);
				$dompdf->render();
				$today_date = date('d-m-Y');
				$dompdf->stream("Orissa Renewable Energy Development Agency".$today_date, array("Attachment" => false));
			break;
			
			/**
			* Name : Subhashree Jena
			* Date :22-08-2019
			* Purpose : Print Vendor View
			*/
			case 'print_sm_vendor_view':
				$expload_data = explode("#",urldecode($this->uri->segment(3)));
				$month_code   = $expload_data[0];
				$year    	  = $expload_data[1];
				$data['sm_vendor_data'] = $this->dashboard_model->get(array('year' =>$year,'month'=>$month_code),'get_sm_vendor_data');
				$msg = $this->load->view('system/sm_vendor_view_pdf',$data,true);
				$dompdf = new Dompdf();
				$dompdf->set_option('isHtml5ParserEnabled', true);
				$dompdf->loadHtml($msg);
				$dompdf->render();
				$today_date = date('d-m-Y');
				$dompdf->stream("Orissa Renewable Energy Development Agency".$today_date, array("Attachment" => false));
			break;
			
			/**
			* Name : Subhashree Jena
			* Date :22-08-2019
			* Purpose : Print Vendor View
			*/
			case 'print_sm_vendor_scheme_view':
				$expload_data = explode("#",urldecode($this->uri->segment(3)));
				$month_code   = $expload_data[0];
				$year    	  = $expload_data[1];
				$vendor_id    = $expload_data[2];
				$data['sm_vendor_scheme_data'] = $this->dashboard_model->get(array('year' =>$year,'month'=>$month_code,'vendor_id'=>$vendor_id),'get_sm_vendor_scheme_data');
				$msg = $this->load->view('system/sm_vendor_scheme_view_pdf',$data,true);
				$dompdf = new Dompdf();
				$dompdf->set_option('isHtml5ParserEnabled', true);
				$dompdf->loadHtml($msg);
				$dompdf->render();
				$today_date = date('d-m-Y');
				$dompdf->stream("Orissa Renewable Energy Development Agency".$today_date, array("Attachment" => false));
			break;
			
			/**
			* Name : Subhashree Jena
			* Date :22-08-2019
			* Purpose : Print Scheme View
			*/
			case 'print_sm_scheme_view':
				$expload_data = explode("#",urldecode($this->uri->segment(3)));
				$month_code   = $expload_data[0];
				$year    	  = $expload_data[1];
				$data['sm_scheme_data'] = $this->dashboard_model->get(array('year' =>$year,'month'=>$month_code),'get_sm_scheme_data');
				$msg = $this->load->view('system/sm_scheme_view_pdf',$data,true);
				$dompdf = new Dompdf();
				$dompdf->set_option('isHtml5ParserEnabled', true);
				$dompdf->loadHtml($msg);
				$dompdf->render();
				$today_date = date('d-m-Y');
				$dompdf->stream("Orissa Renewable Energy Development Agency".$today_date, array("Attachment" => false));
			break;
			/**
			* Name : Subhashree Jena
			* Date :06-09-2019
			* Purpose : Print Scheme View
			*/
			case 'print_vendor_status_project':
				$data['vendor_status'] = $this->dashboard_model->get(null,'get_vendor_status_project');
				$msg = $this->load->view('system/vendor_status_project_pdf',$data,true);
				$dompdf = new Dompdf();
				$dompdf->set_option('isHtml5ParserEnabled', true);
				$dompdf->setPaper('A4', 'landscape');
				$dompdf->loadHtml($msg);
				$dompdf->render();
				$today_date = date('d-m-Y');
				$dompdf->stream("Orissa Renewable Energy Development Agency".$today_date, array("Attachment" => false));
			break;
			/**
			* Name : Subhashree Jena
			* Date :06-09-2019
			* Purpose : Print Single project data
			*/
			case 'print_status_project_single_vendor':
				$data['supplier_code'] 	=urldecode($this->uri->segment(3));
				$data['vendor_name'] = $this->vendor_model->get(array('supplier_code'=>$data['supplier_code']),'get_vendor_view_details');
				$data['vendor_List'] = $this->dashboard_model->get(array('supplier_code'=>$data['supplier_code']),'get_status_individual_vendor');
				$msg = $this->load->view('system/status_project_single_vendor_pdf',$data,true);
				$dompdf = new Dompdf();
				$dompdf->set_option('isHtml5ParserEnabled', true);
				$dompdf->setPaper('A4','landscape');
				$dompdf->loadHtml($msg);
				$dompdf->render();
				$today_date = date('d-m-Y');
				$dompdf->stream("Orissa Renewable Energy Development Agency".$today_date, array("Attachment" => false));
			break;
			
			/**
			* Name : Subhashree Jena
			* Date :06-09-2019
			* Purpose : Print Project Venbdor Data
			*/
			case 'print_project_vendor':
				$expload_data = explode("#",urldecode($this->uri->segment(3)));
				$supplier_code = $expload_data[0];
				$scheme_id 	  = $expload_data[1];
				$data['vendor_list'] = $this->dashboard_model->get(array('supplier_code'=>$supplier_code,'scheme_id' =>$scheme_id),'get_vendor_project_list');
				$data['scheme_name'] = $this->scheme_model->get(array('pk_scheme_code' =>$scheme_id),'get_scheme_details');
				$data['vendor_name'] = $this->vendor_model->get(array('supplier_code' =>$supplier_code),'get_vendor_view_details');
				$data['scheme_id'] = $scheme_id;
				$data['supplier_code'] = $supplier_code;
				$msg = $this->load->view('system/project_vendor_pdf',$data,true);
				$dompdf = new Dompdf();
				$dompdf->set_option('isHtml5ParserEnabled', true);
				$dompdf->setPaper('A4','landscape');
				$dompdf->loadHtml($msg);
				$dompdf->render();
				$today_date = date('d-m-Y');
				$dompdf->stream("Orissa Renewable Energy Development Agency".$today_date, array("Attachment" => false));
			break;
			case 'scoring_performance':
				$data['scheduler_maintenance_score'] =$this->scoring_model->get(null,'get_scheduler_maintenance_score');
				$data['corrective_maintenance_score'] =$this->scoring_model->get(null,'get_corrective_maintenance_score');
				$msg = $this->load->view('system/scoring_performance_pdf',$data,true);
				$dompdf = new Dompdf();
				$dompdf->set_option('isHtml5ParserEnabled', true);
				$dompdf->loadHtml($msg);
				$dompdf->render();
				$today_date = date('d-m-Y');
				$dompdf->stream("Scoring Performance".$today_date, array("Attachment" => false));
			break;
		}
	}
}