<?php defined('BASEPATH') OR exit('No direct script access allowed');
	class Mis_controller extends CI_Controller  {
  		public function __construct(){
    		parent::__construct();
    		
    		# libraries
			$this->load->library('form_validation');
			$this->load->library('user_agent');
			
			# libraries
			$this->load->helper('custom_page');
			
			# models
			$this->load->model('getter_model');
			
			# views
			$data['title'] = $this->getter_model->get(null,'get_title');
			$this->load->view('templates/header',$data);
   		}
   		
		public function _remap($method){
			$class = $this->router->class;
			$role = $this->session->userdata('role');
			$check_user = $this->getter_model->get(null,'get_user_check');
			$role_action_auth = array( 
				'VENDOR'=>array('vendor_mis_report'),
				'ADEPT'=>array('department_mis_report'),
				'OCE'=>array('department_mis_report'),
				'ODR'=>array('department_mis_report'),
				'ODH'=>array('department_mis_report'),
				'ODA'=>array('department_mis_report'),
				'OTO'=>array('department_mis_report'),
				'CRCAGENT'=>array('department_mis_report'),
				'CRCADMIN'=>array('cm_receipt_redressal_status','sm_complaince_statement','cm_frequency_request_received','trend_cm_request',
				'trend_new_customer_registration','age_analysis_open_cases','supplier_analysis','cm_scheme_performance','cm_supplier_performance',
				'list_open_cases','district_abstract_open_case')
				
			);
			if( $role == false || !isset($role_action_auth[$role]) || !in_array($method, $role_action_auth[$role]) || !$check_user){
				redirect('logout');
			}else{
				if (in_array(strtolower($method), array_map('strtolower', get_class_methods($this)))){
					$uri = $this->uri->segment_array();
					unset($uri[1]);
					unset($uri[2]);
					call_user_func_array(array($this, $method), $uri);
				}else{
					self::page_not_found();
				}
			}
		}
		public function vendor_mis_report(){
			$sidebar['menu_item'] = 'MIS Report';
			$sidebar['menu_group'] = 'MIS Report';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('report/mis_report');
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		
		public function department_mis_report(){
			$sidebar['menu_item'] = 'MIS Report';
			$sidebar['menu_group'] = 'MIS Report';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('report/all_mis_report');
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		
		public function cm_receipt_redressal_status(){
			$sidebar['menu_item'] = 'SRR Of CM';
			$sidebar['menu_group'] = 'MIS Dashboard';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$data['all_admin_department'] = $this->getter_model->get(null,'get_all_admin_department');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('mis_report/cm_receipt_redressal_status',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function sm_complaince_statement(){
			$sidebar['menu_item'] = 'SM Complaince Statement';
			$sidebar['menu_group'] = 'MIS Dashboard';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('mis_report/sm_complaince_statement');
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		
		public function cm_frequency_request_received(){
			$sidebar['menu_item'] = 'CM FRR';
			$sidebar['menu_group'] = 'MIS Analysis';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('mis_report/cm_frequency_request_received');
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		
		public function trend_cm_request(){
			$sidebar['menu_item'] = 'Trend CM Request';
			$sidebar['menu_group'] = 'MIS Analysis';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('mis_report/trend_cm_request');
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function trend_new_customer_registration(){
			$sidebar['menu_item'] = 'Trend New Customer Reg.';
			$sidebar['menu_group'] = 'MIS Analysis';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('mis_report/trend_new_customer_registration');
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		
		public function age_analysis_open_cases(){
			$sidebar['menu_item'] = 'Age Analysis Open Cases';
			$sidebar['menu_group'] = 'MIS Analysis';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('mis_report/age_analysis_open_cases');
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		
		public function supplier_analysis(){
			$sidebar['menu_item'] = 'Vendor Analysis';
			$sidebar['menu_group'] = 'MIS Analysis';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('mis_report/supplier_analysis');
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function cm_scheme_performance(){
			$sidebar['menu_item'] = 'CM Project Performance';
			$sidebar['menu_group'] = 'MIS Analysis';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			$data['scheme_details'] = $this->getter_model->get(null,'get_all_scheme_list');
			if($page_status!= 0) {
				$this->load->view('mis_report/cm_scheme_performance',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		
		public function cm_supplier_performance(){
			$sidebar['menu_item'] = 'CM Vendor Performance';
			$sidebar['menu_group'] = 'MIS Analysis';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			$data['supplier_list'] = $this->getter_model->get(null,'get_supplier_list');
			if($page_status!= 0) {
				$this->load->view('mis_report/cm_supplier_performance',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function list_open_cases(){
			$sidebar['menu_item'] = 'Open Case List';
			$sidebar['menu_group'] = 'MIS Annexure';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			$data['all_admin_department'] = $this->getter_model->get(null,'get_all_admin_department');
			if($page_status!= 0) {
				$this->load->view('mis_report/list_open_cases',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		
		public function district_abstract_open_case(){
			$sidebar['menu_item'] = 'District Abstract Open Cases';
			$sidebar['menu_group'] = 'MIS Annexure';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			$data['district'] = $this->getter_model->get(array('state_code'=>21),'get_dist_name');
			if($page_status!= 0) {
				$this->load->view('mis_report/district_abstract_open_case',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
	}