<?php defined('BASEPATH') OR exit('No direct script access allowed');
include APPPATH . 'third_party'.DIRECTORY_SEPARATOR.'dompdf'.DIRECTORY_SEPARATOR.'vendor'.DIRECTORY_SEPARATOR.'autoload.php';
use Dompdf\Dompdf;

class System_controller extends CI_Controller
{
	public function __construct() 
	{
		parent::__construct();
		
		date_default_timezone_set('Asia/Kolkata');
		
		# libraries
		$this->load->library('form_validation');
		$this->load->library('user_agent');
		
		# models
		 	$this->load->model('dashboard_model');
	}	


	/*
	*	purpose : to check whether the method is correct or not
	*/
	public function _remap($method)
	{
		$class 	= $this->router->class;
		$role = $this->session->userdata('role');

		$role_action_auth = array(
			'ADMIN'=>array('index', 'op_print'),
			'CRCADMIN'=>array('index', 'op_print'),
			'USER'=>array('index', 'op_print'),
			'ADO'=>array('index', 'op_print'),
			'DA'=>array('index', 'op_print'),
			'SI'=>array('index', 'op_print'),
			'DDA'=>array('index', 'op_print'),
			'JDA'=>array('index', 'op_print'),
			'VENDOR'=>array('index', 'op_print'),
			'TECHNICIAN'=>array('index', 'op_print')
		);

		if( $role == false || !isset($role_action_auth[$role]) || !in_array($method, $role_action_auth[$role]) )
		{
			self::page_not_found();
		}
		else
		{
			if (in_array(strtolower($method), array_map('strtolower', get_class_methods($this))))
			{
				$uri = $this->uri->segment_array();
				unset($uri[1]);
				unset($uri[2]);
				call_user_func_array(array($this, $method), $uri);
			}
			else
			{
				self::page_not_found();
			}
		}
	}

	/*
	*	purpose : Handle page not found
	*/
	public function page_not_found(){
		$this->load->view('templates/404.php');
		$this->load->view('templates/footer');
	}
	
	
	
	public function op_print(){
		$type = $this->uri->segment(2);
		$data = array();
		$view = '';
		switch($type){
			case 'print_company_view_pdf':
				$data['scheme_list'] = $this->dashboard_model->get(null,'get_scheme_list');
				$data['get_transactioncount'] = $this->dashboard_model->get(null,'get_transactioncount');
				$data['get_open_cases'] = $this->dashboard_model->get(null,'get_open_cases');
				$data['get_cases'] = $this->dashboard_model->get(null,'get_cases');
				$data['no_of_days_open'] = $this->dashboard_model->get(null,'no_of_days_open');
				$data['no_of_days_close'] = $this->dashboard_model->get(null,'no_of_days_close');
				$data['get_close_cases'] = $this->dashboard_model->get(array('ticket_status'=>'CLOSE'),'get_ticket_cases');
				$data['get_suspend_cases'] = $this->dashboard_model->get(array('ticket_status'=>'SUSPEND'),'get_ticket_cases');
				$msg = $this->load->view('system/company_view_pdf',$data,true);
				$dompdf = new Dompdf();
				$dompdf->set_option('isHtml5ParserEnabled', true);
				$dompdf->loadHtml($msg);
				$dompdf->render();
				$today_date = date('d-m-Y');
				$dompdf->stream("Orissa Renewable Energy Development Agency".$today_date, array("Attachment" => false));
			break;
			case 'print_total_scheme_view_pdf':
				$data['scheme_list'] = $this->dashboard_model->get(null,'get_scheme_list');
				$data['get_transactioncount'] = $this->dashboard_model->get(null,'get_transactioncount');
				$data['get_open_cases'] = $this->dashboard_model->get(null,'get_open_cases');
				$data['get_cases'] = $this->dashboard_model->get(null,'get_cases');
				$data['no_of_days_open'] = $this->dashboard_model->get(null,'no_of_days_open');
				$data['no_of_days_close'] = $this->dashboard_model->get(null,'no_of_days_close');
				$data['get_close_cases'] = $this->dashboard_model->get(array('ticket_status'=>'CLOSE'),'get_ticket_cases');
				$data['get_suspend_cases'] = $this->dashboard_model->get(array('ticket_status'=>'SUSPEND'),'get_ticket_cases');
				$msg = $this->load->view('system/total_scheme_view_pdf',$data,true);
				$dompdf = new Dompdf();
				$dompdf->set_option('isHtml5ParserEnabled', true);
				$dompdf->loadHtml($msg);
				$dompdf->render();
				$today_date = date('d-m-Y');
				$dompdf->stream("Orissa Renewable Energy Development Agency".$today_date, array("Attachment" => false));
			break;
			case 'print_total_vendor_view_pdf':
				$decode_scheme_code = $this->uri->segment(3);
				$smth 			= preg_replace("/%u([0-9a-f]{3,4})/i","&#x\\1;",urldecode($decode_scheme_code)); 
				$smth_scheme_code 	= html_entity_decode($smth,null,'UTF-8');
				$scheme_code		= base64_decode($smth_scheme_code);
				$data['scheme_list'] = $this->dashboard_model->get(array('pk_scheme_code'=>$scheme_code),'get_scheme_details');
				$data['get_vendor'] = $this->dashboard_model->get(array('pk_scheme_code'=>$scheme_code),'get_supplier_count');
				$data['footer_vendor'] = $this->dashboard_model->get(array('id'=>$data['scheme_list']['id']),'get_installation_count');
				$data['footer_open'] = $this->dashboard_model->get(array('scheme_code'=>$data['scheme_list']['scheme_code']),'get_transaction_count_open');
				$data['open_avg'] = $this->dashboard_model->get(array('scheme_code'=>$data['scheme_list']['scheme_code']),'get_no_of_days_open_scheme');
				$data['close_avg'] = $this->dashboard_model->get(array('scheme_code'=>$data['scheme_list']['scheme_code']),'get_no_of_days_close_scheme');
				$data['footer_close'] = $this->dashboard_model->get(array('scheme_code'=>$data['scheme_list']['scheme_code'],'ticket_status'=>'CLOSE'),'get_ticket_status_scheme');
			
				$msg = $this->load->view('system/total_vendor_view_pdf',$data,true);
				$dompdf = new Dompdf();
				$dompdf->set_option('isHtml5ParserEnabled', true);
				$dompdf->loadHtml($msg);
				$dompdf->render();
				$today_date = date('d-m-Y');
				$dompdf->stream("Orissa Renewable Energy Development Agency".$today_date, array("Attachment" => false));
			break;
			case 'print_vendor_ticket_pdf':
				$decode_scheme_code = $this->uri->segment(3);
				$smth 			= preg_replace("/%u([0-9a-f]{3,4})/i","&#x\\1;",urldecode($decode_scheme_code)); 
				$smth_scheme_code 	= html_entity_decode($smth,null,'UTF-8');
				$scheme_code		= base64_decode($smth_scheme_code);
				$explode_value = explode("#",$scheme_code);
				$supplier_code = $explode_value[0];
				$scheme_code = $explode_value[1];
				$data['suplier_name'] = $explode_value[2];
				$data['get_ticket_data'] = $this->dashboard_model->get(array('supplier_code' =>$supplier_code ,'scheme_code' =>$scheme_code),'get_raise_ticket_cases');
			//	print("<pre>");print_r($data['get_ticket_data']);die();
				$msg = $this->load->view('system/vendor_ticket_view_pdf',$data,true);
				$dompdf = new Dompdf();
				$dompdf->set_option('isHtml5ParserEnabled', true);
				$dompdf->loadHtml($msg);
				$dompdf->render();
				$today_date = date('d-m-Y');
				$dompdf->stream("Orissa Renewable Energy Development Agency".$today_date, array("Attachment" => false));
			break;
			
		}
	}
}