<?php defined('BASEPATH') OR exit('No direct script access allowed');
	class Scheme_controller extends CI_Controller  {
  		public function __construct(){
    		parent::__construct();
    		
    		# libraries
			$this->load->library('form_validation');
			$this->load->library('user_agent');
			
			# libraries
			$this->load->helper('custom_page');
			
			# models
			$this->load->model('getter_model');
			$this->load->model('scheme_model');
			
			# views
			$data['title'] = $this->getter_model->get(null,'get_title');
			$this->load->view('templates/header',$data);
   		}
   		public function _remap($method){
   			$class 	= $this->router->class;
			$role = $this->session->userdata('role');
			$check_user = $this->getter_model->get(null,'get_user_check');
			if( !in_array($role, array('CRCADMIN','ODA')) || !$check_user){
				redirect('logout');
			}
			if (in_array(strtolower($method), array_map('strtolower', get_class_methods($this)))){
				$uri = $this->uri->segment_array();
				unset($uri[1]);
				unset($uri[2]);
				call_user_func_array(array($this, $method), $uri);
			}else{
				self::page_not_found();
			}
		}
		/**
		* Name : Subhashree Jena
		* Date : 30-04-2019
		* Purpose : Scheme
		* @return
		*/
		public function categorywise_scheme_list(){
			$sidebar['menu_item'] = 'Schemes';
			$sidebar['menu_group'] = 'Masters';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$data['scheme_type'] = $this->getter_model->get(array('gen_code_group'=>'SCHEME_TYPE'),'get_gencode_desc');
			$data['admin_department'] = $this->getter_model->get(null,'get_all_admin_department');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('scheme/scheme',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		/**
		* Name : Subhashree Jena
		* date: 30-04-2019
		* Purpose: Scheme Category
		* @return
		*/
		public function project_category(){
			$sidebar['menu_item'] = 'Project Category';
			$sidebar['menu_group'] = 'Masters';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('scheme/project_category');
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function scheme_list(){
			$decode_id      = $this->uri->segment(2);
		    $smth 			= preg_replace("/%u([0-9a-f]{3,4})/i","&#x\\1;",urldecode($decode_id)); 
		    $smth_id 	    = html_entity_decode($smth,null,'UTF-8');
		    $data['category_code']     = base64_decode($smth_id);
			$sidebar['menu_item'] = 'Schemes';
			$sidebar['menu_group'] = 'Masters';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('scheme/scheme_list',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function add_scheme(){
			$sidebar['menu_item'] = 'Schemes';
			$sidebar['menu_group'] = 'Masters';
			
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$data['scheme_category'] = $this->scheme_model->get(null,'get_scheme_category');
			$data['scheme_type'] = $this->getter_model->get(array('gen_code_group'=>'SCHEME_TYPE'),'get_gencode_desc');
			$data['admin_department'] = $this->getter_model->get(null,'get_all_admin_department');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('scheme/add_scheme',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function edit_scheme_data(){
			$decode_id      = $this->uri->segment(2);
		    $smth 			= preg_replace("/%u([0-9a-f]{3,4})/i","&#x\\1;",urldecode($decode_id)); 
		    $smth_id 	    = html_entity_decode($smth,null,'UTF-8');
		    $data['pk_scheme_code']     = base64_decode($smth_id);
		    
			$sidebar['menu_item'] = 'Schemes';
			$sidebar['menu_group'] = 'Masters';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$data['scheme_category'] = $this->scheme_model->get(null,'get_scheme_category');
			$data['scheme_type'] = $this->getter_model->get(array('gen_code_group'=>'SCHEME_TYPE'),'get_gencode_desc');
			$data['admin_department'] = $this->getter_model->get(null,'get_all_admin_department');
			$data['installation_class'] = $this->scheme_model->get(null,'get_installation_class');
			//print_r($data['installation_class']);
			$data['scheme_header'] = $this->scheme_model->get(array('pk_scheme_code'=>$data['pk_scheme_code']),'get_scheme_details');
			$data['get_installation'] = $this->scheme_model->get(array('scheme_header_id' => $data['pk_scheme_code']),'get_scheme_installation');
			
			//print_r($data['get_installation']);
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('scheme/edit_scheme',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
			
		}
	}