<?php defined('BASEPATH') OR exit('No direct script access allowed');
	class Schedule_controller extends CI_Controller  {
  		public function __construct(){
    		parent::__construct();
    		
    		# libraries
			$this->load->library('form_validation');
			$this->load->library('user_agent');
			
			# libraries
			$this->load->helper('custom_page');
			
			# models
			$this->load->model('getter_model');
			$this->load->model('crc_model');
			
			# views
			$data['title'] = $this->getter_model->get(null,'get_title');
			$this->load->view('templates/header',$data);
   		}
   		public function _remap($method){
			$class = $this->router->class;
			$role = $this->session->userdata('role');
			$check_user = $this->getter_model->get(null,'get_user_check');

			$role_action_auth = array( 
				'CRCADMIN'=>array('generated_ticket', 'resolve_ticket','rejected_closed'),
				'VENDOR'=>array('generated_ticket', 'resolve_ticket','rejected_closed'),
				'OCE'=>array('generated_ticket', 'resolve_ticket','rejected_closed'),
				'ODR'=>array('generated_ticket', 'resolve_ticket','rejected_closed'),
				'ODH'=>array('generated_ticket', 'resolve_ticket','rejected_closed'),
				'ODA'=>array('generated_ticket', 'resolve_ticket','rejected_closed'),
				'CRCAGENT'=>array('generated_ticket','resolve_ticket','rejected_closed'),
				'TECHNICIAN'=>array('generated_ticket','resolve_ticket','resolution_form')
			);

			if( $role == false || !isset($role_action_auth[$role]) || !in_array($method, $role_action_auth[$role]) || !$check_user){
				redirect('logout');
			}else{
				if (in_array(strtolower($method), array_map('strtolower', get_class_methods($this)))){
					$uri = $this->uri->segment_array();
					unset($uri[1]);
					unset($uri[2]);
					call_user_func_array(array($this, $method), $uri);
				}else{
					self::page_not_found();
				}
			}
		}
		public function generated_ticket(){
			$role = $this->session->userdata('role');
			$sidebar['menu_item'] 	= 'Generated Ticket';
			$sidebar['menu_group'] 	= 'Schedule Maintenance';
			$data['ticket_list'] 	= $this->getter_model->get(array('gen_code_group'=>'TICKET_TYPE'),'get_gencode_desc');
			if($role=='VENDOR'){
				$data['all_scheme_list']  = $this->getter_model->get(null,'get_scheme');
			}else{
				$data['all_scheme_list']  = $this->getter_model->get(null,'get_all_scheme_list');
			}
			$data['vendor']  	= $this->getter_model->get(null,'get_vendor_map_list');
			$data['all_tkt_type']  	= $this->getter_model->get(null,'get_all_ticket_type');
			$data['scheme_details'] = $this->getter_model->get(null,'get_all_scheme_list');
			$data['vendor_details'] = $this->getter_model->get(null,'get_supplier_list');
			$sidebar['sidebar'] 	= $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('schedule/generated_ticket',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function resolve_ticket(){
			$sidebar['menu_item'] = 'Resolve Ticket';
			$sidebar['menu_group'] = 'Schedule Maintenance';
			$data['scheme_details'] = $this->getter_model->get(null,'get_all_scheme_list');
			$data['vendor_details'] = $this->getter_model->get(null,'get_supplier_list');
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('schedule/resolve_ticket',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function rejected_closed(){
			$sidebar['menu_item'] = 'Rejected/Closed';
			$sidebar['menu_group'] = 'Schedule Maintenance';
			$data['scheme_details'] = $this->getter_model->get(null,'get_all_scheme_list');
			$data['vendor_details'] = $this->getter_model->get(null,'get_supplier_list');
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('schedule/rejected_closed',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function resolution_form(){
			$decode_ticket = $this->uri->segment(2);
			$tickets_smth = preg_replace("/%u([0-9a-f]{3,4})/i","&#x\\1;",urldecode($decode_ticket)); 
			$smth_ticket = html_entity_decode($tickets_smth,null,'UTF-8');
			$data['ticket_id']= base64_decode($smth_ticket);
			$role = $this->session->userdata('role');
			$sidebar['menu_item'] = 'Generated Ticket';
			$sidebar['menu_group'] = 'Schedule Maintenance';
			$data['all_component'] = $this->getter_model->get(array('ticket_id'=>$data['ticket_id']),'get_ticket_component');
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('schedule/resolution_form',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
	}