<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	class Mobile_api extends CI_Controller {
		public function __construct(){
			parent::__construct();
			header('Access-Control-Allow-Origin: *');
			//header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");
			header('Access-Control-Allow-Origin: ' . $_SERVER['HTTP_ORIGIN']);
	        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method,param");
	        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
	        //header('Access-Control-Allow-Credentials: true');
			# helpers
			$this->load->helper(array('form'));
			$this->load->helper('text');
			# library
			$this->load->library('form_validation');
			#models
			$this->load->model('api_model');
			
		}
	
		/*
		*	purpose : if request is not an ajax request then show error
		*/
		public function _remap($method){
			self::$method();		
		}
		
		/**
		*	purpose : get extension 
		*/
		private function getExtension($pFileName = null) {
			 $i = strrpos($pFileName,".");
			 if( !$i ) {
				return false;
			 }			 
			 $nameLength = strlen($pFileName) - $i;
			 return substr($pFileName,$i+1,$nameLength);
		}

		/**
		*	purpose : Generate unique id
		*/
		private function get_unique_id(){
			return $id = md5(strtotime(date('Y-m-d H:i:s'))).uniqid();
		}
		
		/* 
			purpose : The below function is used for technician login
			Created On  : 20-05-2019
			Created By : Ashutosh Mishra
		*/
		
		public function operation_tech_login(){
	        $data = $this->input->raw_input_stream;
	        $data = json_decode($data, true);
			$fetched_data = $this->api_model->technician($data,'Technician_login');	
			$this->output
	            ->set_status_header(200)
	            ->set_content_type('application/json')
	            ->set_output(json_encode($fetched_data));
			
		}
		
		/* 
			purpose : The below function is used for technician installation details
			Created On  : 20-05-2019
			Created By : Ashutosh Mishra
		*/
		
		public function operation_tech_installation_details(){
			$op_type = $this->uri->segment(3);
			
			switch($op_type){
				case 'get_installation_count': 
					$data = $this->input->raw_input_stream;
			        $data = json_decode($data, true);
					$fetched_installation_data = $this->api_model->technician($data,'Technician_installation_data');	
					$this->output
			            ->set_status_header(200)
			            ->set_content_type('application/json')
			            ->set_output(json_encode($fetched_installation_data));
				
				break;
				case 'get_installation_details':
					$data = $this->input->raw_input_stream;
			        $data = json_decode($data, true);
					$fetched_open_installation_data = $this->api_model->technician($data,'installation_details');	
					$this->output
			            ->set_status_header(200)
			            ->set_content_type('application/json')
			            ->set_output(json_encode($fetched_open_installation_data));
				break;
				
				
				case 'get_open_installation_details':
					$data = $this->input->raw_input_stream;
			        $data = json_decode($data, true);
					$fetched_open_installation_details_data = $this->api_model->technician($data,'open_installation_details_data');	
					$this->output
			            ->set_status_header(200)
			            ->set_content_type('application/json')
			            ->set_output(json_encode($fetched_open_installation_details_data));
				
				break;
				
				case 'get_component_details':
					$data = $this->input->raw_input_stream;
			        $data = json_decode($data, true);
					$fetched_component_details_data = $this->api_model->technician($data,'component_details_data');	
					$this->output
			            ->set_status_header(200)
			            ->set_content_type('application/json')
			            ->set_output(json_encode($fetched_component_details_data));
				
				break;
				
				case 'get_component_image_details':
					$data = $this->input->raw_input_stream;
			        $data = json_decode($data, true);
					$fetched_component_image_details_data = $this->api_model->technician($data,'component_details_image_data');	
					$this->output
			            ->set_status_header(200)
			            ->set_content_type('application/json')
			            ->set_output(json_encode($fetched_component_image_details_data));
				
				break;
				
				case 'submit_component_details':
					$data = $this->input->raw_input_stream;
			        $data = json_decode($data, true);
			       
					$fetched_component_details_insert_status_data = $this->api_model->technician($data,'submit_component_details_data');	
					$this->output
			            ->set_status_header(200)
			            ->set_content_type('application/json')
			            ->set_output(json_encode($fetched_component_details_insert_status_data));
				
				break;
				
				case 'submit_component_image_details':
					$data = $this->input->raw_input_stream;
			        $data = json_decode($data, true);
					$fetched_component_image_details_insert_status_data = $this->api_model->technician($data,'submit_component_image_details_data');	
					$this->output
			            ->set_status_header(200)
			            ->set_content_type('application/json')
			            ->set_output(json_encode($fetched_component_image_details_insert_status_data));
				
				break;
				
				
				case 'get_profile_details':
					$data = $this->input->raw_input_stream;
			        $data = json_decode($data, true);
					$fetched_profile_details_data = $this->api_model->technician($data,'get_profile_details_data');	
					$this->output
			            ->set_status_header(200)
			            ->set_content_type('application/json')
			            ->set_output(json_encode($fetched_profile_details_data));
					
				break;
				
				case 'submit_profile_data':
					$data = $this->input->raw_input_stream;
			        $data = json_decode($data, true);
					$submitted_profile_details_data = $this->api_model->technician($data,'update_profile_details');	
					$this->output
			            ->set_status_header(200)
			            ->set_content_type('application/json')
			            ->set_output(json_encode($submitted_profile_details_data));
				
				break;
				
				
				
				
				default :
            	return array('status' => FALSE, 'msg' =>'Unable to load.Contact Support');
				
			}
			
		}
		
		/* 
			purpose : The below function is used for technician installation details
			Created On  : 20-05-2019
			Created By : Ashutosh Mishra
		*/
		
		public function operation_tech_ticket_details(){
			$op_type = $this->uri->segment(3);
			
			switch($op_type){
				case 'get_ticket_count_data': 
					$data = $this->input->raw_input_stream;
			        $data = json_decode($data, true);
					$fetched_ticket_count_data = $this->api_model->technician($data,'get_total_ticket_count_data');	
					$this->output
			            ->set_status_header(200)
			            ->set_content_type('application/json')
			            ->set_output(json_encode($fetched_ticket_count_data));
				
				break;
				case 'get_scheduled_ticket': 
					$data = $this->input->raw_input_stream;
			        $data = json_decode($data, true);
					$fetched_scheduled_ticket_data = $this->api_model->technician($data,'Technician_scheduled_ticket_data');	
					$this->output
			            ->set_status_header(200)
			            ->set_content_type('application/json')
			            ->set_output(json_encode($fetched_scheduled_ticket_data));
				
				break;
				
				case 'get_scheduled_ticket_details': 
					$data = $this->input->raw_input_stream;
			        $data = json_decode($data, true);
					$fetched_scheduled_ticket_details_data = $this->api_model->technician($data,'Technician_scheduled_ticket_details_data');	
					$this->output
			            ->set_status_header(200)
			            ->set_content_type('application/json')
			            ->set_output(json_encode($fetched_scheduled_ticket_details_data));
				
				break;
				
				case 'get_corrective_ticket_details': 
					$data = $this->input->raw_input_stream;
			        $data = json_decode($data, true);
					$fetched_corrective_ticket_details_data = $this->api_model->technician($data,'Technician_corrective_ticket_details_data');	
					$this->output
			            ->set_status_header(200)
			            ->set_content_type('application/json')
			            ->set_output(json_encode($fetched_corrective_ticket_details_data));
				
				break;
				
				
				
				case 'get_corrective_tickets':
					$data = $this->input->raw_input_stream;
			        $data = json_decode($data, true);
					$fetched_corrective_ticket_data = $this->api_model->technician($data,'Technician_corrective_ticket_data');	
					$this->output
			            ->set_status_header(200)
			            ->set_content_type('application/json')
			            ->set_output(json_encode($fetched_corrective_ticket_data));
				break;
				
				case 'submit_scheduled_ticket_feedback':
					$data = $this->input->raw_input_stream;
			        $data = json_decode($data, true);
			        //print_r($data);die();
					$fetched_scheduled_ticket_feedback_submit_data = $this->api_model->technician($data,'submit_scheduled_ticket_feedback_details');	
					$this->output
			            ->set_status_header(200)
			            ->set_content_type('application/json')
			            ->set_output(json_encode($fetched_scheduled_ticket_feedback_submit_data));
				
				break;
				
				case 'submit_corrective_ticket_feedback':
					$data = $this->input->raw_input_stream;
			        $data = json_decode($data, true);
					$fetched_corrective_ticket_feedback_submit_data = $this->api_model->technician($data,'submit_corrective_ticket_feedback_details');	
					$this->output
			            ->set_status_header(200)
			            ->set_content_type('application/json')
			            ->set_output(json_encode($fetched_corrective_ticket_feedback_submit_data));
					
				break;
				
				case 'get_question_mapped_to_scheduled_ticket':
					$data = $this->input->raw_input_stream;
			        $data = json_decode($data, true);
					$fetched_corrective_ticket_data = $this->api_model->technician($data,'get_questions_mapped_against_schedule_ticket');	
					$this->output
			            ->set_status_header(200)
			            ->set_content_type('application/json')
			            ->set_output(json_encode($fetched_corrective_ticket_data));
				
				break;
				
				default :
            	return array('status' => FALSE, 'msg' =>'Unable to load.Contact Support');
				
			}
			
		}
		
		public function operation_sync_details(){
			$op_type = $this->uri->segment(3);
		
			switch($op_type){
		
				case 'fetch_data_from_server_to_local':
					$data = $this->input->raw_input_stream;
			        $data = json_decode($data, true);
					$fetched_get_master_data_from_server = $this->api_model->syncData($data,'get_master_data_from_server');	
					$this->output
			            ->set_status_header(200)
			            ->set_content_type('application/json')
			            ->set_output(json_encode($fetched_get_master_data_from_server));
				
				break;
				
				case 'upload_images_from_local_to_server':
					//echo "upload_images_from_local_to_server";
					$data = $this->input->raw_input_stream;
					//print_r($data);die();
			        $data = json_decode($data, true);
					$fetched_uploaded_image_status_data = $this->api_model->syncData($data,'upload_images_from_mobile');	
					$this->output
			            ->set_status_header(200)
			            ->set_content_type('application/json')
			            ->set_output(json_encode($fetched_uploaded_image_status_data));
				
				break;
			
				case 'upload_data_from_local_to_server':
					$data = $this->input->raw_input_stream;
			        $data = json_decode($data, true);
					$fetched_uploaded_data_status_data = $this->api_model->syncData($data,'upload_data_from_mobile');	
					$this->output
			            ->set_status_header(200)
			            ->set_content_type('application/json')
			            ->set_output(json_encode($fetched_uploaded_data_status_data));
				
				break;
				
				case 'upload_customer_images_from_local_to_server':
					
					$data = $this->input->raw_input_stream;
			        $data = json_decode($data, true);
					$fetched_uploaded_customer_data_status_data = $this->api_model->syncData($data,'upload_customer_photo');	
					$this->output
			            ->set_status_header(200)
			            ->set_content_type('application/json')
			            ->set_output(json_encode($fetched_uploaded_customer_data_status_data));
				
				break;
				
				case 'upload_scheduled_ticket_evidence_images_from_local_to_server':
					
					$data = $this->input->raw_input_stream;
			        $data = json_decode($data, true);
					$fetched_uploaded_evidence_data_status_data = $this->api_model->syncData($data,'upload_scheduled_ticket_evidence_photo');	
					$this->output
			            ->set_status_header(200)
			            ->set_content_type('application/json')
			            ->set_output(json_encode($fetched_uploaded_evidence_data_status_data));
				
				break;
				
				case 'upload_corrective_ticket_evidence_images_from_local_to_server':
					
					$data = $this->input->raw_input_stream;
			        $data = json_decode($data, true);
					$fetched_uploaded_evidence_data_status_data = $this->api_model->syncData($data,'upload_corrective_ticket_evidence_photo');	
					$this->output
			            ->set_status_header(200)
			            ->set_content_type('application/json')
			            ->set_output(json_encode($fetched_uploaded_evidence_data_status_data));
				
				break;
			}
			
			
		}
		
		
	}
	
	
	