<?php
	Class Export_controller extends CI_Controller{
    	public function __construct() {
            parent::__construct();
            # helpers
            $this->load->helper(array('form'));
            # libraries		
            $this->load->library('user_agent');
            $this->role = $this->session->userdata('role');
            # models
            $this->load->model('transaction_model');
            $this->load->model('getter_model');
    	}
    
	    public function _remap($method){
			$class = $this->router->class;
			$role = $this->session->userdata('role');
			$check_user = $this->getter_model->get(null,'get_user_check');
			$role_action_auth = array( 
				'CRCADMIN'=>array('installations_data')
			);
			if( $role == false || !isset($role_action_auth[$role]) || !in_array($method, $role_action_auth[$role]) || !$check_user){
				redirect('logout');
			}else{
				if (in_array(strtolower($method), array_map('strtolower', get_class_methods($this)))){
					$uri = $this->uri->segment_array();
					unset($uri[1]);
					unset($uri[2]);
					call_user_func_array(array($this, $method), $uri);
				}else{
					self::page_not_found();
				}
			}
		}
    
    
	    public function installations_data(){
	    	$encode_data 	= $this->uri->segment(2);
			$smth 			= preg_replace("/%u([0-9a-f]{3,4})/i","&#x\\1;",urldecode($encode_data)); 
			$smth_code 		= html_entity_decode($smth,null,'UTF-8');
			$decode_data	= base64_decode($smth_code);
			$explode_value 	= explode("#",$decode_data);
	        
	        $scheme_id 		= $explode_value[0];
			$vendor_id 		= $explode_value[1];
			$install_id     = $explode_value[2];
			$district_code	= $explode_value[3];
			$village_code   = $explode_value[4];
	        
	        require(APPPATH. 'third_party/PHPExcel-1.8/Classes/PHPExcel.php');//change if necessary
	        
	        $data['all_installations_data'] = $this->transaction_model->get(array('cmb_scheme'=>$scheme_id,'cmb_vendor'=>$vendor_id,'cmb_installType'=>$install_id,'cmb_district'=>$district_code,'cmb_village'=>$village_code,'view_install' => ''), 'get_export_transaction_details');                                      
	       
	       	$objPHPExcel = new PHPExcel();
            $objPHPExcel->getProperties()->setCreator("");
            $objPHPExcel->getProperties()->setLastModifiedBy("");
            $objPHPExcel->getProperties()->setTitle("");
            $objPHPExcel->getProperties()->setSubject("");
            $objPHPExcel->getProperties()->setDescription("");
            $objPHPExcel->getActiveSheet()->getStyle('A1:AG1')->getFont()->setBold(true)->setSize(13)->getColor()->applyFromArray(array("rgb" =>'EE0E22'));//APLLY BOLD LETTER FONT,SIZE AND COLOR FOR first ROW
            $objPHPExcel->setActiveSheetIndex(0);
            
            $objPHPExcel->getActiveSheet()->setCellValue('A1','#');
            $objPHPExcel->getActiveSheet()->setCellValue('B1','Scheme');
            $objPHPExcel->getActiveSheet()->setCellValue('C1','Sanction Letter No');
            $objPHPExcel->getActiveSheet()->setCellValue('D1','Finance Source');
            $objPHPExcel->getActiveSheet()->setCellValue('E1','Vendor Name');
            $objPHPExcel->getActiveSheet()->setCellValue('F1','Installation Class');
            $objPHPExcel->getActiveSheet()->setCellValue('G1','Work Order/Purchase Order');
            $objPHPExcel->getActiveSheet()->setCellValue('H1','Date of Installation');
            $objPHPExcel->getActiveSheet()->setCellValue('I1','Country');
            $objPHPExcel->getActiveSheet()->setCellValue('J1','State');
            $objPHPExcel->getActiveSheet()->setCellValue('K1','District');
            $objPHPExcel->getActiveSheet()->setCellValue('L1','CD Block');
            $objPHPExcel->getActiveSheet()->setCellValue('M1','Gram Panchayat');
            $objPHPExcel->getActiveSheet()->setCellValue('N1','Revenue Village');
            $objPHPExcel->getActiveSheet()->setCellValue('O1','Area');
            $objPHPExcel->getActiveSheet()->setCellValue('P1','Landmark');
            $objPHPExcel->getActiveSheet()->setCellValue('Q1','Census Code');
            $objPHPExcel->getActiveSheet()->setCellValue('R1','GPS Code');
            $objPHPExcel->getActiveSheet()->setCellValue('S1','District Cluster');
            $objPHPExcel->getActiveSheet()->setCellValue('T1','Maintenance Cluster');
            $objPHPExcel->getActiveSheet()->setCellValue('U1','Scheduled Week');
            $objPHPExcel->getActiveSheet()->setCellValue('V1','Customer Name');
            $objPHPExcel->getActiveSheet()->setCellValue('W1','Name of Father/Spouse');
            $objPHPExcel->getActiveSheet()->setCellValue('X1','Caste/Category');
            $objPHPExcel->getActiveSheet()->setCellValue('Y1','Landline');
            $objPHPExcel->getActiveSheet()->setCellValue('Z1','Mobile1');
            $objPHPExcel->getActiveSheet()->setCellValue('AA1','Mobile2');
            $objPHPExcel->getActiveSheet()->setCellValue('AB1','Email');
            $objPHPExcel->getActiveSheet()->setCellValue('AC1','Gender');
            $objPHPExcel->getActiveSheet()->setCellValue('AD1','Aadhar Card No');
            $objPHPExcel->getActiveSheet()->setCellValue('AE1','Alternate Id No');
            $objPHPExcel->getActiveSheet()->setCellValue('AF1','ACS');
            $objPHPExcel->getActiveSheet()->setCellValue('AG1','Parent Customer');
            
            $row=1;
            $sl_no=1;
            
            foreach($data['all_installations_data'] as $key => $value){ 
                $objPHPExcel->getActiveSheet()->setCellValue('A'.$row,$sl_no);
                $objPHPExcel->getActiveSheet()->setCellValue('B'.$row,$value["scheme_name"]);
                $objPHPExcel->getActiveSheet()->setCellValue('C'.$row,$value["sanction_order_no"]);
                $objPHPExcel->getActiveSheet()->setCellValue('D'.$row,$value["finance_source"]);
                $objPHPExcel->getActiveSheet()->setCellValue('E'.$row,$value["supplier_name"]);
                $objPHPExcel->getActiveSheet()->setCellValue('F'.$row,$value["instal_cls_name"]);
                $objPHPExcel->getActiveSheet()->setCellValue('G'.$row,$value["work_order"]);
                $objPHPExcel->getActiveSheet()->setCellValue('H'.$row,$value["date_of_installation"]);
                $objPHPExcel->getActiveSheet()->setCellValue('I'.$row,$value["India"]);
                $objPHPExcel->getActiveSheet()->setCellValue('J'.$row,$value["state_name"]);
                $objPHPExcel->getActiveSheet()->setCellValue('K'.$row,$value["district_name"]);
                $objPHPExcel->getActiveSheet()->setCellValue('L'.$row,$value["block_name"]);
                $objPHPExcel->getActiveSheet()->setCellValue('M'.$row,$value["gp_name"]);
                $objPHPExcel->getActiveSheet()->setCellValue('N'.$row,$value["village_name"]);
                $objPHPExcel->getActiveSheet()->setCellValue('O'.$row,$value["habitation"]);
                $objPHPExcel->getActiveSheet()->setCellValue('P'.$row,$value["landmark"]);
                $objPHPExcel->getActiveSheet()->setCellValue('Q'.$row,$value["census_code"]);
                $objPHPExcel->getActiveSheet()->setCellValue('R'.$row,$value["tr_gps_code"]);
                $objPHPExcel->getActiveSheet()->setCellValue('S'.$row,$value["dc_val"]);
                $objPHPExcel->getActiveSheet()->setCellValue('T'.$row,$value["mc_val"]);
                $objPHPExcel->getActiveSheet()->setCellValue('U'.$row,$value["scheduled_week"]);
                $objPHPExcel->getActiveSheet()->setCellValue('V'.$row,$value["customer_name"]);
                $objPHPExcel->getActiveSheet()->setCellValue('W'.$row,$value["father_name"]);
                $objPHPExcel->getActiveSheet()->setCellValue('X'.$row,$value["cast_cat"]);
                $objPHPExcel->getActiveSheet()->setCellValue('Y'.$row,$value["phone1"]);
                $objPHPExcel->getActiveSheet()->setCellValue('Z'.$row,$value["mobile1"]);
                $objPHPExcel->getActiveSheet()->setCellValue('AA'.$row,$value["mobile2"]);
                $objPHPExcel->getActiveSheet()->setCellValue('AB'.$row,$value["cu_email"]);
                $objPHPExcel->getActiveSheet()->setCellValue('AC'.$row,$value["gender"]);
                $objPHPExcel->getActiveSheet()->setCellValue('AD'.$row,$value["aadhar_no"]);
                $objPHPExcel->getActiveSheet()->setCellValue('AE'.$row,$value["alternate_id"]);
                $objPHPExcel->getActiveSheet()->setCellValue('AF'.$row,$value["acs"]);
                $objPHPExcel->getActiveSheet()->setCellValue('AG'.$row,$value["parent_customer_name"]);
                

                $row++;
                $sl_no++;
            }

            $filename='Tasks-Exported-on-'.date("Y-m-d-H-i-s").'.xls';
            $objPHPExcel->getActiveSheet()->setTitle("Installations List");//EXCEL SHEET NAME
            // Redirect output to a client�s web browser (Excel5)
            //header('Content-Type: application/vnd.ms-excel');
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="Installations List.xls"');//EXCEL FILE NAME
            header('Cache-Control: max-age=0');

            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel,'Excel2007');
            $objWriter->save('php://output');
            exit;
	    }
	}        
        
        
        
        
      