	$(function(){
	 	getWeatherDetails();	
	});
	
	function getWeatherDetails(){
		var urls =base_url+"service/get_weather_data/get_weather_data";
		var dataTableWeatherView = $('#dataTableWeatherView').DataTable({
			"processing": true, //Feature control the processing indicator.
			"serverSide": true, //Feature control DataTables' server-side processing mode.
			"destroy":    true,
			"paging":     true,
			"info":       true,
			"autoWidth":  true,
			"scrollX":    true,
			"responsive": false,
			"searching":  true,
			"ajax":{
				"url": urls,
				"type": "POST",
				"data": function (data){
			    	data.csrf_weather_token = $('#csrf_weather_token').val();
			    }
			},
			
			//dom: 'Bfrtip',
	        buttons: [{
	        	text: '<i class="fa fa-lg fa-file-pdf-o" style="color:red">  pdf</i>',
                extend: 'pdfHtml5',
                className: 'pdf_button',
                orientation: 'portrait',
                title: 'Weather Report',
                exportOptions: {
                    columns: [ 0, 1, 2, 3, 4, 5, 6],
                },
                /*customize: function(doc) {
				    doc.defaultStyle.alignment = 'left';
				    doc.styles.tableHeader.alignment = 'left';
            	}*/
	        }],
			"sDom":"<'row'<'col-xs-1'B><'col-xs-4'i><'col-xs-3'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' >><'col-xs-6'p>>",
			"columns": [
				{"sName": "slno","sClass":"alignCenter","sWidth":"10%"},
				{"sName": "district_name","sClass":"alignCenter","sWidth":"15%"},
				{"sName": "block_name","sClass":"alignCenter","sWidth":"15%"},
				{"sName": "reading_date","sClass":"alignCenter","sWidth":"20%"},
				{"sName": "high_temp","sClass":"alignCenter","sWidth":"10%"},
				{"sName": "low_temp","sClass":"alignCenter","sWidth":"10%"},
				{"sName": "condition","sClass":"alignCenter","sWidth":"20%"},
			],
			"fnDrawCallback": function(oSettings, json){
		     	$('.tooltipTable').tooltipster({
			        theme: 'tooltipster-punk',
			      	animation: 'grow',
			        delay: 200, 
			        touchDevices: false,
			        trigger: 'hover'
		      	});          
		  	}
		});
	}
	
	$("#cmbDistrict").change(function(){
    	$.ajax({
			url: base_url+"service/get_block_weather",
			type:"POST",
			data:{op_type:'get_block_name',dist_code:$(this).val()},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res1 = JSON.parse(response); 
				for (var i = 0; i < res1.length; i++) {
					options = options + "<option value='"+res1[i].block_code+"'>"+res1[i].block_name+"</option>";
				}
				$('#cmbBlock').html("");
				$('#cmbBlock').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
 		});
	});
	$('#form_weather_update').bootstrapValidator({
	    message: 'This value is not valid',
		submitButtons: 'button[type="submit"]',
		submitHandler: function(validator, form, submitButton) {
			$('#btn_submit').attr('disabled','disabled');
			var formData = new FormData(document.getElementById("form_weather_update"));
			urls =base_url+"service/operation_weather_form";
			$.ajax({
				url : urls,
				method : 'POST',
				data:formData,
				cache: false,
		        contentType: false,
		        processData: false,
				success : function(response){
					try {
		                var obj = JSON.parse(response);
		                if (obj.status == false) {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                	toastr.error(obj.msg);
		                }else if(obj.status === 'validationerror'){
		                	$('#errorlog').html(obj.msg);
		                	$('#errorlog').show();
		                }else{
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
							$('#form_weather_update').data('bootstrapValidator').resetForm(true);//Reseting user form
		                	toastr.success(obj.msg);
		                	window.location.href = base_url+"add-weather-data";
		                }
		            } catch (e) {
		                sweetAlert("Sorry",'Unable to Save.Please Try Again !', "error");
		            }
				},error: function(err){
					toastr.error("unable to save");
				}
			});
        },
		fields: {
	        cmbDistrict: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        cmbBlock: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txtdate: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txthightemp: {							
	           validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txtlowtemp: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txtcondition: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        }
	    }
    });