	$(function(){
	 	getEnergyPerformance();	
	 	addEnergyPerformance();
	 	//get_ColumnChart_data();
	});
	
	function getEnergyPerformance(){
		var urls =base_url+"service/get_energy_performance_data/get_energy_performance_data";
		var dataTableEnergyView = $('#dataTableEnergyView').dataTable({
			"processing": true, //Feature control the processing indicator.
			"serverSide": true, //Feature control DataTables' server-side processing mode.
			"destroy":    true,
			"paging":     true,
			"info":       true,
			"autoWidth":  true,
			"scrollX":    true,
			"responsive": false,
			"searching":  true,
			"ajax":{
				"url": urls,
				"type": "POST",
				"data": function (data){
			    	data.csrf_energy_token = $('#csrf_energy_token').val();
			    }
			},
			
			//dom: 'Bfrtip',
	        buttons: [{
	        	text: '<i class="fa fa-lg fa-file-pdf-o" style="color:red">  pdf</i>',
                extend: 'pdfHtml5',
                className: 'pdf_button',
                orientation: 'portrait',
                title: 'Energy Performance Report',
                pageSize: 'LEGAL',
                exportOptions: {
                    columns: [ 0, 1, 2, 3, 4, 5 ],
                },
                customize: function(doc) {
				    doc.defaultStyle.alignment = 'left';
				    doc.styles.tableHeader.alignment = 'left';
            	}
	        }],
			"sDom":"<'row'<'col-md-1 btn_add_energy'><'col-md-2 btn_add_weather'><'col-xs-1'B><'col-xs-3'i><'col-xs-1'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' >><'col-xs-6'p>>",
			"columns": [
				{"sName": "slno","sClass":"alignCenter"},
				{"sName": "consumer_id","sClass":"alignCenter"},
				{"sName": "NAME","sClass":"alignCenter"},
				{"sName": "address","sClass":"alignCenter"},
				{"sName": "capacity","sClass":"alignCenter"},
				{"sName": "tr_status","sClass":"alignCenter"}
			],
			// to show tooltips in datatable
			"fnDrawCallback": function(oSettings, json){
		     	$('.tooltipTable').tooltipster({
			        theme: 'tooltipster-punk',
			      	animation: 'grow',
			        delay: 200, 
			        touchDevices: false,
			        trigger: 'hover'
		      	});          
		  	}
		});
		$("div.btn_add_energy").html('<button class="btn btn-info tooltipTable btn-circle" title="Add Energy Generation Data" onclick="btnAddEnergyForm()" ><i class="fa fa-plus" aria-hidden="true"></i>&nbsp;Energy</button>');
		$("div.btn_add_weather").html('<button class="btn btn-info tooltipTable btn-circle" title="Add Weather Data" onclick="btnAddWeatherForm()" ><i class="fa fa-plus" aria-hidden="true"></i>&nbsp;Weather </button>');
	}
	
	
	
	function addEnergyPerformance(){
		var urls =base_url+"service/get_add_energy_performance_data/get_add_energy_performance_data";
		var dataTableAddEnergyView = $('#dataTableAddEnergyView').dataTable({
			"processing": true, //Feature control the processing indicator.
			"serverSide": true, //Feature control DataTables' server-side processing mode.
			"destroy":    true,
			"paging":     true,
			"info":       true,
			"autoWidth":  true,
			"scrollX":    true,
			"responsive": false,
			"searching":  true,
			"ajax":{
				"url": urls,
				"type": "POST",
				"data": function (data){
			    	data.csrf_add_energy_token = $('#csrf_add_energy_token').val();
			    	data.inverter_type = $("#cmbType").val();
			    }
			},
			
			//dom: 'Bfrtip',
	        buttons: [{
	        	text: '<i class="fa fa-lg fa-file-pdf-o" style="color:red">  pdf</i>',
                extend: 'pdfHtml5',
                className: 'pdf_button',
                orientation: 'landscape',
                title: 'Register Cases',
                pageSize: 'LEGAL',
                exportOptions: {
                    columns: [ 0, 1, 2, 3],
                },
                customize: function(doc) {
				    doc.defaultStyle.alignment = 'left';
				    doc.styles.tableHeader.alignment = 'left';
            	}
	        }],
			"sDom":"<'row'<'col-xs-1'B><'col-xs-4'i><'col-xs-3'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' >><'col-xs-6'p>>",
			"columns": [
				{"sName": "slno","sClass":"alignCenter","sWidth":"20%"},
				{"sName": "consumer_id","sClass":"alignCenter","sWidth":"20%"},
				{"sName": "NAME","sClass":"alignCenter","sWidth":"20%"},
				{"sName": "address","sClass":"alignCenter","sWidth":"20%"},
				//{"sName": "button",data:null,"sClass" : "alignCenter","sDefaultContent":"<input type='text' class='form-control' id='txtenergy' name='txtenergy'>"},
				{"sName": "button","sClass" : "alignCenter","sWidth": "15%","mRender": function( data, type, full) {
					str="<input type='text' class='form-control' id='txtenergy"+full.sl_no+"' name='txtenergy"+full.sl_no+"' >";
					return str;
				}},
				{"sName": "button",data:null,"sClass" : "alignCenter","sDefaultContent":"<button type='button' id='btn_submit' class='btn btn-success btn-circle tooltipTable' onclick='btnEnergyUpdate(event)' title='Update'><i class='fa fa-external-link'></i></button>"}
			],
			"fnDrawCallback": function(oSettings, json){
		     	$('.tooltipTable').tooltipster({
			        theme: 'tooltipster-punk',
			      	animation: 'grow',
			        delay: 200, 
			        touchDevices: false,
			        trigger: 'hover'
		      	});          
		  	}
		});
	}
	
	function btnAddEnergyForm(){
		window.location.href = base_url+"add-energy-data";
	}
	
	function btnAddWeatherForm(){
		window.location.href = base_url+"add-weather-data";
	}
	
	$('#btn_search').click(function(){
		dataTableAddEnergyView = $('#dataTableAddEnergyView').DataTable();
		dataTableAddEnergyView.draw();
		dataTableAddEnergyView.clear();
	});
	
	dataTableEnergyreport = $('#dataTableEnergyreport').DataTable();
	
	/*$("#cmb_state").change(function() {
		$.ajax({
			url: base_url+"service/get_energy_dist",
			type:"POST",
			data:{op_type:'get_dist_name',state_code : $('#cmb_state').val()},
			success:function(response) {
				var options = "<option value=''>Select</option>";
				$('#cmb_cdblock').html(options);
				var res1 = JSON.parse(response);
				for (var i = 0; i < res1.length; i++) {
					options = options + "<option value='"+res1[i].district_code+"'>"+res1[i].district_name+"</option>";
				}
				$('#cmb_district').html("");
				
				$('#cmb_district').append(options);
			},error:function() {
				toastr.error('Unable to process please contact support');
			}
		});
	});*/
	$("#cmb_district").change(function() {
		$.ajax({
			url: base_url+"service/get_energy_block_dropdown",
			type:"POST",
			data:{op_type:'get_energy_block_name',dist_code:$(this).val()},
			success:function(response) {
				var options = "<option value=''>Select</option>";
				var res1 = JSON.parse(response);
				for (var i = 0; i < res1.length; i++) {
					options = options + "<option value='"+res1[i].block_code+"'>"+res1[i].block_name+"</option>";
				}
				$('#cmb_cdblock').html("");
				$('#cmb_cdblock').append(options);
			},error:function() {
				toastr.error('Unable to process please contact support');
			}
		});

	});
	$("#cmb_cdblock").change(function() {
		$.ajax({
			url: base_url+"service/get_energy_gp_dropdown",
			type:"POST",
			data:{op_type:'get_energy_gp_name',block_code:$(this).val()},
			success:function(response) {
				var options = "<option value=''>Select</option>";
				var res1 = JSON.parse(response);
				for (var i = 0; i < res1.length; i++) {
					options = options + "<option value='"+res1[i].pk_gp_code+"'>"+res1[i].gp_name+"</option>";
				}
				$('#cmb_grampanchayat').html("");
				$('#cmb_grampanchayat').append(options);
			},error:function() {
				toastr.error('Unable to process please contact support');
			}
		});
	});
	$("#cmb_grampanchayat").change(function() {
		$.ajax({
			url: base_url+"service/get_energy_village_dropdown",
			type:"POST",
			data:{op_type:'get_energy_village_dropdown',gp_code:$(this).val()},
			success:function(response) {
				var options = "<option value=''>Select</option>";
				var res1 = JSON.parse(response);
				for (var i = 0; i < res1.length; i++) {
					options = options + "<option value='"+res1[i].pk_village_code+"'>"+res1[i].village_name+"</option>";
				}
				$('#cmb_revenuevillage').html("");
				$('#cmb_revenuevillage').append(options);
			},error:function() {
				toastr.error('Unable to process please contact support');
			}
		});
	});
	
	$("#cmbType").change(function() {
		var type= $(this).val();
		if (type=='year') {
			document.getElementById("divDay").style.display="none";
			document.getElementById("divMonth").style.display="none";
			document.getElementById("divYear").style.display="block";
			$('#txtMonth').val('');
			$('#txtDay').val('');
		} else if (type=='month') {
			document.getElementById("divDay").style.display="none";
			document.getElementById("divMonth").style.display="block";
			document.getElementById("divYear").style.display="none";
			$('#txtYear').val('');
			$('#txtDay').val('');
		}else{
			document.getElementById("divDay").style.display="block";
			document.getElementById("divMonth").style.display="none";
			document.getElementById("divYear").style.display="none";
			$('#txtMonth').val('');
			$('#txtYear').val('');
		}
	});
	
	$("#cmbCustomerType").change(function() {
		var type= $(this).val();
		if (type=='year') {
			document.getElementById("divToDay").style.display="none";
			document.getElementById("divToMonth").style.display="none";
			document.getElementById("divToYear").style.display="block";
			$('#individualperformance').hide();
			$('#individualperformanceyear').show();
			$('#txttoMonth').val('');
			$('#txttoDay').val('');
		} else if (type=='month') {
			document.getElementById("divToDay").style.display="none";
			document.getElementById("divToMonth").style.display="block";
			document.getElementById("divToYear").style.display="none";
			$('#individualperformanceyear').hide();
			$('#individualperformance').show();
			$('#txttoYear').val('');
			$('#txttoDay').val('');
		} else {
			document.getElementById("divToDay").style.display="block";
			document.getElementById("divToMonth").style.display="none";
			document.getElementById("divToYear").style.display="none";
			$('#individualperformanceyear').hide();
			$('#individualperformance').show();
			$('#txttoMonth').val('');
			$('#txttoYear').val('');
		}
	});
	
	
	
	$('#btn_filter_graph').click(function() {
		var day = $('#txtDay').val();
		var month = $('#txtMonth').val();
		var year = $('#txtYear').val();
		get_ColumnChart_data(day,month,year);
	});
	
	
	
	$('#btn_search_energy_table').click(function(){
		document.getElementById("CustomerData").style.display="block";
		var district = $('#cmb_district').val();
		var block = $('#cmb_cdblock').val();
		var gp = $('#cmb_grampanchayat').val();
		var village = $('#cmb_revenuevillage').val();
		var day ="";
		var month ="";
		var year ="";
		var sl_no = 1;
		urls =base_url+"service/filter_energy_table";
		$.ajax({
				url : urls,
				method : 'POST',
				data:{district:district,block:block,gp:gp,village:village,op_type:"get_energy_report_table_data"},
				success : function(response)
				{
					try {
		                var obj = JSON.parse(response);
		                dataTableEnergyreport.draw();
		                dataTableEnergyreport.clear();
		                $today = '';
		                $fromday = '';
		                $tomonth = '';
		                $frommonth = '';
		                $toyear = '';
		                $fromyear = '';
						for (var i = 0; i < obj.length; i++) {
			                $('#dataTableEnergyreport').DataTable().row.add([
							    '<td>'+sl_no+'</td>', 
							    '<td><a onclick=\"redirectCustomerGraph(\''+obj[i].consumer_id+'\',$today,$tomonth,$toyear);\">'+obj[i].consumer_id+'</a></td>', 
							    '<td>'+obj[i].c_name+'</td>', 
							    '<td>'+obj[i].capacity+'</td>', 
							    '<td>'+obj[i].tr_status+'</td>', 
							    '<td>'+obj[i].current_day+'</td>', 
							    '<td>'+obj[i].month_data+'</td>', 
							    '<td>'+obj[i].year_data+'</td>' 
							]).draw();
							sl_no++;
						}
		            } catch (e) {
		                toastr.error("Unable to Fetch Data");
		            }
				},error: function(err){
					toastr.error("Something Went Wrong");
				}
			});
			get_ColumnChart_data(day,month,year);
	});
	
	$('#btn_filter_customergraph').click(function() {
		var today = $('#txttoDay').val();
		var fromday = $('#txtfromDay').val();
		var tomonth = $('#txttoMonth').val();
		var frommonth = $('#txtfromMonth').val();
		var toyear = $('#txttoYear').val();
		var fromyear = $('#txtfromYear').val();
		var consumer_id = $('#hid_customerid').val();

		redirectCustomerGraph(consumer_id,today,tomonth,toyear);
		redirectCustomerYearGraph(consumer_id,today,tomonth,toyear);
	});
	
	function redirectCustomerGraph(consumer_id, today,tomonth, toyear)
	{
		document.getElementById("IndividualCustomerData").style.display="block";
		$('#hid_customerid').val(consumer_id);
		customerdata(consumer_id);
		var urls =base_url+"service/get_IndividualColumnChart_data";
		$.ajax({
			"url": urls,
			"type": "POST",
			"data": {op_type:'get_data_individualcolumnchart',consumer_id:consumer_id,today:today,tomonth:tomonth,toyear:toyear},
			success: function(result) {
				var value = JSON.parse(result);
				var customerenergySeries = new Array();
				for (var e = 0; e < value.length; e++) {
					var date = value[e].dte;
					var customerenergydata =value[e].energy_generated;
					str1="["+"'"+date+"'"+","+customerenergydata+"]";
					customerenergySeries.push(str1);
				}
				
				drawcustomercolumnchart(customerenergySeries);
			},
			error: function(jqXHR, status, error) {
				swal('error');
			}
		});
		
	}
	
	function customerdata(consumer_id){
		var urls =base_url+"service/get_IndividualCustomer_data";
		$.ajax({
			"url": urls,
			"type": "POST",
			"data": {op_type:'get_IndividualCustomer_data',consumer_id:consumer_id},
			success: function(result) {
				var res = JSON.parse(result);
				//alert(res.consumer_id);
				$('#consumer_id').html('<h2 style="font-size:14px;"><b>'+res.customer_name+'</b></h2>');
				$('#installed_capacity').html(res.capacity);
				$('#plant_status').html(res.tr_status);
				$('#energy_today').html(res.current_day);
				$('#energy_week').html(res.this_week);
				$('#energy_month').html(res.this_month);
				$('#energy_lifetime').html(res.all_day);
				$('#location').html(res.location);
			},
			error: function(jqXHR, status, error) {
				swal('error');
			}
		});
	}
	
	function redirectCustomerYearGraph(consumer_id, today, tomonth, toyear)
	{
		$('#hid_customerid').val(consumer_id);

		var urls =base_url+"service/get_IndividualColumnChart_data";
		$.ajax({
			"url": urls,
			"type": "POST",
			"data": {op_type:'get_data_individualcolumnchart',consumer_id:consumer_id,today:today,tomonth:tomonth,toyear:toyear},
			success: function(result) {
				var value = JSON.parse(result);
				for (var e = 0; e < value.length; e++) {
					var year1 =value[e].YEAR1;
					var year2 =value[e].YEAR2;
					var year3 =value[e].YEAR3;
					
				}
				drawcustomeryearcolumnchart(year1,year2,year3);
			},
			error: function(jqXHR, status, error) {
				swal('error');
			}
		});
	}
	
	
	
	
	$("#btn_reset_energy_table").click(function(){
		
		dataTableEnergyreport.draw();
		dataTableEnergyreport.clear();
		$('#cmbType').val('');
	});
	
	$("#btn_reset").click(function(){
		dataTableAddEnergyView = $('#dataTableAddEnergyView').DataTable();
		dataTableAddEnergyView.draw();
		dataTableAddEnergyView.clear();
	});
	
	function btnEnergyUpdate(){
		var oTable = $('#dataTableAddEnergyView').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		var id = oTable.fnGetData(row)['id'];
		var slno = oTable.fnGetData(row)['sl_no'];
		var consumer_id = oTable.fnGetData(row)['consumer_id'];
		var updateenergy = oTable.$('#txtenergy'+slno+'').val();
		var date = $('#txt_date').val();
		urls =base_url+"service/operation_energy";
		var formData = {id:id,energy_generated:updateenergy,consumer_id:consumer_id,date:date,op_type:"Update_Energy"};
		$.ajax({
				url : urls,
				method : 'POST',
				data:formData,
				success : function(response)
				{
					try {
		                var obj = JSON.parse(response);
		                if (obj.status == true) {
	                		toastr.success(obj.msg);
	                		location.reload();
		                }else{
		                	toastr.error("Sorry",'Unable to Save.Please Try Again !', "error");
		                }
		            } catch (e) {
		                toastr.error("Sorry",'Unable to Save.Please Try Again !', "error");
		            }
				},error: function(err){
					toastr.error("unable to save");
				}
			});
	}
	
	////Energy Performance chart ////
	
	function get_ColumnChart_data(day,month,year)
	{	
		var selectday = day;
		var selectmonth = month;
		var selectyear = year;
		var village = $('#cmb_revenuevillage').val();
		var urls =base_url+"service/get_ColumnChart_data";
		$.ajax({
			"url": urls,
			"type": "POST",
			"data": {op_type:'get_data_columnchart',village:village,day:selectday,month:selectmonth,year:selectyear},
			success: function(result) {
				var value = JSON.parse(result);
				var energySeries = new Array();
				for (var e = 0; e < value.length; e++) {
					var name = value[e].c_name;
					var energydata =value[e].energy;
					str1="["+"'"+name+"'"+","+energydata+"]";
					energySeries.push(str1);
				}
				drawcolumnchart(energySeries);
			},
			error: function(jqXHR, status, error) {
				swal('error');
			}
		});
	}
	
	function drawcolumnchart(energySeries){
	Highcharts.chart('container', {
			chart: {
				type: 'column'
			},
			title: {
				text: 'Energy Performance'
			},
			
			credits: { enabled: false },
		exporting: { enabled: false },
			xAxis: {
				type: 'category',
				min: 0,
				max:10,

				labels: {
					rotation: -45,
					style: {
						fontSize: '13px',
						fontFamily: 'Verdana, sans-serif'
					}
				}
			},
			 scrollbar: {
				enabled: true
			},
			yAxis: {
				min: 0,
				title: {
					text: 'Energy Generated (kWH)'
				}
			},
			legend: {
				enabled: false
			},
			tooltip: {
				pointFormat: 'Energy Generated: <b>{point.y:.1f} kWH</b>'
			},
			 plotOptions:{
				series:{
					turboThreshold:100//set it to a larger threshold, it is by default to 1000
				}
			},
			series: [{
					name: energySeries,
					data:  Function("return [" + energySeries + "]")(),
					dataLabels: {
						enabled: true,
						rotation: -90,
						color: '#FFFFFF',
						align: 'right',
						format: '{point.y:.1f}', // one decimal
						y: 10, // 10 pixels down from the top
						style: {
							fontSize: '13px',
							fontFamily: 'Verdana, sans-serif'
						}
					}
				}]
		});
	}
	
	
	function drawcustomercolumnchart(customerenergySeries){
		Highcharts.chart('container_customer_reading', {
			chart: {
				type: 'column'
			},
			title: {
				text: 'Energy Performance'
			},
			credits: { enabled: false },
			exporting: { enabled: false },
			xAxis: {
				type: 'category',
				min: 0,
				max:10,

				labels: {
					rotation: -45,
					style: {
						fontSize: '13px',
						fontFamily: 'Verdana, sans-serif'
					}
				}
			},
			scrollbar: {
				enabled: true
			},
			yAxis: {
				min: 0,
				title: {
					text: 'Energy Generated (kWH)'
				}
			},
			legend: {
				enabled: false
			},
			tooltip: {
				pointFormat: 'Energy Generated: <b>{point.y:.1f} kWH</b>'
			},
			plotOptions:{
				series:{
					turboThreshold:100//set it to a larger threshold, it is by default to 1000
				}
			},
			series: [{
					name: customerenergySeries,
					data:  Function("return [" + customerenergySeries + "]")(),
					dataLabels: {
						enabled: true,
						rotation: -90,
						color: '#FFFFFF',
						align: 'right',
						format: '{point.y:.1f}', // one decimal
						y: 10, // 10 pixels down from the top
						style: {
							fontSize: '13px',
							fontFamily: 'Verdana, sans-serif'
						}
					}
				}]
		});
	}
	
	function drawcustomeryearcolumnchart(year1,year2,year3){
		Highcharts.chart('container_energy_year', {
			chart: {
				type: 'column'
			},
			title: {
				text: 'Energy Performance'
			},

			xAxis: {
				categories: [
					'Apr',
					'May',
					'Jun',
					'Jul',
					'Aug',
					'Sep',
					'Oct',
					'Nov',
					'Dec',
					'Jan',
					'Feb',
					'Mar'
				],
				crosshair: true
			},
			yAxis: {
				min: 0,
				title: {
					text: 'Energy Generated (kWH)'
				}
			},
			tooltip: {
				headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
				pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
				'<td style="padding:0"><b>{point.y:.1f} kWH</b></td></tr>',
				footerFormat: '</table>',
				shared: true,
				useHTML: true
			},
			plotOptions: {
				column: {
					pointPadding: 0.2,
					borderWidth: 0
				}
			},
			series: [{
					name: '2018',
					data: Function("return [" + year1 + "]")()

				}, {
					name: '2019',
					data: Function("return [" + year2 + "]")()

				}, {
					name: '2020',
					data: Function("return [" + year3 + "]")()
			}]
		});
	}
	
	