	$(function(){
	 	var urls =base_url+"service/get_closed_suspended/get_all_closed_suspended";
	 	jQuery.fn.DataTable.Api.register( 'buttons.exportData()', function ( options ) {
	        if ( this.context.length ) {
	        	var dataArr = [];
	            var jsonResult = $.ajax({
	                url: urls,
	                type:'POST',
	                data:{page:"ALL",csrf_closeSuspend_token : $('#csrf_closeSuspend_token').val(),cmb_vendor:$("#cmb_vendor").val(),cmb_scheme :$("#cmb_scheme").val(),cmb_ticket_status:$("#cmb_ticket_status").val()},
	                success: function (result) {
	                    res = jQuery.parseJSON(result);
	                    $.each(res.aaData,function(i,arr){
	                    	var objArr = [i+1,arr.ticket_id,arr.customer_name,arr.consumer_id,arr.district_name,arr.block_name,arr.gp_name,arr.village_name,arr.habitation,arr.landmark,arr.scheme_name,arr.supplier_name,arr.issue_date,arr.closed_date,arr.suspend_date,arr.days_to_close,arr.days_suspended,arr.ticket_status];
	                    	dataArr.push(objArr);
	                    });
	                },
	                async: false
	            });
	           return {body: dataArr, header: ['#','Ticket No','Consumer','Consumer Id','District Name','Block Name','Gp Name','Village Name','Habitation','Landmark','Scheme Name','Vendor Name','Issue Date','Close Date','Suspended Date','Days To Close','Days Suspended','Status']};
	           }
	    });
	 	var manage_request = $('#dataTableCloseSuspend').DataTable({
		 	"processing": true, //Feature control the processing indicator.
		    "serverSide": true, //Feature control DataTables' server-side processing mode.
		    "bDestroy": true,
		    "paging":   true,
		    "info":     true,
		    "autoWidth": false,
		    "responsive":true,
		   	"searching":true,
		   	"scrollY": 400,
		   	"scrollX": true,
		 	"bLengthChange": true,
		   	"sDom":"<'row'<'col-xs-2'B><'col-xs-4'i><'col-xs-2'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' >><'col-xs-6'p>>",
		 	
		 	//"dom": 'Bfrtip',
			"buttons": [
				{
					text: '<i class="fa fa-lg fa-file-excel-o" style="color:green">  Excel</i>',
					extend: 'excel',
					filename:'Closed Or Suspended Tickets ',
					header:true,
					title: 'Closed/Suspended Tickets',
					extension: '.xls'
				}
			],
			"ajax": {
			    "url": urls,
			    "type": "POST",
			    "data": function(data) {
			       	data.csrf_closeSuspend_token = $("#csrf_closeSuspend_token").val();
			       	data.cmb_vendor 			 = $("#cmb_vendor").val();
			       	data.cmb_scheme 			 = $("#cmb_scheme").val();
			       	data.cmb_ticket_status 		 = $("#cmb_ticket_status").val();
			       	data.page 					 = '';
			    }
			},
			"columns": [
				{"sName": "sl_no","sWidth": "5%","sClass":"alignCenter"},
				{"sName": "ticket_id","sWidth": "20%","sClass":"alignCenter"},
				{"sName": "customer_name","sWidth": "30%","sClass":"alignLeft"},
				{"sName": "customer_address","sWidth": "30%","sClass":"alignLeft"},
				{"sName": "close_date","sWidth": "30%","sClass":"alignCenter"},
				{"sName": "no_of_days_open","sWidth": "30%","sClass":"alignRight"},
				{"sName": "ticket_status","sWidth": "10%","sClass":"alignCenter"},
				{"sName": "button","sClass" : "alignCenter","sWidth": "15%","mRender": function( data,type,full){
					str = "<button type='button' class='btn btn-primary btn-circle tooltipTable' onclick='btnViewManageRequest(event)' title='Manage Request Action'><i class='fa fa-eye'></i></button>";
					return str;
					}
				}
				
			], 
			"fnDrawCallback": function(oSettings, json) {
			 	$('.tooltipTable').tooltipster({
			     	theme: 'tooltipster-punk',
			  		animation: 'grow',
			    	delay: 200, 
			     	touchDevices: false,
			     	trigger: 'hover'
				});          
			}	 
		});
	});
	/*
	Name: Siddhartha
	Modified Date: 29-08-19
	Purpose: Closed/Suspended Ticket view button
	*/
 	function btnViewManageRequest(event){
		var oTable = $('#dataTableCloseSuspend').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		var managerequest_id = oTable.fnGetData(row)['id'];
		var transaction_id 	 = oTable.fnGetData(row)['req_by'];
		var ticket_id 	 = oTable.fnGetData(row)['ticket_id'];
		//window.location.href = base_url+"edit-manage-request/"+encodeURIComponent(btoa(managerequest_id+'/'+transaction_id+'/'+ticket_id));
		window.open(base_url+"view-manage-request/"+encodeURIComponent(btoa(managerequest_id+'/'+transaction_id+'/'+ticket_id)), '_blank');
	}
	
	$('#btn_search').click(function(){
		manage_request = $('#dataTableCloseSuspend').DataTable();
		manage_request.draw();
		manage_request.clear();
	});
	$('#btn_reset').click(function(){
		$("#cmb_vendor").val('');
		$("#cmb_scheme").val('');
		$("#cmb_ticket_status").val('');
		manage_request = $('#dataTableCloseSuspend').DataTable();
		manage_request.draw();
		manage_request.clear();
	});