 	$(function(){
	 	getComponent();	
	});
 
 	function getComponent(){
		var urls =base_url+"service/get_component_data/get_all_component";
		jQuery.fn.DataTable.Api.register( 'buttons.exportData()', function ( options ) {
	        if ( this.context.length ) {
	        	var dataArr = [];
	            var jsonResult = $.ajax({
	                url: urls,
	                type:'POST',
	                data:{page:"ALL",csrf_component : $('#csrf_component').val()},
	                success: function (result) {
	                    res = jQuery.parseJSON(result);
	                    $.each(res.aaData,function(i,arr){
	                    	var objArr = [i+1,arr.component_name,arr.short_name,arr.description];
	                    	dataArr.push(objArr);
	                    });
	                },
	                async: false
	            });
	            return {body: dataArr, header: ['#','Component Name','Short Name','Description']};
	        }
	    });
		var component = $('#dataTableComponent').DataTable({
		 	"processing": true, //Feature control the processing indicator.
		    "serverSide": true, //Feature control DataTables' server-side processing mode.
		    "bDestroy": true,
		    "paging":   true,
		    "info":     true,
		    "autoWidth": false,
		    "responsive":true,
		   	"searching":true,
		   	"bLengthChange": true,
			"sDom":"<'row'<'col-md-1 btn_add'><'col-xs-1'B><'col-xs-4'i><'col-xs-2'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' >><'col-xs-6'p>>",
			 	
		 	//"dom": 'Bfrtip',
			"buttons": [
				{
					text: '<i class="fa fa-lg fa-file-excel-o" style="color:green">  Excel</i>',
					extend: 'excel',
					filename:'Component',
					header:true,
					title: 'Component',
					extension: '.xls'
				}
			],
			"ajax": {
			    "url": urls,
			    "type": "POST",
			    "data": function(data) {
			       	data.csrf_component = $("#csrf_component").val();
			       	data.page = '';
			    }
			},
			"columns": [
				{"sName": "sl_no","sWidth": "5%","sClass":"alignCenter"},
				{"sName": "component","sWidth": "20%","sClass":"alignLeft"},
				{"sName": "short_name","sWidth": "30%","sClass":"alignLeft"},
				{"sName": "description","sWidth": "30%","sClass":"alignLeft"},
				{"sName": "button",data:null,"sWidth": "20%","sClass" : "alignCenter","sDefaultContent":"<button type='button' class='btn btn-info  btn-circle tooltipTable' onclick='btnComponentView(event)' title='View Details'><i class='fa fa-eye'></i></button>\
					<button type='button' class='btn btn-primary btn-circle tooltipTable' onclick='btnComponentEdit(event)' title='Edit'><i class='fa fa-pencil'></i></button>"}
				
			], 
			"fnDrawCallback": function(oSettings, json) {
			 	$('.tooltipTable').tooltipster({
			     	theme: 'tooltipster-punk',
			  		animation: 'grow',
			    	delay: 200, 
			     	touchDevices: false,
			     	trigger: 'hover'
				});          
			}	  
		});
 		$("div.btn_add").html('<button type="button" class="btn btn-info tooltipTable btn-circle" title="Add"  onclick="btnModalOpen()" ><i class="fa fa-plus" aria-hidden="true"></i></button>');
	}
   
	function get_attributes_list(){
		$.ajax({
			url: base_url+"service/get_all_attributes",
			type:"POST",
			data:{op_type:'get_gencode_desc',gen_code_group:'ATTRIBUTE'},
			success:function(response){
				var options = "";
				var res1 = JSON.parse(response); 
				for (var i = 0; i < res1.length; i++) {
					options = options + "<option value='"+res1[i].gen_code+"' >"+res1[i].description+"</option>";
				}
				$('#cmb_attributes').html("");  
				$('#cmb_attributes').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
 		});
	}get_attributes_list();
	
	
	$('#form_add_component').bootstrapValidator({
		message: 'This value is not valid',
	    feedbackIcons: 
	    {
	        invalid: 'glyphicon glyphicon-remove',
	        validating: 'glyphicon glyphicon-refresh'
	    },
		submitButtons: 'button[type="submit"]',
		
		submitHandler: function(validator,form,submitButton){
			$("#btn_submit").html('<i class="fa fa-gear fa-spin"></i> Loading...');
			var formData = new FormData(document.getElementById("form_add_component"));
			urls =base_url+"service/operation_component";
			$.ajax({
				url : urls,
				method : 'POST',
				data:formData,
				cache: false,
		        contentType: false,
		        processData: false,
				success : function(response)
				{
					try {
		                var obj = JSON.parse(response);
		                if (obj.status == false) {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                	$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Submit");
		                   	toastr.warning(obj.msg);
		                }else if(obj.status === 'validationerror'){
		                	$('#errorlog').html(obj.msg);
		                	$('#errorlog').show();
		                	$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Submit");
		                }else{
		                	$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Submit");
							$('#form_add_component').data('bootstrapValidator').resetForm(true);//Reseting user form
							dataTableComponent = $('#dataTableComponent').DataTable();
							dataTableComponent.draw();
							dataTableComponent.clear();
							$('#operation_component_modal').modal('hide');
							toastr.success(obj.msg);
		                }
		            } catch (e) {
		                toastr.error("Sorry",'Unable to Save.Please Try Again !', "error");
		            }
				},error: function(err){
					toastr.error("unable to save");
				}
			});
		},
	    fields:
	    {
	        txtComponent: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txtCShortName: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        }
	    }	
	});
	
	function btnComponentView(event){
		var oTable = $('#dataTableComponent').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		var component_id = oTable.fnGetData(row)['id'];
		componentView(component_id);
	}
	function componentView(component_id){
		var urls =base_url+"service/view_component_details/"+component_id;
		$.ajax({
			url : urls,
			method : 'POST',
			cache: false,
	        contentType: false,
	        processData: false,
			success : function(response){
				try {
	                var obj = JSON.parse(response);
	                if(obj.status == true){
	                	$("#viewComponentDetails").html("");
						$("#viewComponentDetails").append(obj.data);
						$("#table_component").html("");
						$("#table_component").append(obj.data1);
	                	$("#view_component").modal({backdrop: 'static',keyboard: false});
					}else{
						toastr.warning(obj.data);
					}
	            } catch (e) {
	                toastr.error("Sorry",'Unable to Save.Please Try Again !', "error");
	            }
			},error: function(err){
				toastr.error("unable to save");
			}
		});
	}
	function btnModalOpen(){
		$('#txtCDescription').val('');
		$('#cmb_attributes').val('').trigger("change");
		$("#span_comp")[0].innerHTML = "Add Component";
		$("#form_add_component input[name='op_type']").val("ADD_COMPONENT");
		$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Submit");
		$('#form_add_component').data('bootstrapValidator').resetForm(true);//Reseting user form
		$("#operation_component_modal").modal({backdrop: 'static',keyboard: false});
	}
	
	function form_reset(){
		$('#txtCDescription').val('');
		$('#cmb_attributes').val('').trigger("change");
		$('#form_add_component').data('bootstrapValidator').resetForm(true); //to reset the form
		$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Submit");
		$("#span_comp")[0].innerHTML = "Add Component";
		$("#form_add_component input[name='op_type']").val("ADD_COMPONENT");
	}
	
	function btnComponentEdit(event){
		$('#form_add_component').data('bootstrapValidator').resetForm(true);
		$("#span_comp")[0].innerHTML = "Edit Component";
		$("#form_add_component input[name='op_type']").val("UPDATE_COMPONENT");
		$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Update");
		
		var oTable = $('#dataTableComponent').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		$('#hid_component_id').val(oTable.fnGetData(row)['id']);
		$("#txtComponent").val(oTable.fnGetData(row)['component_name']);
		$("#txtCDescription").val(oTable.fnGetData(row)['description']);
		$("#txtCShortName").val(oTable.fnGetData(row)['short_name']);
		getAttributeList(oTable.fnGetData(row)['id']);
		$("#operation_component_modal").modal({backdrop: 'static',keyboard: false});
	}
	function getAttributeList(component_id){
		$.ajax({
			url: base_url+"service/getAttributeList",
			type:"POST",
			data:{op_type:'get_attribute',components_id:component_id},
			success:function(response){
				var res_data = JSON.parse(response); 
				var selected_value_array = new Array();
				for(var i=0;i<res_data.length;i++){
					selected_value_array.push(res_data[i].attribute);
				}
				$("#cmb_attributes").val(selected_value_array);
				$("#cmb_attributes").select2(selected_value_array);
				
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
 		});
	}