<!DOCTYPE html>
<html class="no-js">
    <head>
        <title>Orissa Renewable Energy Development Agency</title>
		<meta charset="utf-8">
		<meta name = "format-detection" content = "telephone=no" />
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">      
        
	</head>
	
	<style>
		@page { margin: 5px;}
		body { padding:0px; margin-top:10%;}
		
		
		.content img {display: inline;}
		#root{padding:15px;}
		
		.text-center{text-align:center;}
		.text-right{text-align:right;}
		.text-left{text-align:left;}
		.background-image{
			background: url(<?php echo base_url();?>public/upload/logo/oreda_logo.png) no-repeat center center;
		}
		
		h1, h2, h3{color: #000000;background: none;text-decoration: none;font-weight: bold; margin-bottom:10px;}

		h1 { font-size: 13pt; }
		h2 { font-size: 11pt; margin-top: 1em; }
		h3 { font-size: 9pt; margin-top: 1em; }

		.content {line-height: 12pt;margin-bottom: 1em;	overflow: auto; width:100%;}
		
		hr {height: 0;border-top:solid 1px #ccc; border-bottom:0; border-left:0;  border-right:0;margin:10px 0;}

		ol, ul {margin-left: 15pt}

		table{width:100%;}
		td, th{padding:0 5px;}
		table.dashedBorder, .dashedBorder th, .dashedBorder td{border:solid 1px #999; border-collapse: collapse; padding:3px 10px; margin-bottom:20px;}
		strong{font-size:12pt;}
		address{font-size:9pt; line-height:10pt;text-align: justify;padding-top: 5px;width: 80%;}
		.small{font-size:8pt; line-height:10pt;}	
		
		
		@media all {
			.page-break	{ display: none; }
		}

		@media print {
			.page-break	{ display: block; page-break-before: always; }
			.noPrint{display:none;}
			thead{
				display:table-header-group;/*repeat table headers on each page*/
			}
			tbody{
				display:table-row-group;  
				
			}
		}
		
		
		.tableedit {
		    border-spacing: 0;
			text-align: center;
		}
		 .dotted_underline {    
			border-bottom: 2px dotted #000;
			text-decoration: none;
		}
		table, th, td {
		  border: 1px solid black;
		  border-collapse: collapse;
		}
		.table{
			padding-top: 3%;
			width: 95%;
			padding-left: 5%;
		}
#header { position: fixed; margin:2%;}
		
	</style>	
	<body id="root">
	<div id="header">
    <img class="img-rounded img-thumbnail" src="public/upload/logo/oredalogo.jpg" alt="" width="100px">
  	</div>
	<?php $date = date('m/d/Y h:i:s a', time());?>
		<div class="content">
			<h1 style="text-align: center;margin-top: 20%;">Vendor Service Performance Report for the FY 2019-2020</h1>
			<h2 style="text-align: center;margin-top: 5%;">Supplier Name:<?php echo $supplier_data[0]['supplier_name']?></h2>
			<h2 style="text-align: center;">Supplier Code:<?php echo $supplier_data[0]['supplier_code']?></h2>
			<h3 style="text-align: center;margin-top: 10%;">Report Prepared By:</br>Team Leader, OREDA CRC</h2>
			<div style="page-break-before: always;"></div>
			<h1 style="text-align: center;padding-top: 0%;"><u>Schedule Maintenance Performance</u></h1>
			<table id="dtbleTicketScore" class="table table-bordered table-hover" >
			<input type="hidden" id="csrf_ticket_score" value="<?php echo generateToken('dtbleTicketScore'); ?>">
				<thead>
					<th rowspan="2">Sl No.</th>
					<th rowspan="2">Month</th>
					<th rowspan="2">Type Of SM</th>
					<th rowspan="2">Tickets Scheduled</th>
					<th rowspan="2">Total Achievable Points</th>
					<th colspan="5" class="text-center">Performance</th>
					<tr>
						<th>Tickets Compiled</th>
	  					<th>Points Credited</th>
	  					<th>Tickets Defaulted</th>
	  					<th>Points Debited</th>
	  					<th>Net Score</th>
					</tr>
				</thead>
				<tbody>
					<?php
					$slno = 1;
					$total__achieved_points 	= 0;
				$total_net_score			= 0;
				$total_tickets 				= 0;
				$total_compiled_tickets 	= 0;
				$total_defaulted_tickets 	= 0;
				$total_sm_points_credited 	= 0;
				$total_sm_points_debited 	= 0;
						foreach($sm_score_vendorwise as $sm):
					?>
						<tr>
							<td><?php echo $slno?></td>
							<td><?php echo $sm['month_name']?></td>
							<td><?php echo $sm['tkt_type']?></td>
							<td><?php echo $sm['total_tkt']?></td>
							<td><?php echo $sm['total_score']?></td>
							<td><?php echo $sm['total_close_tkt']?></td>
							<td><?php echo $sm['total_close_score']?></td>
							<td><?php echo $sm['total_open_tkt']?></td>
							<td><?php echo $sm['total_open_score']?></td>
							<td><?php echo $sm['net_score']?></td>
						</tr>
					<?php
					$slno++;
					$total__achieved_points +=$sm['total_score'];
				$total_net_score +=$sm['net_score'];
				
				$total_tickets +=$sm['total_tkt'];
				$total_compiled_tickets +=$sm['total_close_tkt'];
				$total_defaulted_tickets +=$sm['total_open_tkt'];
				$total_sm_points_credited +=$sm['total_close_score'];
				$total_sm_points_debited +=$sm['total_close_score'];
						endforeach;
					?>
				</tbody>
				<tfoot>
	            	<tr>
	            		<td colspan="4" class="text-center" style="font-weight: bold;color: red;">Total</td>
	            		<td class="text-right" style="font-weight: bold;color: red;"><?php echo $total__achieved_points ?></td>
	            		<td></td>
	            		<td></td>
	            		<td></td>
	            		<td></td>
	            		<td class="text-right" style="font-weight: bold;color: red;"><?php echo $total_net_score ?></td>
	            	</tr>
	            </tfoot>
			</table>
			<div style="page-break-before: always;"></div>
			<h1 style="text-align: center;padding-top: 5%;"><u>Detailed List of Corrective Maintenance Performance Against Asset</u></h1>
			<?php 
    		$scheme_id='';
    		$total_days_credited 	= 0;
			$total_days_debited 	= 0;
			$total_final_score 		= 0;
			$all_total_days_credited = 0;
        	$all_total_days_debited = 0;
        	$all_final_score = 0;
    		for($i=0;$i<count($scheme_data);$i++){
    			$scheme_id = $scheme_data[$i]['tr_scheme_id'];
    			$scheme_name = $scheme_data[$i]['scheme_name'];
    					echo '<div class="box-title">';
						echo '<h3 style="text-align:center;">'.$scheme_name.'<h3></div>';
    					echo '<table id="dataTableCMScore"  class="table table-bordered table-hover"><thead>';
						echo '<th style="width:15%;">Asset ID/ Ticket ID</th>';
						echo '<th style="width:10%;">Location</th>';
						echo '<th style="width:10%;">Start Date</th>';
						echo '<th style="width:10%;">End Date</th>';
						echo '<th style="width:10%;">Days Credited</th>';
						echo '<th style="width:10%;">Days Debited</th>';
						echo '<th style="width:10%;">Final Score</th>';
        			for($j=0;$j<count($cm_score_vendorwise);$j++){
        				if($scheme_id == $cm_score_vendorwise[$j]['tr_scheme_id']){
        					echo '<tbody><tr>';
						echo '<td>'.$cm_score_vendorwise[$j]['asset_id'].'</td>';
							echo '<td>'.$cm_score_vendorwise[$j]['customer_address'].'</td>';
							echo '<td>'.$cm_score_vendorwise[$j]['date_of_installation'].'</td>';
							echo '<td>'.$cm_score_vendorwise[$j]['valid_till'].'</td>';
							echo '<td>'.$cm_score_vendorwise[$j]['credited_days'].'</td>';
							echo '<td>'.$cm_score_vendorwise[$j]['days_debit'].'</td>';
							echo '<td>'.$cm_score_vendorwise[$j]['fin_score'].'</td>';
							echo '</tr></tbody>';
							$total_days_credited +=$cm_score_vendorwise[$j]['credited_days'];
						$total_days_debited +=$cm_score_vendorwise[$j]['days_debit'];
						$total_final_score +=$cm_score_vendorwise[$j]['fin_score'];
        				}
        			}
        			echo '<tfoot><tr>';
							echo '<td></td>';
							echo '<td></td>';
							echo '<td colspan="2" class="text-center" style="font-weight: bold;color: red;">Total</td>';
        					echo '<td class="text-right" style="font-weight: bold;color: red;">'.$total_days_credited .'</td>';
        					echo '<td class="text-right" style="font-weight: bold;color: red;">'. $total_days_debited .'</td>';
        					echo '<td class="text-right" style="font-weight: bold;color: red;">'. $total_final_score .'</td>';
        					echo '</tr></tfoot>';
        		echo '</table>';
        		$all_total_days_credited += $total_days_credited;
        		$all_total_days_debited += $total_days_debited;
        		$final_total_days_debited= $all_total_days_debited/2;
        		$all_final_score += $total_days_credited;
        					
      			echo '<table class="table table-bordered"><tbody>
      				<tr>
      					<td colspan="4" class="text-right" style="font-weight: bold;">Total Days Credited</td>
      						<td class="text-right" style="font-weight: bold;">'.$all_total_days_credited.'</td>
      					</tr>
      					<tr>
      						<td colspan="4" class="text-right" style="font-weight: bold;">Total Days Debited</td>
      						<td class="text-right" style="font-weight: bold;">'.$final_total_days_debited.'</td>
      					</tr>
      					<tr>
      						<td colspan="4" class="text-right" style="font-weight: bold;">Total Final Score</td>
      						<td class="text-right" style="font-weight: bold;">'.$total_final_score.'</td>
      					</tr>
      				</tbody>
      			</table>';
    		}
			?>
			<div style="page-break-before: always;"></div>
			<h1 style="text-align: center;padding-top: 5%;"><u>CM Score Calculation</u></h1>
			<table id="dataTableCMScoringCal" class="table table-bordered table-hover">
  			<input type="hidden" id="csrf_ticket_score" value="<?php echo generateToken('dataTableCMScoringCal'); ?>">
  				<thead>
  					<tr>
      					<th style="width:5%;">#</th>
						<th style="width:15%;">Ticket ID</th>
						<th style="width:10%;">Start Date</th>
						<th style="width:10%;">End Date</th>
						<th style="width:10%;">Total Open days</th>
						<th style="width:10%;">Open Days in FY 19-20</th>
						<th style="width:10%;">(+ or -) 7 days</th>
						<th style="width:10%;">Final Score</th>
					</tr>
  				</thead>
  				<tbody>
					<?php 
					$sl_no 	= 1;
					$total__open_days 	= 0;
				$total_open_days_fy	= 0;
				$total_final_point 	= 0;
					foreach($cm_score_calculation as $cmcal):
					?>
					<tr>
						<td><?php echo $sl_no; ?></td>
						<td><?php echo $cmcal['ticket_id']; ?></td>
						<td><?php echo $cmcal['start_date']; ?></td>
						<td><?php echo $cmcal['close_date']; ?></td>
						<td><?php echo $cmcal['tot_days_open']; ?></td>
						<td><?php echo $cmcal['day_open_fin_yr_19_20']; ?></td>
						<td><?php echo $cmcal['7days']; ?></td>
						<td><?php echo $cmcal['final_score']; ?></td>
					</tr>
					<?php 
					$sl_no++;
					$total__open_days +=$cmcal['tot_days_open'];
				$total_open_days_fy +=$cmcal['day_open_fin_yr_19_20'];
				$total_final_point +=$cmcal['final_score'];
					endforeach;
					?>
				</tbody>
				<tfoot>
                	<tr>
                		<td></td>
                		<td></td>
                		<td colspan="2" class="text-center" style="font-weight: bold;color: red;">Total</td>
                		<td class="text-right" style="font-weight: bold;color: red;"><?php echo $total__open_days ?></td>
                		<td class="text-right" style="font-weight: bold;color: red;"><?php echo $total_open_days_fy ?></td>
                		<td></td>
                		<td class="text-right" style="font-weight: bold;color: red;"><?php echo $total_final_point ?></td>
                	</tr>
                </tfoot>
  			</table>
  			<div style="page-break-before: always;"></div>
  			<h1 style="text-align: center;margin-top:10%;"><u>Summary of Service Performance Measure</u></h1>
  			<div class="col-lg-12 col-xs-12">
  			<div class="col-lg-6">
      			<table class="table table-bordered">
      				<thead>
      					<th colspan="3" class="text-center"><a style="color:#00000;text-decoration: underline;">Scheduled Maintenance</a></th>
      				</thead>
      				<tbody>
      					<tr>
      						<td>1</td>
      						<td>Total Achiebable Points</td>
      						<td class="text-right"><?php echo $total__achieved_points;?></td>
      					</tr>
      					<tr>
      						<td>2</td>
      						<td>Net Earned Points</td>
      						<td class="text-right"><?php echo $total_net_score;?></td>
      					</tr>
      					<tr>
      						<td>3</td>
      						<td>Normalisation factor</td>
      						<td class="text-right">80%</td>
      					</tr>
      					<tr>
      					<?php  
      						if($total_net_score != '0' && $total__achieved_points != '0'){
      							$sm_score = $total_net_score/$total__achieved_points*20;
      						}else{
      							$sm_score = 0;
      						}
      						
      					?>
      						<td>4</td>
      						<td>Final Score</td>
      						<td class="text-right"><?php echo $sm_score; ?></td>
      					</tr>
      				</tbody>
      			</table>
            </div>
            <div class="col-lg-6">
      			<table class="table table-bordered">
      				<thead>
      					<th colspan="3" class="text-center"><a style="color: #00000;text-decoration: underline;">Corrective Maintenance</a></th>
      				</thead>
      				<tbody>
      					<tr>
      						<td>1</td>
      						<td>Total Achiebable Points</td>
      						<td class="text-right"><?php echo $all_total_days_credited;?></td>
      					</tr>
      					<tr>
      						<td>2</td>
      						<td>Net Earned Points</td>
      						<td class="text-right"><?php echo $total_final_point;?></td>
      					</tr>
      					<tr>
      						<td>3</td>
      						<td>Normalisation factor</td>
      						<td class="text-right">20%</td>
      					</tr>
      					<tr>
      					<?php
      					if($total_final_point != '0' && $all_total_days_credited != '0'){
      						$score = $total_final_point/$all_total_days_credited*20;
      					}else{
      						$score = 0;
      					}
      					?>
      						<td>4</td>
      						<td>Final Score</td>
      						<td class="text-right"><?php echo $score;?></td>
      					</tr>
      				</tbody>
      			</table>
            </div>
            </div>
        	<table class="table table-bordered">
  				<thead>
  					<th colspan="3" class="text-center"><a style="color: #00000;text-decoration: underline;">Schedule Maintenance Performance</a></th>
  				</thead>
  				<tbody>
  					<tr>
  						<td>1</td>
  						<td>No. of Tickets Generated </td>
  						<td class="text-right"><?php echo $total_tickets;?></td>
  					</tr>
  					<tr>
  						<td>2</td>
  						<td>No. of Tickets complied </td>
  						<td class="text-right"><?php echo $total_compiled_tickets;?></td>
  					</tr>
  					<tr>
  						<td>3</td>
  						<td>No. of Tickets Defaulted </td>
  						<td class="text-right"><?php echo $total_defaulted_tickets;?></td>
  					</tr>
  					<tr>
  						<td>4</td>
  						<td>Total Achievable Points</td>
  						<td class="text-right"><?php echo $total__achieved_points;?></td>
  					</tr>
  					<tr>
  						<td>5</td>
  						<td>Points Credited</td>
  						<td class="text-right"><?php echo $total_sm_points_credited;?></td>
  					</tr>
  					<tr>
  						<td>6</td>
  						<td>Points Debited</td>
  						<td class="text-right"><?php echo $total_sm_points_debited?></td>
  					</tr>
  					<tr>
  						<td>7</td>
  						<td>Final Score</td>
  						<td class="text-right"><?php echo $total_net_score;?></td>
  					</tr>
  				</tbody>
  			</table>
  			<table class="table table-bordered">
  				<thead>
  					<th colspan="3" class="text-center"><a style="color: #00000;text-decoration: underline;">Corrective Maintenance Performance</a></th>
  				</thead>
  				<tbody>
  					<tr>
  					<?php
  						$total_tickets =count($cm_score_calculation);
  					?>
  						<td>1</td>
  						<td>No. of Tickets Raised</td>
  						<td class="text-right"><?php echo $total_tickets;?></td>
  					</tr>
  					<tr>
  					
  						<td>2</td>
  						<td>Total Down time in FY (Days)</td>
  						<td class="text-right"><?php echo $total_open_days_fy;?></td>
  					</tr>
  					<tr>
  						<td>3</td>
  						<td>Points Awarded</td>
  						<td class="text-right"><?php echo $all_total_days_credited;?></td>
  					</tr>
  					<tr>
  						<td>4</td>
  						<td>Points Credited/ Debited</td>
  						<td class="text-right"><?php echo $all_total_days_debited;?></td>
  					</tr>
  					<tr>
  						<td>5</td>
  						<td>Final Score</td>
  						<td class="text-right"><?php echo $total_final_point;?></td>
  					</tr>
  				</tbody>
  			</table>
		</div>
	</body>
</html>
	
