<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

   	class Transaction_model extends CI_Model{
  		function __construct(){
    		// Call the Model constructor
    		parent::__construct();
    		
    		$this->load->helper('date');
	        if (ENVIRONMENT == 'production') {
	            $this->db->save_queries = FALSE;
	        }
	        date_default_timezone_set('Asia/Kolkata');
			$date = date('Y-m-d H:i:s', time());
	        
	        $this->role 		= $this->session->userdata('role');
	        $this->user_name 	= $this->session->userdata('user_name');
	        $this->user_code 	= $this->session->userdata('user_code');
 	 	}
 	 	public function get($data ,$op){
			date_default_timezone_set('Asia/Kolkata');
			$date = date('Y-m-d H:i:s', time());
			switch($op){
	            case 'get_parent_customer':
        			$res = $this->db->query("SELECT id,CONCAT (IFNULL(name1,''), ' ',IFNULL(name2,''),' ' ,IFNULL(name3,'')) AS customer_name FROM customer 
						WHERE id IN (SELECT tr_customer_id FROM transaction_header WHERE power_plant=1 and tr_scheme_id = '".$data['scheme_id']."' AND tr_supplier_id ='".$data['vendor_id']."' AND district = '".$data['dist_id']."' AND revenue_village = '".$data['village_id']."')");
        			return $res->result_array();
	        	break;
	        	case'get_filter_village_data':
            		$this->db->from('village_master a');
            		$this->db->select('a.pk_village_code,a.village_name');
            		$this->db->join('gp_master b','a.gp_code = b.pk_gp_code','inner');
            		$this->db->where('b.fk_district_code',$data['district_code']);
            		$this->db->order_by('a.village_name','ASC');
            		$res = $this->db->get();
            		return $res->result_array();
            	break;
	        	case 'get_all_transaction_details':
					$order = '';
	                $Ocolumn = '';
	                $Odir = '';
	                $output = array("aaData" => array());
	                $page = $data['page'];
	                $iDisplayLength = $this->input->post('length');//to shw number of record to be shown
		            $iDisplayStart = $this->input->post('start');//to start from that position (ex: offset)
	                //print_r($data);die();
	                if($page ==  'ALL'){
	                	$this->db->from('transaction_header th');
		               	$this->db->select('sh.scheme_name,su.sanction_order_no,gcd.description AS  finance_source,sp.supplier_name,icd.instal_cls_name,th.work_order,
							DATE_FORMAT(th.date_of_installation,"%d-%m-%Y") AS date_of_installation,th.power_plant,"India",s.state_name,dm.district_name,
							bm.block_name,gm.gp_name,vm.village_name,th.plot_no,th.habitation,th.landmark,th.pincode,th.census_code,th.tr_gps_code,l1.description AS dc_val,
							l2.description AS mc_val,l3.description AS scheduled_week,th.consumer_id,CONCAT(b.name1, " ",IF(IFNULL(b.name2,"")="","",CONCAT(b.name2," ")),b.name3) AS customer_name,
							b.father_name,CONCAT(b.caste,"-",b.category) AS cast_cat,b.phone1,b.mobile1,b.mobile2,b.cu_email,l4.description AS gender,b.aadhar_no,b.alternate_id,CONCAT(th.capacity," ",th.unit) as capacity,
							b.acs,CONCAT(b.name1,"  ",IF(IFNULL(b.name2,"")="","  ",CONCAT(b.name2," ")),b.name3) AS parent_customer_name, th.created_by,
							DATE_FORMAT(th.created_at,"%d-%m-%Y") as created_at,th.updated_by,DATE_FORMAT(th.updated_at,"%d-%m-%Y") as updated_at');
						$this->db->join('customer b','th.tr_customer_id  = b.id','left');
						$this->db->join('village_master vm','th.revenue_village=vm.pk_village_code','left');
						$this->db->join('block_master bm','th.cd_block=bm.block_code','left');
						$this->db->join('gp_master gm','th.gp=gm.pk_gp_code','left');
						$this->db->join('district_master dm','th.district=dm.district_code','left');
						$this->db->join('state_master s','th.state=s.state_code','left');
						$this->db->join('scheme_header sh','sh.pk_scheme_code = th.tr_scheme_id','left');
						$this->db->join('admin_dept ad','ad.pk_dept_code = sh.fk_dept_code','left');
						$this->db->join('supplier sp','sp.supplier_code = th.tr_supplier_id','left');
						$this->db->join('gen_code_desc gcd','th.finance_source=gcd.gen_code AND gcd.gen_code_group = "FINANCE_SOURCE"','left');
						$this->db->join('gen_code_desc l1','th.installation_cluster=l1.gen_code  AND l1.gen_code_group = "DISTRICT_CLUSTER"','left');
						$this->db->join('gen_code_desc l2','th.schedule_month=l2.gen_code AND  l2.gen_code_group = "SCHEDULE_MONTH"','left');
						$this->db->join('gen_code_desc l3','th.scheduled_week=l3.gen_code AND  l3.gen_code_group = "SCHEDULE_WEEK"','left');
						$this->db->join('gen_code_desc l4','b.gender=l4.gen_code AND  l4.gen_code_group = "GENDER"','left');
						$this->db->join('scheme_upload su','th.sanction_no=su.id','left');
						$this->db->join('installation_class_header icd','icd.id=th.tr_instal_id','left');
						$this->db->join('sup_tech_map stm','stm.transaction_header_id = th.id','left');
		               	$this->db->where('transaction_status !=',"cancelled");
		               	if($this->role == 'ADEPT'){
							$this->db->where('ad.fk_user_code',$this->user_code);
						}
						if($this->role == 'VENDOR'){
							$this->db->where('sp.fk_user_code',$this->user_code);
						}
						if($this->role == 'TECHNICIAN'){
							$this->db->where('stm.technician_mobile_number',$this->user_name);
						}
		               	if($data['cmb_scheme'] !=''){
							$this->db->where('th.tr_scheme_id',$data['cmb_scheme']);
						}
						if($data['cmb_vendor'] !=''){
							$this->db->where('th.tr_supplier_id',$data['cmb_vendor']);
						}
						if($data['cmb_installType'] !=''){
							$this->db->where('th.tr_instal_id',$data['cmb_installType']);
						}
						if($data['cmb_district'] !=''){
							$this->db->where('th.district',$data['cmb_district']);
						}
						if($data['cmb_village'] !=''){
							$this->db->where('th.revenue_village',$data['cmb_village']);
						}
						if($data['view_install'] =='VI'){
							$this->db->where('th.consumer_id !=','');
						}else{
							$this->db->where('th.consumer_id is null');
						}
		               	$this->db->order_by('th.id','DESC');
		                $query = $this->db->get()->result_array();
	                }else{
		                $order = $this->input->post('order');
		                if ($order) {
		                    foreach ($order as $row) {
		                        $Ocolumn = $row['column'];
		                        $Odir = $row['dir'];
		                    }
		                    $this->db->order_by($Ocolumn, $Odir);
		                } else {
		                    $this->db->order_by(1, "ASC");
		                }
		                $search = $this->input->post('search');
		                $header = array('b.customer_name','th.transaction_status','th.habitation','vm.village_name','th.consumer_id');//search filter will work on this column
		                $filter_string="";
		                if ($search['value'] != '') {
		                    for ($i = 0; $i < count($header); $i++) {
		                       $filter_string.=' or '.$header[$i]." LIKE '%".$search['value']."%'";
		                    }
		                    $filter_string=substr($filter_string,3);
		                    $filter_string='('.$filter_string.')';
		                }
						$cdata = '(SELECT id,CONCAT(name1, " ",IF(IFNULL(name2,"")="","",CONCAT(name2," ")),name3) AS customer_name FROM customer) b';
		                
		                $this->db->limit($iDisplayLength, $iDisplayStart);
		               	$this->db->from('transaction_header th');
		               	$this->db->select("b.customer_name,th.consumer_id, 
								CONCAT( IF(IFNULL(th.habitation, '')='', '', CONCAT(th.habitation, ', ')), IF(IFNULL(vm.village_name, '')='', '', 
								CONCAT(vm.village_name, ', ')), IF(IFNULL(gm.gp_name, '')='', '', CONCAT(gm.gp_name, ', ')), IF(IFNULL(bm.block_name, '')='', '', 
								CONCAT(bm.block_name, ', ')), dm.district_name) AS customer_address, 
								CASE WHEN th.approval_status= '0'   THEN 'Admin Rejected' 
								WHEN th.approval_status = '1'   THEN 'Admin Approved' 
								WHEN th.approval_status = '3' THEN 'Oreda Approved'
								WHEN th.approval_status = '4' THEN 'Oreda Rejected' 
								ELSE th.transaction_status END AS transaction_status_flag,th.transaction_status,th.id, th.revenue_village,th.tr_customer_id,th.tracking_installation");
						$this->db->join($cdata,'th.tr_customer_id  = b.id','left');
						$this->db->join('village_master vm','th.revenue_village=vm.pk_village_code','left');
						$this->db->join('block_master bm','th.cd_block=bm.block_code','left');
						$this->db->join('gp_master gm','th.gp=gm.pk_gp_code','left');
						$this->db->join('district_master dm','th.district=dm.district_code','left');
						$this->db->join('scheme_header sh','sh.pk_scheme_code = th.tr_scheme_id','left');
						$this->db->join('admin_dept ad','ad.pk_dept_code = sh.fk_dept_code','left');
						$this->db->join('supplier sp','sp.supplier_code = th.tr_supplier_id','left');
						$this->db->join('sup_tech_map stm','stm.transaction_header_id = th.id','left');
		               	$this->db->where('transaction_status !=',"cancelled");
		               	if($this->role == 'ADEPT'){
							$this->db->where('ad.fk_user_code',$this->user_code);
						}
						if($this->role == 'VENDOR'){
							$this->db->where('sp.fk_user_code',$this->user_code);
						}
						if($this->role == 'TECHNICIAN'){
							$this->db->where('stm.technician_mobile_number',$this->user_name);
						}
		               	if($data['cmb_scheme'] !=''){
							$this->db->where('th.tr_scheme_id',$data['cmb_scheme']);
						}
						if($data['cmb_vendor'] !=''){
							$this->db->where('th.tr_supplier_id',$data['cmb_vendor']);
						}
						if($data['cmb_installType'] !=''){
							$this->db->where('th.tr_instal_id',$data['cmb_installType']);
						}
						if($data['cmb_district'] !=''){
							$this->db->where('th.district',$data['cmb_district']);
						}
						if($data['cmb_village'] !=''){
							$this->db->where('th.revenue_village',$data['cmb_village']);
						}
						if($data['view_install'] =='VI'){
							$this->db->where('th.consumer_id !=','');
						}else{
							$this->db->where('th.consumer_id is null');
						}
						if($filter_string!=''){
							$this->db->where($filter_string);
						}
						
		               	$this->db->order_by('th.id','DESC');
		                $query = $this->db->get()->result_array();
		                //print_r($this->db->last_query());die();
		                /*----FOR PAGINATION-----*/
		                $this->db->from('transaction_header th');
		               	$this->db->select("b.customer_name,th.consumer_id, 
								CONCAT( IF(IFNULL(th.habitation, '')='', '', CONCAT(th.habitation, ', ')), IF(IFNULL(vm.village_name, '')='', '', 
								CONCAT(vm.village_name, ', ')), IF(IFNULL(gm.gp_name, '')='', '', CONCAT(gm.gp_name, ', ')), IF(IFNULL(bm.block_name, '')='', '', 
								CONCAT(bm.block_name, ', ')), dm.district_name) AS customer_address, 
								CASE WHEN th.approval_status= '0'   THEN 'Admin Rejected' 
								WHEN th.approval_status = '1'   THEN 'Admin Approved' 
								WHEN th.approval_status = '3' THEN 'Oreda Approved'
								WHEN th.approval_status = '4' THEN 'Oreda Rejected' 
								ELSE th.transaction_status END AS transaction_status_flag,th.transaction_status,th.id, th.revenue_village,th.tr_customer_id,th.tracking_installation");
						$this->db->join($cdata,'th.tr_customer_id  = b.id','left');
						$this->db->join('village_master vm','th.revenue_village=vm.pk_village_code','left');
						$this->db->join('block_master bm','th.cd_block=bm.block_code','left');
						$this->db->join('gp_master gm','th.gp=gm.pk_gp_code','left');
						$this->db->join('district_master dm','th.district=dm.district_code','left');
						$this->db->join('scheme_header sh','sh.pk_scheme_code = th.tr_scheme_id','left');
						$this->db->join('admin_dept ad','ad.pk_dept_code = sh.fk_dept_code','left');
						$this->db->join('supplier sp','sp.supplier_code = th.tr_supplier_id','left');
						$this->db->join('sup_tech_map stm','stm.transaction_header_id = th.id','left');
		               	$this->db->where('transaction_status !=',"cancelled");
		               	if($this->role == 'ADEPT'){
							$this->db->where('ad.fk_user_code',$this->user_code);
						}
						if($this->role == 'VENDOR'){
							$this->db->where('sp.fk_user_code',$this->user_code);
						}
						if($this->role == 'TECHNICIAN'){
							$this->db->where('stm.technician_mobile_number',$this->user_name);
						}
		               	if($data['cmb_scheme'] !=''){
							$this->db->where('th.tr_scheme_id',$data['cmb_scheme']);
						}
						if($data['cmb_vendor'] !=''){
							$this->db->where('th.tr_supplier_id',$data['cmb_vendor']);
						}
						if($data['cmb_installType'] !=''){
							$this->db->where('th.tr_instal_id',$data['cmb_installType']);
						}
						if($data['cmb_district'] !=''){
							$this->db->where('th.district',$data['cmb_district']);
						}
						if($data['cmb_village'] !=''){
							$this->db->where('th.revenue_village',$data['cmb_village']);
						}
						if($data['view_install'] =='VI'){
							$this->db->where('th.consumer_id !=','');
						}else{
							$this->db->where('th.consumer_id is null');
						}
						if($filter_string!=''){
							$this->db->where($filter_string);
						}
		               	$this->db->order_by('th.id','DESC');
		                $res1 = $this->db->get();
		                $output["draw"] = intval($this->input->post('draw'));
		                $output['iTotalRecords'] = $res1->num_rows();
		                $output['iTotalDisplayRecords'] = $res1->num_rows();
	                }
	                $slno = $iDisplayStart+1;
	                foreach ($query as $aRow) {
	                    $row[0] = $slno;
	                    $row['sl_no'] = $slno;
	                    $i = 1;
	                    foreach ($aRow as $key => $value) {
	                        $row[$i] = $value;
	                        $row[$key] = $value;
	                        $i++;
	                    }
	                    $slno++;
	                    $output['aaData'][] = $row;
	                    unset($row);
	                }
            		return $output;
            	break;
            	case 'get_header_data':
	            	$this->db->select('th.*,CONCAT (c.name1," ",c.name2," ",c.name3) AS customer_name,l1.description as dc_val, l2.description as mc_val,v.pk_village_code as census_code,
	            	v.village_name,,gm.gp_name,dm.district_name,bm.block_name, th.id as tid,c.*,c.id as cid,sh.scheme_name,sh.scheme_code,
	            	sh.id as shid,icd.instal_cls_name,gcd.description,icd.id as icid,s.supplier_name,s.supplier_code,s.id as sid,ad.dept_name,
	            	c.photo as photo1,th.id_proof as id_proof1,th.installation_photo as installation_photo1,su.sanction_order_no,st.state_name,DATE_FORMAT(th.date_of_installation,"%d-%m-%Y") as date_of_installation');
					$this->db->from("transaction_header th");
					$this->db->join('customer c','c.id=th.tr_customer_id','LEFT');
					$this->db->join('scheme_header sh','sh.pk_scheme_code=th.tr_scheme_id ','LEFT');
					$this->db->join('installation_class_header icd','icd.id=th.tr_instal_id','LEFT');
					$this->db->join('admin_dept ad','ad.pk_dept_code=sh.fk_dept_code','LEFT');
					$this->db->join('supplier s','s.supplier_code=th.tr_supplier_id','LEFT');
					$this->db->join('village_master v','v.pk_village_code=th.revenue_village','LEFT');
					$this->db->join('gen_code_desc l1','th.installation_cluster=l1.gen_code  AND l1.gen_code_group = "DISTRICT_CLUSTER"','LEFT');
					$this->db->join('gen_code_desc l2','th.schedule_month=l2.gen_code AND  l2.gen_code_group = "SCHEDULE_MONTH"','LEFT');
					$this->db->join('gen_code_desc gcd','th.finance_source=gcd.gen_code AND gcd.gen_code_group = "FINANCE_SOURCE"','LEFT');
					$this->db->join('gp_master gm','th.gp=gm.pk_gp_code','LEFT');
					$this->db->join('district_master dm','th.district=dm.district_code','LEFT');
					$this->db->join('block_master bm','th.cd_block=bm.block_code','LEFT');
					$this->db->join('state_master st','st.state_code=th.state','LEFT');
					$this->db->join('scheme_upload su','th.sanction_no=su.id','LEFT');
					$this->db->where('th.id', $data['trans_id']);
					$query = $this->db->get(); 
					//print_r($this->db->last_query());die(); 
					return $query->row();
            	break;
            	case 'get_trans_details_data':
            		$this->db->select('td.id tid, tcv.id id, gcd.description attribute_name, tcv.attribute_values attribute_value, c.component_name, 
						c.id component_id, cd.id component_details_id, tcv.sl_no');
					$this->db->from("transaction_details td");
					$this->db->join('transaction_component_value tcv','td.id = tcv.transaction_details_id AND td.tr_header_id = "'.$data['trans_id'].'"','INNER');
					$this->db->join('components_details cd','tcv.components_detail_id = cd.attribute AND td.tr_component_id=cd.components_id','INNER');
					$this->db->join('gen_code_desc gcd','gcd.gen_code = cd.attribute AND gen_code_group = "ATTRIBUTE"','LEFT');
					$this->db->join('components c','c.id = td.tr_component_id','INNER');
					$this->db->order_by('tcv.transaction_details_id,tcv.sl_no','ASC');
            		return $this->db->get()->result();
            	break;
            	case 'get_trans_img':
            		$this->db->select('a.component_id,b.image_name, a.img_path');
					$this->db->from("transaction_image a");
					$this->db->join('image_upload_master b ','a.component_id=b.id','LEFT');
					$this->db->where('tr_header_id', $data['trans_id']);
					$query = $this->db->get();
					//print_r($this->db->last_query());die();    
					return $query->result();
            	break;
            	case 'get_components_details':
            		$this->db->select('icd.id AS pk_installation_id,icd.installation_header_id,icd.component_id,icd.quantity,icd.mandatory_yn,c.component_name, c.id AS cid,d.id AS transdetails_id');
					$this->db->from("installation_class_detail icd");
					$this->db->join('components c','c.id=icd.component_id','INNER');
					$this->db->join('transaction_details d','c.id=d.tr_component_id and tr_header_id="'.$data['trans_id'].'"','INNER');
					$this->db->where('icd.installation_header_id',$data['installation_id']);//
					$query = $this->db->get(); 
					//print_r($this->db->last_query());die(); 
					return $query->result_array();
            	break;
            	case 'get_attribute_details':
            		$this->db->select('cd.id,cd.components_id,cd.attribute,gcd.description AS attribute_name');
					$this->db->from("components_details cd");
					$this->db->join('gen_code_desc gcd','cd.attribute = gcd.gen_code AND gen_code_group = "ATTRIBUTE"','LEFT');
					$this->db->where('cd.components_id', $data['component_id']);
					$query = $this->db->get();     
					return $query->result_array();
            	break;
            	case 'get_trans_component_data':
            		$this->db->select('cd.attribute,gcd.description AS attribute_name');
					$this->db->from("components_details cd");
					$this->db->join('gen_code_desc gcd','cd.attribute = gcd.gen_code AND gen_code_group = "ATTRIBUTE"','LEFT');
					$this->db->where('cd.components_id', $data['component_id']);
					$res_query = $this->db->get()->result_array();
					$str="SELECT sl_no  as `#`,transaction_details_id";
					foreach($res_query as $key_res){
						$str.=",MAX(CASE WHEN components_detail_id='".$key_res['attribute']."' THEN attribute_values ELSE '' END) AS '".$key_res['attribute_name']."'";
					}
					$str.=" FROM(SELECT sl_no,transaction_details_id,components_detail_id,attribute_values
 					      FROM transaction_component_value WHERE transaction_details_id='".$data['trans_details_id']."' ORDER BY sl_no)a GROUP BY sl_no,transaction_details_id";
            		$query=$this->db->query($str);      
					return $query->result_array();
            	break;
            	case 'get_trans_component_data_header':
            		$this->db->select('cd.attribute,gcd.description AS attribute_name');
					$this->db->from("components_details cd");
					$this->db->join('gen_code_desc gcd','cd.attribute = gcd.gen_code AND gen_code_group = "ATTRIBUTE"','LEFT');
					$this->db->where('cd.components_id', $data['component_id']);
					$res_query = $this->db->get()->result_array();
					$str="SELECT sl_no as `#`,transaction_details_id";
					foreach($res_query as $key_res){
						$str.=",MAX(CASE WHEN components_detail_id='".$key_res['attribute']."' THEN attribute_values ELSE '' END) AS '".$key_res['attribute_name']."'";
					}
					$str.=" FROM(SELECT sl_no,transaction_details_id,components_detail_id,attribute_values
 					      FROM transaction_component_value WHERE transaction_details_id='".$data['trans_details_id']."' ORDER BY sl_no)a GROUP BY sl_no,transaction_details_id limit 0";
            		$query=$this->db->query($str);      
					return $query;
            	break;
            	case 'get_all_attribute_details':
            		$this->db->select("a.sl_no,a.transaction_details_id,a.components_detail_id,a.attribute_values,b.description AS attr_header");
            		$this->db->from("transaction_component_value a");
            		$this->db->join("gen_code_desc b","b.gen_code_group = 'ATTRIBUTE' AND a.components_detail_id=b.gen_code",'left');
            		$this->db->where("a.transaction_details_id",$data['trans_details_id']);
            		$this->db->where("a.sl_no",$data['sl_no']);
					return $this->db->get()->result_array();
            	break;
            default :
            	return array('status' => FALSE, 'msg' =>'Unable to load.Contact Support');
			}
		}
 	 	public function post($data ,$op){
			date_default_timezone_set('Asia/Kolkata');
			$date = date('Y-m-d H:i:s', time());
			switch($op){
				case 'add_approval_information':
					$this->db->trans_begin();
					try{
						$status = '';
	 					$sup_tech_status = '';
				 		switch($data['cmb_approval_status']):
				 			case '0':
				 				$status = 'Admin Rejected';
				 				$sup_tech_status = 'Open';
				 				$transaction_status = 'submitted';
				 			break;
				 			case '1':
				 				$status = 'Admin Approved';
				 				$sup_tech_status = 'Closed';
				 				$transaction_status = 'approved';
				 			break;
				 		endswitch;
				 		$data_update = array(
							'transaction_status'=>$transaction_status,
							'remarks' => $data['txt_remarks'],
							'approval_status' =>$data['cmb_approval_status']
				 		);
				 		$this->db->where('id',$data['hidtrans_id']);
				 		$result_transaction_header = $this->db->update('transaction_header',$data_update);
	 		
	 					if($result_transaction_header){
						  	$this->db->where('id', $data['hidtrans_id']);
						  	$result = $this->db->get('transaction_header')->row_array();
			  	
						  	$insert_data = array(
						  		'id'					=> $result['id'],
						  		'consumer_id'			=> $result['consumer_id'],
						  		'tr_type'	    		=> $result['tr_type'],
						  		'admin_dep'	    		=> $result['admin_dep'],
						  		'tr_scheme_id'			=> $result['tr_scheme_id'],
						  		'tr_instal_id'			=> $result['tr_instal_id'],
						  		'tr_supplier_id'		=> $result['tr_supplier_id'],
						  		'country'	    		=> $result['country'],
						  		'state'	        		=> $result['state'],
						  		'district'	    		=> $result['district'],
						  		'cd_block'	    		=> $result['cd_block'],
						  		'gp'	        		=> $result['gp'],
						  		'revenue_village'		=> $result['revenue_village'],
						  		'habitation'			=> $result['habitation'],
						  		'landmark'	    		=> $result['landmark'],
						  		'tr_customer_id'		=> $result['tr_customer_id'],
						  		'date_of_charging'		=> $result['date_of_charging'],
						  		'transaction_status'	=> $result['transaction_status'],
						  		'assign_to'	    		=> $result['assign_to'],
						  		'created_by'			=> $result['created_by'],
						  		'created_at'			=> $result['created_at'],
						  		'updated_by'			=> $result['updated_by'],
						  		'updated_at'			=> date('Y-m-d H:i:s',time()),
						  		'plot_no'	    		=> $result['plot_no'],
						  		'pincode'	    		=> $result['pincode'],
						  		'census_code'			=> $result['census_code'],
						  		'tr_gps_code'			=> $result['tr_gps_code'],
						  		'capacity'	    		=> $result['capacity'],
						  		'unit'	        		=> $result['unit'],
						  		'date_of_installation'	=> $result['date_of_installation'],
						  		'power_plant'			=> $result['power_plant'],
						  		'parent_customer_id'	=> $result['parent_customer_id'],
						  		'termination_date'		=> $result['termination_date'],
						  		'reason_termination'	=> $result['reason_termination'],
						  		'work_order'			=> $result['work_order'],
						  		'finance_source'		=> $result['finance_source'],
						  		'mobile'	    		=> $result['mobile'],
						  		'id_proof'	    		=> $result['id_proof'],
						  		'installation_photo'	=> $result['installation_photo'],
						  		'sanction_no'			=> $result['sanction_no'],
						  		'date'	        		=> $result['date'],
						  		'remarks'	    		=> $result['remarks'],
						  		'approval_status'		=> $result['approval_status']
						  	);
						  	$insert_Transaction_header_history = $this->db->insert('transaction_header_history',$insert_data);
						  	if($insert_Transaction_header_history){
								$this->db->where('transaction_header_id',$data['hidtrans_id']);
				 				$result_sup_tech_map = $this->db->update('sup_tech_map',array('status'=>$sup_tech_status));
				 				if($result_sup_tech_map){
				 					if($data['cmb_approval_status'] == 0){
										$this->db->where('tr_header_id',$data['hidtrans_id']);
										$res_data = $this->db->delete('transaction_image');
										if($res_data){
											$this->db->trans_commit();
											$dbstatus 	= TRUE;
											$dbmessage =  $status." successfully";
										}else{
											$this->db->trans_commit();
											$dbstatus 	= FALSE;
											$dbmessage =  "Error in Delete !! try again.";
										}
									}else{
										$this->db->trans_commit();
										$dbstatus 	= TRUE;
										$dbmessage =  $status." successfully";
									}
								}else{
									$this->db->trans_rollback();
									$dbstatus 	= FALSE;
									$dbmessage =  'Error in update2!! try again.';
								}
							}else{
								$this->db->trans_rollback();
								$dbstatus 	= FALSE;
								$dbmessage =  'Error in insert!! try again.';
							}
						}else{
							$this->db->trans_rollback();
							$dbstatus 	= FALSE;
							$dbmessage =  'Error in update1!! try again.';
						}
					}catch(Exception $e){
				      	$this->db->trans_rollback();
				      	$dbstatus = FALSE;
				      	$dbmessage = $e->getMessage();
				    }
					return array('status' => $dbstatus,'msg' => $dbmessage);
				break;
				case 'add_dh_approval_information':
					$this->db->trans_begin();
					try{
						$status 			= '';
				 		$sup_tech_status 	= '';
				 		$consumer_id		= '';
				 		$status_value		= '';
				 		switch($data['cmb_approval_status']):
				 			case '1':
				 				$status 			= 'Oreda Approved';
				 				$sup_tech_status 	= 'Closed';
				 				$transaction_status = 'approved';
				 				$status_value 		= 3;
				 				
				 				$this->db->from("transaction_header th");
				 				$this->db->select('power_plant,tr_scheme_id,parent_customer_id');
				 				$this->db->where('id',$data['hidtrans_id']);
				 				$res_data = $this->db->get()->row_array();
				 				
				 				if($res_data['power_plant'] == 1){
									/*$res1 = $this->db->query("SELECT CONCAT(category_short_code,' ',LPAD(SUBSTRING(cid,-lnth,lnth-3),2,0) ,' ',SUBSTRING(cid,-3) ,' 000')AS cid1 FROM
										(SELECT LENGTH(MAX(CAST(CONCAT(SPLIT_STR(consumer_id,' ',2),SPLIT_STR(consumer_id,' ',3))AS UNSIGNED INTEGER))+1) AS lnth,
										(MAX(CAST(CONCAT(SPLIT_STR(consumer_id,' ',2),SPLIT_STR(consumer_id,' ',3))AS UNSIGNED INTEGER))+1) AS cid,category_short_code
										FROM transaction_header a LEFT JOIN  (SELECT category_short_code,pk_scheme_code FROM scheme_header b INNER JOIN scheme_category_master c 
										ON b.fk_scheme_category=c.category_code WHERE fk_scheme_category IN
										 (SELECT  fk_scheme_category FROM scheme_header WHERE pk_scheme_code='".$res_data['tr_scheme_id']."'))b  ON a.tr_scheme_id=b.pk_scheme_code 
										WHERE  power_plant=1 AND consumer_id IS NOT NULL AND category_short_code IS NOT NULL GROUP BY category_short_code )a ");
										*/
										$res1=$this->db->query("SELECT IF(c_cnt!=0, CONCAT(category_short_code,' ',LPAD(SUBSTRING(cid,-lnth,lnth-3),2,0) ,' ',SUBSTRING(LPAD(cid,5,0),-3) ,' 000'),CONCAT(category_short_code1,' 00 001 000'))AS cid1 FROM
										(SELECT LENGTH(MAX(CAST(CONCAT(SPLIT_STR(consumer_id,' ',2),SPLIT_STR(consumer_id,' ',3))AS UNSIGNED INTEGER))+1) AS lnth,
										(MAX(CAST(CONCAT(SPLIT_STR(consumer_id,' ',2),SPLIT_STR(consumer_id,' ',3))AS UNSIGNED INTEGER))+1) AS cid,category_short_code , COUNT(consumer_id)AS dc
										FROM transaction_header a RIGHT JOIN (SELECT category_short_code,pk_scheme_code FROM scheme_header b INNER JOIN scheme_category_master c
										ON b.fk_scheme_category=c.category_code WHERE fk_scheme_category IN
										(SELECT fk_scheme_category FROM scheme_header WHERE pk_scheme_code='".$res_data['tr_scheme_id']."'))b ON a.tr_scheme_id=b.pk_scheme_code
										WHERE power_plant=1 AND consumer_id IS NOT NULL AND consumer_id!='' AND category_short_code IS NOT NULL GROUP BY category_short_code )a RIGHT JOIN 
										(SELECT COUNT(consumer_id) AS c_cnt,category_short_code AS category_short_code1 FROM transaction_header a RIGHT JOIN 
										(SELECT category_short_code,pk_scheme_code FROM scheme_header b INNER JOIN scheme_category_master c
										ON b.fk_scheme_category=c.category_code WHERE fk_scheme_category IN
										(SELECT fk_scheme_category FROM scheme_header WHERE pk_scheme_code='".$res_data['tr_scheme_id']."'))b ON a.tr_scheme_id=b.pk_scheme_code
										WHERE power_plant=1 AND consumer_id IS NOT NULL AND consumer_id!='' AND category_short_code IS NOT NULL ) d ON 1=1");
									$cons_data1 = $res1->row_array();
									if(!empty($cons_data1)){
										$consumer_id = $cons_data1['cid1'];
									}else{
										$this->db->trans_commit();
										$dbstatus 	= FALSE;
										$dbmessage =  "Error for Generated Consumer Id.";
									}
								}else{
									/*$res2 = $this->db->query("SELECT CONCAT(category_short_code,' ',LPAD(SUBSTRING(cid,-lnth,lnth-6),2,0) ,' ',LPAD(SUBSTRING(cid,-6,3),3,0) ,' ',SUBSTRING(cid,-3))AS cid1 FROM
										(SELECT tr_scheme_id,(MAX(CAST(CONCAT(SPLIT_STR(consumer_id,' ',2),SPLIT_STR(consumer_id,' ',3),SPLIT_STR(consumer_id,' ',4))AS UNSIGNED INTEGER))+1) AS cid,
										LENGTH(MAX(CAST(CONCAT(SPLIT_STR(consumer_id,' ',2),SPLIT_STR(consumer_id,' ',3),SPLIT_STR(consumer_id,' ',4))AS UNSIGNED INTEGER))+1) AS lnth 
										FROM transaction_header WHERE consumer_id LIKE
										(SELECT CONCAT(SUBSTRING(consumer_id,1,12),'%') AS f FROM transaction_header WHERE id=(
										SELECT parent_customer_id AS parent_customer_id FROM transaction_header WHERE id='".$data['hidtrans_id']."')) GROUP BY tr_scheme_id) a
										LEFT JOIN scheme_header b ON a.tr_scheme_id=b.pk_scheme_code LEFT JOIN scheme_category_master c ON b.fk_scheme_category=c.category_code");*/
										$res2 = $this->db->query("SELECT CONCAT(category_short_code,' ',LPAD(SUBSTRING(cid,-lnth,lnth-6),2,0) ,' ',LPAD(SUBSTRING(LPAD(cid,8,0),-6,3),3,0) ,' ',SUBSTRING(cid,-3))AS cid1 FROM
										(SELECT tr_scheme_id,(MAX(CAST(CONCAT(SPLIT_STR(consumer_id,' ',2),SPLIT_STR(consumer_id,' ',3),SPLIT_STR(consumer_id,' ',4))AS UNSIGNED INTEGER))+1) AS cid,
										LENGTH(MAX(CAST(CONCAT(SPLIT_STR(consumer_id,' ',2),SPLIT_STR(consumer_id,' ',3),SPLIT_STR(consumer_id,' ',4))AS UNSIGNED INTEGER))+1) AS lnth
										FROM transaction_header WHERE consumer_id LIKE
										(SELECT CONCAT(SUBSTRING(consumer_id,1,12),'%') AS f FROM transaction_header WHERE tr_customer_id=(
										SELECT parent_customer_id AS parent_customer_id FROM transaction_header WHERE id='".$data['hidtrans_id']."')) GROUP BY tr_scheme_id) a
										LEFT JOIN scheme_header b ON a.tr_scheme_id=b.pk_scheme_code LEFT JOIN scheme_category_master c ON b.fk_scheme_category=c.category_code");
									$cons_data2 = $res2->row_array();
									
									if(!empty($cons_data2)){
										$consumer_id = $cons_data2['cid1'];
									}else{
										$this->db->trans_commit();
										$dbstatus 	= FALSE;
										$dbmessage =  "Error for Generated Consumer Id.";
									}
								}
				 			break;
				 			case '0':
				 				$status 			= 'Oreda Rejected';
				 				$sup_tech_status 	= 'Open';
				 				$transaction_status = 'install';
				 				$status_value 		= 4;
				 				$consumer_id 		= null;
				 			break;
				 		endswitch;
				 		$update_query = array(
				 			'transaction_status'=> $transaction_status,
				 			'date'				=> date("Y-m-d",strtotime($data['txt_approval_date'])),
				 			'remarks'			=> $data['txt_remarks'],
				 			'consumer_id'		=> $consumer_id,
				 			'approval_status' 	=> $status_value
				 		);
	 					$this->db->where('id',$data['hidtrans_id']);
	 					$update_result = $this->db->update('transaction_header',$update_query);
	 					//print_r($this->db->last_query());die();
				 		if($update_result){
						  	$this->db->select('*');
						  	$this->db->from("transaction_header");
						  	$this->db->where('id', $data['hidtrans_id']);
						  	$res = $this->db->get();
						  	$result = $res->row_array();
						  	
						  	$insert_data = array(
						  		'id'					=> $result['id'],
						  		'consumer_id'			=> $result['consumer_id'],
						  		'tr_type'	    		=> $result['tr_type'],
						  		'admin_dep'	    		=> $result['admin_dep'],
						  		'tr_scheme_id'			=> $result['tr_scheme_id'],
						  		'tr_instal_id'			=> $result['tr_instal_id'],
						  		'tr_supplier_id'		=> $result['tr_supplier_id'],
						  		'country'	    		=> $result['country'],
						  		'state'	        		=> $result['state'],
						  		'district'	    		=> $result['district'],
						  		'cd_block'	    		=> $result['cd_block'],
						  		'gp'	        		=> $result['gp'],
						  		'revenue_village'		=> $result['revenue_village'],
						  		'habitation'			=> $result['habitation'],
						  		'landmark'	    		=> $result['landmark'],
						  		'tr_customer_id'		=> $result['tr_customer_id'],
						  		'date_of_charging'		=> $result['date_of_charging'],
						  		'transaction_status'	=> $result['transaction_status'],
						  		'assign_to'	    		=> $result['assign_to'],
						  		'created_by'			=> $result['created_by'],
						  		'created_at'			=> $result['created_at'],
						  		'updated_by'			=> $result['updated_by'],
						  		'updated_at'			=> date('Y-m-d H:i:s',time()),
						  		'plot_no'	    		=> $result['plot_no'],
						  		'pincode'	    		=> $result['pincode'],
						  		'census_code'			=> $result['census_code'],
						  		'tr_gps_code'			=> $result['tr_gps_code'],
						  		'capacity'	    		=> $result['capacity'],
						  		'unit'	        		=> $result['unit'],
						  		'date_of_installation'	=> $result['date_of_installation'],
						  		'power_plant'			=> $result['power_plant'],
						  		'parent_customer_id'	=> $result['parent_customer_id'],
						  		'termination_date'		=> $result['termination_date'],
						  		'reason_termination'	=> $result['reason_termination'],
						  		'work_order'			=> $result['work_order'],
						  		'finance_source'		=> $result['finance_source'],
						  		'mobile'	    		=> $result['mobile'],
						  		'id_proof'	    		=> $result['id_proof'],
						  		'installation_photo'	=> $result['installation_photo'],
						  		'sanction_no'			=> $result['sanction_no'],
						  		'date'	        		=> $result['date'],
						  		'remarks'	    		=> $result['remarks'],
						  		'approval_status'		=> $result['approval_status']
						  	);
						  	$insert_transaction_header_history = $this->db->insert('transaction_header_history',$insert_data);
						  	if($insert_transaction_header_history){
								$this->db->where('transaction_header_id',$data['hidtrans_id']);
				 				$result_sup_tech_map = $this->db->update('sup_tech_map',array('status'=>$sup_tech_status));
				 				if($result_sup_tech_map){
				 					if($data['cmb_approval_status'] == 0){
										$this->db->where('tr_header_id',$data['hidtrans_id']);
										$res_data = $this->db->delete('transaction_image');
										if($res_data){
											$this->db->trans_commit();
											$dbstatus 	= TRUE;
											$dbmessage =  $status." successfully";
										}else{
											$this->db->trans_rollback();
											$dbstatus 	= FALSE;
											$dbmessage =  "Error in Delete !! try again.";
										}
									}else{
										$this->db->trans_commit();
										$dbstatus 	= TRUE;
										$dbmessage =  $status." successfully";
									}
								}else{
									$this->db->trans_rollback();
									$dbstatus 	= FALSE;
									$dbmessage =  'Error in update2!! try again.';
								}
							}else{
								$this->db->trans_rollback();
								$dbstatus 	= FALSE;
								$dbmessage =  'Error in insert!! try again.';
							}
						}else{
							$this->db->trans_rollback();
							$dbstatus 	= FALSE;
							$dbmessage =  'Error in update!! try again.';
						}
					}catch(Exception $e){
				      	$this->db->trans_rollback();
				      	$dbstatus = FALSE;
				      	$dbmessage = $e->getMessage();
				    }
					return array('status' => $dbstatus,'msg' => $dbmessage);
				break;
				case 'ADD_TRANSACTION' :
					if($data['txt_longitudecode']!="" && $data['txt_latitudecode']!=""){
						$gps_code = $data['txt_latitudecode'] . "," . $data['txt_longitudecode'];
					}else{
						$gps_code ="";
					}
					//print_r($gps_code);die();
					$this->db->trans_begin();
					try{
						$file_customer_photo 		= "";
						$file_id_proof 		 		= "";
						$file_installation_photo 	= "";
						if($_FILES['file_customerphoto']['name'] == ''){
							$customer_photo_store_path = "";
						}else{
							$file_customer_photo = $_FILES['file_customerphoto']['name'];
							$allowed_mime_type_arr = array('image/jpg','image/png','image/jpeg','image/x-icon');
							$mime = get_mime_by_extension($file_customer_photo);
							$dot_count 	= substr_count($file_customer_photo,'.');
							$zero_count = substr_count($file_customer_photo,"%0");
							if(in_array($mime, $allowed_mime_type_arr)){
								if($zero_count == 0 && $dot_count == 1){
									$file_move_path  = FCPATH.'public/upload/consumer_upload';
									if(!is_dir($file_move_path))
		     							mkdir($file_move_path,0777,true);
		     						$customer_photo_store_path  = 'public/upload/consumer_upload/'.$file_customer_photo ;
		     						$upload_customer_photo = move_uploaded_file($_FILES['file_customerphoto']['tmp_name'],$customer_photo_store_path);
									if(!$upload_customer_photo){
										$dbstatus = FALSE;
										$dbmessage = 'Consumer Photo Upload Falied';
									}
								}else{
									$dbstatus = FALSE;
									$dbmessage = 'Invalid Image format.It should not contain multiple dot(.) or 0) 1';
								}
							}else{
								$dbstatus = FALSE;
								$dbmessage = 'Please select Image format.';
							}
						}
						
						if($_FILES['file_idproof']['name'] == ''){
							$id_proof_store_path = "";
						}else{
							$file_id_proof = $_FILES['file_idproof']['name'];
							$allowed_mime_type_arr = array('image/jpg','image/png','image/jpeg','image/x-icon');
							$mime = get_mime_by_extension($file_id_proof);
							$dot_count 	= substr_count($file_id_proof,'.');
							$zero_count = substr_count($file_id_proof,"%0");
							if(in_array($mime, $allowed_mime_type_arr)){
								if($zero_count == 0 && $dot_count == 1){
									$file_move_path  = FCPATH.'public/upload/consumer_upload';
									if(!is_dir($file_move_path))
			     						mkdir($file_move_path,0777,true);
			     					$id_proof_store_path  = 'public/upload/consumer_upload/'.$file_id_proof ;
				     				$upload_id_proof_file = move_uploaded_file($_FILES['file_idproof']['tmp_name'],$id_proof_store_path);
									if(!$upload_id_proof_file){
										$dbstatus = FALSE;
										$dbmessage = 'Consumer Photo Upload Falied';
									}		
								}else{
									$dbstatus = FALSE;
									$dbmessage = 'Invalid Image format.It should not contain multiple dot(.) or 0) 2';
								}
							}else{
								$dbstatus = FALSE;
								$dbmessage = 'Please select Image format. 2';
							}
						}
						if($_FILES['file_installationphoto']['name'] == ''){
							$installation_photo_store_path = "";
						}else{
							$file_installation_photo = $_FILES['file_installationphoto']['name'];
							$allowed_mime_type_arr = array('image/jpg','image/png','image/jpeg','image/x-icon');
							$mime = get_mime_by_extension($file_installation_photo);
							$dot_count 	= substr_count($file_installation_photo,'.');
							$zero_count = substr_count($file_installation_photo,"%0");
							if(in_array($mime, $allowed_mime_type_arr)){
								if($zero_count == 0 && $dot_count == 1){
									$file_move_path  = FCPATH.'public/upload/consumer_upload';
									if(!is_dir($file_move_path))
		     							mkdir($file_move_path,0777,true);
		     						$installation_photo_store_path  = 'public/upload/consumer_upload/'.$file_installation_photo ;
		     						$upload_installation_photo_file = move_uploaded_file($_FILES['file_idproof']['tmp_name'],$installation_photo_store_path);
									if(!$upload_installation_photo_file){
										$dbstatus = FALSE;
										$dbmessage = 'Cusomer Photo Upload Falied';
									}	
								}else{
									$dbstatus = FALSE;
									$dbmessage = 'Invalid Image format.It should not contain multiple dot(.) or 0) 2';
								}
							}else{
								$dbstatus = FALSE;
								$dbmessage = 'Please select Image format. 2';
							}
						}
						$insert_consumer = array(
							'name1' 			=>  $this->security->xss_clean($data['txt_firstName']),
							'name2' 			=>  $this->security->xss_clean($data['txt_MiddleName']),
							'name3' 			=>  $this->security->xss_clean($data['txt_LastName']),
							'father_name' 		=> 	$this->security->xss_clean($data['txt_fatherSpouse']),
							'caste'				=>	$this->security->xss_clean($data['cmb_casteCategory']),
							'phone1' 			=>	$this->security->xss_clean($data['txt_Landline']),
							'mobile1'			=>  $this->security->xss_clean($data['txt_MobileOne']),
							'mobile2' 			=>  $this->security->xss_clean($data['txt_MobileTwo']),
							'aadhar_no' 		=>  $this->security->xss_clean($data['txt_Aadhar']),
							'cu_email' 			=> 	$this->security->xss_clean($data['txt_email']),
							'alternate_id' 		=>  $this->security->xss_clean($data['txt_Alternate']),
							'gender' 			=>  $this->security->xss_clean($data['cmb_gender']),
							'acs' 				=> 	$this->security->xss_clean($data['cmb_acs']),
							'photo' 			=> 	$customer_photo_store_path,
							'id_proof' 			=> 	$id_proof_store_path,
							'installation_photo'=> 	$installation_photo_store_path,
							'created_by' 		=> 	$this->user_name,
							'created_at' 		=> 	$date
						);
						
						$result_customer = $this->db->insert('customer',$insert_consumer);
						$customer_id = $this->db->insert_id();
						$pp=isset($_POST['checkbox_powerplant'])?$this->security->xss_clean($data['checkbox_powerplant']):'0';
						$parent_id='';
						if($pp== '1'){
							$parent_id='';
						}else {
							$parent_id=$this->security->xss_clean($data['cmb_parentcustomer']);
						}
						if($result_customer){
							$insert_transaction_header = array(
								'tr_scheme_id' => $this->security->xss_clean($data['cmb_scheme']),
								'tr_instal_id' => $this->security->xss_clean($data['cmb_installationClass']),
								'tr_supplier_id' => $this->security->xss_clean($data['cmb_vendorname']),
								'tr_customer_id' => $customer_id,
								'landmark' => $this->security->xss_clean($data['txt_landmark']),
								'plot_no' =>  $this->security->xss_clean($data['txt_plotno']),
								'pincode' => $this->security->xss_clean($data['txt_pincode']),
								'census_code' => $this->security->xss_clean($data['txt_censuscode']),
								'habitation' => $this->security->xss_clean($data['txt_area']),
								'power_plant' => isset($_POST['checkbox_powerplant'])?$this->security->xss_clean($data['checkbox_powerplant']):'0',
								'tr_gps_code' => $gps_code,
								'revenue_village' =>  $this->security->xss_clean($data['cmb_revenuevillage']),
								'scheduled_week' =>  $this->security->xss_clean($data['cmb_scheduled_week']),
								'cd_block' => $this->security->xss_clean($data['cmb_cdblock']),
								'gp' => $this->security->xss_clean($data['cmb_grampanchayat']),
								'district' => $this->security->xss_clean($data['cmb_district']),
								'state' => $this->security->xss_clean($data['cmb_state']),
								'country' => $this->security->xss_clean($data['cmb_country']),
								'finance_source' => $this->security->xss_clean($data['cmb_finance_source']),
								'date_of_installation' => $this->security->xss_clean(date("Y-m-d", strtotime($data['txt_dateInstallation']))),
								'parent_customer_id' => $parent_id,
								'work_order' => $this->security->xss_clean($data['txtWorkOrder']),
								'sanction_no' => $this->security->xss_clean($data['cmb_sanctionletter']),
								'installation_cluster' => $this->security->xss_clean($data['cmb_districtcluster']),
								'schedule_month' => $this->security->xss_clean($data['cmb_maintenanceCluster']),
								'capacity' 	=> $this->security->xss_clean($data['txtTotalCapacity']),
								'unit' 		=> $this->security->xss_clean($data['txtUnit']),
								'transaction_status' => 'install',
								'tr_status' => 'WORKING',
								'id_proof' => $id_proof_store_path,
								'installation_photo' => $installation_photo_store_path,
								'created_by' => $this->user_name,
								'created_at' => $date
						  	);
							$result_transaction_header = $this->db->insert('transaction_header',$insert_transaction_header);
							$trans_id = $this->db->insert_id();
							if($result_transaction_header){
								$history_data = $this->db->query("INSERT INTO transaction_header_history 
									(id, consumer_id, tr_type, admin_dep, tr_scheme_id, tr_instal_id, tr_supplier_id, country, state, district, cd_block, gp, 
									revenue_village, habitation, landmark, tr_customer_id, date_of_charging, transaction_status, assign_to, plot_no, pincode, 
									census_code, tr_gps_code, capacity, unit, date_of_installation, power_plant, parent_customer_id, termination_date, 
									reason_termination, work_order, finance_source, mobile, id_proof, installation_photo, sanction_no, installation_cluster, 
									schedule_month, scheduled_week, DATE, remarks, approval_status, amc_letter_no, document, valid_from, valid_till, tr_status, 
									status_remarks, recce_date, material_site_date, installation_date, payment_made_date, tracking_installation, created_by, 
									created_at, updated_by, updated_at) SELECT * FROM transaction_header WHERE id='".$trans_id."'");
								if($history_data){
									$this->db->select('c.id AS component_id');
									$this->db->from("installation_class_detail icd");
									$this->db->join('components c','c.id=icd.component_id','INNER');
									$this->db->where('icd.installation_header_id', $data['cmb_installationClass']);
									$query = $this->db->get(); 
									$component_details =  $query->result_array();
									$sl_no = 1;
									for($c=0;$c<sizeof($component_details);$c++){
										$insert_data[] = array(
											'tr_header_id' 	  => $trans_id,
											'tr_component_id' => $component_details[$c]['component_id'],
											'sl_no'			  => $sl_no,
											'created_by' 	  => $this->user_name,
											'created_at' 	  => $date
										);
										$sl_no++;
									}
									$result_transaction_details = $this->db->insert_batch('transaction_details',$insert_data);
									if($result_transaction_details){
										$transaction_id = $trans_id;
										$this->db->trans_commit();
										$dbstatus = TRUE;
										$dbmessage = 'Data Save successfully';
									}else{
										$this->db->trans_rollback();
										$dbstatus = FALSE;
										$transaction_id = "";
										$dbmessage = 'Error While Saving Data';
									}
								}else{
									$this->db->trans_rollback();
									$dbstatus = FALSE;
									$transaction_id = "";
									$dbmessage = 'Error While History Data';
								}
							}else{
								$this->db->trans_rollback();
								$dbstatus = FALSE;
								$transaction_id = "";
								$dbmessage = 'Error While Transaction Data';
							}
						}else{
							$this->db->trans_rollback();
							$dbstatus = FALSE;
							$transaction_id = "";
							$dbmessage = 'Error While Customer Data';
						}
					}catch(Exception $e){
				      	$this->db->trans_rollback();
				      	$dbstatus = FALSE;
				      	$transaction_id = "";
				      	$dbmessage = $e->getMessage();
				    }
				    return array('status' => $dbstatus,'msg' => $dbmessage,'trans_id'=>$transaction_id); 
				break;
				case 'UPDATE_TRANSACTION' :
					$gps_code ="";
					if($data['txt_longitudecode']!="" && $data['txt_latitudecode']!=""){
						$gps_code = $data['txt_latitudecode'] . "," . $data['txt_longitudecode'];
					}else{
						$gps_code ="";
					}
					
					$this->db->trans_begin();
					try{
						$file_customer_photo 		= "";
						$file_id_proof 		 		= "";
						$file_installation_photo 	= "";
						if($_FILES['file_customerphoto']['name'] == ''){
							if($data['hidcustomerphoto'] == '') {
								$customer_photo_store_path = "";
							}else{
								$customer_photo_store_path = $data['hidcustomerphoto'];
							}
						}else{
							$file_customer_photo = $_FILES['file_customerphoto']['name'];
							$allowed_mime_type_arr = array('image/jpg','image/png','image/jpeg','image/x-icon');
							$mime = get_mime_by_extension($file_customer_photo);
							$dot_count 	= substr_count($file_customer_photo,'.');
							$zero_count = substr_count($file_customer_photo,"%0");
							if(in_array($mime, $allowed_mime_type_arr)){
								if($zero_count == 0 && $dot_count == 1){
									$file_move_path  = FCPATH.'public/upload/consumer_upload';
									if(!is_dir($file_move_path))
		     							mkdir($file_move_path,0777,true);
		     						$customer_photo_store_path  = 'public/upload/consumer_upload/'.$file_customer_photo ;
		     						$upload_customer_photo = move_uploaded_file($_FILES['file_customerphoto']['tmp_name'],$customer_photo_store_path);
									if(!$upload_customer_photo){
										$dbstatus = FALSE;
										$dbmessage = 'Consumer Photo Upload Falied';
									}
								}else{
									$dbstatus = FALSE;
									$dbmessage = 'Invalid Image format.It should not contain multiple dot(.) or 0) 1';
								}
							}else{
								$dbstatus = FALSE;
								$dbmessage = 'Please select Image format.';
							}
						}
						if($_FILES['file_idproof']['name'] == ''){
							if($data['hididproof'] == ''){
								$id_proof_store_path = "";
							}else{
								$id_proof_store_path = $data['hididproof'];
							}
						}else{
							$file_id_proof = $_FILES['file_idproof']['name'];
							$allowed_mime_type_arr = array('image/jpg','image/png','image/jpeg','image/x-icon');
							$mime = get_mime_by_extension($file_id_proof);
							$dot_count 	= substr_count($file_id_proof,'.');
							$zero_count = substr_count($file_id_proof,"%0");
							if(in_array($mime, $allowed_mime_type_arr)){
								if($zero_count == 0 && $dot_count == 1){
									$file_move_path  = FCPATH.'public/upload/consumer_upload';
									if(!is_dir($file_move_path))
			     						mkdir($file_move_path,0777,true);
			     					$id_proof_store_path  = 'public/upload/consumer_upload/'.$file_id_proof ;
				     				$upload_id_proof_file = move_uploaded_file($_FILES['file_idproof']['tmp_name'],$id_proof_store_path);
									if(!$upload_id_proof_file){
										$dbstatus = FALSE;
										$dbmessage = 'Consumer Photo Upload Falied';
									}		
								}else{
									$dbstatus = FALSE;
									$dbmessage = 'Invalid Image format.It should not contain multiple dot(.) or 0) 2';
								}
							}else{
								$dbstatus = FALSE;
								$dbmessage = 'Please select Image format. 2';
							}
						}
						if($_FILES['file_installationphoto']['name'] == ''){
							if($data['hidinstallationphoto'] == ''){
								$installation_photo_store_path = "";
							}else{
								$installation_photo_store_path = $data['hidinstallationphoto'];
							}
						}else{
							$file_installation_photo = $_FILES['file_installationphoto']['name'];
							$allowed_mime_type_arr = array('image/jpg','image/png','image/jpeg','image/x-icon');
							$mime = get_mime_by_extension($file_installation_photo);
							$dot_count 	= substr_count($file_installation_photo,'.');
							$zero_count = substr_count($file_installation_photo,"%0");
							if(in_array($mime, $allowed_mime_type_arr)){
								if($zero_count == 0 && $dot_count == 1){
									$file_move_path  = FCPATH.'public/upload/consumer_upload';
									if(!is_dir($file_move_path))
		     							mkdir($file_move_path,0777,true);
		     						$installation_photo_store_path  = 'public/upload/consumer_upload/'.$file_installation_photo ;
		     						$upload_installation_photo_file = move_uploaded_file($_FILES['file_idproof']['tmp_name'],$installation_photo_store_path);
									if(!$upload_installation_photo_file){
										$dbstatus = FALSE;
										$dbmessage = 'Cusomer Photo Upload Falied';
									}	
								}else{
									$dbstatus = FALSE;
									$dbmessage = 'Invalid Image format.It should not contain multiple dot(.) or 0) 2';
								}
							}else{
								$dbstatus = FALSE;
								$dbmessage = 'Please select Image format. 2';
							}
						}
						$update_consumer = array(
							'name1' 			=>  $this->security->xss_clean($data['txt_firstName']),
							'name2' 			=>  $this->security->xss_clean($data['txt_MiddleName']),
							'name3' 			=>  $this->security->xss_clean($data['txt_LastName']),
							'father_name' 		=> 	$this->security->xss_clean($data['txt_fatherSpouse']),
							'caste'				=>	$this->security->xss_clean($data['cmb_casteCategory']),
							'phone1' 			=>	$this->security->xss_clean($data['txt_Landline']),
							'mobile1'			=>  $this->security->xss_clean($data['txt_MobileOne']),
							'mobile2' 			=>  $this->security->xss_clean($data['txt_MobileTwo']),
							'aadhar_no' 		=>  $this->security->xss_clean($data['txt_Aadhar']),
							'cu_email' 			=> 	$this->security->xss_clean($data['txt_email']),
							'alternate_id' 		=>  $this->security->xss_clean($data['txt_Alternate']),
							'gender' 			=>  $this->security->xss_clean($data['cmb_gender']),
							'acs' 				=> 	$this->security->xss_clean($data['cmb_acs']),
							'photo' 			=> 	$customer_photo_store_path,
							'id_proof' 			=> 	$id_proof_store_path,
							'installation_photo'=> 	$installation_photo_store_path,
							'updated_by' 		=> 	$this->user_name,
							'updated_at' 		=> 	$date
						);
						$this->db->where('id',$data['hidcust_id']);
						$result_customer = $this->db->update('customer',$update_consumer);
						$pp=isset($_POST['checkbox_powerplant'])?$this->security->xss_clean($data['checkbox_powerplant']):'0';
						$parent_id='';
						if($pp== '1'){
							$parent_id='';
						}else{
							$parent_id=$this->security->xss_clean($data['cmb_parentcustomer']);
						}
						if($result_customer){
							$update_transaction_header = array(
								'tr_scheme_id' => $this->security->xss_clean($data['cmb_scheme']),
								'tr_instal_id' => $this->security->xss_clean($data['cmb_installationClass']),
								'tr_supplier_id' => $this->security->xss_clean($data['cmb_vendorname']),
								'tr_customer_id' => $data['hidcust_id'],
								'landmark' => $this->security->xss_clean($data['txt_landmark']),
								'plot_no' =>  $this->security->xss_clean($data['txt_plotno']),
								'pincode' => $this->security->xss_clean($data['txt_pincode']),
								'census_code' => $this->security->xss_clean($data['txt_censuscode']),
								'habitation' => $this->security->xss_clean($data['txt_area']),
								'power_plant' => isset($_POST['checkbox_powerplant'])?$this->security->xss_clean($data['checkbox_powerplant']):'0',
								'tr_gps_code' => $gps_code,
								'revenue_village' =>  $this->security->xss_clean($data['cmb_revenuevillage']),
								'scheduled_week' =>  $this->security->xss_clean($data['cmb_scheduled_week']),
								'cd_block' => $this->security->xss_clean($data['cmb_cdblock']),
								'gp' => $this->security->xss_clean($data['cmb_grampanchayat']),
								'district' => $this->security->xss_clean($data['cmb_district']),
								'state' => $this->security->xss_clean($data['cmb_state']),
								'country' => $this->security->xss_clean($data['cmb_country']),
								'finance_source' => $this->security->xss_clean($data['cmb_finance_source']),
								'date_of_installation' => $this->security->xss_clean(date("Y-m-d", strtotime($data['txt_dateInstallation']))),
								'parent_customer_id' => $this->security->xss_clean($parent_id),
								'work_order' => $this->security->xss_clean($data['txtWorkOrder']),
								'sanction_no' => $this->security->xss_clean($data['cmb_sanctionletter']),
								'installation_cluster' => $this->security->xss_clean($data['cmb_districtcluster']),
								'schedule_month' => $this->security->xss_clean($data['cmb_maintenanceCluster']),
								'id_proof' => $id_proof_store_path,
								'installation_photo' => $installation_photo_store_path,
								'capacity' 	=> $this->security->xss_clean($data['txtTotalCapacity']),
								'unit' 		=> $this->security->xss_clean($data['txtUnit']),
								'updated_by' 		=> 	$this->user_name,
								'updated_at' 		=> 	$date
						  	);
						  	$this->db->where('id',$data['tranaction_id']);
							$result_transaction_header = $this->db->update('transaction_header',$update_transaction_header);
							if($result_transaction_header){
								$history_data = $this->db->query("INSERT INTO transaction_header_history 
									(id, consumer_id, tr_type, admin_dep, tr_scheme_id, tr_instal_id, tr_supplier_id, country, state, district, cd_block, gp, 
									revenue_village, habitation, landmark, tr_customer_id, date_of_charging, transaction_status, assign_to, plot_no, pincode, 
									census_code, tr_gps_code, capacity, unit, date_of_installation, power_plant, parent_customer_id, termination_date, 
									reason_termination, work_order, finance_source, mobile, id_proof, installation_photo, sanction_no, installation_cluster, 
									schedule_month, scheduled_week, DATE, remarks, approval_status, amc_letter_no, document, valid_from, valid_till, tr_status, 
									status_remarks, recce_date, material_site_date, installation_date, payment_made_date, tracking_installation, created_by, 
									created_at, updated_by, updated_at) SELECT * FROM transaction_header WHERE id='".$data['tranaction_id']."'");
								if($history_data){
									$transaction_id = $data['tranaction_id'];
									$this->db->trans_commit();
									$dbstatus = TRUE;
									$dbmessage = 'Data Update successfully';
								}else{
									$this->db->trans_rollback();
									$dbstatus = FALSE;
									$transaction_id = "";
									$dbmessage = 'Error While Saving History Data';
								}
							}else{
								$this->db->trans_rollback();
								$dbstatus = FALSE;
								$transaction_id = "";
								$dbmessage = 'Error While Transaction Data';
							}
						}else{
							$this->db->trans_rollback();
							$dbstatus = FALSE;
							$transaction_id = "";
							$dbmessage = 'Error While Customer Data';
						}
					}catch(Exception $e){
				      	$this->db->trans_rollback();
				      	$dbstatus = FALSE;
				      	$transaction_id = "";
				      	$dbmessage = $e->getMessage();
				    }
				    return array('status' => $dbstatus,'msg' => $dbmessage,'trans_id'=>$transaction_id); 
				break;
				case 'UPDATE_TRANSACTION_VIEW' :
				$gps_code ="";
					if($data['txt_longitudecode']!="" && $data['txt_latitudecode']!=""){
						$gps_code = $data['txt_longitudecode'] . "," . $data['txt_latitudecode'];
					}else{
						$gps_code ="";
					}
					$this->db->trans_begin();
					try{
						$file_customer_photo 		= "";
						$file_id_proof 		 		= "";
						$file_installation_photo 	= "";
						if($_FILES['file_customerphoto']['name'] == ''){
							if($data['hidcustomerphoto'] == '') {
								$customer_photo_store_path = "";
							}else{
								$customer_photo_store_path = $data['hidcustomerphoto'];
							}
						}else{
							$file_customer_photo = $_FILES['file_customerphoto']['name'];
							$allowed_mime_type_arr = array('image/jpg','image/png','image/jpeg','image/x-icon');
							$mime = get_mime_by_extension($file_customer_photo);
							$dot_count 	= substr_count($file_customer_photo,'.');
							$zero_count = substr_count($file_customer_photo,"%0");
							if(in_array($mime, $allowed_mime_type_arr)){
								if($zero_count == 0 && $dot_count == 1){
									$file_move_path  = FCPATH.'public/upload/consumer_upload';
									if(!is_dir($file_move_path))
		     							mkdir($file_move_path,0777,true);
		     						$customer_photo_store_path  = 'public/upload/consumer_upload/'.$file_customer_photo ;
		     						$upload_customer_photo = move_uploaded_file($_FILES['file_customerphoto']['tmp_name'],$customer_photo_store_path);
									if(!$upload_customer_photo){
										$dbstatus = FALSE;
										$dbmessage = 'Consumer Photo Upload Falied';
									}
								}else{
									$dbstatus = FALSE;
									$dbmessage = 'Invalid Image format.It should not contain multiple dot(.) or 0) 1';
								}
							}else{
								$dbstatus = FALSE;
								$dbmessage = 'Please select Image format.';
							}
						}
						if($_FILES['file_idproof']['name'] == ''){
							if($data['hididproof'] == ''){
								$id_proof_store_path = "";
							}else{
								$id_proof_store_path = $data['hididproof'];
							}
						}else{
							$file_id_proof = $_FILES['file_idproof']['name'];
							$allowed_mime_type_arr = array('image/jpg','image/png','image/jpeg','image/x-icon');
							$mime = get_mime_by_extension($file_id_proof);
							$dot_count 	= substr_count($file_id_proof,'.');
							$zero_count = substr_count($file_id_proof,"%0");
							if(in_array($mime, $allowed_mime_type_arr)){
								if($zero_count == 0 && $dot_count == 1){
									$file_move_path  = FCPATH.'public/upload/consumer_upload';
									if(!is_dir($file_move_path))
			     						mkdir($file_move_path,0777,true);
			     					$id_proof_store_path  = 'public/upload/consumer_upload/'.$file_id_proof ;
				     				$upload_id_proof_file = move_uploaded_file($_FILES['file_idproof']['tmp_name'],$id_proof_store_path);
									if(!$upload_id_proof_file){
										$dbstatus = FALSE;
										$dbmessage = 'Consumer Photo Upload Falied';
									}		
								}else{
									$dbstatus = FALSE;
									$dbmessage = 'Invalid Image format.It should not contain multiple dot(.) or 0) 2';
								}
							}else{
								$dbstatus = FALSE;
								$dbmessage = 'Please select Image format. 2';
							}
						}
						if($_FILES['file_installationphoto']['name'] == ''){
							if($data['hidinstallationphoto'] == ''){
								$installation_photo_store_path = "";
							}else{
								$installation_photo_store_path = $data['hidinstallationphoto'];
							}
						}else{
							$file_installation_photo = $_FILES['file_installationphoto']['name'];
							$allowed_mime_type_arr = array('image/jpg','image/png','image/jpeg','image/x-icon');
							$mime = get_mime_by_extension($file_installation_photo);
							$dot_count 	= substr_count($file_installation_photo,'.');
							$zero_count = substr_count($file_installation_photo,"%0");
							if(in_array($mime, $allowed_mime_type_arr)){
								if($zero_count == 0 && $dot_count == 1){
									$file_move_path  = FCPATH.'public/upload/consumer_upload';
									if(!is_dir($file_move_path))
		     							mkdir($file_move_path,0777,true);
		     						$installation_photo_store_path  = 'public/upload/consumer_upload/'.$file_installation_photo ;
		     						$upload_installation_photo_file = move_uploaded_file($_FILES['file_idproof']['tmp_name'],$installation_photo_store_path);
									if(!$upload_installation_photo_file){
										$dbstatus = FALSE;
										$dbmessage = 'Cusomer Photo Upload Falied';
									}	
								}else{
									$dbstatus = FALSE;
									$dbmessage = 'Invalid Image format.It should not contain multiple dot(.) or 0) 2';
								}
							}else{
								$dbstatus = FALSE;
								$dbmessage = 'Please select Image format. 2';
							}
						}
						$update_consumer = array(
							'name1' 			=>  $this->security->xss_clean($data['txt_firstName']),
							'name2' 			=>  $this->security->xss_clean($data['txt_MiddleName']),
							'name3' 			=>  $this->security->xss_clean($data['txt_LastName']),
							'father_name' 		=> 	$this->security->xss_clean($data['txt_fatherSpouse']),
							'caste'				=>	$this->security->xss_clean($data['cmb_casteCategory']),
							'phone1' 			=>	$this->security->xss_clean($data['txt_Landline']),
							'mobile1'			=>  $this->security->xss_clean($data['txt_MobileOne']),
							'mobile2' 			=>  $this->security->xss_clean($data['txt_MobileTwo']),
							'aadhar_no' 		=>  $this->security->xss_clean($data['txt_Aadhar']),
							'cu_email' 			=> 	$this->security->xss_clean($data['txt_email']),
							'alternate_id' 		=>  $this->security->xss_clean($data['txt_Alternate']),
							'gender' 			=>  $this->security->xss_clean($data['cmb_gender']),
							'acs' 				=> 	$this->security->xss_clean($data['cmb_acs']),
							'photo' 			=> 	$customer_photo_store_path,
							'id_proof' 			=> 	$id_proof_store_path,
							'installation_photo'=> 	$installation_photo_store_path,
							'updated_by' 		=> 	$this->user_name,
							'updated_at' 		=> 	$date
						);
						$this->db->where('id',$data['hidcust_id']);
						$result_customer = $this->db->update('customer',$update_consumer);
						if($result_customer){
							$update_transaction_header = array(
								'tr_customer_id' => $data['hidcust_id'],
								'landmark' => $this->security->xss_clean($data['txt_landmark']),
								'plot_no' =>  $this->security->xss_clean($data['txt_plotno']),
								'pincode' => $this->security->xss_clean($data['txt_pincode']),
								'census_code' => $this->security->xss_clean($data['txt_censuscode']),
								'habitation' => $this->security->xss_clean($data['txt_area']),
								'power_plant' => isset($_POST['checkbox_powerplant'])?$this->security->xss_clean($data['checkbox_powerplant']):'0',
								'tr_gps_code' => $gps_code,
								'revenue_village' =>  $this->security->xss_clean($data['cmb_revenuevillage']),
								'scheduled_week' =>  $this->security->xss_clean($data['cmb_scheduled_week']),
								'cd_block' => $this->security->xss_clean($data['cmb_cdblock']),
								'gp' => $this->security->xss_clean($data['cmb_grampanchayat']),
								'district' => $this->security->xss_clean($data['cmb_district']),
								'state' => $this->security->xss_clean($data['cmb_state']),
								'country' => $this->security->xss_clean($data['cmb_country']),
								'date_of_installation' => $this->security->xss_clean(date("Y-m-d", strtotime($data['txt_dateInstallation']))),
								//'parent_customer_id' => $this->security->xss_clean($data['cmb_parentcustomer']),
								'work_order' => $this->security->xss_clean($data['txtWorkOrder']),
								'installation_cluster' => $this->security->xss_clean($data['cmb_districtcluster']),
								'schedule_month' => $this->security->xss_clean($data['cmb_maintenanceCluster']),
								'id_proof' => $id_proof_store_path,
								'installation_photo' => $installation_photo_store_path,
								'capacity' 	=> $this->security->xss_clean($data['txtTotalCapacity']),
								'unit' 		=> $this->security->xss_clean($data['txtUnit']),
								'updated_by' 		=> 	$this->user_name,
								'updated_at' 		=> 	$date
						  	);
						  	$this->db->where('id',$data['tranaction_id']);
							$result_transaction_header = $this->db->update('transaction_header',$update_transaction_header);
							if($result_transaction_header){
								$history_data = $this->db->query("INSERT INTO transaction_header_history 
									(id, consumer_id, tr_type, admin_dep, tr_scheme_id, tr_instal_id, tr_supplier_id, country, state, district, cd_block, gp, 
									revenue_village, habitation, landmark, tr_customer_id, date_of_charging, transaction_status, assign_to, plot_no, pincode, 
									census_code, tr_gps_code, capacity, unit, date_of_installation, power_plant, parent_customer_id, termination_date, 
									reason_termination, work_order, finance_source, mobile, id_proof, installation_photo, sanction_no, installation_cluster, 
									schedule_month, scheduled_week, DATE, remarks, approval_status, amc_letter_no, document, valid_from, valid_till, tr_status, 
									status_remarks, recce_date, material_site_date, installation_date, payment_made_date, tracking_installation, created_by, 
									created_at, updated_by, updated_at) SELECT * FROM transaction_header WHERE id='".$data['tranaction_id']."'");
								if($history_data){
									$transaction_id = $data['tranaction_id'];
									$this->db->trans_commit();
									$dbstatus = TRUE;
									$dbmessage = 'Data Update successfully';
								}else{
									$this->db->trans_rollback();
									$dbstatus = FALSE;
									$transaction_id = "";
									$dbmessage = 'Error While Saving History Data';
								}
							}else{
								$this->db->trans_rollback();
								$dbstatus = FALSE;
								$transaction_id = "";
								$dbmessage = 'Error While Transaction Data';
							}
						}else{
							$this->db->trans_rollback();
							$dbstatus = FALSE;
							$transaction_id = "";
							$dbmessage = 'Error While Customer Data';
						}
					}catch(Exception $e){
				      	$this->db->trans_rollback();
				      	$dbstatus = FALSE;
				      	$transaction_id = "";
				      	$dbmessage = $e->getMessage();
				    }
				    return array('status' => $dbstatus,'msg' => $dbmessage,'trans_id'=>$transaction_id); 
				break;
				case 'ADD_ATTRIBUTE_DETAILS':
					$this->db->trans_begin();
					try{
						$trans_details_id = $this->security->xss_clean($data['trans_details_id']);
						$result = $this->db->query("SELECT cd.id,cd.components_id,cd.attribute,gcd.description AS attribute_name,nxt_sl FROM 
							components_details cd LEFT JOIN gen_code_desc gcd ON 
							cd.attribute = gcd.gen_code AND gen_code_group = 'ATTRIBUTE'
							LEFT JOIN transaction_details td ON cd.components_id=td.tr_component_id
							JOIN (SELECT IFNULL(MAX(sl_no),0)+1 AS nxt_sl FROM transaction_component_value WHERE transaction_details_id='".$trans_details_id."') s
							WHERE td.id='".$trans_details_id."'");
						$comp_data = $result->result_array();
						for($k=0;$k < sizeof($comp_data);$k++){
							$insert_data[] = array(
								'transaction_details_id' => $trans_details_id,
								'sl_no' => $comp_data[$k]['nxt_sl'],
								'components_detail_id' => $comp_data[$k]['attribute'],
								'attribute_values' => $data[$comp_data[$k]['components_id']."-".$comp_data[$k]['id']],
								'created_by' 	  => $this->user_name,
								'created_at' 	  => $date
						  	);
						}
						$insert_transaction_component_value = $this->db->insert_batch('transaction_component_value',$insert_data);
						if($insert_transaction_component_value){
							$this->db->trans_commit();
							$dbstatus = TRUE;
							$dbmessage = 'Data Save successfully';
						}else{
							$this->db->trans_rollback();
							$dbstatus = FALSE;
							$dbmessage = 'Error While Saving';
						}
					}catch(Exception $e){
						$this->db->trans_rollback();
				      	$dbstatus = FALSE;
				      	$dbmessage = $e->getMessage();
					}
					return array('status' => $dbstatus,'msg' => $dbmessage); 
				break;
				case 'EDIT_ATTRIBUTE_DETAILS':
					$this->db->trans_begin();
					try{
						$trans_details_id = $this->security->xss_clean($data['hid_transaction_details_id']);
						$sl_no = $this->security->xss_clean($data['hsl']);
						
						$this->db->from("transaction_component_value");
						$this->db->select("components_detail_id");
						$this->db->where("transaction_details_id",$trans_details_id);
						$this->db->where("sl_no",$sl_no);
						$result_data =  $this->db->get()->result_array();
						for($k=0;$k < sizeof($result_data);$k++){
							$update_data = array(
								'attribute_values' => $data[$result_data[$k]['components_detail_id']],
								'updated_by'	   => $this->user_name,
								'updated_at' 	   => $date
							);
							$this->db->where('components_detail_id',$result_data[$k]['components_detail_id']);
							$this->db->where('sl_no',$sl_no);
							$this->db->where('transaction_details_id',$trans_details_id);
							$update_transaction_component_value = $this->db->update('transaction_component_value',$update_data);
						}
						
						if($update_transaction_component_value){
							$this->db->trans_commit();
							$dbstatus = TRUE;
							$dbmessage = 'Data Update successfully';
						}else{
							$this->db->trans_rollback();
							$dbstatus = FALSE;
							$dbmessage = 'Error While Saving';
						}
					}catch(Exception $e){
						$this->db->trans_rollback();
				      	$dbstatus = FALSE;
				      	$dbmessage = $e->getMessage();
					}
					return array('status' => $dbstatus,'msg' => $dbmessage); 
				break;
				case 'project_track_status':
					$this->db->trans_begin();
					try{
						switch($data['hidtrack_ins']):
							case 1:
								$update_data = array('recce_date'=>date("Y-m-d", strtotime($data['txtTrackingDate'])),'tracking_installation'=>2);
							break;
							case 2:
								$update_data = array('material_site_date'=>date("Y-m-d", strtotime($data['txtTrackingDate'])),'tracking_installation'=>3);
							break;
							case 3:
								$update_data = array('installation_date'=>date("Y-m-d", strtotime($data['txtTrackingDate'])),'tracking_installation'=>4);
							break;
							case 4:
								$update_data = array('payment_made_date'=>date("Y-m-d", strtotime($data['txtTrackingDate'])),'tracking_installation'=>5);
							break;	
						endswitch;
						$this->db->where('id',$data['hidtrack_trans_id']);
						$update_transaction_header = $this->db->update('transaction_header',$update_data);
						if($update_transaction_header){
							$this->db->trans_commit();
							$dbstatus = TRUE;
							$dbmessage = 'Data Update successfully';
						}else{
							$this->db->trans_rollback();
							$dbstatus = FALSE;
							$dbmessage = 'Error While Saving';
						}
					
					}catch(Exception $e){
						$this->db->trans_rollback();
				      	$dbstatus = FALSE;
				      	$dbmessage = $e->getMessage();
					}
					return array('status' => $dbstatus,'msg' => $dbmessage); 
				break;
				case 'delete_transaction':
	        	$dbstatus = TRUE;
            	$dbmessage = 'Data deleted successfully';
            	$trans_id = $this->input->post('trans_id');
            	
           		$result = $this->db->query("SELECT id FROM transaction_details WHERE tr_header_id='".$trans_id."'");
				$comp_data = $result->row_array();
				
				$result = $this->db->query("SELECT tr_customer_id FROM transaction_header WHERE id='".$trans_id."'");
				$customer_data = $result->row_array();
				
				$this->db->where('id', $this->input->post('trans_id'));
				$this->db->delete('transaction_header');
				
				if($deletetransac = $this->db->affected_rows()){
					$this->db->where('tr_header_id', $this->input->post('trans_id'));
					$this->db->delete('transaction_details');
					$transdetailsresult= $this->db->affected_rows();
				}
				if($transdetailsresult){
					$this->db->where('id', $customer_data['tr_customer_id']);
					$this->db->delete('customer');
					$customerresult= $this->db->affected_rows();
				}
				if($customerresult){
					$this->db->where('transaction_details_id', $comp_data['id']);
					$this->db->delete('transaction_component_value');
					$valueresult= $this->db->affected_rows();
				}
				
				if ($customerresult)
	                return array('status' => $dbstatus, 'msg' => $dbmessage);
                else 
                	return array('status' => 'FAILURE', 'msg' => 'Error while deleting');
				break;
				default:
	            	return array('status' => false, 'msg' =>'Unable to load.Contact Support');	
			}
		}
  	}