<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	require_once APPPATH."third_party/phpmailer/class.phpmailer.php";
   	class Service_request_model extends CI_Model{
  		function __construct(){
    		parent::__construct();
    		
    		# helper
    		$this->load->helper('date');
	        $this->load->helper('send_email');
	        
	        if (ENVIRONMENT == 'production') {
	            $this->db->save_queries = FALSE;
	        }
	        date_default_timezone_set('Asia/Kolkata');
			$date = date('Y-m-d H:i:s', time());
	        
	        $this->role 		= $this->session->userdata('role');
	        $this->user_name 	= $this->session->userdata('user_name');
	        $this->user_code 	= $this->session->userdata('user_code');
 	 	}
 	 	public function get($data ,$op){
			date_default_timezone_set('Asia/Kolkata');
			$date = date('Y-m-d H:i:s', time());
			switch($op){
	            case 'get_schedule_ticket_count':
					$sql = $this->db->query("SELECT IFNULL(gen_code,'Total') gen_code,SUM(IFNULL(tkt_cnt,0)) AS tkt_cnt 
					FROM (SELECT * FROM ( SELECT CAST(gen_code AS CHAR) gen_code,sl_no 
					FROM gen_code_desc WHERE gen_code_group='TKT_TYPE_POINT' ) a 
					LEFT JOIN (SELECT COUNT(*) AS tkt_cnt ,t_type 
					FROM ( 
					SELECT a.id,month_id,month_name,qtr_id,a.mc,dc,dist_code,block_code,'".$data['year']."' AS yr,LPAD(fy_mth_code,2,0) AS mc_code,'Y' AS t_type  
					FROM schedule_mth_qtr_mc a 
					LEFT JOIN schedule_mc_dc_block b ON a.mc=b.mc
					WHERE  a.month_id='".$data['month']."' AND is_yrly=1
					UNION ALL
					SELECT a.id,month_id,month_name,qtr_id,a.mc,dc,dist_code,block_code,'".$data['year']."' AS yr,LPAD(fy_mth_code,2,0) AS mc_code,'H' AS t_type  
					FROM schedule_mth_qtr_mc a 
					LEFT JOIN schedule_mc_dc_block b ON a.mc=b.mc
					WHERE  a.month_id='".$data['month']."' AND is_half=1
					UNION ALL
					SELECT a.id,month_id,month_name,qtr_id,a.mc,dc,dist_code,block_code,'".$data['year']."' AS yr,LPAD(fy_mth_code,2,0) AS mc_code,'Q' AS t_type  
					FROM schedule_mth_qtr_mc a 
					LEFT JOIN schedule_mc_dc_block b ON a.mc=b.mc
					WHERE  a.month_id='".$data['month']."' AND is_qtr=1
					ORDER BY id) a
					LEFT JOIN 
					(SELECT d.id AS sd,d.consumer_id,d.admin_dep,d.tr_scheme_id,d.tr_instal_id,e.supplier_code,f.block_code AS cd_block,gp,d.tr_customer_id 
					,d.tr_supplier_id,CONCAT(IF(IFNULL(d.landmark,'')='','',CONCAT(d.landmark,',')),IF(IFNULL(d.habitation,'')='','',CONCAT(d.habitation,',')),
					v.village_name) AS habitation,scheduled_week
					FROM transaction_header d LEFT JOIN supplier e ON d.tr_supplier_id=e.supplier_code LEFT JOIN block_master f ON d.cd_block=f.block_code 
					LEFT JOIN village_master v ON d.revenue_village=v.pk_village_code LEFT JOIN gp_master g ON d.gp=g.pk_gp_code 
					WHERE transaction_status!='cancelled' AND tr_status NOT IN ('SUSPEND','ABANDONED') AND consumer_id IS NOT NULL ORDER BY `tr_supplier_id`,`district`,d.cd_block)
					 b ON a.block_code=cd_block 
					WHERE tr_instal_id NOT IN (SELECT installation_id FROM schedule_approval 
					WHERE s_month='".$data['month']."' AND s_year='".$data['year']."') AND b.sd IS NOT NULL GROUP BY t_type) b ON a.gen_code=b.t_type 
					ORDER BY sl_no ASC) g
					GROUP BY gen_code WITH ROLLUP ");
				return $sql->result_array();
	            break;
	            /**
				* Name : Subhashree Jena
				* Date : 30-08-2019
				* @var 
				* Purpose : Get Amc Expiry Report
				*/
				case 'get_amc_expiry':
					$order = '';
	                $Ocolumn = '';
	                $Odir = '';
	                $order = $this->input->post('order');
	                if ($order) {
	                    foreach ($order as $row) {
	                        $Ocolumn = $row['column'];
	                        $Odir = $row['dir'];
	                    }
	                    $this->db->order_by($Ocolumn, $Odir);
	                } else {
	                    $this->db->order_by(1, "ASC");
	                }
	                $search = $this->input->post('search');
	                $header = array('scheme_code');//search filter will work on this column
	               	$filter_string="";
	                if ($search['value'] != '') {
	                    for ($i = 0; $i < count($header); $i++) {
	                       $filter_string.=' or '.$header[$i]." LIKE '%".$search['value']."%'";
	                    }
	                    $filter_string=substr($filter_string,3);
	                    $filter_string='where'.$filter_string ;
	                }

	                $iDisplayLength = $this->input->post('length');//to shw number of record to be shown
	                $iDisplayStart = $this->input->post('start');//to start from that position (ex: offset)

	                $this->db->limit($iDisplayLength, $iDisplayStart);
					$query_one = $this->db->query("SELECT scheme_code,IFNULL(a.w1,0) AS w1,IFNULL(a.w2,0) AS w2,IFNULL(a.w3,0) AS w3,
						IFNULL(a.w4,0) AS w4,IFNULL(b.w1,0) AS q1,IFNULL(b.w2,0) AS q2,IFNULL(b.w3,0) AS q3,
						IFNULL(b.w4,0) AS q4,
						CONCAT('Q1_',YEAR(NOW())) AS fy_qr1,CONCAT('Q2_',YEAR(NOW())) AS fy_qr2,CONCAT('Q3_',YEAR(NOW())) AS fy_qr3,
						CONCAT('Q4_',YEAR(NOW())) AS fy_qr4,CONCAT('Q1_',YEAR(NOW())+1) AS fy_qr5,CONCAT('Q2_',YEAR(NOW())+1) AS fy_qr6,
						CONCAT('Q3_',YEAR(NOW())+1) AS fy_qr7,CONCAT('Q4_',YEAR(NOW())+1) AS fy_qr8 ,
						pk_scheme_code FROM scheme_header s LEFT JOIN 
						(SELECT tr_scheme_id,MAX(CASE WHEN wk=1 THEN cnt ELSE 0 END) AS w1,MAX(CASE WHEN wk=2 THEN cnt ELSE 0 END) AS w2,
						MAX(CASE WHEN wk=3 THEN cnt ELSE 0 END) AS w3,MAX(CASE WHEN wk=4 THEN cnt ELSE 0 END) AS w4 FROM 
						(
						SELECT tr_scheme_id,COUNT(*) AS cnt,CASE WHEN MONTH( th.valid_till) IN ('4','5','6') THEN 1 
						WHEN MONTH( th.valid_till) IN ('7','8','9') THEN 2  
						WHEN MONTH( th.valid_till) IN ('10','11','12') THEN 3  
						WHEN MONTH( th.valid_till) IN ('1','2','3') THEN 4  END AS wk  
						FROM transaction_header th WHERE YEAR( th.valid_till)=YEAR(NOW()) GROUP BY th.tr_scheme_id,wk) a
						GROUP BY tr_scheme_id)a ON s.pk_scheme_code=a.tr_scheme_id 
						LEFT JOIN 
						(SELECT tr_scheme_id,MAX(CASE WHEN wk=1 THEN cnt ELSE 0 END) AS w1,MAX(CASE WHEN wk=2 THEN cnt ELSE 0 END) AS w2,
						MAX(CASE WHEN wk=3 THEN cnt ELSE 0 END) AS w3,MAX(CASE WHEN wk=4 THEN cnt ELSE 0 END) AS w4 FROM 
						(
						SELECT tr_scheme_id,COUNT(*) AS cnt,CASE WHEN MONTH( th.valid_till) IN ('4','5','6') THEN 1 
						WHEN MONTH( th.valid_till) IN ('7','8','9') THEN 2  
						WHEN MONTH( th.valid_till) IN ('10','11','12') THEN 3  
						WHEN MONTH( th.valid_till) IN ('1','2','3') THEN 4  END AS wk  
						FROM transaction_header th WHERE YEAR( th.valid_till)=YEAR(NOW())+1 GROUP BY th.tr_scheme_id,wk) a
						GROUP BY tr_scheme_id)b  ON s.pk_scheme_code=b.tr_scheme_id $filter_string LIMIT $iDisplayLength OFFSET $iDisplayStart ");
					$res = $query_one->result_array();
					/*----FOR PAGINATION-----*/
					$query_two = $this->db->query("SELECT scheme_code,IFNULL(a.w1,0) AS w1,IFNULL(a.w2,0) AS w2,IFNULL(a.w3,0) AS w3,
						IFNULL(a.w4,0) AS w4,IFNULL(b.w1,0) AS q1,IFNULL(b.w2,0) AS q2,IFNULL(b.w3,0) AS q3,
						IFNULL(b.w4,0) AS q4,
						CONCAT('Q1_',YEAR(NOW())) AS fy_qr1,CONCAT('Q2_',YEAR(NOW())) AS fy_qr2,CONCAT('Q3_',YEAR(NOW())) AS fy_qr3,
						CONCAT('Q4_',YEAR(NOW())) AS fy_qr4,CONCAT('Q1_',YEAR(NOW())+1) AS fy_qr5,CONCAT('Q2_',YEAR(NOW())+1) AS fy_qr6,
						CONCAT('Q3_',YEAR(NOW())+1) AS fy_qr7,CONCAT('Q4_',YEAR(NOW())+1) AS fy_qr8 ,
						pk_scheme_code FROM scheme_header s LEFT JOIN 
						(SELECT tr_scheme_id,MAX(CASE WHEN wk=1 THEN cnt ELSE 0 END) AS w1,MAX(CASE WHEN wk=2 THEN cnt ELSE 0 END) AS w2,
						MAX(CASE WHEN wk=3 THEN cnt ELSE 0 END) AS w3,MAX(CASE WHEN wk=4 THEN cnt ELSE 0 END) AS w4 FROM 
						(
						SELECT tr_scheme_id,COUNT(*) AS cnt,CASE WHEN MONTH( th.valid_till) IN ('4','5','6') THEN 1 
						WHEN MONTH( th.valid_till) IN ('7','8','9') THEN 2  
						WHEN MONTH( th.valid_till) IN ('10','11','12') THEN 3  
						WHEN MONTH( th.valid_till) IN ('1','2','3') THEN 4  END AS wk  
						FROM transaction_header th WHERE YEAR( th.valid_till)=YEAR(NOW()) GROUP BY th.tr_scheme_id,wk) a
						GROUP BY tr_scheme_id)a ON s.pk_scheme_code=a.tr_scheme_id 
						LEFT JOIN 
						(SELECT tr_scheme_id,MAX(CASE WHEN wk=1 THEN cnt ELSE 0 END) AS w1,MAX(CASE WHEN wk=2 THEN cnt ELSE 0 END) AS w2,
						MAX(CASE WHEN wk=3 THEN cnt ELSE 0 END) AS w3,MAX(CASE WHEN wk=4 THEN cnt ELSE 0 END) AS w4 FROM 
						(
						SELECT tr_scheme_id,COUNT(*) AS cnt,CASE WHEN MONTH( th.valid_till) IN ('4','5','6') THEN 1 
						WHEN MONTH( th.valid_till) IN ('7','8','9') THEN 2  
						WHEN MONTH( th.valid_till) IN ('10','11','12') THEN 3  
						WHEN MONTH( th.valid_till) IN ('1','2','3') THEN 4  END AS wk  
						FROM transaction_header th WHERE YEAR( th.valid_till)=YEAR(NOW())+1 GROUP BY th.tr_scheme_id,wk) a
						GROUP BY tr_scheme_id)b  ON s.pk_scheme_code=b.tr_scheme_id $filter_string");
						$res1 = $query_two->result_array();
						$output["draw"] = intval($this->input->post('draw'));
		                $output['iTotalRecords'] = $query_two->num_rows();
		                $output['iTotalDisplayRecords'] = $query_two->num_rows();
	                $slno = $iDisplayStart+1;
	                foreach ($res as $aRow) {
	                    $row[0] = $slno;
	                    $row['sl_no'] = $slno;
	                    $i = 1;
	                    foreach ($aRow as $key => $value) {
	                        $row[$i] = $value;
	                        $row[$key] = $value;
	                        $i++;
	                    }
	                    $output['aaData'][] = $row;
	                    $slno++;
	                    unset($row);
	                }
	                return $output;
	            break;
	            /**
				* Name : Subhashree Jena
				* Date :31-08-2019
				* Purpose : Get Amc Expiry Report Details
				* @var 
				*/
				case 'get_amc_expiry_report_details':
					$explode = explode("_",$_POST['year']);
					$month = $explode[0];
					$year = $explode[1];
					
					$order = '';
	                $Ocolumn = '';
	                $Odir = '';
	                $page = $data['page'];
	                if($month == 'Q1'){
						$qmnth = '("4","5","6")';
					}
					if($month == 'Q2'){
						$qmnth = '("7","8","9")';
					}
					if($month == 'Q3'){
						$qmnth = '("10","11","12")';
					}
					if($month == 'Q4'){
						$qmnth = '("1","2","3")';
					}
	                
	                $output = array("aaData" => array());
	                $iDisplayLength = $this->input->post('length');//to shw number of record to be shown
		            $iDisplayStart = $this->input->post('start');
		            if($page ==  'ALL'){
		             	$query_one = $this->db->query("SELECT a.consumer_id ,CONCAT( IF(IFNULL(b.district_name,'')='','',CONCAT(b.district_name,',')),
							IF(IFNULL(c.block_name,'')='','',CONCAT(c.block_name,',')),
							IF(IFNULL(d.gp_name,'')='','',CONCAT(d.gp_name,',')),
							IF(IFNULL(e.village_name,'')='','',CONCAT(e.village_name,',')),
							IF(IFNULL(a.habitation,'')='','',CONCAT(a.habitation,','))) AS customer_address,a.tr_status,
							f.supplier_name,DATE_FORMAT(a.valid_till , '%d-%m-%Y') AS valid_till,a.tr_scheme_id
							FROM transaction_header a
							LEFT JOIN district_master b ON b.district_code = a.district
							LEFT JOIN block_master c ON c.block_code = a.cd_block
							LEFT JOIN gp_master d ON d.pk_gp_code = a.gp
							LEFT JOIN village_master e ON e.pk_village_code = a.revenue_village
							LEFT JOIN supplier f ON f.supplier_code = a.tr_supplier_id
							WHERE a.tr_scheme_id = '".$data['pk_scheme_code']."'
							AND YEAR( a.valid_till) = '".$year."'
							AND MONTH( a.valid_till) IN ".$qmnth." ");
						 $res = $query_one->result_array();	
		            	}else{
							$order = $this->input->post('order');
		                if ($order) {
		                    foreach ($order as $row) {
		                        $Ocolumn = $row['column'];
		                        $Odir = $row['dir'];
		                    }
		                    $this->db->order_by($Ocolumn, $Odir);
		                } else {
		                    $this->db->order_by(1, "ASC");
		                }
		                $search = $this->input->post('search');
		                $header = array('a.consumer_id');//search filter will work on this column
		                $filter_string="";
		                if ($search['value'] != '') {
		                    for ($i = 0; $i < count($header); $i++) {
		                       $filter_string.=' or '.$header[$i]." LIKE '%".$search['value']."%'";
		                    }
		                    $filter_string=substr($filter_string,3);
		                    $filter_string=' and ('.$filter_string.')';
		                }
						$query_one = $this->db->query("SELECT a.consumer_id ,CONCAT( IF(IFNULL(b.district_name,'')='','',CONCAT(b.district_name,',')),
							IF(IFNULL(c.block_name,'')='','',CONCAT(c.block_name,',')),
							IF(IFNULL(d.gp_name,'')='','',CONCAT(d.gp_name,',')),
							IF(IFNULL(e.village_name,'')='','',CONCAT(e.village_name,',')),
							IF(IFNULL(a.habitation,'')='','',CONCAT(a.habitation,','))) AS customer_address,a.tr_status,
							f.supplier_name,DATE_FORMAT(a.valid_till , '%d-%m-%Y') AS valid_till,a.tr_scheme_id
							FROM transaction_header a
							LEFT JOIN district_master b ON b.district_code = a.district
							LEFT JOIN block_master c ON c.block_code = a.cd_block
							LEFT JOIN gp_master d ON d.pk_gp_code = a.gp
							LEFT JOIN village_master e ON e.pk_village_code = a.revenue_village
							LEFT JOIN supplier f ON f.supplier_code = a.tr_supplier_id
							WHERE a.tr_scheme_id = '".$data['pk_scheme_code']."'
							AND YEAR( a.valid_till) = '".$year."'
							AND MONTH( a.valid_till) IN ".$qmnth." $filter_string LIMIT $iDisplayLength OFFSET $iDisplayStart ");
						 $res = $query_one->result_array();
							//print_r($this->db->last_query());die();
						 /*----FOR PAGINATION-----*/
						 $query_two = $this->db->query("SELECT a.consumer_id ,a.tr_scheme_id,CONCAT( IF(IFNULL(b.district_name,'')='','',CONCAT(b.district_name,',')),
							IF(IFNULL(c.block_name,'')='','',CONCAT(c.block_name,',')),
							IF(IFNULL(d.gp_name,'')='','',CONCAT(d.gp_name,',')),
							IF(IFNULL(e.village_name,'')='','',CONCAT(e.village_name,',')),
							IF(IFNULL(a.habitation,'')='','',CONCAT(a.habitation,','))) AS customer_address,a.tr_status,
							f.supplier_name,DATE_FORMAT(a.valid_till , '%d-%m-%Y') AS valid_till,a.tr_scheme_id
							FROM transaction_header a
							LEFT JOIN district_master b ON b.district_code = a.district
							LEFT JOIN block_master c ON c.block_code = a.cd_block
							LEFT JOIN gp_master d ON d.pk_gp_code = a.gp
							LEFT JOIN village_master e ON e.pk_village_code = a.revenue_village
							LEFT JOIN supplier f ON f.supplier_code = a.tr_supplier_id
							WHERE a.tr_scheme_id = '".$data['pk_scheme_code']."'
							AND YEAR( a.valid_till) = '".$year."'
							AND MONTH( a.valid_till) IN ".$qmnth." ");
						$res1 = $query_two->result_array();
						$output["draw"] = intval($this->input->post('draw'));
		                $output['iTotalRecords'] = $query_two->num_rows();
		                $output['iTotalDisplayRecords'] = $query_two->num_rows();
					}
	                $slno = $iDisplayStart+1;
	                foreach ($res as $aRow) {
	                    $row[0] = $slno;
	                    $row['sl_no'] = $slno;
	                    $i = 1;
	                    foreach ($aRow as $key => $value) {
	                        $row[$i] = $value;
	                        $row[$key] = $value;
	                        $i++;
	                    }
	                    $output['aaData'][] = $row;
	                    $slno++;
	                    unset($row);
	                }
	                return $output;
				break;
	            case 'get_ticket_gen_validation':
	            	$order = '';
	                $Ocolumn = '';
	                $Odir = '';
	                $order = $this->input->post('order');
	                if ($order) {
	                    foreach ($order as $row) {
	                        $Ocolumn = $row['column'];
	                        $Odir = $row['dir'];
	                    }
	                    $this->db->order_by($Ocolumn, $Odir);
	                } else {
	                    $this->db->order_by(1, "ASC");
	                }
	                $search = $this->input->post('search');
	                $header = array('consumer_id','inst_status');//search filter will work on this column
	                if ($search['value'] != '') {
	                    for ($i = 0; $i < count($header); $i++) {
	                        $this->db->or_like($header[$i], $search['value']);
	                    }
	                }

	                $iDisplayLength = $this->input->post('length');//to shw number of record to be shown
	                $iDisplayStart = $this->input->post('start');//to start from that position (ex: offset)

	                $this->db->limit($iDisplayLength, $iDisplayStart);
	               	$cond = '(consumer_id!="" OR consumer_id IS NOT NULL )';
			 		$cond1 = 'transaction_status NOT IN ("cancelled","submitted")';
			        $this->db->select('consumer_id,inst_status,status_remarks,transaction_status,id,tr_customer_id');
			        $this->db->from("(select consumer_id,CASE WHEN tr_status='CLOSE'||tr_status IS NULL THEN 'Working' 
					WHEN tr_status='OPEN'||tr_status='REOPEN' THEN 'Breakdown' ELSE tr_status END AS inst_status,status_remarks,transaction_status,id,tr_customer_id  from transaction_header)a");
			        $this->db->where($cond);
			        $this->db->where($cond1);
			        $this->db->order_by('id','DESC');
	                $query = $this->db->get()->result_array();
	                $output = array("aaData" => array());
	                /*----FOR PAGINATION-----*/
	                if ($search['value'] != '') {
	                    for ($i = 0; $i < count($header); $i++) {
	                        $this->db->or_like($header[$i], $search['value']);
	                    }
	                }
	                $cond = '(consumer_id!="" OR consumer_id IS NOT NULL ) ';
			 		$cond1 = 'transaction_status NOT IN ("cancelled","submitted")';
			         $this->db->select('consumer_id,inst_status,status_remarks,transaction_status,id,tr_customer_id');
			        $this->db->from("(select consumer_id,CASE WHEN tr_status='CLOSE'||tr_status IS NULL THEN 'Working' 
					WHEN tr_status='OPEN'||tr_status='REOPEN' THEN 'Breakdown' ELSE tr_status END AS inst_status,status_remarks,transaction_status,id,tr_customer_id  from transaction_header)a");
			        $this->db->where($cond);
			        $this->db->where($cond1);
			        $this->db->order_by('id','DESC');
	                $res1 = $this->db->get();
	                $output["draw"] = intval($this->input->post('draw'));
	                $output['iTotalRecords'] = $res1->num_rows();
	                $output['iTotalDisplayRecords'] = $res1->num_rows();
	                $slno = $iDisplayStart +1;
	                foreach ($query as $aRow) {
	                    $row[0] = $slno;
	                    $row['sl_no'] = $slno;
	                    $i = 1;
	                    foreach ($aRow as $key => $value) {
	                        $row[$i] = $value;
	                        $row[$key] = $value;
	                        $i++;
	                    }
	                    $output['aaData'][] = $row;
	                    $slno++;
	                    unset($row);
	                }
	                return $output;
	            break;
	            /**
				* 
				* Name:Siddhartha 
				* Modified_on:29-08-19
				* Purpose: Scheme Filter Modification
				* 
				* 
				* 
				*/
	            case 'get_amc_validation':
	            //print_r($data); die();
					$order = '';
	                $Ocolumn = '';
	                $Odir = '';
	                $output = array("aaData" => array());
	                $page = $data['page'];
	                $iDisplayLength = $this->input->post('length');//to shw number of record to be shown
		            $iDisplayStart = $this->input->post('start');//to start from that position (ex: offset)
	                if($page ==  'ALL'){
		               	$this->db->select("th.consumer_id,sh.scheme_name,CASE WHEN (CURDATE() > (th.valid_till)) THEN 'Invalid'
						WHEN (CURDATE() <= (th.valid_till)) THEN 'valid' ELSE 'not valid' END AS STATUS,
						DATE_FORMAT(th.valid_from, '%d-%m-%Y') AS valid_from, DATE_FORMAT(th.valid_till, '%d-%m-%Y') AS valid_till,  
						th.tr_customer_id, th.tr_scheme_id,  th.tr_instal_id, ich.instal_cls_name, th.date_of_installation, 
						CONCAT(b.name1, ' ', b.name2, '', b.name3) AS customer_name");
				        $this->db->from('transaction_header th');
				        $this->db->join('customer b', 'th.tr_customer_id = b.id', 'left');
				        $this->db->join('scheme_header sh', 'th.tr_scheme_id = sh.id', 'left');
				        $this->db->join('installation_class_header ich', 'th.tr_instal_id = ich.id', 'left');
				        $this->db->where('th.consumer_id !=', '');
				        $this->db->where('th.date_of_installation !=', '');
	        			if($data['scheme_id'] != ''){
						$this->db->where('th.tr_scheme_id',$data['scheme_id']);
					}
					$this->db->order_by('th.consumer_id' , 'DESC');
		               
			        $query = $this->db->get()->result_array();
		               // print_r($this->db->last_query());die();
		            }else{
	                $order = $this->input->post('order');
	                if ($order) {
	                    foreach ($order as $row) {
	                        $Ocolumn = $row['column'];
	                        $Odir = $row['dir'];
	                    }
	                    $this->db->order_by($Ocolumn, $Odir);
	                } else {
	                    $this->db->order_by(1, "ASC");
	                }
	                $search = $this->input->post('search');
	                $header = array('consumer_id');//search filter will work on this column
	                $filter_string="";
	                if ($search['value'] != '') {
	                    for ($i = 0; $i < count($header); $i++) {
	                       $filter_string.=' or '.$header[$i]." LIKE '%".$search['value']."%'";
	                    }
	                    $filter_string=substr($filter_string,3);
	                    $filter_string='('.$filter_string.')';
	                }

	                $iDisplayLength = $this->input->post('length');//to shw number of record to be shown
	                $iDisplayStart = $this->input->post('start');//to start from that position (ex: offset)

	                $this->db->limit($iDisplayLength, $iDisplayStart);
	               	$this->db->select("th.consumer_id,sh.scheme_name,CASE WHEN (CURDATE() > (th.valid_till)) THEN 'Invalid'
					WHEN (CURDATE() <= (th.valid_till)) THEN 'valid' ELSE 'not valid' END AS STATUS,
					DATE_FORMAT(th.valid_from, '%d-%m-%Y') AS valid_from, DATE_FORMAT(th.valid_till, '%d-%m-%Y') AS valid_till,  
					th.tr_customer_id, th.tr_scheme_id,  th.tr_instal_id, ich.instal_cls_name, th.date_of_installation, 
					CONCAT(b.name1, ' ', b.name2, '', b.name3) AS customer_name");
			        $this->db->from('transaction_header th');
			        $this->db->join('customer b', 'th.tr_customer_id = b.id', 'left');
			        $this->db->join('scheme_header sh', 'th.tr_scheme_id = sh.id', 'left');
			        $this->db->join('installation_class_header ich', 'th.tr_instal_id = ich.id', 'left');
			        $this->db->where('th.consumer_id !=', '');
			        $this->db->where('th.date_of_installation !=', '');
        			$this->db->order_by('th.consumer_id' , 'DESC');
        			if($filter_string!=''){
						$this->db->where($filter_string);
					}
					if($data['scheme_id'] != ''){
						$this->db->where('th.tr_scheme_id',$data['scheme_id']);
					}
	                $query = $this->db->get()->result_array();
	                //print_r($this->db->last_query());die();
	                $output = array("aaData" => array());
	                /*----FOR PAGINATION-----*/
	                if ($search['value'] != '') {
	                    for ($i = 0; $i < count($header); $i++) {
	                        $this->db->or_like($header[$i], $search['value']);
	                    }
	                }
	               	$this->db->select("th.consumer_id,sh.scheme_name,CASE WHEN (CURDATE() > (th.valid_till)) THEN 'Invalid'
					WHEN (CURDATE() <= (th.valid_till)) THEN 'valid' ELSE 'not valid' END AS STATUS,
					DATE_FORMAT(th.valid_from, '%d-%m-%Y') AS valid_from, DATE_FORMAT(th.valid_till, '%d-%m-%Y') AS valid_till,  
					th.tr_customer_id, th.tr_scheme_id,  th.tr_instal_id, ich.instal_cls_name, th.date_of_installation, 
					CONCAT(b.name1, ' ', b.name2, '', b.name3) AS customer_name");
			        $this->db->from('transaction_header th');
			        $this->db->join('customer b', 'th.tr_customer_id = b.id', 'left');
			        $this->db->join('scheme_header sh', 'th.tr_scheme_id = sh.id', 'left');
			        $this->db->join('installation_class_header ich', 'th.tr_instal_id = ich.id', 'left');
			        $this->db->where('th.consumer_id !=', ' ');
			        $this->db->where('th.date_of_installation !=', ' ');
        			$this->db->order_by('th.consumer_id' , 'DESC');
        			if($filter_string!=''){
						$this->db->where($filter_string);
					}
					if($data['scheme_id'] != ''){
						$this->db->where('th.tr_scheme_id',$data['scheme_id']);
					}
	                $res1 = $this->db->get();
	                $output["draw"] = intval($this->input->post('draw'));
	                $output['iTotalRecords'] = $res1->num_rows();
	                $output['iTotalDisplayRecords'] = $res1->num_rows();
		            }
	                $slno = $iDisplayStart +1;
	                foreach ($query as $aRow) {
	                    $row[0] = $slno;
	                    $row['sl_no'] = $slno;
	                    $i = 1;
	                    foreach ($aRow as $key => $value) {
	                        $row[$i] = $value;
	                        $row[$key] = $value;
	                        $i++;
	                    }
	                    $output['aaData'][] = $row;
	                    $slno++;
	                    unset($row);
	                }
	                return $output;
	            break;
	            case 'get_amc_history':
					$order = '';
	                $Ocolumn = '';
	                $Odir = '';
	                $order = $this->input->post('order');
	                if ($order) {
	                    foreach ($order as $row) {
	                        $Ocolumn = $row['column'];
	                        $Odir = $row['dir'];
	                    }
	                    $this->db->order_by($Ocolumn, $Odir);
	                } else {
	                    $this->db->order_by(1, "ASC");
	                }
	                $search = $this->input->post('search');
	                $header = array('consumer_id');//search filter will work on this column
	                if ($search['value'] != '') {
	                    for ($i = 0; $i < count($header); $i++) {
	                        $this->db->or_like($header[$i], $search['value']);
	                    }
	                }

	                $iDisplayLength = $this->input->post('length');//to shw number of record to be shown
	                $iDisplayStart = $this->input->post('start');//to start from that position (ex: offset)

	                $this->db->limit($iDisplayLength, $iDisplayStart);
	               	$this->db->select("consumer_id,case when (CURDATE() > (valid_till)) then 'Invalid'
					when (CURDATE() < (valid_till)) then 'valid' else 'not valid' end as status,dATE_FORMAT(valid_from,'%d-%m-%Y') AS valid_from,
					dATE_FORMAT(valid_till,'%d-%m-%Y') AS valid_till,amc_letter_no,document");
			        $this->db->from('amc_history');
			        $this->db->where('consumer_id',$data['custom_no']);
	                $query = $this->db->get()->result_array();
	                //print_r($this->db->last_query());die();
	                $output = array("aaData" => array());
	                /*----FOR PAGINATION-----*/
	                if ($search['value'] != '') {
	                    for ($i = 0; $i < count($header); $i++) {
	                        $this->db->or_like($header[$i], $search['value']);
	                    }
	                }
	               	$this->db->select("consumer_id,case when (CURDATE() > (valid_till)) then 'Invalid'
					when (CURDATE() < (valid_till)) then 'valid' else 'not valid' end as status,dATE_FORMAT(valid_from,'%d-%m-%Y') AS valid_from,
					dATE_FORMAT(valid_till,'%d-%m-%Y') AS valid_till,amc_letter_no,document");
			        $this->db->from('amc_history');
			        $this->db->where('consumer_id',$data['custom_no']);
	                $res1 = $this->db->get();
	                $output["draw"] = intval($this->input->post('draw'));
	                $output['iTotalRecords'] = $res1->num_rows();
	                $output['iTotalDisplayRecords'] = $res1->num_rows();
	                $slno = $iDisplayStart +1;
	                foreach ($query as $aRow) {
	                    $row[0] = $slno;
	                    $row['sl_no'] = $slno;
	                    $i = 1;
	                    foreach ($aRow as $key => $value) {
	                        $row[$i] = $value;
	                        $row[$key] = $value;
	                        $i++;
	                    }
	                    $output['aaData'][] = $row;
	                    $slno++;
	                    unset($row);
	                }
	                return $output;
	            break;
	            case 'get_sm_control':
	            	$order = '';
	                $Ocolumn = '';
	                $Odir = '';
	                $order = $this->input->post('order');
	                
	                if ($order) {
	                    foreach ($order as $row) {
	                        $Ocolumn = $row['column'];
	                        $Odir = $row['dir'];
	                    }
	                    $this->db->order_by($Ocolumn, $Odir);
	                } else {
	                    $this->db->order_by(1, "ASC");
	                }
	                $search = $this->input->post('search');
	                $header = array('gcd.description');//search filter will work on this column
	                if ($search['value'] != '') {
	                    for ($i = 0; $i < count($header); $i++) {
	                        $this->db->or_like($header[$i], $search['value']);
	                    }
	                }

	                $iDisplayLength = $this->input->post('length');//to shw number of record to be shown
	                $iDisplayStart = $this->input->post('start');//to start from that position (ex: offset)

	                $this->db->limit($iDisplayLength, $iDisplayStart);
	               	/*$cond = '(gen_code_group = "MONTH")';
			        $this->db->select("gcd.description AS MONTH,sa.s_year,COUNT(sa.installation_id) AS total_install,sa.s_month");
			        $this->db->from('schedule_approval sa');
			        $this->db->join('gen_code_desc gcd ', 'gcd.gen_code = sa.s_month', 'left');
			        $this->db->where($cond);
			        $this->db->group_by('sa.s_year,sa.s_month');
	                $query = $this->db->get()->result_array();
	                $output = array("aaData" => array());*/
	                $cond = '(gen_code_group = "MONTH")';
			        $this->db->select("gcd.description AS MONTH,c_year AS s_year,IFNULL(total_install,0) AS total_install,month_code AS s_month");
			        
			        $this->db->from("(SELECT DISTINCT  MONTH(dte) AS month_code,YEAR(dte) AS c_year FROM 
									( SELECT '2019-04-01' + INTERVAL 1000*a +100*b+10*c+e DAY dte FROM
									(SELECT 0 a UNION SELECT 1 a UNION SELECT 2 UNION SELECT 3
									UNION SELECT 4 UNION SELECT 5 UNION SELECT 6 UNION SELECT 7
									UNION SELECT 8 UNION SELECT 9 ) d,
									(SELECT 0 b UNION SELECT 1 b UNION SELECT 2 UNION SELECT 3
									UNION SELECT 4 UNION SELECT 5 UNION SELECT 6 UNION SELECT 7
									UNION SELECT 8 UNION SELECT 9) m, 
									(SELECT 0 c UNION SELECT 1 c UNION SELECT 2 UNION SELECT 3
									UNION SELECT 4 UNION SELECT 5 UNION SELECT 6 UNION SELECT 7
									UNION SELECT 8 UNION SELECT 9) n,
									(SELECT 0 e UNION SELECT 1 e UNION SELECT 2 UNION SELECT 3
									UNION SELECT 4 UNION SELECT 5 UNION SELECT 6 UNION SELECT 7
									UNION SELECT 8 UNION SELECT 9) p
									ORDER BY 1000*a +100*b+10*c+e )f WHERE dte< DATE_ADD(NOW(),INTERVAL 1 MONTH) ORDER BY c_year DESC,month_code DESC) st");
			        $this->db->join('gen_code_desc gcd ', 'gcd.gen_code = st.month_code AND gen_code_group = "MONTH"', 'left');
			        $this->db->join('(SELECT s_year, COUNT(installation_id) AS total_install, s_month FROM  schedule_approval GROUP BY s_year,s_month) sa ', 'st.c_year=sa.s_year AND st.month_code=sa.s_month', 'left');
			        $this->db->where($cond);
			        $this->db->order_by('c_year','DESC');
			        $this->db->order_by('month_code','DESC');
	                $query = $this->db->get()->result_array();
	                $output = array("aaData" => array());
	                
	                /*----FOR PAGINATION-----*/
	                if ($search['value'] != '') {
	                    for ($i = 0; $i < count($header); $i++) {
	                        $this->db->or_like($header[$i], $search['value']);
	                    }
	                }
	                $cond = '(gen_code_group = "MONTH")';
			        $this->db->select("gcd.description AS MONTH,c_year AS s_year,IFNULL(total_install,0) AS total_install,month_code AS s_month");
			        
			        $this->db->from("(SELECT DISTINCT  MONTH(dte) AS month_code,YEAR(dte) AS c_year FROM 
									( SELECT '2019-04-01' + INTERVAL 1000*a +100*b+10*c+e DAY dte FROM
									(SELECT 0 a UNION SELECT 1 a UNION SELECT 2 UNION SELECT 3
									UNION SELECT 4 UNION SELECT 5 UNION SELECT 6 UNION SELECT 7
									UNION SELECT 8 UNION SELECT 9 ) d,
									(SELECT 0 b UNION SELECT 1 b UNION SELECT 2 UNION SELECT 3
									UNION SELECT 4 UNION SELECT 5 UNION SELECT 6 UNION SELECT 7
									UNION SELECT 8 UNION SELECT 9) m, 
									(SELECT 0 c UNION SELECT 1 c UNION SELECT 2 UNION SELECT 3
									UNION SELECT 4 UNION SELECT 5 UNION SELECT 6 UNION SELECT 7
									UNION SELECT 8 UNION SELECT 9) n,
									(SELECT 0 e UNION SELECT 1 e UNION SELECT 2 UNION SELECT 3
									UNION SELECT 4 UNION SELECT 5 UNION SELECT 6 UNION SELECT 7
									UNION SELECT 8 UNION SELECT 9) p
									ORDER BY 1000*a +100*b+10*c+e )f WHERE dte< DATE_ADD(NOW(),INTERVAL 1 MONTH) ORDER BY c_year DESC,month_code DESC) st");
			        $this->db->join('gen_code_desc gcd ', 'gcd.gen_code = st.month_code AND gen_code_group = "MONTH"', 'left');
			        $this->db->join('(SELECT s_year, COUNT(installation_id) AS total_install, s_month FROM  schedule_approval GROUP BY s_year,s_month) sa ', 'st.c_year=sa.s_year AND st.month_code=sa.s_month', 'left');
			        $this->db->where($cond);
			        $this->db->order_by('c_year','DESC');
			        $this->db->order_by('month_code','DESC');
	                $res1 = $this->db->get();
	                $output["draw"] = intval($this->input->post('draw'));
	                $output['iTotalRecords'] = $res1->num_rows();
	                $output['iTotalDisplayRecords'] = $res1->num_rows();
	                $slno = $iDisplayStart +1;
	                foreach ($query as $aRow) {
	                    $row[0] = $slno;
	                    $row['sl_no'] = $slno;
	                    $i = 1;
	                    foreach ($aRow as $key => $value) {
	                        $row[$i] = $value;
	                        $row[$key] = $value;
	                        $i++;
	                    }
	                    $output['aaData'][] = $row;
	                    $slno++;
	                    unset($row);
	                }
	                return $output;
	            break;
	            case 'get_exclude_install_list':
					$sql = $this->db->query("SELECT  gcd.description AS MONTH, sa.s_year, CASE WHEN sa.vendor_id = 'All' THEN 'All' ELSE s.supplier_name END AS supplier, 
					sh.scheme_name, ich.instal_cls_name, sa.s_month, sa.vendor_id, sa.scheme_id, sa.installation_id
					FROM schedule_approval sa
					LEFT JOIN scheme_header sh ON sh.pk_scheme_code = sa.scheme_id
					LEFT JOIN installation_class_header ich ON ich.id = sa.installation_id
					LEFT JOIN supplier s ON s.supplier_code = sa.vendor_id
					LEFT JOIN gen_code_desc gcd ON gcd.gen_code = sa.s_month
					WHERE (gen_code_group = 'MONTH') AND sa.s_year = '".$data['year_code']."' AND  sa.s_month = '".$data['month_code']."'
					ORDER BY s_month DESC");
				return $sql->result_array();
				break;
		        default :
		            return array('status' => FALSE, 'msg' =>'Unable to load.Contact Support');
			}
		}
 	 	public function post($data ,$op){
			date_default_timezone_set('Asia/Kolkata');
			$date = date('Y-m-d H:i:s', time());
			switch($op){
				case 'ADD_SCHEDULE_APPROVAL':
					$this->db->trans_begin();
					try{
						$month = $this->security->xss_clean($data['txtMonth']);
						$year = $this->security->xss_clean($data['txtYear']);
						$installation_class = $this->security->xss_clean($this->input->post('cmb_installation_class'));
						$get_month = date('m', strtotime($month));
		                for($j = 0 ; $j< sizeof($installation_class); $j++){
			                $insert_schedule_approval[] = array( 
			                    "s_month" => $get_month,
			                    "s_year" => $year,
			                    "vendor_id" => $this->security->xss_clean($data['cmb_vendor']),
			                    "scheme_id" => $this->security->xss_clean($data['cmb_schemes']),
			                    "installation_id" => $installation_class[$j],
			                    'created_by'=> $this->user_name,
			                    'created_at'=>$date
			                );
		                }
		                $res_schedule_approval = $this->db->insert_batch('schedule_approval',$insert_schedule_approval);
		                if($res_schedule_approval){
		                	$this->db->trans_commit();
							$dbstatus = TRUE;
		                	$dbmessage = 'Data saved successfully';
		                }else{
		                	$this->db->trans_rollback();
		                    $dbstatus = FALSE;
		                    $dbmessage = 'Error While Saving';
						}
					}catch(Exception $e){
				      	$this->db->trans_rollback();
				      	$dbstatus = FALSE;
				      	$dbmessage = $e->getMessage();
				    }
                return array('status'=>$dbstatus,'msg'=>$dbmessage,'month'=>$get_month,'year'=>$year);
				break;
				case 'ADD_TICKET_APPROVAL':
					$this->db->trans_begin();
					try{
						$month = $this->security->xss_clean($this->input->post('hidden_month'));
						$year = $this->security->xss_clean($this->input->post('hidden_year'));
						$time = $this->security->xss_clean($data['txtTicketTime']);    
			            $get_time =   date("H:i", strtotime($time));
			            $this->db->select("s_month,s_year");
			        	$this->db->from('schedule_details');
			        	$this->db->order_by('id','DESC');
			        	$query = $this->db->get()->row_array();
			                $insert_schedule_details = array( 
			                    "s_month" => $month,
			                    "s_year" => $year,
			                    "s_date" => $this->security->xss_clean(date("Y-m-d", strtotime($data['txtTicketDate']))),
			                    "s_time" => $get_time,
			                    "comments" => $this->security->xss_clean($data['txtComments']),
			                    'created_by'=> $this->user_name,
			                    'created_at'=>$date
			                );
		                $res_schedule_details = $this->db->insert('schedule_details',$insert_schedule_details);
		                if($res_schedule_details){
		                	$this->db->trans_commit();
							$dbstatus = TRUE;
		                	$dbmessage = 'Data saved successfully';
		                }else{
		                	$this->db->trans_rollback();
		                    $dbstatus = FALSE;
		                    $dbmessage = 'Error While Saving';
						}
					}catch(Exception $e){
				      	$this->db->trans_rollback();
				      	$dbstatus = FALSE;
				      	$dbmessage = $e->getMessage();
				    }
                return array('status'=>$dbstatus,'msg'=>$dbmessage);
				break;
				/**
				* Name : Subhashree jena
				* Date : 21-06-2019
				* Purpose : Update Ticket Validation Status
				* 
				*/
				case 'UPDATE_TICKET_VALIDATION_STATUS':
					$this->db->trans_begin();
					try{
						$hidden_id = $this->security->xss_clean($this->input->post('hidden_id'));
		                $update_ticket_status = array( 
		                    "tr_status" => $this->security->xss_clean($data['cmb_ticketStatus']),
		                    "status_remarks" => $this->security->xss_clean($data['txtRemarks']),
		                    'updated_by'=> $this->user_name,
		                    'updated_at'=>$date
		                );
		                $this->db->where('tr_customer_id',$hidden_id);
		                $res_ticket_status = $this->db->update('transaction_header',$update_ticket_status);
		                if($res_ticket_status){
		                	if($data['hidden_status']=='SUSPEND'){
	                		$ticket_status = 'SUSPEND';
	                		$this->db->where('ticket_status',$ticket_status);
	                		$this->db->where('req_by',$hidden_id);
				 			$tr_res_update = $this->db->update('raise_ticket',array('ticket_status'=>'CLOSE','updated_by'=>$this->user_name,'updated_at'=>$date));
		                	}
		                	$this->db->trans_commit();
							$dbstatus = TRUE;
		                	$dbmessage = 'Data update successfully';
		                }else{
		                	$this->db->trans_rollback();
		                    $dbstatus = FALSE;
		                    $dbmessage = 'Error While Saving';
						}
					}catch(Exception $e){
				      	$this->db->trans_rollback();
				      	$dbstatus = FALSE;
				      	$dbmessage = $e->getMessage();
				    }
                	return array('status'=>$dbstatus,'msg'=>$dbmessage);
				break;
				case 'ADD_AMC':
					$this->db->trans_begin();
					$this->db->from('amc_history');
					$this->db->select_max('id');
					$max_id = $this->db->get()->row_array();
					$max_id_value = $max_id['id']+1;
					$document_name = $_FILES['file_amcdoc']['name'];
					$allowed_mime_type_arr = array('application/pdf','application/msword','application/vnd.ms-office','application/octet-stream','application/vnd.openxmlformats-officedocument.wordprocessingml.document', 'application/zip', 'application/msword', 'application/x-zip', 'application/octet-stream');
					$mime = get_mime_by_extension($document_name);
					$dot_count 	= substr_count($document_name,'.');
					$zero_count = substr_count($document_name,"%0");
					if(in_array($mime, $allowed_mime_type_arr)){
						if($zero_count == 0 && $dot_count == 1){
							$file_move_path  = FCPATH.'public/upload/document/'.$max_id_value;
							if(!is_dir($file_move_path))
	 							mkdir($file_move_path,0777,true);
	 						$store_path  = 'public/upload/document/'.$max_id_value.'/'.$document_name ;
	 						$upload_file = move_uploaded_file($_FILES['file_amcdoc']['tmp_name'],$store_path);
							if($upload_file){
								$data_update = array(
									'amc_letter_no' => $data['txtLetterNo'],
	    							'document'      => $store_path,
	    							'valid_from' 	=> date("Y-m-d",strtotime($data['txtvalidfrom'])),
									'valid_till' 	=> date("Y-m-d",strtotime($data['txtvalidtill'])),
	    							"updated_by"	=> $this->user_name,
									"updated_at"	=> $date
								);
								$this->db->where('consumer_id',$data['txtConsumerId']);
								$result_update = $this->db->update('transaction_header',$data_update);
								if($result_update){
								  	$insert_data = array(
								  	'consumer_id'   => $data['txtConsumerId'],
								  	'amc_letter_no' => $data['txtLetterNo'],
									'valid_from'    => date("Y-m-d",strtotime($data['txtvalidfrom'])),
									'valid_till'    => date("Y-m-d",strtotime($data['txtvalidtill'])),
									'document'      => $store_path,
									'created_by'    => $this->user_name,
									'created_at'    => $date
								  	);
								  	$insert_amc_history = $this->db->insert('amc_history',$insert_data);
										if($result_update){
											$this->db->trans_commit();
											$dbstatus = TRUE;
						        			$dbmessage = 'Data Save successfully';
										}else{
											$this->db->trans_rollback();
											$dbstatus = FALSE;
											$dbmessage = 'Error While Saving';
										}
								}else{
									$dbstatus 	= FALSE;
									$dbmessage =  'Error in update1!! try again.';
								}
							}else{
								$dbstatus = FALSE;
								$dbmessage = $this->upload->display_errors();
							}
						}else{
							$dbstatus = FALSE;
							$dbmessage = 'Invalid Image format.It should not contain multiple dot(.) or 0)';
						}
					}else{
						$dbstatus = FALSE;
						$dbmessage = 'Please select pdf format.';
					}
		    		return array('status'=>$dbstatus,'msg'=>$dbmessage);
				break;
				default :
		            return array('status' => FALSE, 'msg' =>'Unable to load.Contact Support');
			}
		}
  	}