<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

   	class Installation_model extends CI_Model{
  		function __construct(){
    		// Call the Model constructor
    		parent::__construct();
    		
    		$this->load->helper('date');
	        if (ENVIRONMENT == 'production') {
	            $this->db->save_queries = FALSE;
	        }
	        date_default_timezone_set('Asia/Kolkata');
			$date = date('Y-m-d H:i:s', time());
	        
	        $this->role 		= $this->session->userdata('role');
	        $this->user_name 	= $this->session->userdata('user_name');
 	 	}
 	 	public function get($data ,$op){
			date_default_timezone_set('Asia/Kolkata');
			$date = date('Y-m-d H:i:s', time());
			switch($op){
				case 'get_installation_view' :
	            	$this->db->from('installation_class_header a');
	            	$this->db->select('a.instal_cls_name,a.description,a.short_name,a.type,a.created_by,DATE_FORMAT(a.created_at, "%d-%m-%Y %h:%m:%s") as created_at ,a.updated_by,a.updated_at,a.id,b.installation_header_id,b.component_id');
	            	$this->db->join('installation_class_detail b','a.id = b.installation_header_id','left');
	            	$this->db->where('a.id',$data['installtion_id']);
	            	return $this->db->get()->row_array();
	            break;
	            case 'get_component' :
	            	$this->db->from('installation_class_detail a');
	            	$this->db->select('b.component_name,a.component_id,a.created_by,a.created_at,a.updated_by,a.updated_at');
	            	$this->db->join('components b','b.id = a.component_id','left');
	            	$this->db->where('a.installation_header_id',$data['installation_header_id']);
	            	return $this->db->get()->result_array();
	            break;
	            case 'get_installation':
					$order = '';
	                $Ocolumn = '';
	                $Odir = '';
	                $order = $this->input->post('order');
	                if ($order) {
	                    foreach ($order as $row) {
	                        $Ocolumn = $row['column'];
	                        $Odir = $row['dir'];
	                    }
	                    $this->db->order_by($Ocolumn, $Odir);
	                } else {
	                    $this->db->order_by(1, "ASC");
	                }
	                $search = $this->input->post('search');
	                $header = array('instal_cls_name','short_name');//search filter will work on this column
	                if ($search['value'] != '') {
	                    for ($i = 0; $i < count($header); $i++) {
	                        $this->db->or_like($header[$i], $search['value']);
	                    }
	                }

	                $iDisplayLength = $this->input->post('length');//to shw number of record to be shown
	                $iDisplayStart = $this->input->post('start');//to start from that position (ex: offset)

	                $this->db->limit($iDisplayLength, $iDisplayStart);
	               	$this->db->from('installation_class_header');
	               	$this->db->select('instal_cls_name,short_name,type,description,id');
	               	$this->db->order_by('updated_at','DESC');
	                $query = $this->db->get()->result_array();
	                $output = array("aaData" => array());
	                /*----FOR PAGINATION-----*/
	                if ($search['value'] != '') {
	                    for ($i = 0; $i < count($header); $i++) {
	                        $this->db->or_like($header[$i], $search['value']);
	                    }
	                }
	               	$this->db->from('installation_class_header');
	               	$this->db->select('instal_cls_name,short_name,type,description,id');
	               	$this->db->order_by('updated_at','DESC');
	                $res1 = $this->db->get();
	                $output["draw"] = intval($this->input->post('draw'));
	                $output['iTotalRecords'] = $res1->num_rows();
	                $output['iTotalDisplayRecords'] = $res1->num_rows();
	                $slno = $iDisplayStart+1;
	                foreach ($query as $aRow) {
	                    $row[0] = $slno;
	                    $row['sl_no'] = $slno;
	                    $i = 1;
	                    foreach ($aRow as $key => $value) {
	                        $row[$i] = $value;
	                        $row[$key] = $value;
	                        $i++;
	                    }
	                    $output['aaData'][] = $row;
	                    $slno++;
	                    unset($row);
	                }
	                return $output;
	            break;
            default :
            	return array('status' => FALSE, 'msg' =>'Unable to load.Contact Support');
			}
		}
 	 	public function post($data ,$op){
			date_default_timezone_set('Asia/Kolkata');
			$date = date('Y-m-d H:i:s', time());
			switch($op){
				case 'ADD_INSTALLATION_CLASS':
					$this->db->trans_begin();
					try{
						$insert_installation = array(
							"instal_cls_name"  => $this->security->xss_clean($data['txtClassName']),
							"description" 	 => $this->security->xss_clean($data['txtDescription']),
							"short_name"  	=> 	$this->security->xss_clean($data['txtShortName']),
							"type"  		=> 	$this->security->xss_clean($data['cmbType']),
							"created_by"	=>	$this->user_name,
							"created_at"	=>	$date,
							"updated_by"	=>	$this->user_name,
							"updated_at"	=>	$date
						);
						$installation_class = $this->db->insert('installation_class_header',$insert_installation);
						$installation_id = $this->db->insert_id();
						if($installation_class){
							$component =   $this->security->xss_clean($this->input->post('cmb_component'));
							for($i = 0; $i< sizeof($component); $i++){
								$installation_details[] = array(
									"installation_header_id" => $installation_id,
									"component_id"			 =>$component[$i],
									"created_by"	=>	$this->user_name,
									"created_at"	=>	$date,
									"updated_by"	=>	$this->user_name,
									"updated_at"	=>	$date
								);
							}
							$installation_class_details = $this->db->insert_batch('installation_class_detail',$installation_details);
							if($installation_class_details){
								$this->db->trans_commit();
								$dbstatus = TRUE;
			        			$dbmessage = 'Data saved successfully';
							}else{
								$this->db->trans_rollback();
								$dbstatus = FALSE;
								$dbmessage = 'Error While Saving';
							}
						}else{
								$this->db->trans_rollback();
								$dbstatus = FALSE;
								$dbmessage = 'Error While Saving1';
							}
					}catch(Exception $e){
				      	$this->db->trans_rollback();
				      	$dbstatus = FALSE;
				      	$dbmessage = $e->getMessage();
			    	}
			    	return array('status'=>$dbstatus,'msg'=>$dbmessage);
				break;
				case 'UPDATE_INSTALLATION_CLASS':
				$this->db->trans_begin();
					$installation_id = $this->security->xss_clean($data['hid_installation_id']);
					try{
						$update_installation = array(
							"instal_cls_name"  => $this->security->xss_clean($data['txtClassName']),
							"description" 	 => $this->security->xss_clean($data['txtDescription']),
							"short_name"  	=> 	$this->security->xss_clean($data['txtShortName']),
							"type"  		=> 	$this->security->xss_clean($data['cmbType']),
							"updated_by"	=>	$this->user_name,
							"updated_at"	=>	$date
						);
						$this->db->where('id',$installation_id);
						$installation_class = $this->db->update('installation_class_header',$update_installation);
						if($installation_class){
							$this -> db -> where('installation_header_id', $installation_id);
  							$res_delete = $this -> db -> delete('installation_class_detail');
							if($res_delete){
								$component =   $this->security->xss_clean($this->input->post('cmb_component'));
								for($i = 0; $i< sizeof($component); $i++){
									$installation_details[] = array(
										"installation_header_id" => $installation_id,
										"component_id"			 =>$component[$i],
										"updated_by"	=>	$this->user_name,
										"updated_at"	=>	$date
									);
								}
								$installation_class_details = $this->db->insert_batch('installation_class_detail',$installation_details);
								if($installation_class_details){
									$this->db->trans_commit();
									$dbstatus = TRUE;
				        			$dbmessage = 'Data Update successfully';
								}else{
									$this->db->trans_rollback();
									$dbstatus = FALSE;
									$dbmessage = 'Error While Saving';
								}
							}else{
								$this->db->trans_rollback();
								$dbstatus = FALSE;
								$dbmessage = 'Error While delete Record';
							}
						}else{
							$this->db->trans_rollback();
							$dbstatus = FALSE;
							$dbmessage = 'Error While Saving';
						}
					}catch(Exception $e){
				      	$this->db->trans_rollback();
				      	$dbstatus = FALSE;
				      	$dbmessage = $e->getMessage();
			    	}
			    	return array('status'=>$dbstatus,'msg'=>$dbmessage);
				break;
			default:
            	return array('status' => false, 'msg' =>'Unable to load.Contact Support');	
			}
		}
  	}