<?php
	class Dashboard_model extends CI_model{
		function __construct(){
        	parent::__construct();
        	if (ENVIRONMENT == 'production'){
		    	$this->db->save_queries = FALSE;
			}
			date_default_timezone_set('Asia/Kolkata');
			$date = date('Y-m-d H:i:s', time());
        	$this->role 		= $this->session->userdata('role');
        	$this->user_name 	= $this->session->userdata('user_name');
        	$this->user_code 	= $this->session->userdata('user_code');
        	$this->sess_id 		= $this->session->userdata('sess_id');
    	}
    	
		public function get($data, $op){
			switch ($op){
				case 'GET_ROLEWISE_USER':
	                $this->db->select('b.role_name,COUNT(a.user_code) as cnt');
	                $this->db->join('role_master b','a.primary_role=b.role_code','INNER');
					$this->db->where('a.record_status','1');
					$this->db->group_by('b.role_name');
	                $res = $this->db->get('user_master a');
	                return $res->result_array();
				break;
				case 'GET_LOGIN_CURRENT_DATE':
	                $this->db->select('b.user_display_name,DATE_FORMAT(a.created_on,"%d-%m-%Y %h:%i:%s") AS created_on');
	                $this->db->join('user_master b','a.login_id=b.user_code','INNER');
					$this->db->where('b.record_status','1');
					$this->db->where('DATE(a.created_on)',date('Y-m-d'));
					$res = $this->db->get('login_detail a');
	                return $res->result_array();
				break;
				case 'get_scheme_wise_transacation_details':
					$this->db->select('scheme_name ,COUNT(s.id)AS cnt');
					$this->db->from('transaction_header s');
					$this->db->join('supplier c','c.supplier_code=s.tr_supplier_id','left');
					$this->db->join('scheme_header d','d.pk_scheme_code=s.tr_scheme_id ','left');
					$this->db->where('s.transaction_status != ','cancelled');
					if($this->role =='VENDOR'){
						$this->db->where('c.fk_user_code',$this->user_code);
					}
					$this->db->group_by('scheme_name');
					return $this->db->get()->result_array();
				break;
				/*Debashish Jyotish*/
				case 'get_company_view':
					$dept_code = '';
					$dept_code1 = '';
	                if($this->role == 'ADEPT'){
						$this->db->select('pk_dept_code');
						$this->db->from('admin_dept');
						$this->db->where('fk_user_code',$this->user_code);
						$ret = $this->db->get()->row_array();
						$dept_code = "WHERE fk_dept_code = '".$ret['pk_dept_code']."'";
						$dept_code1 = "AND fk_dept_code = '".$ret['pk_dept_code']."'";
					}
					/*$res = $this->db->query("SELECT * FROM (SELECT COUNT(*) AS scheme_cnt FROM scheme_header)a  
						JOIN (SELECT COUNT(*) AS installation_count FROM transaction_header WHERE consumer_id IS NOT NULL AND DATE(IFNULL(valid_till,NOW()))>=DATE(NOW())
						AND tr_status IN('WORKING','CLOSE','OPEN','SUSPEND','ABANDONED'))b
						JOIN (SELECT COUNT(*) AS case_count FROM raise_ticket) c
						JOIN (SELECT COUNT(*) AS open_case_count FROM raise_ticket WHERE ticket_status IN('OPEN','SUSPEND'))d
						JOIN (SELECT ROUND(SUM(DATEDIFF(close_date,actual_issue_date))/COUNT(ticket_id),2) AS closed_avg FROM raise_ticket
						WHERE ticket_status='CLOSE')e
						JOIN(SELECT COUNT(*) AS suspended FROM transaction_header
						WHERE consumer_id IS NOT NULL AND DATE(IFNULL(valid_till,NOW()))>=DATE(NOW())
						AND tr_status IN('SUSPEND','ABANDONED'))f");*/
						
						// modified by Biswajit on 04-10-2019
						$res = $this->db->query("SELECT * FROM (SELECT COUNT(*) AS scheme_cnt FROM scheme_header $dept_code)a
						JOIN (SELECT COUNT(*) AS total_asset FROM transaction_header 
						LEFT JOIN scheme_header ON tr_scheme_id=pk_scheme_code 
						WHERE consumer_id IS NOT NULL $dept_code1)w
						JOIN (SELECT COUNT(*) AS maintainable_asset FROM transaction_header
						LEFT JOIN scheme_header ON tr_scheme_id=pk_scheme_code
						WHERE consumer_id IS NOT NULL AND DATE(IFNULL(valid_till,NOW()))>=DATE(NOW())
						AND tr_status IN('WORKING','CLOSE','OPEN','SUSPEND','ABANDONED') $dept_code1)b
						JOIN (SELECT COUNT(*) AS request_registered FROM raise_ticket
						LEFT JOIN transaction_header ON req_by = tr_customer_id 
						LEFT JOIN scheme_header ON tr_scheme_id=pk_scheme_code $dept_code) c
						JOIN (SELECT COUNT(*) AS request_close FROM raise_ticket 
						LEFT JOIN transaction_header ON req_by = tr_customer_id 
						LEFT JOIN scheme_header ON tr_scheme_id=pk_scheme_code WHERE ticket_status = 'CLOSE' $dept_code1)z
						JOIN (SELECT ROUND(SUM(DATEDIFF(close_date,actual_issue_date))/COUNT(ticket_id),2) AS closed_avg FROM raise_ticket 
						LEFT JOIN transaction_header ON req_by = tr_customer_id 
						LEFT JOIN scheme_header ON tr_scheme_id=pk_scheme_code WHERE ticket_status='CLOSE' $dept_code1)e
						JOIN (SELECT COUNT(*) AS request_open FROM raise_ticket 
						LEFT JOIN transaction_header ON req_by = tr_customer_id 
						LEFT JOIN scheme_header ON tr_scheme_id=pk_scheme_code WHERE ticket_status IN('OPEN','REOPEN','RESOLVE') $dept_code1)d
						JOIN (SELECT ROUND(SUM(DATEDIFF(NOW(),actual_issue_date))/COUNT(ticket_id),2) AS open_avg FROM raise_ticket 
						LEFT JOIN transaction_header ON req_by = tr_customer_id 
						LEFT JOIN scheme_header ON tr_scheme_id=pk_scheme_code  WHERE ticket_status IN('OPEN','REOPEN','RESOLVE') $dept_code1)v
						JOIN(SELECT COUNT(*) AS suspended FROM transaction_header
						LEFT JOIN scheme_header ON tr_scheme_id=pk_scheme_code
						WHERE consumer_id IS NOT NULL AND DATE(IFNULL(valid_till,NOW()))>=DATE(NOW())
						AND tr_status IN('SUSPEND','ABANDONED') $dept_code1)f");
					//print_r($this->db->last_query());die();
					return $res->row_array();
				break;
				case 'get_company_view_vendorwise':
					$this->db->select('supplier_code');
					$this->db->where('fk_user_code',$this->user_code);
					$result = $this->db->get('supplier')->row_array();
					$res = $this->db->query("SELECT * FROM 
						(SELECT COUNT(DISTINCT scheme_id) AS scheme_cnt FROM sup_village_detail WHERE supplier_id ='".$result['supplier_code']."')a 
						JOIN (SELECT COUNT(*) AS installation_count FROM transaction_header WHERE consumer_id is not null AND DATE(IFNULL(valid_till,NOW()))>=DATE(NOW()) AND tr_status IN('WORKING','CLOSE','OPEN','SUSPEND','ABANDONED') AND tr_supplier_id='".$result['supplier_code']."')b 
						JOIN (SELECT COUNT(*) AS case_count FROM raise_ticket WHERE req_for_to ='".$result['supplier_code']."') c 
						JOIN (SELECT COUNT(*) AS open_case_count FROM raise_ticket WHERE ticket_status IN('OPEN','SUSPEND') AND req_for_to='".$result['supplier_code']."')d 
						JOIN (SELECT ROUND(IFNULL(SUM(DATEDIFF(close_date,actual_issue_date))/COUNT(ticket_id),0),2) AS closed_avg 
						FROM raise_ticket WHERE ticket_status='CLOSE' AND req_for_to='".$result['supplier_code']."')e");
					//print_r($this->db->last_query());die();
					return $res->row_array();
				break;
				case 'get_total_statistics_all_schemes':
					$dept_code = '';
					$dept_code1 = '';
	                if($this->role == 'ADEPT'){
						$this->db->select('pk_dept_code');
						$this->db->from('admin_dept');
						$this->db->where('fk_user_code',$this->user_code);
						$ret = $this->db->get()->row_array();
						$dept_code = "WHERE fk_dept_code = '".$ret['pk_dept_code']."'";
						$dept_code1 = "AND fk_dept_code = '".$ret['pk_dept_code']."'";
					}
					/*$res = $this->db->query("SELECT pk_scheme_code,scheme_code,installation_count,open_case_count,
						IF(open_case_count=0,0,ROUND((case_count/open_case_count),2)) AS reg_feq,closed_avg,suspended
						FROM
						(SELECT a.pk_scheme_code,a.scheme_code,IFNULL(b.installation_count,0) AS installation_count,IFNULL(c.case_count,0) AS case_count,
						IFNULL(d.open_case_count,0) AS open_case_count,IFNULL(e.closed_avg,0) AS closed_avg,suspended
						FROM (SELECT pk_scheme_code,scheme_name,scheme_code FROM scheme_header)a
						LEFT JOIN
						(SELECT COUNT(id) AS installation_count,tr_scheme_id FROM transaction_header
						WHERE consumer_id IS NOT NULL AND DATE(IFNULL(valid_till,NOW()))>=DATE(NOW()) AND
						tr_status IN('WORKING','CLOSE','OPEN','SUSPEND','ABANDONED') GROUP BY tr_scheme_id)b ON a.pk_scheme_code = b.tr_scheme_id
						LEFT JOIN
						(SELECT COUNT(id) AS case_count,req_sub_group FROM raise_ticket GROUP BY req_sub_group) c ON a.scheme_code =c.req_sub_group
						LEFT JOIN
						(SELECT COUNT(*) AS open_case_count,req_sub_group FROM raise_ticket
						WHERE ticket_status IN('OPEN') GROUP BY req_sub_group)d ON a.scheme_code =d.req_sub_group
						LEFT JOIN
						(SELECT ROUND(SUM(DATEDIFF(close_date,actual_issue_date))/COUNT(ticket_id),2) AS closed_avg,req_sub_group FROM raise_ticket
						WHERE ticket_status='CLOSE'
						GROUP BY req_sub_group)e ON a.scheme_code =e.req_sub_group
						LEFT JOIN
						(SELECT tr_scheme_id,COUNT(*) AS suspended FROM transaction_header
						WHERE consumer_id IS NOT NULL AND DATE(IFNULL(valid_till,NOW()))>=DATE(NOW())
						AND tr_status IN('SUSPEND','ABANDONED')GROUP BY tr_scheme_id)f ON f.tr_scheme_id=a.pk_scheme_code)a1");*/
						$res = $this->db->query("SELECT pk_scheme_code,scheme_code,total_asset,maintainable_asset,request_registered,request_close,closed_avg,request_open,open_avg,suspended
							FROM
							(SELECT a.pk_scheme_code,a.scheme_code,IFNULL(w.total_asset,0) AS total_asset,IFNULL(b.maintainable_asset,0) AS maintainable_asset,
							IFNULL(c.request_registered,0) AS request_registered,IFNULL(z.request_close,0) AS request_close,
							IFNULL(d.request_open,0) AS request_open,IFNULL(e.closed_avg,0) AS closed_avg,IFNULL(v.open_avg,0) AS open_avg,suspended
							FROM (SELECT pk_scheme_code,scheme_name,scheme_code FROM scheme_header $dept_code )a

							LEFT JOIN
							(SELECT COUNT(th.id) AS total_asset,th.tr_scheme_id FROM transaction_header th
							LEFT JOIN scheme_header ON th.tr_scheme_id=pk_scheme_code
							WHERE th.consumer_id IS NOT NULL $dept_code1 GROUP BY th.tr_scheme_id)w ON a.pk_scheme_code = w.tr_scheme_id
							LEFT JOIN
							(SELECT COUNT(th.id) AS maintainable_asset,th.tr_scheme_id FROM transaction_header th
							LEFT JOIN scheme_header ON th.tr_scheme_id=pk_scheme_code
							WHERE th.consumer_id IS NOT NULL AND DATE(IFNULL(valid_till,NOW()))>=DATE(NOW()) AND
							th.tr_status IN('WORKING','CLOSE','OPEN','SUSPEND','ABANDONED') $dept_code1 GROUP BY th.tr_scheme_id)b ON a.pk_scheme_code = b.tr_scheme_id

							LEFT JOIN
							(SELECT COUNT(rt.id) AS request_registered,req_sub_group FROM raise_ticket rt
							LEFT JOIN transaction_header ON req_by = tr_customer_id 
							LEFT JOIN scheme_header ON tr_scheme_id=pk_scheme_code 
							$dept_code GROUP BY req_sub_group WITH ROLLUP) c ON a.scheme_code =c.req_sub_group
							LEFT JOIN
							(SELECT COUNT(*) AS request_close,req_sub_group FROM raise_ticket
							LEFT JOIN transaction_header ON req_by = tr_customer_id 
							LEFT JOIN scheme_header ON tr_scheme_id=pk_scheme_code 
							WHERE ticket_status=('CLOSE') $dept_code1 GROUP BY req_sub_group)z ON a.scheme_code =z.req_sub_group
							LEFT JOIN
							(SELECT ROUND(SUM(DATEDIFF(close_date,actual_issue_date))/COUNT(ticket_id),2) AS closed_avg,req_sub_group FROM raise_ticket
							LEFT JOIN transaction_header ON req_by = tr_customer_id 
							LEFT JOIN scheme_header ON tr_scheme_id=pk_scheme_code
							WHERE ticket_status='CLOSE' $dept_code1
							GROUP BY req_sub_group)e ON a.scheme_code =e.req_sub_group
							LEFT JOIN
							(SELECT COUNT(*) AS request_open,req_sub_group FROM raise_ticket
							LEFT JOIN transaction_header ON req_by = tr_customer_id 
							LEFT JOIN scheme_header ON tr_scheme_id=pk_scheme_code
							WHERE ticket_status IN('OPEN','REOPEN','RESOLVE') $dept_code1 GROUP BY req_sub_group)d ON a.scheme_code =d.req_sub_group
							LEFT JOIN
							(SELECT ROUND(SUM(DATEDIFF(NOW(),actual_issue_date))/COUNT(ticket_id),2) AS open_avg,req_sub_group FROM raise_ticket 
							LEFT JOIN transaction_header ON req_by = tr_customer_id 
							LEFT JOIN scheme_header ON tr_scheme_id=pk_scheme_code
							WHERE ticket_status='OPEN' $dept_code1
							GROUP BY req_sub_group)v ON a.scheme_code =v.req_sub_group

							LEFT JOIN
							(SELECT tr_scheme_id,COUNT(*) AS suspended FROM transaction_header
							LEFT JOIN scheme_header ON tr_scheme_id=pk_scheme_code
							WHERE consumer_id IS NOT NULL AND DATE(IFNULL(valid_till,NOW()))>=DATE(NOW())
							AND tr_status IN('SUSPEND','ABANDONED') $dept_code1 GROUP BY tr_scheme_id)f ON f.tr_scheme_id=a.pk_scheme_code)a1");
					return $res->result_array();
				break;
				case 'get_total_statistics_schemes_vendorwise':
					$this->db->select('supplier_code');
					$this->db->where('fk_user_code',$this->user_code);
					$result = $this->db->get('supplier')->row_array();
					$res = $this->db->query("SELECT pk_scheme_code,scheme_code,installation_count,open_case_count, IF(open_case_count=0,0,ROUND((case_count/open_case_count),2)) AS reg_feq,
							closed_avg FROM (SELECT a.pk_scheme_code,a.scheme_code,IFNULL(b.installation_count,0) AS installation_count,IFNULL(c.case_count,0) AS case_count,
							IFNULL(d.open_case_count,0) AS open_case_count,IFNULL(e.closed_avg,0) AS closed_avg 
							FROM (SELECT DISTINCT scheme_id  FROM sup_village_detail WHERE supplier_id ='".$result['supplier_code']."')s INNER JOIN 
							(SELECT pk_scheme_code,scheme_name,scheme_code  FROM scheme_header)a ON s.scheme_id=a.pk_scheme_code
							LEFT JOIN (SELECT COUNT(id) AS installation_count,tr_scheme_id 
							FROM transaction_header WHERE consumer_id is not null AND DATE(IFNULL(valid_till,NOW()))>=DATE(NOW()) AND tr_status IN('WORKING','CLOSE','OPEN','SUSPEND','ABANDONED') AND tr_supplier_id='".$result['supplier_code']."' GROUP BY tr_scheme_id)b ON a.pk_scheme_code = b.tr_scheme_id
							LEFT JOIN (SELECT COUNT(id) AS case_count,req_sub_group FROM raise_ticket WHERE req_for_to ='".$result['supplier_code']."' GROUP BY req_sub_group) c ON a.scheme_code =c.req_sub_group
							LEFT JOIN (SELECT COUNT(*) AS open_case_count,req_sub_group FROM raise_ticket WHERE req_for_to ='".$result['supplier_code']."' AND ticket_status IN('OPEN','SUSPEND') 
							GROUP BY req_sub_group)d ON a.scheme_code =d.req_sub_group
							LEFT JOIN (SELECT ROUND(SUM(DATEDIFF(close_date,actual_issue_date))/COUNT(ticket_id),2) AS closed_avg,req_sub_group 
							FROM raise_ticket WHERE ticket_status='CLOSE' AND req_for_to ='".$result['supplier_code']."' 
							GROUP BY req_sub_group)e ON a.scheme_code =e.req_sub_group) al");
					return $res->result_array();
				break;
				case 'get_schemes_wise_statistics':
					/*$res = $this->db->query("SELECT supplier_id,supplier_name,installation_count,open_case_count,
						IF(open_case_count=0,0,ROUND((case_count/open_case_count),2)) AS reg_feq,closed_avg,suspended
						FROM
						(SELECT a.supplier_id,a.supplier_name,IFNULL(b.installation_count,0) AS installation_count,
						IFNULL(c.case_count,0) AS case_count,IFNULL(d.open_case_count,0) AS open_case_count,IFNULL(e.closed_avg,0) AS closed_avg,0 AS suspended
						FROM
						(SELECT DISTINCT svd.supplier_id,sup.supplier_name FROM sup_village_detail svd
						LEFT JOIN supplier sup ON sup.supplier_code = svd.supplier_id WHERE svd.scheme_id =".$data['scheme_id'].") a
						LEFT JOIN
						(SELECT COUNT(id) AS installation_count,tr_supplier_id FROM transaction_header
						WHERE tr_scheme_id=".$data['scheme_id']." AND consumer_id IS NOT NULL AND DATE(IFNULL(valid_till,NOW()))>=DATE(NOW())
						AND tr_status IN('WORKING','CLOSE','OPEN','SUSPEND','ABANDONED') AND tr_scheme_id =".$data['scheme_id']."
						GROUP BY tr_supplier_id)b ON a.supplier_id = b.tr_supplier_id
						LEFT JOIN
						(SELECT COUNT(id) AS case_count,req_for_to FROM raise_ticket
						WHERE req_sub_group='".$data['scheme_code']."'
						GROUP BY req_for_to) c ON a.supplier_id =c.req_for_to
						LEFT JOIN
						(SELECT COUNT(*) AS open_case_count,req_for_to FROM raise_ticket
						WHERE req_sub_group='".$data['scheme_code']."' AND ticket_status IN('OPEN')
						GROUP BY req_for_to)d ON a.supplier_id =d.req_for_to
						LEFT JOIN
						(SELECT ROUND(SUM(DATEDIFF(close_date,actual_issue_date))/COUNT(ticket_id),2) AS closed_avg,req_for_to FROM raise_ticket
						WHERE req_sub_group='".$data['scheme_code']."' AND ticket_status='CLOSE'
						GROUP BY req_for_to)e ON a.supplier_id =e.req_for_to)a1
						UNION
						SELECT '','oreda',0,0,0,0,COUNT(*) AS suspended FROM transaction_header
						WHERE consumer_id IS NOT NULL AND DATE(IFNULL(valid_till,NOW()))>=DATE(NOW())
						AND tr_status IN('SUSPEND','ABANDONED') AND tr_scheme_id =".$data['scheme_id']."");*/
						$res = $this->db->query("SELECT supplier_id,supplier_name,total_asset,maintainable_asset,request_register,
						request_close,closed_avg,request_open,open_avg,suspended
						FROM
						(SELECT a.supplier_id,a.supplier_name,IFNULL(b.maintainable_asset,0) AS maintainable_asset,IFNULL(w.total_asset,0) AS total_asset,
						IFNULL(c.request_register,0) AS request_register,IFNULL(d.request_open,0) AS request_open,IFNULL(z.request_close,0) AS request_close,
						IFNULL(e.closed_avg,0) AS closed_avg,IFNULL(v.open_avg,0) AS open_avg,0 AS suspended
						FROM
						(SELECT DISTINCT svd.supplier_id,sup.supplier_name FROM sup_village_detail svd
						LEFT JOIN supplier sup ON sup.supplier_code = svd.supplier_id WHERE svd.scheme_id ='".$data['scheme_id']."') a
						LEFT JOIN
						(SELECT COUNT(id) AS total_asset,tr_supplier_id FROM transaction_header
						WHERE tr_scheme_id='".$data['scheme_id']."' AND consumer_id IS NOT NULL AND tr_scheme_id ='".$data['scheme_id']."'
						GROUP BY tr_supplier_id)w ON a.supplier_id = w.tr_supplier_id
						LEFT JOIN
						(SELECT COUNT(id) AS maintainable_asset,tr_supplier_id FROM transaction_header
						WHERE tr_scheme_id='".$data['scheme_id']."' AND consumer_id IS NOT NULL AND DATE(IFNULL(valid_till,NOW()))>=DATE(NOW())
						AND tr_status IN('WORKING','CLOSE','OPEN','SUSPEND','ABANDONED') AND tr_scheme_id ='".$data['scheme_id']."'
						GROUP BY tr_supplier_id)b ON a.supplier_id = b.tr_supplier_id
						LEFT JOIN
						(SELECT COUNT(id) AS request_register,req_for_to FROM raise_ticket
						WHERE req_sub_group='".$data['scheme_code']."'
						GROUP BY req_for_to) c ON a.supplier_id =c.req_for_to
						LEFT JOIN
						(SELECT COUNT(*) AS request_close,req_for_to FROM raise_ticket
						WHERE req_sub_group='".$data['scheme_code']."' AND ticket_status=('CLOSE') GROUP BY req_for_to WITH ROLLUP)z ON a.supplier_id =z.req_for_to
						LEFT JOIN
						(SELECT COUNT(*) AS request_open,req_for_to FROM raise_ticket
						WHERE req_sub_group='".$data['scheme_code']."' AND ticket_status IN('OPEN','REOPEN','RESOLVE')
						GROUP BY req_for_to)d ON a.supplier_id =d.req_for_to
						LEFT JOIN
						(SELECT ROUND(SUM(DATEDIFF(NOW(),actual_issue_date))/COUNT(ticket_id),2) AS open_avg,req_for_to FROM raise_ticket
						WHERE req_sub_group='".$data['scheme_code']."' AND ticket_status='OPEN'
						GROUP BY req_for_to)v ON a.supplier_id =v.req_for_to
						LEFT JOIN
						(SELECT ROUND(SUM(DATEDIFF(close_date,actual_issue_date))/COUNT(ticket_id),2) AS closed_avg,req_for_to FROM raise_ticket
						WHERE req_sub_group='".$data['scheme_code']."' AND ticket_status='CLOSE'
						GROUP BY req_for_to)e ON a.supplier_id =e.req_for_to )a1 ");
					return $res->result_array();
				break;
				case 'get_vendor_wise_schemes_statistics':
					$this->db->select('supplier_code');
					$this->db->where('fk_user_code',$this->user_code);
					$result = $this->db->get('supplier')->row_array();
					$res = $this->db->query("SELECT rt.ticket_id,ticket_status, th.habitation, vm.village_name, gm.gp_name, bm.block_name,
						dm.district_name, rt.actual_issue_date, DATEDIFF(NOW(), rt.actual_issue_date) AS ageing, th.id, rt.req_by
						FROM raise_ticket rt
						LEFT JOIN customer c ON rt.req_by = c.id
						LEFT JOIN transaction_header th ON c.id = th.tr_customer_id
						LEFT JOIN district_master dm ON th.district = dm.district_code
						LEFT JOIN block_master bm ON th.cd_block = bm.block_code
						LEFT JOIN gp_master gm ON th.gp = gm.pk_gp_code
						LEFT JOIN village_master vm ON th.revenue_village = vm.pk_village_code
						LEFT JOIN supplier sup ON sup.supplier_code=th.tr_supplier_id
						WHERE ticket_status IN('ABANDONED', 'SUSPEND')AND DATE(IFNULL(valid_till,NOW()))>=DATE(NOW())
						AND consumer_id IS NOT NULL
						AND rt.req_for_to = '".$result['supplier_code']."'
						AND rt.req_sub_group = '".$data['scheme_code']."'
						ORDER BY DATEDIFF(NOW(), rt.actual_issue_date) DESC");
					return $res->result_array();
				break;
				case 'get_oreda_bucket':
					$res = $this->db->query("SELECT 'oreda' AS supplier_id,'oreda' AS supplier_name,COUNT(*) AS total_asset,0 AS maintainable_asset,0 AS request_register,
					0 AS request_close, 0 AS closed_avg,0 AS request_open,0 AS open_avg,0 AS suspended 
					FROM transaction_header 
					WHERE consumer_id IS NOT NULL AND DATE(IFNULL(valid_till,NOW()))>=DATE(NOW()) 
					AND tr_status IN('SUSPEND','ABANDONED') AND tr_scheme_id ='".$data['scheme_id']."'");
					return $res->result_array();
				break;
				case 'get_scheme_list':
        			$this->db->from('scheme_header');
        			$this->db->select('id,pk_scheme_code,scheme_code,scheme_name');
        			$this->db->where('pk_scheme_code',$data['scheme_id']);
        			return $this->db->get()->row_array();
        		break;
				case 'get_raise_ticket_cases':
					$this->db->select('rt.ticket_id,th.habitation,vm.village_name,gm.gp_name,bm.block_name,dm.district_name,rt.actual_issue_date,
						DATEDIFF(NOW(),rt.actual_issue_date) AS ageing,th.id,rt.req_by');
					$this->db->from('raise_ticket rt');
					$this->db->join('customer c','rt.req_by = c.id ','left');
					$this->db->join('transaction_header th','c.id = th.tr_customer_id','left');
					$this->db->join('district_master dm','th.district = dm.district_code','left');
					$this->db->join('block_master bm','th.cd_block = bm.block_code','left');
					$this->db->join('gp_master gm','th.gp = gm.pk_gp_code','left');
					$this->db->join('village_master vm','th.revenue_village = vm.pk_village_code','left');
					$this->db->join('supplier sup','sup.supplier_code=th.tr_supplier_id ','left');
					$this->db->where_in('ticket_status',array('OPEN','SUSPEND'));
					$this->db->where('rt.req_for_to',$data['supplier_code']);
					$this->db->where('rt.req_sub_group',$data['scheme_code']);
					$this->db->where('th.transaction_status !=' ,'cancelled');
					if($this->role =='VENDOR'){
						$this->db->where('sup.fk_user_code',$this->user_code);
					}
					 $this->db->order_by('DATEDIFF(NOW(), rt.actual_issue_date) DESC');
					return $this->db->get()->result_array();
				break;
				case 'get_raise_ticket_cases_d':
				if($data['supplier_code']=="oreda")
				{
					$this->db->select('rt.ticket_id,ticket_status, th.habitation, vm.village_name, gm.gp_name, bm.block_name,
					dm.district_name, rt.actual_issue_date, DATEDIFF(NOW(), rt.actual_issue_date) AS ageing, th.id, rt.req_by');
					$this->db->from('raise_ticket rt');
					$this->db->join('customer c','rt.req_by = c.id ','left');
					$this->db->join('transaction_header th','c.id = th.tr_customer_id','left');
					$this->db->join('district_master dm','th.district = dm.district_code','left');
					$this->db->join('block_master bm','th.cd_block = bm.block_code','left');
					$this->db->join('gp_master gm','th.gp = gm.pk_gp_code','left');
					$this->db->join('village_master vm','th.revenue_village = vm.pk_village_code','left');
					$this->db->join('supplier sup','sup.supplier_code=th.tr_supplier_id ','left');
					$this->db->where_in('ticket_status',array('ABANDONED', 'SUSPEND'));
					$this->db->where('date(ifnull(valid_till,now()))>=date(now())');
					$this->db->where('consumer_id IS NOT NULL');
					$this->db->where('rt.req_sub_group',$data['scheme_code']);
					$this->db->order_by('DATEDIFF(NOW(), rt.actual_issue_date) DESC');
					return $this->db->get()->result_array();
				}
				else{
				$this->db->select('rt.ticket_id,th.habitation,vm.village_name,gm.gp_name,bm.block_name,dm.district_name,rt.actual_issue_date,
						DATEDIFF(NOW(),rt.actual_issue_date) AS ageing,th.id,rt.req_by');
					$this->db->from('raise_ticket rt');
					$this->db->join('customer c','rt.req_by = c.id ','left');
					$this->db->join('transaction_header th','c.id = th.tr_customer_id','left');
					$this->db->join('district_master dm','th.district = dm.district_code','left');
					$this->db->join('block_master bm','th.cd_block = bm.block_code','left');
					$this->db->join('gp_master gm','th.gp = gm.pk_gp_code','left');
					$this->db->join('village_master vm','th.revenue_village = vm.pk_village_code','left');
					$this->db->join('supplier sup','sup.supplier_code=th.tr_supplier_id ','left');
					$this->db->where_in('ticket_status',array('OPEN'));
					$this->db->where('date(ifnull(valid_till,now()))>=date(now())');
					$this->db->where('rt.req_for_to',$data['supplier_code']);
					$this->db->where('rt.req_sub_group',$data['scheme_code']);
					$this->db->where('th.transaction_status !=' ,'cancelled');
					if($this->role =='VENDOR'){
						$this->db->where('sup.fk_user_code',$this->user_code);
					}
					 $this->db->order_by('DATEDIFF(NOW(), rt.actual_issue_date) DESC');
					return $this->db->get()->result_array();
				}	
				break;
				case 'get_sm_data':
					$dept_code = '';
					$dept_code1 = '';
	                if($this->role == 'ADEPT'){
						$this->db->select('pk_dept_code');
						$this->db->from('admin_dept');
						$this->db->where('fk_user_code',$this->user_code);
						$ret = $this->db->get()->row_array();
						$dept_code = "WHERE fk_dept_code = '".$ret['pk_dept_code']."'";
						$dept_code1 = "AND fk_dept_code = '".$ret['pk_dept_code']."'";
					}
					/*$query = $this->db->query("SELECT d.c_year,d.month_code,month_yr,tot_tkt, CONCAT(open_tkt,'(',ROUND(((open_tkt/tot_tkt)*100),1),'%)') AS h_tkt,
					CONCAT(closed_tkt,'(',ROUND(((closed_tkt/tot_tkt)*100),1),'%)') AS d_tkt ,rewards, penalty FROM 
					( SELECT c_year,month_code,CONCAT(month_name,'-',c_year) AS month_yr,MAX(CASE WHEN tkt_status='CLOSED' THEN tkts ELSE 0 END) AS open_tkt,
					MAX(CASE WHEN tkt_status='REJECTED' THEN tkts ELSE 0 END) AS closed_tkt,SUM(CASE WHEN tkt_status='REJECTED' THEN tkt_score ELSE 0 END) AS penalty,
					SUM(CASE WHEN tkt_status='CLOSED' THEN tkt_score ELSE 0 END) AS rewards 
					FROM (
					SELECT a.c_year,a.month_code,b.month_name ,COUNT(*)AS tkts,tkt_status,SUM(tkt_score)AS tkt_score
					FROM (SELECT st.* FROM schedule_ticket st LEFT JOIN scheme_header ON scheme_id=pk_scheme_code 
					WHERE tkt_status IN ('REJECTED','CLOSED') $dept_code1) a 
					LEFT JOIN schedule_mth_qtr_mc b ON a.month_code=b.month_id GROUP BY c_year,month_code,tkt_status 
					ORDER BY c_year,month_code DESC) a GROUP BY c_year,month_code
					)d LEFT JOIN 
					(SELECT c_year,month_code,COUNT(*) AS tot_tkt FROM schedule_ticket 
					LEFT JOIN scheme_header ON scheme_id=pk_scheme_code 
					$dept_code GROUP BY c_year,month_code)e 
					ON d.c_year=e.c_year AND d.month_code=e.month_code");*/
					$query = $this->db->query("SELECT e.c_year,e.month_code,month_yr,tot_tkt, CONCAT(open_tkt,'(',ROUND(((open_tkt/tot_tkt)*100),1),'%)') AS h_tkt,
											CONCAT(closed_tkt,'(',ROUND(((closed_tkt/tot_tkt)*100),1),'%)') AS d_tkt ,rewards, penalty FROM 
											(SELECT c_year,month_code,CONCAT(month_name,'-',c_year) AS month_yr,COUNT(*) AS tot_tkt FROM schedule_ticket a
											LEFT JOIN schedule_mth_qtr_mc b ON a.month_code=b.month_id 
											LEFT JOIN scheme_header c ON scheme_id=pk_scheme_code $dept_code 
											 GROUP BY c_year,month_code  ORDER BY c_year DESC,month_code DESC)e  LEFT JOIN  
											( SELECT c_year,month_code,MAX(CASE WHEN tkt_status='CLOSED' THEN tkts ELSE 0 END) AS open_tkt,
											MAX(CASE WHEN tkt_status='REJECTED' THEN tkts ELSE 0 END) AS closed_tkt,SUM(CASE WHEN tkt_status='REJECTED' THEN tkt_score ELSE 0 END) AS penalty,
											SUM(CASE WHEN tkt_status='CLOSED' THEN tkt_score ELSE 0 END) AS rewards 
											FROM (SELECT a.c_year,a.month_code,COUNT(*)AS tkts,tkt_status,SUM(tkt_score)AS tkt_score
											FROM (SELECT st.* FROM schedule_ticket st LEFT JOIN scheme_header ON scheme_id=pk_scheme_code 
											WHERE tkt_status IN ('REJECTED','CLOSED') $dept_code1) a 
											GROUP BY c_year,month_code,tkt_status 
											ORDER BY c_year,month_code DESC) a GROUP BY c_year ,month_code  ORDER BY c_year DESC,month_code DESC)d
											ON d.c_year=e.c_year AND d.month_code=e.month_code");
					
					return $query->result_array();		
				break;
				case 'get_sm_vendor_data':
					$dept_code = '';
	                if($this->role == 'ADEPT'){
						$this->db->select('pk_dept_code');
						$this->db->from('admin_dept');
						$this->db->where('fk_user_code',$this->user_code);
						$ret = $this->db->get()->row_array();
						$dept_code = "AND fk_dept_code = '".$ret['pk_dept_code']."'";
					}
					$query = $this->db->query("SELECT c_year,month_code,month_yr,vendor_id,supplier_name,tot_tkt,IF(month_code=MONTH(NOW()),'OPEN','CLOSE') AS t_status,CONCAT(closed_tkt,'(',ROUND(((closed_tkt/tot_tkt)*100),1),'%)') AS h_tkt, CONCAT(reject_tkt,'(',ROUND(((reject_tkt/tot_tkt)*100),1),'%)') AS d_tkt, IF(closed_tkt_score,closed_tkt_score,0) AS rewards,IF(reject_tkt_score,reject_tkt_score,0) AS penalty FROM 
						(SELECT c_year,month_code,vendor_id,supplier_name,CONCAT(month_name,'-',c_year) AS month_yr,SUM(tkts) AS tot_tkt,MAX(CASE WHEN tkt_status='REJECTED' THEN tkts ELSE 0 END) AS reject_tkt,
						MAX(CASE WHEN tkt_status='CLOSED' THEN tkts ELSE 0 END) AS closed_tkt,MAX(CASE WHEN tkt_status='REJECTED' THEN tkt_score ELSE '' END) AS reject_tkt_score,
						MAX(CASE WHEN tkt_status='CLOSED' THEN tkt_score ELSE '' END) AS closed_tkt_score FROM (
						SELECT a.c_year,a.month_code,b.month_name,vendor_id,supplier_name ,COUNT(*) AS tkts,tkt_status,SUM(tkt_score) AS tkt_score
						FROM  schedule_ticket a 
						LEFT JOIN schedule_mth_qtr_mc b ON a.month_code=b.month_id
						LEFT JOIN supplier c ON a.vendor_id =c.supplier_code
						LEFT JOIN scheme_header ON scheme_id=pk_scheme_code 
						WHERE c_year='".$data['year']."' AND month_code='".$data['month']."' $dept_code
						GROUP BY c_year,month_code,vendor_id,supplier_name,tkt_status 
						ORDER BY supplier_name ASC) a GROUP BY c_year,month_code,supplier_name,vendor_id)d");
					return $query->result_array();		
				break;
				case 'get_sm_vendor_scheme_data':
					$dept_code = '';
	                if($this->role == 'ADEPT'){
						$this->db->select('pk_dept_code');
						$this->db->from('admin_dept');
						$this->db->where('fk_user_code',$this->user_code);
						$ret = $this->db->get()->row_array();
						$dept_code = "AND fk_dept_code = '".$ret['pk_dept_code']."'";
					}
					$query = $this->db->query("SELECT c_year,month_code,month_yr,supplier_name,scheme_name,scheme_id,tot_tkt,IF(month_code=MONTH(NOW()),'OPEN','CLOSE') AS t_status,CONCAT(closed_tkt,'(',ROUND(((closed_tkt/tot_tkt)*100),1),'%)') AS h_tkt, CONCAT(reject_tkt,'(',ROUND(((reject_tkt/tot_tkt)*100),1),'%)') AS d_tkt, IF(closed_tkt_score,closed_tkt_score,0) AS rewards,IF(reject_tkt_score,reject_tkt_score,0) AS penalty FROM 
						(SELECT c_year,month_code,supplier_name,scheme_id,scheme_name,CONCAT(month_name,'-',c_year) AS month_yr,SUM(tkts) AS tot_tkt,MAX(CASE WHEN tkt_status='REJECTED' THEN tkts ELSE 0 END) AS reject_tkt,
						MAX(CASE WHEN tkt_status='CLOSED' THEN tkts ELSE 0 END) AS closed_tkt,MAX(CASE WHEN tkt_status='REJECTED' THEN tkt_score ELSE '' END) AS reject_tkt_score,
						MAX(CASE WHEN tkt_status='CLOSED' THEN tkt_score ELSE '' END) AS closed_tkt_score FROM (
						SELECT a.c_year,a.month_code,b.month_name,supplier_name,scheme_id,scheme_name ,COUNT(*) AS tkts,tkt_status,SUM(tkt_score) AS tkt_score
						FROM  schedule_ticket a 
						LEFT JOIN schedule_mth_qtr_mc b ON a.month_code=b.month_id
						LEFT JOIN supplier c ON a.vendor_id =c.supplier_code 
						LEFT JOIN scheme_header d ON a.scheme_id =d.pk_scheme_code 
						WHERE c_year='".$data['year']."' AND month_code='".$data['month']."' AND vendor_id='".$data['vendor_id']."' $dept_code
						GROUP BY c_year,month_code,supplier_name,scheme_id,scheme_name,tkt_status 
						ORDER BY scheme_name ASC) a GROUP BY c_year,month_code,supplier_name,scheme_name,scheme_id)d");
					return $query->result_array();		
				break;
				case 'get_sm_scheme_data':
					$dept_code = '';
	                if($this->role == 'ADEPT'){
						$this->db->select('pk_dept_code');
						$this->db->from('admin_dept');
						$this->db->where('fk_user_code',$this->user_code);
						$ret = $this->db->get()->row_array();
						$dept_code = "AND fk_dept_code = '".$ret['pk_dept_code']."'";
					}
					$query = $this->db->query("SELECT c_year,month_code,month_yr,scheme_name,scheme_id,tot_tkt,IF(month_code=MONTH(NOW()),'OPEN','CLOSE') AS t_status,CONCAT(closed_tkt,'(',ROUND(((closed_tkt/tot_tkt)*100),1),'%)') AS h_tkt, CONCAT(reject_tkt,'(',ROUND(((reject_tkt/tot_tkt)*100),1),'%)') AS d_tkt, IF(closed_tkt_score,closed_tkt_score,0) AS rewards,IF(reject_tkt_score,reject_tkt_score,0) AS penalty FROM 
						(SELECT c_year,month_code,scheme_id,scheme_name,CONCAT(month_name,'-',c_year) AS month_yr,SUM(tkts) AS tot_tkt,MAX(CASE WHEN tkt_status='REJECTED' THEN tkts ELSE 0 END) AS reject_tkt,
						MAX(CASE WHEN tkt_status='CLOSED' THEN tkts ELSE 0 END) AS closed_tkt,MAX(CASE WHEN tkt_status='REJECTED' THEN tkt_score ELSE '' END) AS reject_tkt_score,
						MAX(CASE WHEN tkt_status='CLOSED' THEN tkt_score ELSE '' END) AS closed_tkt_score FROM (
						SELECT a.c_year,a.month_code,b.month_name,scheme_id,scheme_name ,COUNT(*) AS tkts,tkt_status,SUM(tkt_score) AS tkt_score
						FROM  schedule_ticket a 
						LEFT JOIN schedule_mth_qtr_mc b ON a.month_code=b.month_id
						LEFT JOIN supplier c ON a.vendor_id =c.supplier_code
						LEFT JOIN scheme_header d ON a.scheme_id =d.pk_scheme_code 
						WHERE c_year='".$data['year']."' AND month_code='".$data['month']."' $dept_code
						GROUP BY c_year,month_code,scheme_id,scheme_name,tkt_status 
						ORDER BY scheme_name ASC) a GROUP BY c_year,month_code,scheme_name,scheme_id)d");
					return $query->result_array();		
				break;
				case 'get_status_projects':
					$dept_code = '';
	                if($this->role == 'ADEPT'){
						$this->db->select('pk_dept_code');
						$this->db->from('admin_dept');
						$this->db->where('fk_user_code',$this->user_code);
						$ret = $this->db->get()->row_array();
						$dept_code = "WHERE fk_dept_code = '".$ret['pk_dept_code']."'";
					}
					$status_query = $this->db->query("SELECT k.scheme_header_id,scheme_name,IFNULL(sanction_cnt,'NO') AS sanction_cnt,IFNULL(order_cnt,'NO') AS order_cnt,location_cnt,vendor_cnt,id_generated,detail_uploaded,installation_completed FROM 
						(SELECT a.scheme_header_id FROM
						(SELECT scheme_header_id,installation,IFNULL(y_id,0) AS y_id,IFNULL(n_id,0) AS n_id FROM 
						(SELECT scheme_header_id,SUM(installation) AS installation FROM scheme_upload GROUP BY scheme_header_id) a
						LEFT JOIN (
						SELECT tr_scheme_id,IFNULL(MAX(CASE WHEN c_id=0 THEN c_cnt END),0) AS n_id,IFNULL(MAX(CASE WHEN c_id=1 THEN c_cnt END),0) AS y_id FROM( 
						SELECT tr_scheme_id,c_id, COUNT(c_id)AS c_cnt FROM(
						SELECT tr_scheme_id,IF(consumer_id IS NULL,0,1)AS c_id FROM transaction_header ) a GROUP BY tr_scheme_id,c_id) b GROUP BY tr_scheme_id
						) b ON a.scheme_header_id=b.tr_scheme_id )a
						WHERE (installation>y_id) OR n_id>0)k
						LEFT JOIN 
						(SELECT 'YES' AS sanction_cnt,scheme_header_id FROM scheme_upload GROUP BY scheme_header_id)a
						ON k.scheme_header_id=a.scheme_header_id left JOIN
						(SELECT 'YES' AS order_cnt,scheme_id FROM sup_village_detail GROUP BY scheme_id)b ON k.scheme_header_id=b.scheme_id
						left JOIN 
						(SELECT COUNT(villages) AS location_cnt,scheme_id FROM sup_village_detail GROUP BY scheme_id)c ON k.scheme_header_id=c.scheme_id
						left JOIN 
						(SELECT COUNT(DISTINCT supplier_id) AS vendor_cnt,scheme_id FROM sup_village_detail GROUP BY scheme_id)d ON k.scheme_header_id=d.scheme_id
						LEFT JOIN 
						(SELECT COUNT(*) AS id_generated,tr_scheme_id FROM transaction_header WHERE consumer_id IS NOT NULL GROUP BY tr_scheme_id)e ON k.scheme_header_id=e.tr_scheme_id
						left JOIN
						(SELECT COUNT(*) AS detail_uploaded,tr_scheme_id FROM transaction_header WHERE transaction_status IN ('approved','submitted') 
						GROUP BY tr_scheme_id)f ON k.scheme_header_id=f.tr_scheme_id
						left JOIN
						(SELECT COUNT(*) AS installation_completed,tr_scheme_id FROM transaction_header WHERE transaction_status IN ('install','approved','submitted') GROUP BY tr_scheme_id)g
						ON k.scheme_header_id=g.tr_scheme_id
						INNER JOIN scheme_header i ON k.scheme_header_id=i.pk_scheme_code $dept_code ");
					return $status_query->result_array();	
				break;
				case "get_vendor_status_list":
					$dept_code = '';
					$dept_code1 = '';
	                if($this->role == 'ADEPT'){
						$this->db->select('pk_dept_code');
						$this->db->from('admin_dept');
						$this->db->where('fk_user_code',$this->user_code);
						$ret = $this->db->get()->row_array();
						$dept_code = "WHERE fk_dept_code = '".$ret['pk_dept_code']."'";
						$dept_code1 = "AND fk_dept_code = '".$ret['pk_dept_code']."'";
					}
					$query = $this->db->query("SELECT supplier_name,IFNULL(sanction_cnt,'NO') AS sanction_cnt,IFNULL(order_cnt,'NO') AS order_cnt,location_cnt,id_generated,detail_uploaded,installation_completed,supplier_code,k.scheme_header_id FROM 
						(
						SELECT a.scheme_header_id FROM
						(SELECT scheme_header_id,SUM(installation) AS installation FROM scheme_upload LEFT JOIN scheme_header ON scheme_header_id = pk_scheme_code $dept_code  GROUP BY scheme_header_id) a
						LEFT JOIN (
						SELECT tr_scheme_id,IFNULL(MAX(CASE WHEN c_id=0 THEN c_cnt END),0) AS n_id,IFNULL(MAX(CASE WHEN c_id=1 THEN c_cnt END),0) AS y_id FROM( 
						SELECT tr_scheme_id,c_id, COUNT(c_id)AS c_cnt FROM(SELECT tr_scheme_id,IF(consumer_id IS NULL,0,1)AS c_id FROM transaction_header 
						LEFT JOIN scheme_header ON tr_scheme_id = pk_scheme_code $dept_code) a 
						GROUP BY tr_scheme_id,c_id) b GROUP BY tr_scheme_id
						) b ON a.scheme_header_id=b.tr_scheme_id
						WHERE (installation>y_id) OR n_id>0 )k 
						INNER JOIN
						(SELECT 'YES' AS sanction_cnt,scheme_header_id FROM scheme_upload LEFT JOIN scheme_header ON scheme_header_id = pk_scheme_code 
						$dept_code GROUP BY scheme_header_id)a
						ON k.scheme_header_id=a.scheme_header_id INNER JOIN
						(SELECT 'YES' AS order_cnt,supplier_id,scheme_id FROM sup_village_detail LEFT JOIN scheme_header ON scheme_id = pk_scheme_code 
						$dept_code GROUP BY scheme_id,supplier_id)b ON k.scheme_header_id=b.scheme_id
						INNER JOIN 
						(SELECT COUNT(villages) AS location_cnt,supplier_id,scheme_id FROM sup_village_detail LEFT JOIN scheme_header ON scheme_id = pk_scheme_code 
						$dept_code GROUP BY scheme_id,supplier_id)c ON k.scheme_header_id=c.scheme_id AND b.supplier_id=c.supplier_id
						LEFT JOIN 
						(SELECT COUNT(*) AS id_generated,tr_scheme_id,tr_supplier_id FROM transaction_header LEFT JOIN scheme_header ON tr_scheme_id = pk_scheme_code 
						WHERE consumer_id IS NOT NULL $dept_code1 GROUP BY tr_scheme_id,tr_supplier_id)e 
						ON k.scheme_header_id=e.tr_scheme_id AND b.supplier_id=e.tr_supplier_id
						LEFT JOIN
						(SELECT COUNT(*) AS detail_uploaded,tr_scheme_id,tr_supplier_id FROM transaction_header LEFT JOIN scheme_header ON tr_scheme_id = pk_scheme_code WHERE transaction_status IN ('approved','submitted') $dept_code1 
						GROUP BY tr_scheme_id,tr_supplier_id)f ON k.scheme_header_id=f.tr_scheme_id AND b.supplier_id=f.tr_supplier_id
						LEFT JOIN
						(SELECT COUNT(*) AS installation_completed,tr_scheme_id,tr_supplier_id FROM transaction_header LEFT JOIN scheme_header ON tr_scheme_id = pk_scheme_code
						 WHERE transaction_status IN ('install','approved','submitted') $dept_code1 GROUP BY tr_scheme_id,tr_supplier_id)g
						ON k.scheme_header_id=g.tr_scheme_id AND b.supplier_id=g.tr_supplier_id
						INNER JOIN supplier i ON b.supplier_id=i.supplier_code
						WHERE k.scheme_header_id='".$data['scheme_id']."' ");
					return $query->result_array();
				break;
				/**
				* Modify By : Subhashree Jena
				* Date: 13-09-2019
				* 
				*/
				case 'get_vendor_wise_status_list':
					/*$query = $this->db->query("SELECT consumer_id,district_name,village_name,block_name,gp_name,work_order_date,id_generated,detail_uploaded,installation_completed,date_of_installation FROM 
						(SELECT consumer_id,work_order,tr_scheme_id,tr_supplier_id,district_name,village_name,block_name,gp_name,a.revenue_village,date_of_installation FROM transaction_header a
						LEFT JOIN district_master d ON a.district=d.district_code
						LEFT JOIN block_master b ON a.cd_block=b.block_code
						LEFT JOIN gp_master g ON a.gp=g.pk_gp_code
						LEFT JOIN village_master v ON a.revenue_village=v.pk_village_code
						WHERE consumer_id IS NULL AND  tr_scheme_id='".$data['scheme_id']."' AND tr_supplier_id='".$data['supplier_code']."')k 
						LEFT JOIN

						(SELECT work_order ,villages,supplier_id,scheme_id,DATE_FORMAT(work_order_date,'%d-%m-%Y') AS work_order_date FROM sup_village_detail WHERE scheme_id='".$data['scheme_id']."' AND supplier_id='".$data['supplier_code']."')b 
						ON k.tr_scheme_id=b.scheme_id AND k.tr_supplier_id=b.supplier_id  AND k.revenue_village=b.villages
						LEFT JOIN 
						(SELECT COUNT(*) AS id_generated,tr_scheme_id,tr_supplier_id FROM transaction_header WHERE consumer_id IS NOT NULL AND tr_scheme_id='".$data['scheme_id']."' AND tr_supplier_id='".$data['supplier_code']."')e 
						ON k.tr_scheme_id=e.tr_scheme_id AND b.supplier_id=e.tr_supplier_id
						LEFT JOIN
						(SELECT COUNT(*) AS detail_uploaded,tr_scheme_id,tr_supplier_id FROM transaction_header WHERE transaction_status IN ('approved','submitted') AND tr_scheme_id='".$data['scheme_id']."' AND tr_supplier_id='".$data['supplier_code']."'
						GROUP BY tr_scheme_id,tr_supplier_id)f ON k.tr_scheme_id=f.tr_scheme_id AND b.supplier_id=f.tr_supplier_id
						LEFT JOIN
						(SELECT COUNT(*) AS installation_completed,tr_scheme_id,tr_supplier_id FROM transaction_header WHERE transaction_status IN ('install','approved','submitted') AND tr_scheme_id='".$data['scheme_id']."'
						AND tr_supplier_id='".$data['supplier_code']."' GROUP BY tr_scheme_id,tr_supplier_id)g
						ON k.tr_scheme_id=g.tr_scheme_id AND b.supplier_id=g.tr_supplier_id");*/
						$query = $this->db->query("SELECT consumer_id,district_name,village_name,block_name,gp_name,IFNULL(work_order_date,'') AS work_order_date,
							IFNULL(DATE_FORMAT(date_of_installation,'%d-%m-%Y'),'') AS date_of_installation,IFNULL(DATE_FORMAT(recce_date,'%d-%m-%Y'),'') AS recce_date,
							IFNULL(DATE_FORMAT(material_site_date,'%d-%m-%Y'),'') AS material_site_date,IFNULL(DATE_FORMAT(installation_date,'%d-%m-%Y'),'') AS installation_date,
							IFNULL(DATE_FORMAT(payment_made_date,'%d-%m-%Y'),'') AS payment_made_date FROM 
							(SELECT consumer_id,work_order,tr_scheme_id,tr_supplier_id,district_name,village_name,block_name,
							gp_name,a.revenue_village,date_of_installation, recce_date,material_site_date,installation_date,payment_made_date
							FROM transaction_header a
							LEFT JOIN district_master d ON a.district=d.district_code
							LEFT JOIN block_master b ON a.cd_block=b.block_code
							LEFT JOIN gp_master g ON a.gp=g.pk_gp_code
							LEFT JOIN village_master v ON a.revenue_village=v.pk_village_code
							WHERE consumer_id IS NULL AND  tr_scheme_id='".$data['scheme_id']."' AND tr_supplier_id='".$data['supplier_code']."'
							)k LEFT JOIN
							(SELECT work_order ,villages,supplier_id,scheme_id,DATE_FORMAT(work_order_date,'%d-%m-%Y') AS work_order_date FROM sup_village_detail WHERE scheme_id='".$data['scheme_id']."' AND supplier_id='".$data['supplier_code']."')b 
							ON k.tr_scheme_id=b.scheme_id AND k.tr_supplier_id=b.supplier_id  AND k.revenue_village=b.villages ");
					return $query->result_array();
				break;
				//Modified_on:12-09-2019 Purpose:Dashboard project data columns added
				case 'project_asset_status':
					if($this->role == 'ADEPT'){
						$this->db->select('pk_dept_code');
						$this->db->from('admin_dept');
						$this->db->where('fk_user_code',$this->user_code);
						$ret = $this->db->get()->row_array();
						$dept_code = "AND fk_dept_code = '".$ret['pk_dept_code']."'";
					}
					$asset_data = $this->db->query("SELECT vendor_cnt,scheme_cnt,installation,cmclapsed,(installation-cmclapsed)AS 'oreda_maintainable' FROM
					(SELECT COUNT(DISTINCT tr_supplier_id) AS vendor_cnt FROM transaction_header LEFT JOIN scheme_header ON tr_scheme_id = pk_scheme_code WHERE consumer_id IS NOT NULL AND tr_status IN ('WORKING','CLOSE') $dept_code )a
					INNER JOIN (SELECT COUNT(DISTINCT tr_scheme_id ) AS scheme_cnt FROM transaction_header  
					LEFT JOIN scheme_header ON  tr_scheme_id = pk_scheme_code  WHERE consumer_id IS NOT NULL AND tr_status IN ('WORKING','CLOSE') $dept_code) b
					INNER JOIN (SELECT COUNT(*) AS installation FROM transaction_header LEFT JOIN scheme_header ON  tr_scheme_id = pk_scheme_code WHERE consumer_id IS NOT NULL $dept_code)c
					INNER JOIN (SELECT COUNT(*) AS cmclapsed FROM transaction_header LEFT JOIN scheme_header ON  tr_scheme_id = pk_scheme_code WHERE consumer_id IS NOT NULL AND CURDATE() > valid_till $dept_code)d");
        			return $asset_data->row_array();
        		break;
        		//Modified_on:12-09-2019 Purpose:Dashboard project data columns added
        		case 'projectwise_asset_status':
        			if($this->role == 'ADEPT'){
						$this->db->select('pk_dept_code');
						$this->db->from('admin_dept');
						$this->db->where('fk_user_code',$this->user_code);
						$ret = $this->db->get()->row_array();
						$dept_code = "AND fk_dept_code = '".$ret['pk_dept_code']."'";
					}
	                $projectwise_asset_status_data = $this->db->query("SELECT DISTINCT(c.tr_scheme_id),scheme_name,installation, vendor,cmclapsed,(installation-cmclapsed) AS 'oreda_maintainable' FROM
					(SELECT tr_scheme_id, b.scheme_name, COUNT(a.id) AS installation, COUNT(DISTINCT tr_supplier_id) AS vendor FROM scheme_header b
					LEFT JOIN transaction_header a ON a.tr_scheme_id=b.pk_scheme_code WHERE consumer_id != '' $dept_code
					GROUP BY tr_scheme_id, b.scheme_name)c
					LEFT JOIN (SELECT tr_scheme_id,COUNT(cmclapsed) AS cmclapsed FROM
					(SELECT tr_scheme_id,CASE WHEN CURDATE() > valid_till THEN 'invalid' END AS cmclapsed  FROM transaction_header
					LEFT JOIN scheme_header ON tr_scheme_id=pk_scheme_code WHERE consumer_id IS NOT NULL $dept_code)d
					GROUP BY tr_scheme_id)e ON c.tr_scheme_id=e.tr_scheme_id");
        			return $projectwise_asset_status_data->result_array();
				break;	
				//Modified_on:12-09-2019 Purpose:Dashboard project data columns added
				case 'schemewise_asset_status':
					if($this->role == 'ADEPT'){
						$this->db->select('pk_dept_code');
						$this->db->from('admin_dept');
						$this->db->where('fk_user_code',$this->user_code);
						$ret = $this->db->get()->row_array();
						$dept_code = "AND fk_dept_code = '".$ret['pk_dept_code']."'";
					}
	                $schemewise_asset_status_data = $this->db->query("SELECT th.consumer_id, CONCAT(IF(IFNULL(th.habitation, '')='', '',
					CONCAT(th.habitation, ', ')), IF(IFNULL(vm.village_name, '')='', '',
					CONCAT(vm.village_name, ', ')), IF(IFNULL(gm.gp_name, '')='', '',
					CONCAT(gm.gp_name, ', ')), IF(IFNULL(bm.block_name, '')='', '',
					CONCAT(bm.block_name, ', ')), dm.district_name) AS customer_address,
					sh.supplier_name, th.id,
					CASE WHEN CURDATE() > valid_till THEN 'cmclapsed' ELSE 'oreda maintainable' END AS 'status'
					FROM transaction_header th
					LEFT JOIN village_master vm ON th.revenue_village=vm.pk_village_code
					LEFT JOIN block_master bm ON th.cd_block=bm.block_code
					LEFT JOIN gp_master gm ON th.gp=gm.pk_gp_code
					LEFT JOIN district_master dm ON th.district=dm.district_code
					LEFT JOIN supplier sh ON sh.supplier_code = th.tr_supplier_id
					LEFT JOIN scheme_header ON tr_scheme_id=pk_scheme_code 
					WHERE transaction_status != 'cancelled' AND th.consumer_id != '' AND th.tr_scheme_id = '".$data['scheme_id']."' $dept_code
					ORDER BY th.id");
        			return $schemewise_asset_status_data->result_array();
				break;
				case 'get_asset_vendor_count':
					if($this->role == 'ADEPT'){
						$this->db->select('pk_dept_code');
						$this->db->from('admin_dept');
						$this->db->where('fk_user_code',$this->user_code);
						$ret = $this->db->get()->row_array();
						$dept_code = "AND fk_dept_code = '".$ret['pk_dept_code']."'";
					}
					$query = $this->db->query("SELECT vendor_cnt,scheme_cnt,installation,cmclapsed,(installation-cmclapsed)AS 'oreda maintainable' FROM
					(SELECT COUNT(DISTINCT tr_supplier_id) AS vendor_cnt FROM transaction_header LEFT JOIN scheme_header ON tr_scheme_id = pk_scheme_code WHERE consumer_id IS NOT NULL AND tr_status IN ('WORKING','CLOSE') $dept_code)a
					INNER JOIN
					(SELECT COUNT(DISTINCT tr_scheme_id ) AS scheme_cnt FROM transaction_header LEFT JOIN scheme_header ON tr_scheme_id = pk_scheme_code WHERE consumer_id IS NOT NULL AND tr_status IN ('WORKING','CLOSE') $dept_code) b
					INNER JOIN
					(SELECT COUNT(*) AS installation FROM transaction_header LEFT JOIN scheme_header ON tr_scheme_id = pk_scheme_code WHERE consumer_id IS NOT NULL $dept_code)c
					INNER JOIN
					(SELECT COUNT(*) AS cmclapsed FROM transaction_header LEFT JOIN scheme_header ON tr_scheme_id = pk_scheme_code WHERE consumer_id IS NOT NULL AND CURDATE() > valid_till $dept_code)d");
					return $query->row_array();
				break;
				case 'get_vendor_asset_project_list':
					$order = '';
	                $Ocolumn = '';
	                $Odir = '';
	                $output = array("aaData" => array());
	                $page = $data['page'];
	                $iDisplayLength = $this->input->post('length');//to shw number of record to be shown
		            $iDisplayStart = $this->input->post('start');//to start from that position (ex: offset)
	                if($page ==  'ALL'){
	                	$this->db->from("transaction_header th");
						$this->db->select("th.consumer_id,sh.scheme_code, CONCAT(IF(IFNULL(th.habitation, '')='', '', CONCAT(th.habitation, ', ')),
							IF(IFNULL(vm.village_name, '')='', '', CONCAT(vm.village_name, ', ')), 
							IF(IFNULL(gm.gp_name, '')='', '', CONCAT(gm.gp_name, ', ')), 
							IF(IFNULL(bm.block_name, '')='', '', CONCAT(bm.block_name, ', ')), dm.district_name) AS customer_address,CASE WHEN CURDATE() > valid_till THEN 'CMC lapsed' ELSE 'Oreda Maintainable' END AS 'Status',th.id,th.tr_customer_id");
						$this->db->join("village_master vm","th.revenue_village=vm.pk_village_code","left");
						$this->db->join("block_master bm","th.cd_block=bm.block_code","left");
						$this->db->join("gp_master gm","th.gp=gm.pk_gp_code","left");
						$this->db->join("district_master dm","th.district=dm.district_code","left");
						$this->db->join("scheme_header sh","sh.pk_scheme_code = th.tr_scheme_id","left");
						$this->db->where("transaction_status !=","cancelled");
						$this->db->where("th.consumer_id !=","");
						$this->db->where("th.tr_supplier_id",$data['supplier_code']);
						$this->db->order_by("th.id","ASC");
		                $query = $this->db->get()->result_array();
	                }else{
		                $order = $this->input->post('order');
		                if ($order) {
		                    foreach ($order as $row) {
		                        $Ocolumn = $row['column'];
		                        $Odir = $row['dir'];
		                    }
		                    $this->db->order_by($Ocolumn, $Odir);
		                } else {
		                    $this->db->order_by(1, "ASC");
		                }
		                $search = $this->input->post('search');
		                $header = array('sh.scheme_code','th.consumer_id');//search filter will work on this column
		                $filter_string="";
		                if ($search['value'] != '') {
		                    for ($i = 0; $i < count($header); $i++) {
		                       $filter_string.=' or '.$header[$i]." LIKE '%".$search['value']."%'";
		                    }
		                    $filter_string=substr($filter_string,3);
		                    $filter_string='('.$filter_string.')';
		                }
		                $this->db->limit($iDisplayLength, $iDisplayStart);
		               	$this->db->from("transaction_header th");
						$this->db->select("th.consumer_id,sh.scheme_code, CONCAT(IF(IFNULL(th.habitation, '')='', '', CONCAT(th.habitation, ', ')),
							IF(IFNULL(vm.village_name, '')='', '', CONCAT(vm.village_name, ', ')), 
							IF(IFNULL(gm.gp_name, '')='', '', CONCAT(gm.gp_name, ', ')), 
							IF(IFNULL(bm.block_name, '')='', '', CONCAT(bm.block_name, ', ')), dm.district_name) AS customer_address,CASE WHEN CURDATE() > valid_till THEN 'CMC lapsed' ELSE 'Oreda Maintainable' END AS 'Status',
							th.id,th.tr_customer_id");
						$this->db->join("village_master vm","th.revenue_village=vm.pk_village_code","left");
						$this->db->join("block_master bm","th.cd_block=bm.block_code","left");
						$this->db->join("gp_master gm","th.gp=gm.pk_gp_code","left");
						$this->db->join("district_master dm","th.district=dm.district_code","left");
						$this->db->join("scheme_header sh","sh.pk_scheme_code = th.tr_scheme_id","left");
						$this->db->where("transaction_status !=","cancelled");
						$this->db->where("th.consumer_id !=","");
						$this->db->where("th.tr_supplier_id",$data['supplier_code']);
						if($filter_string!=''){
							$this->db->where($filter_string);
						}
						$this->db->order_by("th.id","ASC");
		                $query = $this->db->get()->result_array();
		                //print_r($this->db->last_query());die();
		                /*----FOR PAGINATION-----*/
		                $this->db->from("transaction_header th");
						$this->db->select("th.consumer_id,sh.scheme_code, CONCAT(IF(IFNULL(th.habitation, '')='', '', CONCAT(th.habitation, ', ')),
							IF(IFNULL(vm.village_name, '')='', '', CONCAT(vm.village_name, ', ')), 
							IF(IFNULL(gm.gp_name, '')='', '', CONCAT(gm.gp_name, ', ')), 
							IF(IFNULL(bm.block_name, '')='', '', CONCAT(bm.block_name, ', ')), dm.district_name) AS customer_address,CASE WHEN CURDATE() > valid_till THEN 'CMC lapsed' ELSE 'Oreda Maintainable' END AS 'Status',
							th.id,th.tr_customer_id");
						$this->db->join("village_master vm","th.revenue_village=vm.pk_village_code","left");
						$this->db->join("block_master bm","th.cd_block=bm.block_code","left");
						$this->db->join("gp_master gm","th.gp=gm.pk_gp_code","left");
						$this->db->join("district_master dm","th.district=dm.district_code","left");
						$this->db->join("scheme_header sh","sh.pk_scheme_code = th.tr_scheme_id","left");
						$this->db->where("transaction_status !=","cancelled");
						$this->db->where("th.consumer_id !=","");
						$this->db->where("th.tr_supplier_id",$data['supplier_code']);
						if($filter_string!=''){
							$this->db->where($filter_string);
						}
						$this->db->order_by("th.id","ASC");
		                $res1 = $this->db->get();
		                $output["draw"] = intval($this->input->post('draw'));
		                $output['iTotalRecords'] = $res1->num_rows();
		                $output['iTotalDisplayRecords'] = $res1->num_rows();
	                }
	                $slno = $iDisplayStart+1;
	                foreach ($query as $aRow) {
	                    $row[0] = $slno;
	                    $row['sl_no'] = $slno;
	                    $i = 1;
	                    foreach ($aRow as $key => $value) {
	                        $row[$i] = $value;
	                        $row[$key] = $value;
	                        $i++;
	                    }
	                    $slno++;
	                    $output['aaData'][] = $row;
	                    unset($row);
	                }
            		return $output;
				break;
				case "get_vendor_asset_status_list":
					if($this->role == 'ADEPT'){
						$this->db->select('pk_dept_code');
						$this->db->from('admin_dept');
						$this->db->where('fk_user_code',$this->user_code);
						$ret = $this->db->get()->row_array();
						$dept_code = "AND fk_dept_code = '".$ret['pk_dept_code']."'";
					}
					$query = $this->db->query("SELECT d.tr_supplier_id,supplier_name,installation,scheme,cmclapsed,(installation-cmclapsed) AS 'oreda maintainable' FROM
					(SELECT tr_supplier_id,supplier_name,COUNT(a.id) AS installation,COUNT(DISTINCT tr_scheme_id) AS scheme
					FROM transaction_header a
					LEFT JOIN supplier b ON a.tr_supplier_id=b.supplier_code
					LEFT JOIN scheme_header ON tr_scheme_id=pk_scheme_code 
					WHERE consumer_id IS NOT NULL $dept_code
					GROUP BY tr_supplier_id)d
					LEFT JOIN
					(SELECT tr_supplier_id,COUNT(cmclapsed) AS cmclapsed FROM
					(SELECT tr_supplier_id,CASE WHEN CURDATE() > valid_till THEN 'invalid' END AS cmclapsed  FROM transaction_header 
					LEFT JOIN scheme_header ON tr_scheme_id=pk_scheme_code 
					WHERE consumer_id IS NOT NULL $dept_code)d
					GROUP BY tr_supplier_id)e ON d.tr_supplier_id = e.tr_supplier_id");
					return $query->result_array();
				break;
				/**
				* Name : Subhashree jena
				* Date :09-08-2019
				* Purpose: Technician ticket count
				* @var 
				* 
				*/
				case 'get_tech_installation_count':
					$query = $this->db->query("SELECT open_inst,closed FROM
						(SELECT COUNT(*)AS open_inst FROM `sup_tech_map` WHERE STATUS = 'open' AND `technician_mobile_number` = '".$this->user_name."')a JOIN 
						(SELECT COUNT(*) AS closed FROM `sup_tech_map` WHERE STATUS = 'Closed' AND `technician_mobile_number` = '".$this->user_name."' )b ");
					return $query->row_array();
				break;
				case 'get_tech_schedule_ticket_count':
					$query = $this->db->query("SELECT open_tkt,close_tkt FROM 
						(SELECT COUNT(*) AS open_tkt FROM `schedule_ticket` WHERE technician_id='".$this->user_name."' AND tkt_status='OPEN') a JOIN
						(SELECT COUNT(*) AS close_tkt FROM `schedule_ticket` WHERE technician_id='".$this->user_name."' AND tkt_status IN('RESOLVE','CLOSED')) b ");
					return $query->row_array();
				break;
				case 'get_tech_corrective_ticket_count':
					$query = $this->db->query("SELECT open_tkt,close_tkt FROM
						(SELECT COUNT(*) AS open_tkt FROM raise_ticket WHERE technician_id = '".$this->user_name."' AND ticket_status IN ('OPEN','REOPEN')) a JOIN
						(SELECT COUNT(*) AS close_tkt FROM raise_ticket WHERE technician_id = '".$this->user_name."' AND ticket_status  ='CLOSE') b ");
					return $query->row_array();
				break;
				/**
				* Name : Subhashree jena
				* Date : 06-09-2019
				* Purpose : Get Vendor Status project
				*/
				case 'get_vendor_status_project':
					if($this->role == 'ADEPT'){
						$this->db->select('pk_dept_code');
						$this->db->from('admin_dept');
						$this->db->where('fk_user_code',$this->user_code);
						$ret = $this->db->get()->row_array();
						$dept_code = "WHERE fk_dept_code = '".$ret['pk_dept_code']."'";
					}
					$query = $this->db->query("SELECT k.tr_supplier_id,supplier_name,IFNULL(order_cnt,'NO') AS sanction_cnt,SUM(IFNULL(location_cnt,0)) AS location_cnt,
						IFNULL(order_cnt,'NO') AS order_cnt,MAX(s_cnt) AS scheme_count,SUM(IFNULL(detail_uploaded,0)) AS detail_uploaded,
						SUM(IFNULL(installation_completed,0)) AS installation_completed,SUM(IFNULL(id_generated,0)) AS id_generated FROM 
						( SELECT tr_supplier_id,tr_scheme_id,fk_dept_code  FROM transaction_header LEFT JOIN scheme_header ON  consumer_id IS NULL AND tr_scheme_id = pk_scheme_code $dept_code  GROUP BY  tr_supplier_id,tr_scheme_id,fk_dept_code )k INNER JOIN
						(SELECT tr_supplier_id,COUNT(DISTINCT tr_scheme_id) AS s_cnt  FROM transaction_header WHERE consumer_id IS NULL GROUP BY  tr_supplier_id)s
						ON k.tr_supplier_id=s.tr_supplier_id LEFT JOIN
						(SELECT 'YES' AS order_cnt,supplier_id,scheme_id FROM sup_village_detail GROUP BY scheme_id,supplier_id)b ON k.tr_scheme_id=b.scheme_id AND k.tr_supplier_id=b.supplier_id
						LEFT JOIN 
						(SELECT COUNT(villages) AS location_cnt,supplier_id,scheme_id FROM sup_village_detail GROUP BY scheme_id,supplier_id)c ON k.tr_scheme_id=c.scheme_id AND k.tr_supplier_id=c.supplier_id
						LEFT JOIN 
						(SELECT COUNT(*) AS id_generated,tr_scheme_id,tr_supplier_id FROM transaction_header WHERE  consumer_id IS NOT NULL GROUP BY tr_scheme_id,tr_supplier_id)e 
						ON k.tr_scheme_id=e.tr_scheme_id AND k.tr_supplier_id=e.tr_supplier_id
						LEFT JOIN
						(SELECT COUNT(*) AS detail_uploaded,tr_scheme_id,tr_supplier_id FROM transaction_header WHERE  transaction_status IN ('approved','submitted') 
						GROUP BY tr_scheme_id,tr_supplier_id)f ON k.tr_scheme_id=f.tr_scheme_id AND k.tr_supplier_id=f.tr_supplier_id
						LEFT JOIN
						(SELECT COUNT(*) AS installation_completed,tr_scheme_id,tr_supplier_id FROM transaction_header WHERE  transaction_status IN ('install','approved','submitted') GROUP BY tr_scheme_id,tr_supplier_id)g
						ON k.tr_scheme_id=g.tr_scheme_id AND k.tr_supplier_id=g.tr_supplier_id
						INNER JOIN supplier i ON k.tr_supplier_id=i.supplier_code
						GROUP BY k.tr_supplier_id,supplier_name,order_cnt ");
					return $query->result_array();
				break;
				case 'get_status_individual_vendor':
				$dept_code = '';
				$dept_code1 = '';
	                if($this->role == 'ADEPT'){
						$this->db->select('pk_dept_code');
						$this->db->from('admin_dept');
						$this->db->where('fk_user_code',$this->user_code);
						$ret = $this->db->get()->row_array();
						$dept_code = "where fk_dept_code = '".$ret['pk_dept_code']."'";
						$dept_code1 = "AND fk_dept_code = '".$ret['pk_dept_code']."'";
					}
				 	$query = $this->db->query("SELECT k.tr_supplier_id,k.tr_scheme_id,scheme_name,IFNULL(order_cnt,'NO') AS sanction_cnt,IFNULL(location_cnt,0) AS location_cnt,
					IFNULL(order_cnt,'NO') AS order_cnt,IFNULL(detail_uploaded,0) AS detail_uploaded,
					IFNULL(installation_completed,0) AS installation_completed,IFNULL(id_generated,0) AS id_generated FROM 
					( SELECT  tr_supplier_id, tr_scheme_id  FROM transaction_header WHERE tr_supplier_id='".$data['supplier_code']."' AND consumer_id IS NULL GROUP BY  tr_supplier_id,tr_scheme_id
					)k 
					LEFT JOIN
					(SELECT 'YES' AS order_cnt,supplier_id,scheme_id FROM sup_village_detail LEFT JOIN scheme_header ON scheme_id = pk_scheme_code $dept_code GROUP BY scheme_id,supplier_id)b ON k.tr_scheme_id=b.scheme_id AND k.tr_supplier_id=b.supplier_id
					LEFT JOIN 
					(SELECT COUNT(villages) AS location_cnt,supplier_id,scheme_id FROM sup_village_detail LEFT JOIN scheme_header ON scheme_id = pk_scheme_code $dept_code GROUP BY scheme_id,supplier_id)c ON k.tr_scheme_id=c.scheme_id AND k.tr_supplier_id=c.supplier_id
					LEFT JOIN 
					(SELECT COUNT(*) AS id_generated,tr_scheme_id,tr_supplier_id FROM transaction_header LEFT JOIN scheme_header ON tr_scheme_id = pk_scheme_code  WHERE  consumer_id IS NOT NULL $dept_code1 GROUP BY tr_scheme_id,tr_supplier_id)e 
					ON k.tr_scheme_id=e.tr_scheme_id AND k.tr_supplier_id=e.tr_supplier_id
					LEFT JOIN
					(SELECT COUNT(*) AS detail_uploaded,tr_scheme_id,tr_supplier_id FROM transaction_header LEFT JOIN scheme_header ON tr_scheme_id = pk_scheme_code WHERE  transaction_status IN ('approved','submitted') $dept_code1
					GROUP BY tr_scheme_id,tr_supplier_id)f ON k.tr_scheme_id=f.tr_scheme_id AND k.tr_supplier_id=f.tr_supplier_id
					LEFT JOIN
					(SELECT COUNT(*) AS installation_completed,tr_scheme_id,tr_supplier_id FROM transaction_header LEFT JOIN scheme_header ON tr_scheme_id = pk_scheme_code
					WHERE transaction_status IN ('install','approved','submitted') $dept_code1 GROUP BY tr_scheme_id,tr_supplier_id)g
					ON k.tr_scheme_id=g.tr_scheme_id AND k.tr_supplier_id=g.tr_supplier_id
					INNER JOIN scheme_header i ON k.tr_scheme_id=i.pk_scheme_code");
						
				 	return $query->result_array();
				break;
				/**
				* 
				* Modify By : Subhashree Jena
				* Date : 13-09-2019
				*/
				case 'get_vendor_project_list' :
					/*$query = $this->db->query("SELECT consumer_id,CONCAT (district_name,'|',block_name,'|',gp_name,'|',village_name) AS name_units,work_order_date,id_generated,detail_uploaded,installation_completed FROM (
						SELECT consumer_id,work_order,tr_scheme_id,tr_supplier_id,district_name,village_name,block_name,gp_name,revenue_village FROM transaction_header a
						LEFT JOIN district_master d ON a.district=d.district_code
						LEFT JOIN block_master b ON a.cd_block=b.block_code
						LEFT JOIN gp_master g ON a.gp=g.pk_gp_code
						LEFT JOIN village_master v ON a.revenue_village=v.pk_village_code
						 WHERE tr_scheme_id='".$data['scheme_id']."' AND tr_supplier_id='".$data['supplier_code']."' AND consumer_id IS NULL )k 
						LEFT JOIN (SELECT work_order ,villages,supplier_id,scheme_id,DATE_FORMAT(work_order_date,'%d-%m-%Y') AS work_order_date  FROM sup_village_detail WHERE scheme_id='".$data['scheme_id']."' AND supplier_id='".$data['supplier_code']."')b 
						ON k.tr_scheme_id=b.scheme_id AND k.tr_supplier_id=b.supplier_id AND k.revenue_village=b.villages
						LEFT JOIN (SELECT COUNT(*) AS id_generated,tr_scheme_id,tr_supplier_id FROM transaction_header WHERE  consumer_id IS NOT NULL AND  tr_scheme_id='".$data['scheme_id']."' AND tr_supplier_id='".$data['supplier_code']."')e 
						ON k.tr_scheme_id=e.tr_scheme_id AND b.supplier_id=e.tr_supplier_id
						LEFT JOIN(SELECT COUNT(*) AS detail_uploaded,tr_scheme_id,tr_supplier_id FROM transaction_header WHERE  transaction_status IN ('approved','submitted') AND  tr_scheme_id='".$data['scheme_id']."' AND tr_supplier_id='".$data['supplier_code']."'
						GROUP BY tr_scheme_id,tr_supplier_id)f ON k.tr_scheme_id=f.tr_scheme_id AND b.supplier_id=f.tr_supplier_id
						LEFT JOIN (SELECT COUNT(*) AS installation_completed,tr_scheme_id,tr_supplier_id FROM transaction_header WHERE  transaction_status IN ('install','approved','submitted') AND  tr_scheme_id='".$data['scheme_id']."'
						 AND tr_supplier_id='".$data['supplier_code']."' GROUP BY tr_scheme_id,tr_supplier_id)g
						ON k.tr_scheme_id=g.tr_scheme_id AND b.supplier_id=g.tr_supplier_id");*/
						$query = $this->db->query("SELECT consumer_id,CONCAT (district_name,'|',block_name,'|',gp_name,'|',village_name) AS name_units,work_order_date,
						IFNULL(DATE_FORMAT(date_of_installation,'%d-%m-%Y'),'') AS date_of_installation,IFNULL(DATE_FORMAT(recce_date,'%d-%m-%Y'),'') AS recce_date,
						IFNULL(DATE_FORMAT(material_site_date,'%d-%m-%Y'),'') AS material_site_date,IFNULL(DATE_FORMAT(installation_date,'%d-%m-%Y'),'') AS installation_date,
						IFNULL(DATE_FORMAT(payment_made_date,'%d-%m-%Y'),'') AS payment_made_date
						FROM (SELECT consumer_id,work_order,tr_scheme_id,tr_supplier_id,district_name,village_name,block_name,gp_name,revenue_village,
						date_of_installation, recce_date,material_site_date,installation_date,payment_made_date
						 FROM transaction_header a
						LEFT JOIN district_master d ON a.district=d.district_code
						LEFT JOIN block_master b ON a.cd_block=b.block_code
						LEFT JOIN gp_master g ON a.gp=g.pk_gp_code
						LEFT JOIN village_master v ON a.revenue_village=v.pk_village_code
						WHERE tr_scheme_id='".$data['scheme_id']."' AND tr_supplier_id='".$data['supplier_code']."' AND consumer_id IS NULL )k 
						LEFT JOIN (SELECT work_order ,villages,supplier_id,scheme_id,IFNULL(DATE_FORMAT(work_order_date,'%d-%m-%Y'),'') AS work_order_date  FROM sup_village_detail WHERE scheme_id='".$data['scheme_id']."' AND supplier_id='".$data['supplier_code']."')b 
						ON k.tr_scheme_id=b.scheme_id AND k.tr_supplier_id=b.supplier_id AND k.revenue_village=b.villages");
					return $query->result_array();
				default:
					return array('status'=>false, 'msg'=>NO_OPERATION);
			}
		}
	}