
<?php defined('BASEPATH') OR exit('No direct script access allowed');
	class Transaction_controller extends CI_Controller  {
  		public function __construct(){
    		parent::__construct();
    		
    		# libraries
			$this->load->library('form_validation');
			$this->load->library('user_agent');
			
			# libraries
			$this->load->helper('custom_page');
			
			# models
			$this->load->model(array('getter_model','transaction_model','raise_ticket_model'));
			# views
			$data['title'] = $this->getter_model->get(null,'get_title');
			$this->load->view('templates/header',$data);
   		}
   		public function page_not_found(){
			$this->load->view('templates/404');
			$this->load->view('templates/footer');
		}
		public function _remap($method){
			$class 	= $this->router->class;
			$role = $this->session->userdata('role');
			$check_user = $this->getter_model->get(null,'get_user_check');
			
			$role_action_auth = array(			
				'CRCADMIN'=>array('add_installations','edit_installations','edit_view_installations', 'manage_installations','view_transaction_details','transaction_report','view_installations','maintainance_report'),
				'CRCAGENT'=>array('add_installations','edit_installations','edit_view_installations', 'manage_installations','view_transaction_details','transaction_report','view_installations','maintainance_report'),
				'ADEPT'=>array('manage_installations','transaction_report','view_transaction_details','maintainance_report'),
				'OCE'=>array('manage_installations','transaction_report','view_transaction_details','maintainance_report'),
				'ODR'=>array('manage_installations','transaction_report','view_transaction_details','maintainance_report','view_installations'),
				'VENDOR'=>array('add_installations','edit_installations','manage_installations','transaction_report','view_transaction_details','maintainance_report','view_installations'),
				'ODH'=>array('manage_installations','transaction_report','view_transaction_details','view_installations','maintainance_report'),
				'ODA'=>array('manage_installations','add_installations','edit_installations','transaction_report','view_installations','view_transaction_details','maintainance_report'),
				'OTO'=>array('manage_installations','transaction_report','view_transaction_details','maintainance_report'),
				'TECHNICIAN'=>array('transaction_report','maintainance_report','view_installations')
			);

			if( $role == false || !isset($role_action_auth[$role]) || !in_array($method, $role_action_auth[$role]) || !$check_user){
				redirect('logout');
			}else{
				if (in_array(strtolower($method), array_map('strtolower', get_class_methods($this)))){
					$uri = $this->uri->segment_array();
					unset($uri[1]);
					unset($uri[2]);
					call_user_func_array(array($this, $method), $uri);
				}else{
					self::page_not_found();
				}
			}
		}
		public function add_installations(){
			$sidebar['menu_item'] = 'Add Installations';
			$sidebar['menu_group'] = 'Project Management';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$data['all_scheme_list'] 	  = $this->getter_model->get(null,'get_all_scheme_list');
			//$data['all_finance_source']   = $this->getter_model->get(array('gen_code_group'=>'FINANCE_SOURCE'),'get_gencode_desc');
			$data['all_district_cluster'] = $this->getter_model->get(array('gen_code_group'=>'DISTRICT_CLUSTER'),'get_gencode_desc');
			$data['all_schedule_month']   = $this->getter_model->get(array('gen_code_group'=>'SCHEDULE_MONTH'),'get_gencode_desc');
			$data['all_schedule_week']    = $this->getter_model->get(array('gen_code_group'=>'SCHEDULE_WEEK'),'get_gencode_desc');
			$data['all_caste'] 			  = $this->getter_model->get(array('gen_code_group'=>'CASTE'),'get_gencode_desc');
			$data['all_acs'] 			  = $this->getter_model->get(array('gen_code_group'=>'ACS'),'get_gencode_desc');
			$data['get_all_state']        = $this->getter_model->get(array('country_code'=>'IND'),'get_state_name');
			$data['all_gender']      	  = $this->getter_model->get(array('gen_code_group'=>'GENDER'),'get_gencode_desc');
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('transaction/add_installations',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function edit_installations(){
			$role = $this->session->userdata('role');
			$decode_id      = $this->uri->segment(2);
		    $smth 			= preg_replace("/%u([0-9a-f]{3,4})/i","&#x\\1;",urldecode($decode_id)); 
		    $smth_id 	    = html_entity_decode($smth,null,'UTF-8');
		    $data['trans_id']     = base64_decode($smth_id);
			$sidebar['menu_item'] = 'Manage Installations';
			$sidebar['menu_group'] = 'Project Management';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$data['all_scheme_list'] 	  = $this->getter_model->get(null,'get_all_scheme_list');
			//$data['all_finance_source']   = $this->getter_model->get(array('gen_code_group'=>'FINANCE_SOURCE'),'get_gencode_desc');
			$data['all_district_cluster'] = $this->getter_model->get(array('gen_code_group'=>'DISTRICT_CLUSTER'),'get_gencode_desc');
			$data['all_schedule_month']   = $this->getter_model->get(array('gen_code_group'=>'SCHEDULE_MONTH'),'get_gencode_desc');
			$data['all_schedule_week']    = $this->getter_model->get(array('gen_code_group'=>'SCHEDULE_WEEK'),'get_gencode_desc');
			$data['all_caste'] 			  = $this->getter_model->get(array('gen_code_group'=>'CASTE'),'get_gencode_desc');
			$data['all_acs'] 			  = $this->getter_model->get(array('gen_code_group'=>'ACS'),'get_gencode_desc');
			$data['get_all_state']        = $this->getter_model->get(array('country_code'=>'IND'),'get_state_name');
			$data['all_gender']      	  = $this->getter_model->get(array('gen_code_group'=>'GENDER'),'get_gencode_desc');
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				if($role =='VENDOR'){
					$this->load->view('transaction/vendor_edit_installations',$data);
				}else{
					$this->load->view('transaction/edit_installations',$data);
				}
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function edit_view_installations(){
			$decode_id      = $this->uri->segment(2);
		    $smth 			= preg_replace("/%u([0-9a-f]{3,4})/i","&#x\\1;",urldecode($decode_id)); 
		    $smth_id 	    = html_entity_decode($smth,null,'UTF-8');
		    $data['trans_id']     = base64_decode($smth_id);
			$sidebar['menu_item'] = 'View Installations';
			$sidebar['menu_group'] = 'Asset Management';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$data['all_scheme_list'] 	  = $this->getter_model->get(null,'get_all_scheme_list');
			$data['all_finance_source']   = $this->getter_model->get(array('gen_code_group'=>'FINANCE_SOURCE'),'get_gencode_desc');
			$data['all_district_cluster'] = $this->getter_model->get(array('gen_code_group'=>'DISTRICT_CLUSTER'),'get_gencode_desc');
			$data['all_schedule_month']   = $this->getter_model->get(array('gen_code_group'=>'SCHEDULE_MONTH'),'get_gencode_desc');
			$data['all_schedule_week']    = $this->getter_model->get(array('gen_code_group'=>'SCHEDULE_WEEK'),'get_gencode_desc');
			$data['all_caste'] 			  = $this->getter_model->get(array('gen_code_group'=>'CASTE'),'get_gencode_desc');
			$data['all_acs'] 			  = $this->getter_model->get(array('gen_code_group'=>'ACS'),'get_gencode_desc');
			$data['get_all_state']        = $this->getter_model->get(array('country_code'=>'IND'),'get_state_name');
			$data['all_gender']      	  = $this->getter_model->get(array('gen_code_group'=>'GENDER'),'get_gencode_desc');
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('transaction/edit_view_installations',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function view_installations(){
			$sidebar['menu_item'] = 'View Installations';
			$sidebar['menu_group'] = 'Asset Management';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$role = $this->session->userdata('role');
			$this->load->view('templates/side_menu',$sidebar);
			//$data['all_scheme_list']  = $this->getter_model->get(null,'get_all_scheme_list');
			if($role=='VENDOR'){
				$data['all_scheme_list']  = $this->getter_model->get(null,'get_scheme');
			}else{
				$data['all_scheme_list']  = $this->getter_model->get(null,'get_all_scheme_list');
			}
			//$data['scheme_details'] = $this->getter_model->get(null,'get_all_scheme_list');
			$data['vendor_details'] = $this->getter_model->get(null,'get_supplier_list');
			$data['all_dist_list'] 	  = $this->getter_model->get(array('state_code'=>'21'),'get_dist_name');
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('transaction/view_installations',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function manage_installations(){
			$sidebar['menu_item'] = 'Manage Installations';
			$sidebar['menu_group'] = 'Project Management';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$role = $this->session->userdata('role');
			if($role=='VENDOR'){
				$data['all_scheme_list']  = $this->getter_model->get(null,'get_scheme');
			}else{
				$data['all_scheme_list']  = $this->getter_model->get(null,'get_all_scheme_list');
			}
			$data['all_dist_list'] 	  = $this->getter_model->get(array('state_code'=>'21'),'get_dist_name');
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('transaction/manage_installations',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function view_transaction_details(){
			$decode_id      = $this->uri->segment(2);
		    $smth 			= preg_replace("/%u([0-9a-f]{3,4})/i","&#x\\1;",urldecode($decode_id)); 
		    $smth_id 	    = html_entity_decode($smth,null,'UTF-8');
		    $data['trans_id']     = base64_decode($smth_id);
		    $data['header_data'] = $this->transaction_model->get(array('trans_id'=>$data['trans_id']),'get_header_data');
		    $data['details_data'] = $this->transaction_model->get(array('trans_id'=>$data['trans_id']),'get_trans_details_data');
		    $sidebar['menu_item'] = 'Manage Installations';
			$sidebar['menu_group'] = 'Project Management';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('transaction/view_transaction_details',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function transaction_report(){
			$data['decode_id']  = $this->uri->segment(2);
		    $smth 				= preg_replace("/%u([0-9a-f]{3,4})/i","&#x\\1;",urldecode($data['decode_id'])); 
		    $smth_id 	    	= html_entity_decode($smth,null,'UTF-8');
		    $explode			= explode("#",base64_decode($smth_id));
		    $data['trans_id']   = $explode[0];   	
		    //$data['req_by']     = $explode[1];
			$role 				= $this->session->userdata('role');
		    if($role == "TECHNICIAN"){
				$sidebar['menu_item'] 	= 'Dashboard';
				$sidebar['menu_group'] 	= 'Dashboard';
			}else{
				$sidebar['menu_item'] 	= 'Manage Installations';
				$sidebar['menu_group'] 	= 'Project Management';
			}
			$sidebar['sidebar'] 	= $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$data['get_header'] 	= $this->transaction_model->get(array('trans_id'=>$data['trans_id']),'get_header_data');
			$data['sanction_no'] 	= $this->transaction_model->get(array('sanction_no'=>$data['get_header']->sanction_no),'get_sanction_no');
			$data['details_data'] 	= $this->transaction_model->get(array('trans_id'=>$data['trans_id']),'get_trans_details_data');
			$data['trans_imge_data']= $this->transaction_model->get(array('trans_id'=>$data['trans_id']),'get_trans_img');
			$page_status 			= page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('transaction/transaction_report',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function maintainance_report(){
			$data['decode_id']      = $this->uri->segment(2);
		    $smth 					= preg_replace("/%u([0-9a-f]{3,4})/i","&#x\\1;",urldecode($data['decode_id'])); 
		    $smth_id 	    		= html_entity_decode($smth,null,'UTF-8');
		    $explode				= explode("#",base64_decode($smth_id));
		    $data['trans_id']   	= $explode[0];   	
		    $data['req_by']     	= $explode[1];  
		    $role 					= $this->session->userdata('role');
		    if($role == "TECHNICIAN"){
				$sidebar['menu_item'] 	= 'Dashboard';
				$sidebar['menu_group'] 	= 'Dashboard';
			}else{
				$sidebar['menu_item'] 	= 'Manage Installations';
				$sidebar['menu_group'] 	= 'Project Management';
			}
			$sidebar['sidebar'] 	= $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$data['ticket_value_open']			=  $this->raise_ticket_model->get(array('transaction_id'  => $data['req_by']),'get_ticket_all_status_report');
			$data['ticket_value_close']			=  $this->raise_ticket_model->get(array('transaction_id'  => $data['req_by']),'get_ticket_close_status');
			$data['ticket_value_open_details'] 	= $this->raise_ticket_model->get(array('transaction_id'	  => $data['ticket_value_open']['ticket_id']),'get_data_report_details');
			$page_status 			= page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('transaction/maintainance_report',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
	}	