<?php defined('BASEPATH') OR exit('No direct script access allowed');
	class Scoring_controller extends CI_Controller  {
  		public function __construct(){
    		parent::__construct();
    		
    		# libraries
			$this->load->library('form_validation');
			$this->load->library('user_agent');
			# libraries
			$this->load->helper('custom_page');
			# models
			$this->load->model('getter_model');
			$this->load->model('scoring_model');
			# views
			$data['title'] = $this->getter_model->get(null,'get_title');
			$this->load->view('templates/header',$data);
   		}
		public function _remap($method){
			$class = $this->router->class;
			$role = $this->session->userdata('role');
			$check_user = $this->getter_model->get(null,'get_user_check');
			$role_action_auth = array( 
				'CRCADMIN'=>array('cm_itemized_score','sm_itemized_score','sm_itemized_vendor','energy_performance','scoring_performance','add_energy_data','add_weather_data','cm_score_vendorwise','scorecard_vendorwise','scorecard_vendorwise_report'),
				'OCE'=>array('cm_itemized_score','sm_itemized_score','energy_performance'),
				'ODR'=>array('cm_itemized_score','sm_itemized_score','energy_performance'),
				'ODH'=>array('cm_itemized_score','sm_itemized_score','energy_performance'),
				'ODA'=>array('cm_itemized_score','sm_itemized_score','energy_performance'),
				'VENDOR'=>array('cm_itemized_score','sm_itemized_score','energy_performance'),
				'TECHNICIAN'=>array('sm_itemized_score')
			);
			if( $role == false || !isset($role_action_auth[$role]) || !in_array($method, $role_action_auth[$role]) || !$check_user){
				redirect('logout');
			}else{
				if (in_array(strtolower($method), array_map('strtolower', get_class_methods($this)))){
					$uri = $this->uri->segment_array();
					unset($uri[1]);
					unset($uri[2]);
					call_user_func_array(array($this, $method), $uri);
				}else{
					self::page_not_found();
				}
			}
		}
		public function page_not_found(){
			$this->load->view('templates/404');
			$this->load->view('templates/footer');
		}
		public function cm_itemized_score(){
			$sidebar['menu_item'] = 'CM Itemized Score';
			$sidebar['menu_group'] = 'Performance Monitor';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$data['scheme_list'] 	  = $this->getter_model->get(null,'get_supplier_list');
			$data['cm_itemized_score_record']= $this->scoring_model->get(null,'get_cm_itemized_score');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('scoring/cm_itemized_score',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function sm_itemized_score(){
			$sidebar['menu_item'] = 'SM Itemized Score';
			$sidebar['menu_group'] = 'Performance Monitor';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('scoring/sm_itemized_score');
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function energy_performance(){
			$sidebar['menu_item'] = 'Energy Performance';
			$sidebar['menu_group'] = 'Performance Monitor';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$data['inverter_type'] = $this->getter_model->get(null,'get_inverter_type');
			$data['all_dist_list'] 	  = $this->getter_model->get(array('state_code'=>'21'),'get_dist_name');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('scoring/energy_performance',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function scoring_performance(){
			$sidebar['menu_item'] = 'Scoring Performance';
			$sidebar['menu_group'] = 'Performance Monitor';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			$data['scheduler_maintenance_score'] =$this->scoring_model->get(null,'get_scheduler_maintenance_score');
			$data['corrective_maintenance_score'] =$this->scoring_model->get(null,'get_corrective_maintenance_score');
			if($page_status!= 0) {
				$this->load->view('scoring/scoring_performance',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		
		public function add_energy_data(){
			$sidebar['menu_item'] = 'Energy Performance';
			$sidebar['menu_group'] = 'Performance Monitor';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$data['inverter_type'] = $this->getter_model->get(null,'get_inverter_type');
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('scoring/add_energy_generation',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		
		public function add_weather_data(){
			$sidebar['menu_item'] = 'Energy Performance';
			$sidebar['menu_group'] = 'Performance Monitor';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			$data['all_dist_list'] 	  = $this->getter_model->get(array('state_code'=>'21'),'get_dist_name');
			if($page_status!= 0) {
				$this->load->view('scoring/add_weather',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		
		public function sm_itemized_vendor(){
			$decode_request_id 		= $this->uri->segment(2);
			$smth 					= preg_replace("/%u([0-9a-f]{3,4})/i","&#x\\1;",urldecode($decode_request_id)); 
			$smth_request_id 		= html_entity_decode($smth,null,'UTF-8');
			$request_id				= base64_decode($smth_request_id);
			$explode_data			= explode("/",$request_id);
			$data['year']			= $explode_data[0];
			$data['month']			= $explode_data[1];
			$data['type']			= $explode_data[2];
			$sidebar['menu_item'] 	= 'SM Itemized Score';
			$sidebar['menu_group']	= 'Performance Monitor';
			$sidebar['sidebar'] 	= $this->getter_model->get($sidebar,'get_sidebar');
			$data['vendor_data'] 	= $this->scoring_model->get(array('year' => $data['year'],'month' => $data['month'],'type' => $data['type']),'get_all_vendor_score');
			//print("<pre>");
			//print_r($data['vendor_data']);die();
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('scoring/sm_itemized_vendor',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function scorecard_vendorwise(){
			//$vendor_id = $_POST['vendor_id'];
			$sidebar['menu_item'] = 'Vendor Sorecard';
			$sidebar['menu_group'] = 'Performance Monitor';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			//$data['scheme_list'] 	  = $this->getter_model->get(null,'get_supplier_list');
			$data['vendor_details'] = $this->getter_model->get(null,'get_supplier_list');
			$decode_vendor = $this->uri->segment(2);
			$vendor_smth = preg_replace("/%u([0-9a-f]{3,4})/i","&#x\\1;",urldecode($decode_vendor)); 
			$smth_vendor = html_entity_decode($vendor_smth,null,'UTF-8');
			$data['vendor_id']= base64_decode($smth_vendor);
			$data['cm_score_vendorwise']= $this->scoring_model->get($data['vendor_id'],'get_cm_score_vendorwise');
			$data['sm_score_vendorwise']= $this->scoring_model->get($data['vendor_id'],'get_sm_score_vendorwise');
			$data['cm_score_calculation']= $this->scoring_model->get($data['vendor_id'],'get_cm_score_calculation');
			$data['scheme_data']= $this->scoring_model->get($data['vendor_id'],'get_scheme');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('scoring/scorecard_vendorwise',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function scorecard_vendorwise_report(){
			$sidebar['menu_item'] = 'Vendor Sorecard';
			$sidebar['menu_group'] = 'Performance Monitor';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$data['vendor_details'] = $this->getter_model->get(null,'get_supplier_list');
			$decode_vendor = $this->uri->segment(2);
			$vendor_smth = preg_replace("/%u([0-9a-f]{3,4})/i","&#x\\1;",urldecode($decode_vendor));
			$smth_vendor = html_entity_decode($vendor_smth,null,'UTF-8');
			$data['vendor_id']= base64_decode($smth_vendor);
			$data['cm_score_vendorwise']= $this->scoring_model->get($data['vendor_id'],'get_cm_score_vendorwise');
			$data['sm_score_vendorwise']= $this->scoring_model->get($data['vendor_id'],'get_sm_score_vendorwise');
			$data['cm_score_calculation']= $this->scoring_model->get($data['vendor_id'],'get_cm_score_calculation');
			$data['scheme_data']= $this->scoring_model->get($data['vendor_id'],'get_scheme');
			$data['supplier_data']= $this->scoring_model->get($data['vendor_id'],'get_supplier');
			$data['role'] = $this->session->userdata('role');
			$data['total_asset']= $this->scoring_model->get($data['vendor_id'],'get_total_asset');
			$data['cm_data']= $this->scoring_model->get($data['vendor_id'],'get_cmdata');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if ($page_status!= 0) {
				$this->load->view('scoring/scorecard_vendorwise_report',$data);
			} else {
				$this->load->view('templates/page_maintenance');
			}
			
		}
	}