<?php defined('BASEPATH') OR exit('No direct script access allowed');
	class Raise_ticket_controller extends CI_Controller  {
  		public function __construct(){
    		parent::__construct();
    		
    		# libraries
			$this->load->library('form_validation');
			$this->load->library('user_agent');
			
			# libraries
			$this->load->helper('custom_page');
			# models
			$this->load->model('getter_model');
			$this->load->model(array('raise_ticket_model','schedule_model'));
			
			# views
			$data['title'] = $this->getter_model->get(null,'get_title');
			$this->load->view('templates/header',$data);
   		}
		public function _remap($method){
			$class = $this->router->class;
			$role = $this->session->userdata('role');
			$check_user = $this->getter_model->get(null,'get_user_check');
			$role_action_auth = array( 
				'CRCADMIN'=>array('register_request','manage_request','edit_manage_request','view_support_report','closed_suspended','view_manage_request'),
				'CRCAGENT'=>array('register_request','manage_request','edit_manage_request','view_support_report','closed_suspended','view_manage_request'),
				'VENDOR'=>array('manage_request','edit_manage_request','view_support_report','closed_suspended','view_manage_request'),
				'OCE'=>array('manage_request','view_support_report','closed_suspended','view_manage_request'),
				'ODR'=>array('manage_request','view_support_report','closed_suspended','view_manage_request'),
				'ODH'=>array('manage_request','view_support_report','closed_suspended','view_manage_request'),
				'ODA'=>array('manage_request','view_support_report','closed_suspended','view_manage_request'),
				'TECHNICIAN'=>array('manage_request','resolution_form'),
				'ADEPT'=>array('manage_request','closed_suspended','view_support_report')
			);
			if( $role == false || !isset($role_action_auth[$role]) || !in_array($method, $role_action_auth[$role]) || !$check_user){
				redirect('logout');
			}else{
				if (in_array(strtolower($method), array_map('strtolower', get_class_methods($this)))){
					$uri = $this->uri->segment_array();
					unset($uri[1]);
					unset($uri[2]);
					call_user_func_array(array($this, $method), $uri);
				}else{
					self::page_not_found();
				}
			}
		}
		public function page_not_found(){
			$this->load->view('templates/404');
			$this->load->view('templates/footer');
		}
		public function register_request(){
			$max_id = $this->raise_ticket_model->get(null,'get_max_id');
			
			if(!empty($max_id)){
				$unique_user_number='01';
				foreach($max_id as $max){	
					$td_maxid = $max['max_id'];
				}
				if($td_maxid == ''){		
					$td_maxid = 000000;
				}
				$add_max_id1 = $td_maxid+1;
				$num_length = strlen($add_max_id1);
				if($num_length == 1){
					$add_max_id = "000000".$add_max_id1;
				}
				if($num_length == 2){
					$add_max_id = "00000".$add_max_id1;
				}
				if($num_length == 3){
					$add_max_id = "0000".$add_max_id1;
				}
				if($num_length == 4){
					$add_max_id = "000".$add_max_id1;
				}
				if($num_length == 5){
					$add_max_id = "00".$add_max_id1;
				}
				if($num_length == 6){
					$add_max_id = "0".$add_max_id1;
				}
				$ticket_id = 'CM'.$unique_user_number.$add_max_id;
				$data['ticket_id'] = $ticket_id;
			}else{
				$data['ticket_id'] = 'CM000001';
			}
			$sidebar['menu_item'] = 'Register Request';
			$sidebar['menu_group'] = 'Corrective Maintenance';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			$data['all_dept_list'] 	  = $this->getter_model->get(null,'get_all_admin_department');
			$data['all_dist_list'] 	  = $this->getter_model->get(array('state_code'=>21),'get_dist_name');
			if($page_status!= 0) {
				$this->load->view('raise_ticket/register_request',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		
		public function manage_request(){
			$role = $this->session->userdata('role');
			$sidebar['menu_item'] = 'Manage Request';
			$sidebar['menu_group'] = 'Corrective Maintenance';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			if($role=='VENDOR'){
				$data['all_scheme_list']  = $this->getter_model->get(null,'get_scheme');
			}elseif($role=='ADEPT')
			{
				$data['all_scheme_list']  = $this->getter_model->get(null,'get_all_scheme_list');
			}
			else{
				$data['all_scheme_list']  = $this->getter_model->get(null,'get_all_scheme_list');
			}
			$data['vendor_details'] 			= $this->getter_model->get(null,'get_supplier_list');
			$data['technician_list']  = $this->getter_model->get(null,'get_technician_list');
			$data['all_dist_list'] 	  = $this->getter_model->get(array('state_code'=>'21'),'get_dist_name');
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('raise_ticket/manage_request',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function edit_manage_request(){
			$decode_request_id 		= $this->uri->segment(2);
			$smth 					= preg_replace("/%u([0-9a-f]{3,4})/i","&#x\\1;",urldecode($decode_request_id)); 
			$smth_request_id 		= html_entity_decode($smth,null,'UTF-8');
			$request_id				= base64_decode($smth_request_id);
			$explode_data			= explode("/",$request_id);
			$data['request_id']		= $explode_data[0];
			$data['transaction_id']	= $explode_data[1];
			$data['ticket_id']	    = $explode_data[2];
			$sidebar['menu_item'] 	= 'Manage Request';
			$sidebar['menu_group'] 	= 'Corrective Maintenance';
			$sidebar['sidebar'] 	= $this->getter_model->get($sidebar,'get_sidebar');
			//$data['ticket_value_open']			=  $this->raise_ticket_model->get(array('transaction_id'  => $data['transaction_id']),'get_ticket_all_status');
			$data['ticket_value_open'] =  $this->raise_ticket_model->get(array('ticket_id'  => $data['ticket_id']),'get_ticket_all_status');
			$data['ticket_value_open_details'] 	= $this->raise_ticket_model->get(array('transaction_id'	  => $data['ticket_value_open']['ticket_id']),'get_data_report_details');
			$data['report_data']				=  $this->raise_ticket_model->get(array('raise_ticket_id' => $data['request_id']),'get_report_data');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			$data['managerequest_data'] = $this->raise_ticket_model->get(array('id'=>$data['request_id']),'get_managerequest_view');
			$data['reminder_count'] = $this->raise_ticket_model->get(array('id'=>$data['ticket_id']),'get_reminder_count');
			$data['action_list'] 	  	= $this->getter_model->get(array('gen_code_group'=>'MANAGE_REQ_ACTION'),'get_action_list');
			$data['ticket_data'] 		= $this->schedule_model->get(array('ticket_id'=>$data['ticket_id']),'get_cm_ticket_data');
			$data['additional_data'] 	= $this->schedule_model->get(array('ticket_id'=>$data['ticket_id']),'get_cm_additional_data');
			if($page_status!= 0) {
				$this->load->view('raise_ticket/edit_manage_request',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		/*
		Name: Siddhartha
		Modified Date: 29-08-19
		Purpose: Closed/Suspended Ticket view button
		*/
		public function view_manage_request(){
			$decode_request_id 		= $this->uri->segment(2);
			$smth 					= preg_replace("/%u([0-9a-f]{3,4})/i","&#x\\1;",urldecode($decode_request_id)); 
			$smth_request_id 		= html_entity_decode($smth,null,'UTF-8');
			$request_id				= base64_decode($smth_request_id);
			$explode_data			= explode("/",$request_id);
			$data['request_id']		= $explode_data[0];
			$data['transaction_id']	= $explode_data[1];
			$data['ticket_id']	    = $explode_data[2];
			$sidebar['menu_item'] 	= 'Manage Request';
			$sidebar['menu_group'] 	= 'Corrective Maintenance';
			$sidebar['sidebar'] 	= $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			//$data['ticket_value_open']			=  $this->raise_ticket_model->get(array('transaction_id'  => $data['transaction_id']),'get_ticket_close_status');
			$data['ticket_value_open'] =  $this->raise_ticket_model->get(array('ticket_id'  => $data['ticket_id']),'get_ticket_close_status');
			$data['ticket_value_open_details'] 	= $this->raise_ticket_model->get(array('transaction_id'	  => $data['ticket_value_open'][0]['ticket_id']),'get_data_report_details');
			$data['report_data']				=  $this->raise_ticket_model->get(array('raise_ticket_id' => $data['request_id']),'get_report_data');
			
			$data['managerequest_data'] = $this->raise_ticket_model->get(array('id'=>$data['request_id']),'get_managerequest_view');
			$data['action_list'] 	  	= $this->getter_model->get(array('gen_code_group'=>'MANAGE_REQ_ACTION'),'get_action_list');
			$data['ticket_data'] 		= $this->schedule_model->get(array('ticket_id'=>$data['ticket_id']),'get_cm_ticket_data');
			if($page_status!= 0) {
				$this->load->view('raise_ticket/view_request_details',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function view_support_report(){
			$decode_request_id 		= $this->uri->segment(2);
			$smth 					= preg_replace("/%u([0-9a-f]{3,4})/i","&#x\\1;",urldecode($decode_request_id)); 
			$smth_request_id 		= html_entity_decode($smth,null,'UTF-8');
			$request_id				= base64_decode($smth_request_id);
			$explode_data			= explode("/",$request_id);
			$data['request_id']		= $explode_data[0];
			$data['transaction_id']	= $explode_data[1];
			$sidebar['menu_item'] 	= 'Manage Request';
			$sidebar['menu_group'] 	= 'Corrective Maintenance';
			$sidebar['sidebar'] 	= $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$data['report_data']				=  $this->raise_ticket_model->get(array('raise_ticket_id' => $data['request_id']),'get_report_data');
			//$data['ticket_value_open']			=  $this->raise_ticket_model->get(array('transaction_id'  => $data['transaction_id']),'get_ticket_all_status');
			$data['ticket_value_open'] =  $this->raise_ticket_model->get(array('ticket_id'  => $data['ticket_id']),'get_ticket_all_status');
			$data['ticket_value_close']			=  $this->raise_ticket_model->get(array('ticket_id'  => $data['ticket_id']),'get_ticket_close_status');
			$data['ticket_value_open_details'] 	= $this->raise_ticket_model->get(array('transaction_id'	  => $data['ticket_value_open']['ticket_id']),'get_data_report_details');
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('raise_ticket/view_support_report',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function closed_suspended(){
				$role = $this->session->userdata('role');
			$sidebar['menu_item'] = 'Closed/Suspended';
			$sidebar['menu_group'] = 'Corrective Maintenance';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$data['vendor_details'] 			= $this->getter_model->get(null,'get_supplier_list');
			if($role=='VENDOR'){
				$data['all_scheme_list']  = $this->getter_model->get(null,'get_scheme');
			}else{
			$data['all_scheme_list']  = $this->getter_model->get(null,'get_all_scheme_list');
			}
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('raise_ticket/closed_suspended',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		public function resolution_form(){
			$decode_ticket = $this->uri->segment(2);
			$tickets_smth = preg_replace("/%u([0-9a-f]{3,4})/i","&#x\\1;",urldecode($decode_ticket)); 
			$smth_ticket = html_entity_decode($tickets_smth,null,'UTF-8');
			$data['ticket_id']= base64_decode($smth_ticket);
			$role = $this->session->userdata('role');
			$sidebar['menu_item'] = 'Manage Request';
			$sidebar['menu_group'] = 'Corrective Maintenance';
			/*$data['all_component'] = $this->getter_model->get(array('ticket_id'=>$data['ticket_id']),'get_ticket_component');*/
			$data['visit_purpose'] = $this->getter_model->get(array('gen_code_group'=>'CM_VISIT_PURPOSE'),'get_gencode_desc');
			$data['sub_visit_purpose'] = $this->getter_model->get(array('gen_code_group'=>'SUB_VISIT_PURPOSE'),'get_gencode_desc');
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('raise_ticket/resolution_form',$data);
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
	}