<?php defined('BASEPATH') OR exit('No direct script access allowed');
	class Mis_controller extends CI_Controller  {
  		public function __construct(){
    		parent::__construct();
    		
    		# libraries
			$this->load->library('form_validation');
			$this->load->library('user_agent');
			
			# libraries
			$this->load->helper('custom_page');
			
			# models
			$this->load->model('getter_model');
			
			# views
			$data['title'] = $this->getter_model->get(null,'get_title');
			$this->load->view('templates/header',$data);
   		}
   		
		public function _remap($method){
			$class = $this->router->class;
			$role = $this->session->userdata('role');
			$check_user = $this->getter_model->get(null,'get_user_check');
			$role_action_auth = array( 
				'VENDOR'=>array('vendor_mis_report'),
				'ADEPT'=>array('department_mis_report'),
				'OCE'=>array('department_mis_report'),
				'ODR'=>array('department_mis_report'),
				'ODH'=>array('department_mis_report'),
				'ODA'=>array('department_mis_report'),
				'OTO'=>array('department_mis_report'),
				'CRCAGENT'=>array('department_mis_report')
				
			);
			if( $role == false || !isset($role_action_auth[$role]) || !in_array($method, $role_action_auth[$role]) || !$check_user){
				redirect('logout');
			}else{
				if (in_array(strtolower($method), array_map('strtolower', get_class_methods($this)))){
					$uri = $this->uri->segment_array();
					unset($uri[1]);
					unset($uri[2]);
					call_user_func_array(array($this, $method), $uri);
				}else{
					self::page_not_found();
				}
			}
		}
		
		/**
		* Name : Subhashree Jena
		* Date : 22-05-2019
		* Purpose : All MIS Report
		* @return
		*/
		
		public function vendor_mis_report(){
			$sidebar['menu_item'] = 'MIS Report';
			$sidebar['menu_group'] = 'MIS Report';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('report/mis_report');
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
		
		public function department_mis_report(){
			$sidebar['menu_item'] = 'MIS Report';
			$sidebar['menu_group'] = 'MIS Report';
			$sidebar['sidebar'] = $this->getter_model->get($sidebar,'get_sidebar');
			$this->load->view('templates/side_menu',$sidebar);
			$page_status = page_status($sidebar['sidebar'],$sidebar['menu_item']);
			if($page_status!= 0) {
				$this->load->view('report/all_mis_report');
			}else{
				$this->load->view('templates/page_maintenance');
			}
			$this->load->view('templates/footer');
		}
	}