<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/

$route['default_controller'] = 'home';
$route['about-us'] 			 = 'home/about_us';
$route['about-us-page'] 	 = 'home/about_us_page';
$route['success'] 			 = 'home/success';
$route['contact-us'] 	     = 'home/contact_us';
$route['faq'] 			 	 = 'home/faq';
$route['clients'] 			 = 'home/clients';
$route['product'] 			 = 'home/product';
$route['documents'] 		 = 'home/documents';
/**
* 
* @var User Controller
* 
*/
$route['login'] 			= 'user/login';
$route['logout'] 			= 'user/logout';
$route['set-password'] 		= 'user/set_password';
$route['forgot-password'] 	= 'user/forgot_password';
$route['user-register'] 	= 'user/user_register';
/**
* 
* @var SuperAdminController
* 
*/
$route['manage-resource'] 	= 'superadmin_controller/manage_resource';
$route['manage-user'] 		= 'superadmin_controller/manage_user';
$route['manage-group'] 		= 'superadmin_controller/manage_group';
$route['title-setup'] 		= 'superadmin_controller/title_setup';
$route['my-account'] 		= 'superadmin_controller/my_account';
$route['login-details'] 	= 'superadmin_controller/login_details';
$route['page-creation'] 	= 'superadmin_controller/page_creation';
$route['approval-user-create'] 	= 'superadmin_controller/approval_user_create';
/**
* 
* @var Admin Controller
* 
*/
$route['gen-code'] 			= 'admin_controller/gen_code_master';
$route['country-master'] 	= 'admin_controller/country_master';
$route['country-preview'] 	= 'admin_controller/country_preview';
$route['state-master'] 		= 'admin_controller/state_master';
$route['state-preview'] 	= 'admin_controller/state_preview';
$route['district-master'] 	= 'admin_controller/district_master';
$route['district-preview'] 	= 'admin_controller/district_preview';
$route['block-master'] 		= 'admin_controller/block_master';
$route['block-preview'] 	= 'admin_controller/block_preview';
$route['gp-master'] 		= 'admin_controller/gp_master';
$route['gp-preview'] 		= 'admin_controller/gp_preview';
$route['village-master'] 	= 'admin_controller/village_master';
$route['village-preview'] 	= 'admin_controller/village_preview';
$route['email-setup'] 		= 'admin_controller/email_setup';
$route['sms-setup'] 		= 'admin_controller/sms_setup';
$route['imei-setup'] 		= 'admin_controller/imei_setup';
$route['admin-user-create'] = 'admin_controller/admin_user_create';
/**
* 
* @var Dashbord Controller
* 
*/
$route['superadmin-dashboard'] 			= 'dashboard_controller/superadmin_dashboard';
$route['admin-dashboard'] 				= 'dashboard_controller/admin_dashboard';
$route['technician-dashboard'] 			= 'dashboard_controller/technician_dashboard';
$route['oda-dashboard'] 				= 'dashboard_controller/oda_dashboard';
$route['admin-department-dashboard'] 	= 'dashboard_controller/admin_department_dashboard';
$route['vendor-dashboard'] 				= 'dashboard_controller/vendor_dashboard';
$route['configure-systems'] 			= 'dashboard_controller/configure_systems';
$route['oce-dashboard'] 				= 'dashboard_controller/oce_dashboard';
$route['odr-dashboard'] 				= 'dashboard_controller/odr_dashboard';
$route['odh-dashboard'] 				= 'dashboard_controller/odh_dashboard';
$route['oto-dashboard'] 				= 'dashboard_controller/oto_dashboard';
$route['crc-agent-dashboard'] 			= 'dashboard_controller/crc_agent_dashboard';
$route['project-management-dashboard'] 	= 'dashboard_controller/project_management_dashboard';
$route['asset-management'] 				= 'dashboard_controller/asset_management';
$route['total-statistics-all-schemes'] 	= 'dashboard_controller/total_statistics_all_schemes';
$route['schemes-wise-statistics-view/(:any)']= 'dashboard_controller/schemes_wise_statistics_view';
$route['schedule-maintenance'] 			= 'dashboard_controller/schedule_maintenance';
$route['sm-vendor-view/(:any)']  		= 'dashboard_controller/sm_vendor_view';
$route['sm-vendor-scheme-view/(:any)']  = 'dashboard_controller/sm_vendor_scheme_view';
$route['sm-scheme-view/(:any)']  		= 'dashboard_controller/sm_scheme_view';
$route['projects-status-scheme'] 		= 'dashboard_controller/projects_status_scheme';
$route['projects-status-vendor/(:any)'] = 'dashboard_controller/projects_status_vendor';
$route['projects-vendor-wise-list/(:any)'] = 'dashboard_controller/projects_vendor_wise_list';
$route['project-asset-status'] 			= 'dashboard_controller/project_asset_status';
$route['project-wise-asset-status']     = 'dashboard_controller/project_wise_asset_status';
$route['scheme-wise-asset-status/(:any)'] = 'dashboard_controller/scheme_wise_asset_status';
$route['assets-vendor-count-view'] 		= 'dashboard_controller/assets_vendor_count_view';
$route['assets-vendor-wise-view'] 		= 'dashboard_controller/assets_vendor_wise_view';
$route['assets-status-project-view/(:any)'] = 'dashboard_controller/assets_status_project_view';
$route['vendor-status-project'] 			= 'dashboard_controller/vendor_status_project';
$route['status-project-single-vendor/(:any)'] = 'dashboard_controller/status_project_single_vendor';
$route['status-project-vendor-data/(:any)'] = 'dashboard_controller/status_project_vendor_data';
/**
* 
* @var Scheme Controller
* 
*/
$route['category-wise-scheme-list'] = 'scheme_controller/scheme_list';
$route['project-category'] 			= 'scheme_controller/project_category';
$route['scheme-list/(:any)'] 		= 'scheme_controller/scheme_list';
$route['edit-scheme-data/(:any)'] 	= 'scheme_controller/edit_scheme_data';
$route['add-scheme'] 				= 'scheme_controller/add_scheme';
/**
* 
* @var Attributes Controller
* 
*/
$route['attribute-setup'] 			= 'attributes_controller/attributes_master';
/**
* 
* @var Installation Controller
* 
*/
$route['scheme-installation-setup'] = 'installation_controller/scheme_installation_setup';
$route['installation-class'] 		= 'installation_controller/installation_class';
/**
* 
* @var Component Controller
* 
*/
$route['component'] 				= 'component_controller/component';
/**
* 
* @var Raise Ticket Controller
* 
*/
$route['register-request'] 			= 'raise_ticket_controller/register_request';
$route['manage-request'] 			= 'raise_ticket_controller/manage_request';
$route['edit-manage-request/(:any)']= 'raise_ticket_controller/edit_manage_request';
$route['view-support-report/(:any)']= 'raise_ticket_controller/view_support_report';
$route['closed-suspended']			= 'raise_ticket_controller/closed_suspended';
$route['raiseticket-resolution-form/(:any)'] 		= 'raise_ticket_controller/resolution_form';
$route['view-manage-request/(:any)'] = 'raise_ticket_controller/view_manage_request';
/** 
* 
* @var Schedule Controller
*
* 
*/
$route['generated-ticket'] 		= 'schedule_controller/generated_ticket';
$route['resolve-ticket'] 		= 'schedule_controller/resolve_ticket';
$route['rejected-closed'] 		= 'schedule_controller/rejected_closed';
$route['resolution-form/(:any)'] = 'schedule_controller/resolution_form';
$route['view-schedule-request/(:any)'] = 'schedule_controller/view_schedule_request_details';
$route['view-resolution-form/(:any)'] = 'schedule_controller/view_sm_resolution_form';
/**
* 
* @var Service Request Controller
*
* 
*/
$route['cmc-management'] 		= 'service_request_controller/cmc_management';
$route['ticket-generation-validation'] 		= 'service_request_controller/ticket_generation_validation';
$route['cm-control-panel'] 		= 'service_request_controller/cm_control_panel';
$route['sm-control-panel'] 		= 'service_request_controller/sm_control_panel';
$route['add-control-panel-installation'] = 'service_request_controller/add_sm_control_panel_installation';

/**
* 
* @var Transaction Controller
*
* 
*/
$route['view-transaction-details/(:any)'] 	= 'transaction_controller/view_transaction_details';
$route['add-installations'] 				= 'transaction_controller/add_installations';
$route['edit-installations/(:any)'] 		= 'transaction_controller/edit_installations';
$route['edit-view-installations/(:any)'] 	= 'transaction_controller/edit_view_installations';
$route['manage-installations'] 				= 'transaction_controller/manage_installations';
$route['transaction-report/(:any)'] 		= 'transaction_controller/transaction_report';
$route['maintainance-report/(:any)'] 		= 'transaction_controller/maintainance_report';
$route['view-installations'] 				= 'transaction_controller/view_installations';

/**
* 
* @var Vendor Controller
* 
*/
$route['vendor'] 									= 'vendor_controller/vendor';
$route['add-vendor-data'] 							= 'vendor_controller/add_vendor_data';
$route['edit-vendor-data/(:any)'] 					= 'vendor_controller/edit_vendor_data';
$route['edit-vendor-account/(:any)'] 				= 'vendor_controller/edit_vendor_account';
$route['vendor-against-technician-details/(:any)'] 	= 'vendor_controller/vendor_against_tech_details';
$route['task-against-technician-details/(:any)'] 	= 'vendor_controller/task_against_technician_details';
$route['vendor-report'] 							= 'vendor_controller/vendor_report';
$route['vendor-technician-mapping'] 				= 'vendor_controller/vendor_technician_mapping';
$route['link-vendor-village'] 						= 'vendor_controller/link_vendor_village';
$route['vendor-village-view/(:any)/(:any)'] 		= 'vendor_controller/link_view_vendor_village';
$route['vendor-village-edit/(:any)/(:any)'] 		= 'vendor_controller/link_edit_vendor_village';
$route['vendorwise-cm-score-report/(:any)'] = 'scoring_controller/scorecard_vendorwise_report';

/**
* 
* @var Technician Controller
* 
*/
$route['technician-master'] 	= 'technician_controller/technician_master';
$route['open-installation-view']= 'technician_controller/open_installation_view';
$route['installation-view-details/(:any)']= 'technician_controller/installation_view_details';
/**
* 
* @var Department Controller
* 
*/
$route['admin-department'] 		= 'department_controller/admin_department';

/**
* 
* @var Mis Controller
* 
*/
$route['department-mis-report'] 			= 'mis_controller/department_mis_report';
$route['vendor-mis-report'] 				= 'mis_controller/vendor_mis_report';
$route['cm-receipt-redressal-status'] 		= 'mis_controller/cm_receipt_redressal_status';
$route['sm-complaince-statement'] 			= 'mis_controller/sm_complaince_statement';
$route['cm-frequency-request-received'] 	= 'mis_controller/cm_frequency_request_received';
$route['trend-cm-request'] 					= 'mis_controller/trend_cm_request';
$route['trend-new-customer-registration'] 	= 'mis_controller/trend_new_customer_registration';
$route['age-analysis-open-cases'] 			= 'mis_controller/age_analysis_open_cases';
$route['supplier-analysis'] 				= 'mis_controller/supplier_analysis';
$route['cm-scheme-performance'] 			= 'mis_controller/cm_scheme_performance';
$route['cm-supplier-performance'] 			= 'mis_controller/cm_supplier_performance';
$route['list-open-cases'] 					= 'mis_controller/list_open_cases';
$route['district-abstract-open-case'] 		= 'mis_controller/district_abstract_open_case';
/**
* 
* @var Scoring Controller
* 
*/
$route['cm-itemized-score']		= 'scoring_controller/cm_itemized_score';
$route['sm-itemized-score'] 	= 'scoring_controller/sm_itemized_score';
$route['scoring-performance'] 	= 'scoring_controller/scoring_performance';
$route['energy-performance'] 	= 'scoring_controller/energy_performance';
$route['add-energy-data'] 		= 'scoring_controller/add_energy_data';
$route['add-weather-data'] 		= 'scoring_controller/add_weather_data';
$route['sm-itemized-vendor/(:any)'] 	= 'scoring_controller/sm_itemized_vendor';
$route['vendorwise-cm-score'] 	= 'scoring_controller/scorecard_vendorwise';
$route['vendorwise-cm-score/(:any)'] 	= 'scoring_controller/scorecard_vendorwise';
/**
* 
* @var Pdf download Of System Controller
* 
*/
$route['op-print/(:any)']				= 'system_controller/op_print';
$route['op-print/(:any)/(:any)']		= 'system_controller/op_print';
$route['op-print/(:any)/(:any)/(:any)']	= 'system_controller/op_print';
/**
* 
* @var Excel download Of Export Controller
* 
*/
$route['export-installations/(:any)']	= 'Export_controller/installations_data';
$route['export-amc-report']	= 'Export_controller/amc_expiry_report';

$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;
