<?php
/**
 * Kadence functions and definitions
 *
 * This file must be parseable by PHP 5.2.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package kadence
 */

define( 'KADENCE_VERSION', '1.1.51' );
define( 'KADENCE_MINIMUM_WP_VERSION', '5.4' );
define( 'KADENCE_MINIMUM_PHP_VERSION', '7.2' );

// Bail if requirements are not met.
if ( version_compare( $GLOBALS['wp_version'], KADENCE_MINIMUM_WP_VERSION, '<' ) || version_compare( phpversion(), KADENCE_MINIMUM_PHP_VERSION, '<' ) ) {
	require get_template_directory() . '/inc/back-compat.php';
	return;
}
// Include WordPress shims.
require get_template_directory() . '/inc/wordpress-shims.php';

// Load the `kadence()` entry point function.
require get_template_directory() . '/inc/class-theme.php';

// Load the `kadence()` entry point function.
require get_template_directory() . '/inc/functions.php';

// Initialize the theme.
call_user_func( 'Kadence\kadence' );
// Shortcode function to display login/logout buttons with custom CSS
function custom_login_logout_shortcode() {
	?>
    <style>
    /* Customize button styles */
    .login-signup-buttons {
        text-align: center;
    }

    .login-button,
    .signup-button,
    .logout-button {
        font-family:'Work Sans';
        display: inline-block;
        padding: 10px 30px;
        text-decoration: none !important;
        font-weight: 500;
        border-radius: 5px;
        cursor: pointer;
		margin-top:-20px !important;
    }
    .signup-button:hover,
	.logout-button:hover{
		color:#fff !important;
	} 
    .login-button:hover,{
	color:#73be44 !important;
    }

    /* Login button styles */
    .login-button {
        border: 2px solid #73be44;
        color: #73be44 !important;
        margin-right:20px;
    }

    /* Logout and Signup button styles */
    .logout-button,
    .signup-button {
		border: 2px solid #73be44;
        background-color: #73be44;
        color: #fff;
    }
</style>

    <?php
    if (is_user_logged_in()) {
        // User is logged in, display logout button
        return '<a class="logout-button" href="' . wp_logout_url() . '">Logout</a>';
    } else {
        // User is not logged in, display login and signup buttons
        ob_start(); ?>

        <div class="login-signup-buttons">
            <a class="login-button" href="<?php echo wp_login_url(); ?>">Login</a>
            <a class="signup-button" href="<?php echo wp_registration_url(); ?>">Start for free</a>
        </div>

        <?php
        return ob_get_clean();
    }
}

// Register the shortcode
add_shortcode('custom_login_logout', 'custom_login_logout_shortcode');
