<?php
get_header();

if (have_posts()) : 
    while (have_posts()) : the_post(); ?>
    <style>
        /* General styles */
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            margin: 0;
            padding: 0;
        }

        /* Book content container */
        .book-content {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }

        /* Book navigation */
        .book-navigation {
            display: flex;
            justify-content: space-between;
            margin-bottom: 20px;
        }

        .book-navigation .nav-previous,
        .book-navigation .nav-next {
            font-size: 16px;
        }

        .book-navigation a {
            text-decoration: none;
            color: #0073aa;
        }

        .book-navigation a:hover {
            text-decoration: underline;
        }

        /* Book row */
        .book-row {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
            margin-bottom: 20px;
        }

        .book-description {
            flex: 2;
            min-width: 300px;
        }

        .book-thumbnail {
            flex: 1;
            min-width: 300px;
        }

        .book-thumbnail img {
            width: 100%;
            height: 540px;
        }

        h1 {
            font-weight: 600;
            font-size: 1.875rem;
            line-height: 1.5;
            color: #7c3920;
            text-transform: capitalize;
            font-family: 'Titillium Web', sans-serif !important;
        }

        .book-meta p {
            color: #858585;
            line-height: 1.8;
        }

        /* Book meta */
        .book-meta {
            margin-top: 10px;
        }

        /* Book details */
        .book-details {
            margin-bottom: 20px;
        }

        .book-details h2 {
            margin-bottom: 10px;
        }

        .book-details p {
            margin: 5px 0;
        }

        .book-description a {
            color: #777777;
            text-decoration: none;
            border: 2px solid;
            border-radius: 30px;
            padding: 8px 18px;
        }

        /* Book availability */
        .book-availability {
            margin-bottom: 20px;
        }

        .book-availability h2 {
            margin-bottom: 10px;
            font-weight: 600;
            font-size: 1.875rem;
            line-height: 1.5;
            color: #7c3920;
            text-transform: capitalize;
        }

        .book-availability ul {
            list-style: none;
            padding: 0;
            margin: 0 auto; 
        }

        .book-availability li {
            margin-bottom: 10px;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .book-availability a {
            margin-left: 10px;
            color: #0073aa;
            text-decoration: none;
        }

        .book-availability a:hover {
            text-decoration: none;
        }

        .buy-now {
            margin-left: 10px;
            background-color: transparent;
            color: #7c3920 !important;
            padding: 8px 18px;
            border-radius: 30px;
            text-decoration: none;
            border: 2px solid;
        }

        .buy-now a:hover {
            background-color: #7c3920;
            color: #fff !important;
        }

        .fa-shopping-cart {
            margin-right: 5px;
        }

        /* Stars rating */
        .book-availability span {
            margin-left: 10px;
            color: gold;
            font-size: 12px;
        }

        .star-rating {
            color: gold;
            font-size: 1.2em;
        }

        .combine {
            justify-content: space-evenly;
            display: flex;
            flex: 1;
        }

        .pdf-modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgba(0, 0, 0, 0.5);
        }

        .pdf-modal-content {
            background-color: #fefefe45;
            margin: 0 auto;
            padding: 20px;
            border: 1px solid #888;
            width: 100%;
            height: 100%;
        }

        .close {
            color: #000;
            float: right;
            font-size: 28px;
            font-weight: bold;
        }

        .close:hover,
        .close:focus {
            color: black;
            text-decoration: none;
            cursor: pointer;
        }

        .pdf-container {
            width: 100%;
            height: 100%;
        }

        /* Review Section */
        .review-section {
            margin-top: 40px;
        }

        .review-section h2 {
            font-weight: 600;
            font-size: 1.875rem;
            line-height: 1.5;
            color: #7c3920;
            text-transform: capitalize;
        }

        .review-carousel {
            margin-top: 20px;
        }

        .review-carousel .slick-slide {
            background: #f9f9f9;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        .review-carousel .slick-prev,
        .review-carousel .slick-next {
            color: #7c3920;
        }
        /* Review Section Styles */
.review-section {
    margin-top: 40px;
}

.review-row {
    display: flex;
    flex-wrap: wrap;
    gap: 20px;
}

.review-col {
    flex: 1;
    min-width: 300px;
}

.review-carousel .review-item {
    padding: 20px;
    background-color: #f9f9f9;
    border-radius: 8px;
    height: 480px;
    overflow-y: auto;
    position: relative;
}

/* Hide scrollbar for Firefox */
.review-carousel .review-item::-webkit-scrollbar {
    width: 0;
}

/* Hide scrollbar for IE, Edge, and Safari */
.review-carousel .review-item {
    -ms-overflow-style: none; /* IE and Edge */
    scrollbar-width: none; /* Firefox */
}


.review-carousel .review-item p {
    margin: 0 0 10px;
}

#commentform label {
    display: block;
    margin-bottom: 5px;
}

#commentform input[type="text"],
#commentform input[type="email"],
#commentform textarea {
    width: 100%;
    padding: 10px;
    margin-bottom: 0px;
    border: 1px solid #ccc;
    border-radius: 4px;
}
#commentform textarea{
    height: 100px;
}

#commentform input[type="submit"] {
    margin-left: 10px;
    background-color: transparent;
    color: #7c3920 !important;
    padding: 8px 18px;
    border-radius: 30px;
    text-decoration: none;
    border: 2px solid;
}

#commentform input[type="submit"]:hover {
    background-color: #7c3920;
    color: #fff !important;
}

        /* Responsive styles */
        @media (max-width: 676px) {
            .combine {
                flex-direction: column;
            }

            a.buy-now {
                font-size: 12px;
                padding: 8px;
            }

            .book-availability li {
                align-items: flex-start !important;
            }
        }

        @media (max-width: 768px) {
            /* Your mobile-specific styles here */
            .modal-content {
                width: 90%;
                height: 80%;
            }

            .pdf-container {
                overflow: auto; /* Allow scrolling for PDF content */
            }
            .review-carousel .review-item{
                height:300px;
            }
        }
    </style>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <div class="book-content">
        <div class="book-navigation">
            <div class="nav-previous">
                <?php previous_post_link('%link', 'Previous Book'); ?>
            </div>
            <div class="nav-next">
                <?php next_post_link('%link', 'Next Book'); ?>
            </div>
        </div>
        <div class="book-row">
            <div class="book-description">
                <h1><?php the_title(); ?></h1>
                <div class="book-meta">
                    <?php the_content(); ?>
                </div>
                <?php
                $pdf_url = get_post_meta(get_the_ID(), 'book_pdf', true);
                if ($pdf_url) :
                    $file_name = basename($pdf_url);
                    ?>
                    <p>
                        <a href="<?php echo esc_url($pdf_url); ?>" download="<?php echo esc_attr($file_name); ?>" target="_blank">Download <i class="fa fa-download" aria-hidden="true"></i></a>
                        <a href="#" id="view-now" data-pdf-url="<?php echo esc_url($pdf_url); ?>">View Now <i class="fa fa-search" aria-hidden="true"></i></a>
                    </p>
                <?php endif; ?>
            </div>
            <?php if (has_post_thumbnail()) : ?>
                <div class="book-thumbnail">
                    <?php the_post_thumbnail(); ?>
                </div>
            <?php endif; ?>
        </div>
        <div class="book-availability">
            <h2>Available On</h2>
            <?php
            $book_available_on = get_post_meta(get_the_ID(), 'book_available_on', true);
            if (!empty($book_available_on)) : ?>
                <ul>
                    <?php foreach ($book_available_on as $store) : ?>
                        <li>
                            <strong><?php echo esc_html($store['store_name']); ?>:</strong>
                            <div class="combine">
                                <a href="<?php echo esc_url($store['url']); ?>" target="_blank"><?php echo esc_url($store['url']); ?></a>
                                <?php 
                                $store_review = isset($store['reviews']) ? $store['reviews'] : '';
                                if ($store_review) : ?>
                                    <span class="star-rating">
                                        <?php
                                        $full_stars = floor($store_review);
                                        $half_star = $store_review - $full_stars >= 0.5 ? 1 : 0;
                                        $empty_stars = 5 - $full_stars - $half_star;

                                        for ($i = 0; $i < $full_stars; $i++) {
                                            echo '<i class="fas fa-star"></i>';
                                        }
                                        if ($half_star) {
                                            echo '<i class="fas fa-star-half-alt"></i>';
                                        }
                                        for ($i = 0; $i < $empty_stars; $i++) {
                                            echo '<i class="far fa-star"></i>';
                                        }
                                        ?>
                                    </span>
                                <?php endif; ?>
                            </div>
                            <a href="<?php echo esc_url($store['book_url']); ?>" class="buy-now" target="_blank"><i class="fa fa-shopping-cart" aria-hidden="true"></i> Buy Now</a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            <?php endif; ?>
        </div>

        <!-- Review Section -->
<div class="review-section">
    <h2>Book Reviews</h2>
    <div class="review-row">
        <!-- Review Carousel Column -->
        <div class="review-col">
            <div class="review-carousel">
                <?php
                $comments = get_comments(array(
                    'post_id' => get_the_ID(),
                    'status' => 'approve'
                ));
                foreach ($comments as $comment) : ?>
                    <div class="review-item">
                        <p><?php echo esc_html($comment->comment_content); ?></p>
                        <h4><strong>- <?php echo esc_html($comment->comment_author); ?></strong></h4>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

        <!-- Review Form Column -->
        <div class="review-col">
            <h3>Leave a Review</h3>
            <?php
            if (comments_open()) : ?>
               <form action="<?php echo site_url('/wp-comments-post.php'); ?>" method="post" id="commentform">
                    <p>
                        <label for="author">Name <span>*</span></label>
                        <input type="text" name="author" id="author" required>
                    </p>
                    <p>
                        <label for="email">Email <span>*</span></label>
                        <input type="email" name="email" id="email" required>
                    </p>
                    <p>
                        <label for="comment">Your Review <span>*</span></label>
                        <textarea name="comment" id="comment" rows="5" required></textarea>
                    </p>
                    <div class="g-recaptcha" data-sitekey="6LcYhPwpAAAAADPSN7X5g-2vao7wNY3cy52OG4pT"></div>
                    <p>
                        <input type="hidden" name="comment_post_ID" value="<?php echo get_the_ID(); ?>" id="comment_post_ID">
                        <input type="submit" value="Submit Review">
                    </p>
                </form>
            <?php else : ?>
                <p>Reviews are closed.</p>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Slick Carousel JavaScript and CSS -->
<link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css"/>
<link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick-theme.css"/>
<script type="text/javascript" src="//cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js"></script>
<script type="text/javascript">
    jQuery(document).ready(function($) {
    $('.review-carousel').slick({
        dots: true,
        infinite: true,
        speed: 300,
        slidesToShow: 1,
        adaptiveHeight: true,
        autoplay: true // Set autoplay to false to disable auto-sliding
    });

    var pdfModal = document.getElementById("pdf-modal");
    var pdfBtn = document.getElementById("view-now");
    var span = document.getElementsByClassName("close")[0];

    pdfBtn.onclick = function() {
        pdfModal.style.display = "block";
        var pdfUrl = pdfBtn.getAttribute("data-pdf-url");
        PDFObject.embed(pdfUrl, "#pdf-container");
    }

    span.onclick = function() {
        pdfModal.style.display = "none";
    }

    window.onclick = function(event) {
        if (event.target == pdfModal) {
            pdfModal.style.display = "none";
        }
    }
});

</script>
<?php endwhile;
else :
    echo '<p>No books found</p>';
endif;

get_footer();
?>
