document.addEventListener('DOMContentLoaded', function() {
    // Get the modal element
    var modal = document.getElementById('pdf-modal');
    
    // Get the close button
    var closeButton = modal.querySelector('.close');
    
    // Get the PDF container element
    var pdfContainer = document.getElementById('pdf-container');
    
    // Get all the "View Now" links
    var viewNowLinks = document.querySelectorAll('#view-now');

    // Function to render PDF in the modal
    function renderPDF(url) {
        pdfContainer.innerHTML = '<iframe src="' + url + '" width="100%" height="100%" style="border: none;"></iframe>';
        modal.style.display = 'block'; // Display the modal
    }

    // Event listener for close button click
    closeButton.addEventListener('click', function() {
        modal.style.display = 'none'; // Hide the modal
        pdfContainer.innerHTML = ''; // Clear the PDF container
    });

    // Event listener for "View Now" links
    viewNowLinks.forEach(function(link) {
        link.addEventListener('click', function(e) {
            e.preventDefault(); // Prevent default link behavior

            var pdfUrl = this.getAttribute('data-pdf-url');
            renderPDF(pdfUrl); // Call renderPDF function with PDF URL
        });
    });
});
