<?php
/**
 * Kadence functions and definitions
 *
 * This file must be parseable by PHP 5.2.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package kadence
 */

define( 'KADENCE_VERSION', '1.2.5' );
define( 'KADENCE_MINIMUM_WP_VERSION', '5.6' );
define( 'KADENCE_MINIMUM_PHP_VERSION', '7.4' );

// Bail if requirements are not met.
if ( version_compare( $GLOBALS['wp_version'], KADENCE_MINIMUM_WP_VERSION, '<' ) || version_compare( phpversion(), KADENCE_MINIMUM_PHP_VERSION, '<' ) ) {
	require get_template_directory() . '/inc/back-compat.php';
	return;
}
// Include WordPress shims.
require get_template_directory() . '/inc/wordpress-shims.php';

// Load the `kadence()` entry point function.
require get_template_directory() . '/inc/class-theme.php';

// Load the `kadence()` entry point function.
require get_template_directory() . '/inc/functions.php';

// Initialize the theme.
call_user_func( 'Kadence\kadence' );
function global_search_bar_shortcode() {
    ob_start();
    ?>
    <style>
        /* Custom styles for the global search bar */
        .searchform {
            display: flex;
            max-width: 300px;
            border: 1px solid #ddd;
            border-radius: 5px;
            overflow: hidden;
/* 			margin-left:10px !important; */
			background-color: #6d193d;
			height:43px;
        }

        #s {
            flex: 1;
            padding: 8px;
            border: none;
            color: #000;
            width: 70%;
            background-color: #fff; /* White background for input */
			border-radius:0px !important;
        }

        .search-submit {
            flex: 0 0 30%;
            background-color: #fff;
            border: none;
/*             padding: 10px; */
            color: ##6d193d;
            cursor: pointer;
			border-radius:0px;
			text-align:center;
			vertical-align:center;
        }
		.searchform input::placeholder {
			color: #6d193d; /* Placeholder text color */
			font-style: 'roboto'; /* You can adjust this based on your preference */
		}
		.search-submit:hover{
			 background-color: #fff !important;
		}
        .search-submit i {
            color: #6d193d;
        }
    </style>

    <form role="search" method="get" id="searchform" class="searchform" action="<?php echo esc_url(home_url('/')); ?>">
        <label for="s" class="screen-reader-text"><?php _e('Search for:', 'textdomain'); ?></label>
        <input type="text" value="<?php echo get_search_query(); ?>" name="s" id="s" placeholder="<?php esc_attr_e('Search...', 'textdomain'); ?>" />
        <button type="submit" id="searchsubmit" class="search-submit">
            <i class="fa fa-search" aria-hidden="true"></i>
        </button>
    </form>
    <?php
    return ob_get_clean();
}
add_shortcode('global_search', 'global_search_bar_shortcode');

// Enqueue Font Awesome
function enqueue_font_awesome() {
    wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css');
}
add_action('wp_enqueue_scripts', 'enqueue_font_awesome');
function enqueue_pdf_viewer_scripts() {
    // Enqueue PDF.js
    if (!wp_script_is('pdfjs', 'enqueued')) {
        wp_enqueue_script('pdfjs', 'https://mozilla.github.io/pdf.js/build/pdf.js', array(), null, true);
    }

    // Enqueue Swiper.js
    if (!wp_script_is('swiper', 'enqueued')) {
        wp_enqueue_script('swiper', 'https://unpkg.com/swiper/swiper-bundle.min.js', array(), null, true);
        wp_enqueue_style('swiper-style', 'https://unpkg.com/swiper/swiper-bundle.min.css');
    }

    // Enqueue custom script for handling the PDF view
    wp_enqueue_script('pdf-viewer', get_template_directory_uri() . '/pdf-viewer.js', array('pdfjs', 'swiper'), null, true);

    // Enqueue custom styles
    //wp_enqueue_style('pdf-viewer-style', get_template_directory_uri() . '/css/pdf-viewer.css');
}
add_action('wp_enqueue_scripts', 'enqueue_pdf_viewer_scripts');
function theme_enqueue_styles() {
    wp_enqueue_style('slick-css', get_template_directory_uri() . '/path-to-slick/slick.css');
    wp_enqueue_style('slick-theme-css', get_template_directory_uri() . '/path-to-slick/slick-theme.css');
    wp_enqueue_script('slick-js', get_template_directory_uri() . '/path-to-slick/slick.min.js', array('jquery'), null, true);
}
add_action('wp_enqueue_scripts', 'theme_enqueue_styles');
function verify_recaptcha($commentdata) {
    $recaptcha_secret = '6LcYhPwpAAAAABuN6ER9Q_3ezMlKdaB3PvzqRYha'; // Replace with your secret key
    $recaptcha_response = $_POST['g-recaptcha-response'];
    $remote_ip = $_SERVER['REMOTE_ADDR'];
    $response = wp_remote_post('https://www.google.com/recaptcha/api/siteverify', array(
        'body' => array(
            'secret' => $recaptcha_secret,
            'response' => $recaptcha_response,
            'remoteip' => $remote_ip
        )
    ));
    $response_body = wp_remote_retrieve_body($response);
    $result = json_decode($response_body);
    if (!$result->success) {
        wp_die('reCAPTCHA verification failed, please try again.');
    }
    return $commentdata;
}
add_filter('preprocess_comment', 'verify_recaptcha');
// Shortcode to display Add to Cart and Buy Now buttons with quantity field
function wc_pay_shortcode($atts) {
    $atts = shortcode_atts(
        array(
            'p_id' => '', // Product ID
        ), $atts, 'wc_pay'
    );

    $product_id = absint($atts['p_id']);

    if (empty($product_id)) {
        return '<p>Please provide a valid product ID.</p>';
    }

    ob_start();

    ?>
    <style>
        .quantity {
            margin-bottom: 20px;
        }
        .button[disabled] {
            opacity: 0.5;
            cursor: not-allowed;
        }
    </style>
    <form class="wc-pay-form" action="" method="post" enctype="multipart/form-data">
        <div class="quantity">
            <label for="quantity">Quantity:</label>
            <input type="number" id="quantity" name="quantity" value="1" min="1" step="1">
        </div>
        <input type="hidden" name="add-to-cart" value="<?php echo esc_attr($product_id); ?>">
        <button type="submit" name="wc_add_to_cart" class="button add_to_cart_button">Add to Cart</button>
        <button type="button" name="wc_buy_now" class="button buy_now_button" data-product-id="<?php echo esc_attr($product_id); ?>">Buy Now</button>
    </form>

    <script type="text/javascript">
        jQuery(document).ready(function($) {
            // Handle Add to Cart button submit
            $('.wc-pay-form').submit(function(e) {
                e.preventDefault();

                var form = $(this);
                var addToCartButton = form.find('.add_to_cart_button');
                var quantity = form.find('input[name="quantity"]').val();
                var productId = form.find('input[name="add-to-cart"]').val();

                // Disable the Add to Cart button during AJAX
                addToCartButton.prop('disabled', true).text('Adding to Cart...');

                // Add product to cart via AJAX
                $.ajax({
                    url: '<?php echo esc_url(admin_url('admin-ajax.php')); ?>',
                    type: 'POST',
                    data: {
                        action: 'custom_wc_buy_now',
                        product_id: productId,
                        quantity: quantity
                    },
                    success: function(response) {
                        if (response.success) {
                            // Optionally refresh the cart count display
                            $(document.body).trigger('wc_fragment_refresh');
                            addToCartButton.text('Added to Cart!');

                            // You can also set a timeout to reset the button text after a few seconds
                            setTimeout(function() {
                                addToCartButton.prop('disabled', false).text('Add to Cart');
                            }, 1000); // Change the timeout duration as needed
                        } else {
                            alert('Error: Could not add product to cart.');
                            addToCartButton.prop('disabled', false).text('Add to Cart');
                        }
                    }
                });
            });

            $('.buy_now_button').click(function(e) {
            e.preventDefault();

            var form = $(this).closest('form');
            var buyNowButton = $(this);
            var productId = $(this).data('product-id');
            var quantity = form.find('input[name="quantity"]').val();

            // Disable the Buy Now button and show a loading spinner
            buyNowButton.prop('disabled', true).text('Loading...');

            // Add product to cart via AJAX
            $.ajax({
                url: '<?php echo esc_url(admin_url('admin-ajax.php')); ?>',
                type: 'POST',
                data: {
                    action: 'custom_wc_buy_now',
                    product_id: productId,
                    quantity: quantity
                },
                success: function(response) {
                    if (response.success) {
                        // Redirect to checkout
                        buyNowButton.prop('disabled', false).text('Buy Now');
                        window.location.href = '<?php echo esc_url(wc_get_checkout_url()); ?>';
                    } else {
                        // Handle error scenario
                        alert('Error: Could not add product to cart.');
                        buyNowButton.prop('disabled', false).text('Buy Now');
                    }
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    // Handle request failure
                    alert('Request failed: ' + textStatus + ' - ' + errorThrown);
                    buyNowButton.prop('disabled', false).text('Buy Now');
                },
                complete: function() {
                    // Reset button state in case of a failure
                    buyNowButton.prop('disabled', false);
                }
            });
        });
        });
    </script>
    <?php

    return ob_get_clean();
}
add_shortcode('wc_pay', 'wc_pay_shortcode');

// AJAX handler for Buy Now
function custom_wc_buy_now_ajax() {
    $product_id = absint($_POST['product_id']);
    $quantity = absint($_POST['quantity']);

    if ($product_id && $quantity) {
        $added = WC()->cart->add_to_cart($product_id, $quantity);
        
        if ($added) {
            wp_send_json_success();
        } else {
            wp_send_json_error();
        }
    } else {
        wp_send_json_error();
    }
}
add_action('wp_ajax_custom_wc_buy_now', 'custom_wc_buy_now_ajax');
add_action('wp_ajax_nopriv_custom_wc_buy_now', 'custom_wc_buy_now_ajax');
// Add custom fields to product data
add_action('woocommerce_product_options_general_product_data', 'add_custom_product_fields');
function add_custom_product_fields() {
    global $post;

    // Shortcode field
    echo '<div class="options_group">';
    woocommerce_wp_text_input(array(
        'id' => '_shortcode', // Note the underscore to follow WordPress meta conventions
        'label' => __('Shortcode', 'woocommerce'),
        'desc_tip' => 'true',
        'description' => __('Auto-generated shortcode for this product.', 'woocommerce'),
        'value' => get_post_meta($post->ID, '_shortcode', true),
        'custom_attributes' => array('readonly' => 'readonly'), // Make it readonly
    ));

    // Related Page URL field
    woocommerce_wp_text_input(array(
        'id' => '_related_page_url',
        'label' => __('Related Page URL', 'woocommerce'),
        'desc_tip' => 'true',
        'description' => __('Enter the related page URL for this product.', 'woocommerce'),
        'value' => get_post_meta($post->ID, '_related_page_url', true),
    ));
    echo '</div>';
}

// Save custom fields
add_action('woocommerce_process_product_meta', 'save_custom_product_fields');
function save_custom_product_fields($post_id) {
    // Save the related page URL
    $related_page_url = isset($_POST['_related_page_url']) ? sanitize_text_field($_POST['_related_page_url']) : '';
    update_post_meta($post_id, '_related_page_url', $related_page_url);

    // Auto-generate and save the shortcode
    $shortcode = '[wc_pay p_id=' . $post_id . ']';
    update_post_meta($post_id, '_shortcode', $shortcode);
}
// Append shortcode to product title in the admin products list
add_filter('the_title', 'append_shortcode_to_product_title', 10, 2);
function append_shortcode_to_product_title($title, $id) {
    // Only modify the title in the admin area and for product post type
    if (is_admin() && 'product' === get_post_type($id)) {
        // Retrieve the shortcode for the product
        $shortcode = get_post_meta($id, '_shortcode', true);

        // Append the shortcode to the title if it exists
        if ($shortcode) {
            $title .= ' ' . esc_html($shortcode) . '';
        }
    }

    return $title;
}
