jQuery(document).ready(function($){
    var file_frame;

    $(document).on('click', '.books-plugin-upload-pdf-button', function(e) {
        e.preventDefault();

        // If the media frame already exists, reopen it.
        if (file_frame) {
            file_frame.open();
            return;
        }

        // Create a new media frame
        file_frame = wp.media({
            title: 'Select or Upload PDF',
            button: {
                text: 'Use this PDF'
            },
            library: {
                type: 'application/pdf'
            },
            multiple: false  // Set to true to allow multiple files to be selected
        });

        // When a file is selected, run a callback.
        file_frame.on('select', function() {
            var attachment = file_frame.state().get('selection').first().toJSON();
            $('#book_pdf_url').val(attachment.url);
            $('.books-plugin-uploaded-pdf').html('<a href="' + attachment.url + '">' + attachment.url + '</a>');
        });

        // Finally, open the modal
        file_frame.open();
    });
});
