<?php
function cbl_create_tables() {
    global $wpdb;
    $charset_collate = $wpdb->get_charset_collate();

    // Table names
    $table_books = $wpdb->prefix . 'books';
    $table_authors = $wpdb->prefix . 'books_author';
    $table_genres = $wpdb->prefix . 'books_genre';
    $table_availability = $wpdb->prefix . 'books_availability';

    // SQL to create tables
    $sql = "CREATE TABLE $table_books (
        id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
        title VARCHAR(255) NOT NULL,
        description TEXT NOT NULL,
        featured_image VARCHAR(255) NOT NULL,
        images TEXT,
        pdf VARCHAR(255),
        author_id BIGINT(20) UNSIGNED NOT NULL,
        genre_id BIGINT(20) UNSIGNED NOT NULL,
        PRIMARY KEY (id)
    ) $charset_collate;

    CREATE TABLE $table_authors (
        id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
        name VARCHAR(255) NOT NULL,
        PRIMARY KEY (id)
    ) $charset_collate;

    CREATE TABLE $table_genres (
        id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
        name VARCHAR(255) NOT NULL,
        PRIMARY KEY (id)
    ) $charset_collate;

    CREATE TABLE $table_availability (
        id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
        book_id BIGINT(20) UNSIGNED NOT NULL,
        site_name VARCHAR(255) NOT NULL,
        site_url VARCHAR(255) NOT NULL,
        ratings DECIMAL(3,2),
        book_url VARCHAR(255) NOT NULL,
        PRIMARY KEY (id),
        FOREIGN KEY (book_id) REFERENCES $table_books(id) ON DELETE CASCADE
    ) $charset_collate;";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
}

