<?php
/**
 * Kadence functions and definitions
 *
 * This file must be parseable by PHP 5.2.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package kadence
 */

define( 'KADENCE_VERSION', '1.2.5' );
define( 'KADENCE_MINIMUM_WP_VERSION', '5.6' );
define( 'KADENCE_MINIMUM_PHP_VERSION', '7.4' );

// Bail if requirements are not met.
if ( version_compare( $GLOBALS['wp_version'], KADENCE_MINIMUM_WP_VERSION, '<' ) || version_compare( phpversion(), KADENCE_MINIMUM_PHP_VERSION, '<' ) ) {
	require get_template_directory() . '/inc/back-compat.php';
	return;
}
// Include WordPress shims.
require get_template_directory() . '/inc/wordpress-shims.php';

// Load the `kadence()` entry point function.
require get_template_directory() . '/inc/class-theme.php';

// Load the `kadence()` entry point function.
require get_template_directory() . '/inc/functions.php';

// Initialize the theme.
call_user_func( 'Kadence\kadence' );
function global_search_bar_shortcode() {
    ob_start();
    ?>
    <style>
        /* Custom styles for the global search bar */
        .searchform {
            display: flex;
            max-width: 300px;
            border: 1px solid #ddd;
            border-radius: 5px;
            overflow: hidden;
/* 			margin-left:10px !important; */
			background-color: #6d193d;
			height:43px;
        }

        #s {
            flex: 1;
            padding: 8px;
            border: none;
            color: #000;
            width: 70%;
            background-color: #fff; /* White background for input */
			border-radius:0px !important;
        }

        .search-submit {
            flex: 0 0 30%;
            background-color: #fff;
            border: none;
/*             padding: 10px; */
            color: ##6d193d;
            cursor: pointer;
			border-radius:0px;
			text-align:center;
			vertical-align:center;
        }
		.searchform input::placeholder {
			color: #6d193d; /* Placeholder text color */
			font-style: 'roboto'; /* You can adjust this based on your preference */
		}
		.search-submit:hover{
			 background-color: #fff !important;
		}
        .search-submit i {
            color: #6d193d;
        }
    </style>

    <form role="search" method="get" id="searchform" class="searchform" action="<?php echo esc_url(home_url('/')); ?>">
        <label for="s" class="screen-reader-text"><?php _e('Search for:', 'textdomain'); ?></label>
        <input type="text" value="<?php echo get_search_query(); ?>" name="s" id="s" placeholder="<?php esc_attr_e('Search...', 'textdomain'); ?>" />
        <button type="submit" id="searchsubmit" class="search-submit">
            <i class="fa fa-search" aria-hidden="true"></i>
        </button>
    </form>
    <?php
    return ob_get_clean();
}
add_shortcode('global_search', 'global_search_bar_shortcode');

// Enqueue Font Awesome
function enqueue_font_awesome() {
    wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css');
}
add_action('wp_enqueue_scripts', 'enqueue_font_awesome');
function enqueue_pdf_viewer_scripts() {
    // Enqueue PDF.js
    if (!wp_script_is('pdfjs', 'enqueued')) {
        wp_enqueue_script('pdfjs', 'https://mozilla.github.io/pdf.js/build/pdf.js', array(), null, true);
    }

    // Enqueue Swiper.js
    if (!wp_script_is('swiper', 'enqueued')) {
        wp_enqueue_script('swiper', 'https://unpkg.com/swiper/swiper-bundle.min.js', array(), null, true);
        wp_enqueue_style('swiper-style', 'https://unpkg.com/swiper/swiper-bundle.min.css');
    }

    // Enqueue custom script for handling the PDF view
    wp_enqueue_script('pdf-viewer', get_template_directory_uri() . '/pdf-viewer.js', array('pdfjs', 'swiper'), null, true);

    // Enqueue custom styles
    //wp_enqueue_style('pdf-viewer-style', get_template_directory_uri() . '/css/pdf-viewer.css');
}
add_action('wp_enqueue_scripts', 'enqueue_pdf_viewer_scripts');
function theme_enqueue_styles() {
    wp_enqueue_style('slick-css', get_template_directory_uri() . '/path-to-slick/slick.css');
    wp_enqueue_style('slick-theme-css', get_template_directory_uri() . '/path-to-slick/slick-theme.css');
    wp_enqueue_script('slick-js', get_template_directory_uri() . '/path-to-slick/slick.min.js', array('jquery'), null, true);
}
add_action('wp_enqueue_scripts', 'theme_enqueue_styles');
function verify_recaptcha($commentdata) {
    $recaptcha_secret = '6LcYhPwpAAAAABuN6ER9Q_3ezMlKdaB3PvzqRYha'; // Replace with your secret key
    $recaptcha_response = $_POST['g-recaptcha-response'];
    $remote_ip = $_SERVER['REMOTE_ADDR'];
    $response = wp_remote_post('https://www.google.com/recaptcha/api/siteverify', array(
        'body' => array(
            'secret' => $recaptcha_secret,
            'response' => $recaptcha_response,
            'remoteip' => $remote_ip
        )
    ));
    $response_body = wp_remote_retrieve_body($response);
    $result = json_decode($response_body);
    if (!$result->success) {
        wp_die('reCAPTCHA verification failed, please try again.');
    }
    return $commentdata;
}
add_filter('preprocess_comment', 'verify_recaptcha');
