<?php
defined('BASEPATH') OR exit('No direct script access allowed');
include('sq_config.php');
/*
|--------------------------------------------------------------------------
| Base Site URL
|--------------------------------------------------------------------------
| 
*/
$config['base_url'] = $sq_base_url;


/*
|--------------------------------------------------------------------------
| Index File
|--------------------------------------------------------------------------
|
| Typically this will be your index.php file, unless you've renamed it to
| something else. If you are using mod_rewrite to remove the page set this
| variable so that it is blank.
|
*/
$config['index_page'] = 'index.php';

/*
|--------------------------------------------------------------------------
| URI PROTOCOL
|--------------------------------------------------------------------------
|
| This item determines which server global should be used to retrieve the
| URI string.  The default setting of 'REQUEST_URI' works for most servers.
| If your links do not seem to work, try one of the other delicious flavors:
|
| 'REQUEST_URI'    Uses $_SERVER['REQUEST_URI']
| 'QUERY_STRING'   Uses $_SERVER['QUERY_STRING']
| 'PATH_INFO'      Uses $_SERVER['PATH_INFO']
|
| WARNING: If you set this to 'PATH_INFO', URIs will always be URL-decoded!
*/
$config['uri_protocol']	= 'REQUEST_URI';

/*
|--------------------------------------------------------------------------
| URL suffix
|--------------------------------------------------------------------------
|
| This option allows you to add a suffix to all URLs generated by CodeIgniter.
| For more information please see the user guide:
|
| https://codeigniter.com/user_guide/general/urls.html
*/
$config['url_suffix'] = '';

/*
|--------------------------------------------------------------------------
| Default Language
|--------------------------------------------------------------------------
|
| This determines which set of language files should be used. Make sure
| there is an available translation if you intend to use something other
| than english.
|
*/
$config['language']	= 'english';



// no of rows per page
$config['number_of_rows']="30";


 
/*
|--------------------------------------------------------------------------
| Default Character Set
|--------------------------------------------------------------------------
|
| This determines which character set is used by default in various methods
| that require a character set to be provided.
|
| See http://php.net/htmlspecialchars for a list of supported charsets.
|
*/
$config['charset'] = 'UTF-8';

/*
|--------------------------------------------------------------------------
| Enable/Disable System Hooks
|--------------------------------------------------------------------------
|
| If you would like to use the 'hooks' feature you must enable it by
| setting this variable to TRUE (boolean).  See the user guide for details.
|
*/
$config['enable_hooks'] = FALSE;

/*
|--------------------------------------------------------------------------
| Class Extension Prefix
|--------------------------------------------------------------------------
|
| This item allows you to set the filename/classname prefix when extending
| native libraries.  For more information please see the user guide:
|
| https://codeigniter.com/user_guide/general/core_classes.html
| https://codeigniter.com/user_guide/general/creating_libraries.html
|
*/
$config['subclass_prefix'] = 'MY_';

/*
|--------------------------------------------------------------------------
| Composer auto-loading
|--------------------------------------------------------------------------
|
| Enabling this setting will tell CodeIgniter to look for a Composer
| package auto-loader script in application/vendor/autoload.php.
|
|	$config['composer_autoload'] = TRUE;
|
| Or if you have your vendor/ directory located somewhere else, you
| can opt to set a specific path as well:
|
|	$config['composer_autoload'] = '/path/to/vendor/autoload.php';
|
| For more information about Composer, please visit http://getcomposer.org/
|
| Note: This will NOT disable or override the CodeIgniter-specific
|	autoloading (application/config/autoload.php)
*/
$config['composer_autoload'] = 'vendor/autoload.php';

/*
|--------------------------------------------------------------------------
| Allowed URL Characters
|--------------------------------------------------------------------------
|
| This lets you specify which characters are permitted within your URLs.
| When someone tries to submit a URL with disallowed characters they will
| get a warning message.
|
| As a security measure you are STRONGLY encouraged to restrict URLs to
| as few characters as possible.  By default only these are allowed: a-z 0-9~%.:_-
|
| Leave blank to allow all characters -- but only if you are insane.
|
| The configured value is actually a regular expression character group
| and it will be executed as: ! preg_match('/^[<permitted_uri_chars>]+$/i
|
| DO NOT CHANGE THIS UNLESS YOU FULLY UNDERSTAND THE REPERCUSSIONS!!
|
*/
$config['permitted_uri_chars'] = '';

/*
|--------------------------------------------------------------------------
| Enable Query Strings
|--------------------------------------------------------------------------
|
| By default CodeIgniter uses search-engine friendly segment based URLs:
| example.com/who/what/where/
|
| By default CodeIgniter enables access to the $_GET array.  If for some
| reason you would like to disable it, set 'allow_get_array' to FALSE.
|
| You can optionally enable standard query string based URLs:
| example.com?who=me&what=something&where=here
|
| Options are: TRUE or FALSE (boolean)
|
| The other items let you set the query string 'words' that will
| invoke your controllers and its functions:
| example.com/index.php?c=controller&m=function
|
| Please note that some of the helpers won't work as expected when
| this feature is enabled, since CodeIgniter is designed primarily to
| use segment based URLs.
|
*/
$config['allow_get_array'] = TRUE;
$config['enable_query_strings'] = FALSE;
$config['controller_trigger'] = 'c';
$config['function_trigger'] = 'm';
$config['directory_trigger'] = 'd';

/*
|--------------------------------------------------------------------------
| Error Logging Threshold
|--------------------------------------------------------------------------
|
| You can enable error logging by setting a threshold over zero. The
| threshold determines what gets logged. Threshold options are:
|
|	0 = Disables logging, Error logging TURNED OFF
|	1 = Error Messages (including PHP errors)
|	2 = Debug Messages
|	3 = Informational Messages
|	4 = All Messages
|
| You can also pass an array with threshold levels to show individual error types
|
| 	array(2) = Debug Messages, without Error Messages
|
| For a live site you'll usually only enable Errors (1) to be logged otherwise
| your log files will fill up very fast.
|
*/
$config['log_threshold'] = 1;

/*
|--------------------------------------------------------------------------
| Error Logging Directory Path
|--------------------------------------------------------------------------
|
| Leave this BLANK unless you would like to set something other than the default
| application/logs/ directory. Use a full server path with trailing slash.
|
*/
$config['log_path'] = '';

/*
|--------------------------------------------------------------------------
| Log File Extension
|--------------------------------------------------------------------------
|
| The default filename extension for log files. The default 'php' allows for
| protecting the log files via basic scripting, when they are to be stored
| under a publicly accessible directory.
|
| Note: Leaving it blank will default to 'php'.
|
*/
$config['log_file_extension'] = '';

/*
|--------------------------------------------------------------------------
| Log File Permissions
|--------------------------------------------------------------------------
|
| The file system permissions to be applied on newly created log files.
|
| IMPORTANT: This MUST be an integer (no quotes) and you MUST use octal
|            integer notation (i.e. 0700, 0644, etc.)
*/
$config['log_file_permissions'] = 0644;

/*
|--------------------------------------------------------------------------
| Date Format for Logs
|--------------------------------------------------------------------------
|
| Each item that is logged has an associated date. You can use PHP date
| codes to set your own date formatting
|
*/
$config['log_date_format'] = 'Y-m-d H:i:s';

/*
|--------------------------------------------------------------------------
| Error Views Directory Path
|--------------------------------------------------------------------------
|
| Leave this BLANK unless you would like to set something other than the default
| application/views/errors/ directory.  Use a full server path with trailing slash.
|
*/
$config['error_views_path'] = '';

/*
|--------------------------------------------------------------------------
| Cache Directory Path
|--------------------------------------------------------------------------
|
| Leave this BLANK unless you would like to set something other than the default
| application/cache/ directory.  Use a full server path with trailing slash.
|
*/
$config['cache_path'] = '';

/*
|--------------------------------------------------------------------------
| Cache Include Query String
|--------------------------------------------------------------------------
|
| Whether to take the URL query string into consideration when generating
| output cache files. Valid options are:
|
|	FALSE      = Disabled
|	TRUE       = Enabled, take all query parameters into account.
|	             Please be aware that this may result in numerous cache
|	             files generated for the same page over and over again.
|	array('q') = Enabled, but only take into account the specified list
|	             of query parameters.
|
*/
$config['cache_query_string'] = FALSE;

/*
|--------------------------------------------------------------------------
| Encryption Key
|--------------------------------------------------------------------------
|
| If you use the Encryption class, you must set an encryption key.
| See the user guide for more info.
|
| https://codeigniter.com/user_guide/libraries/encryption.html
|
*/
$config['encryption_key'] = 'savsoftquiz';

/*
|--------------------------------------------------------------------------
| Session Variables
|--------------------------------------------------------------------------
|
| 'sess_driver'
|
|	The storage driver to use: files, database, redis, memcached
|
| 'sess_cookie_name'
|
|	The session cookie name, must contain only [0-9a-z_-] characters
|
| 'sess_expiration'
|
|	The number of SECONDS you want the session to last.
|	Setting to 0 (zero) means expire when the browser is closed.
|
| 'sess_save_path'
|
|	The location to save sessions to, driver dependent.
|
|	For the 'files' driver, it's a path to a writable directory.
|	WARNING: Only absolute paths are supported!
|
|	For the 'database' driver, it's a table name.
|	Please read up the manual for the format with other session drivers.
|
|	IMPORTANT: You are REQUIRED to set a valid save path!
|
| 'sess_match_ip'
|
|	Whether to match the user's IP address when reading the session data.
|
|	WARNING: If you're using the database driver, don't forget to update
|	         your session table's PRIMARY KEY when changing this setting.
|
| 'sess_time_to_update'
|
|	How many seconds between CI regenerating the session ID.
|
| 'sess_regenerate_destroy'
|
|	Whether to destroy session data associated with the old session ID
|	when auto-regenerating the session ID. When set to FALSE, the data
|	will be later deleted by the garbage collector.
|
| Other session cookie settings are shared with the rest of the application,
| except for 'cookie_prefix' and 'cookie_httponly', which are ignored here.
|
*/
$config['sess_driver'] = 'files';
$config['sess_cookie_name'] = 'ci_session';
$config['sess_expiration'] = 7200;
$config['sess_save_path'] = NULL;
$config['sess_match_ip'] = FALSE;
$config['sess_time_to_update'] = 300;
$config['sess_regenerate_destroy'] = FALSE;

/*
|--------------------------------------------------------------------------
| Cookie Related Variables
|--------------------------------------------------------------------------
|
| 'cookie_prefix'   = Set a cookie name prefix if you need to avoid collisions
| 'cookie_domain'   = Set to .your-domain.com for site-wide cookies
| 'cookie_path'     = Typically will be a forward slash
| 'cookie_secure'   = Cookie will only be set if a secure HTTPS connection exists.
| 'cookie_httponly' = Cookie will only be accessible via HTTP(S) (no javascript)
|
| Note: These settings (with the exception of 'cookie_prefix' and
|       'cookie_httponly') will also affect sessions.
|
*/
$config['cookie_prefix']	= '';
$config['cookie_domain']	= '';
$config['cookie_path']		= '/';
$config['cookie_secure']	= FALSE;
$config['cookie_httponly'] 	= FALSE;

/*
|--------------------------------------------------------------------------
| Standardize newlines
|--------------------------------------------------------------------------
|
| Determines whether to standardize newline characters in input data,
| meaning to replace \r\n, \r, \n occurrences with the PHP_EOL value.
|
| This is particularly useful for portability between UNIX-based OSes,
| (usually \n) and Windows (\r\n).
|
*/
$config['standardize_newlines'] = FALSE;

/*
|--------------------------------------------------------------------------
| Global XSS Filtering
|--------------------------------------------------------------------------
|
| Determines whether the XSS filter is always active when GET, POST or
| COOKIE data is encountered
|
| WARNING: This feature is DEPRECATED and currently available only
|          for backwards compatibility purposes!
|
*/
$config['global_xss_filtering'] = FALSE;

/*
|--------------------------------------------------------------------------
| Cross Site Request Forgery
|--------------------------------------------------------------------------
| Enables a CSRF cookie token to be set. When set to TRUE, token will be
| checked on a submitted form. If you are accepting user data, it is strongly
| recommended CSRF protection be enabled.
|
| 'csrf_token_name' = The token name
| 'csrf_cookie_name' = The cookie name
| 'csrf_expire' = The number in seconds the token should expire.
| 'csrf_regenerate' = Regenerate token on every submission
| 'csrf_exclude_uris' = Array of URIs which ignore CSRF checks
*/
$config['csrf_protection'] = FALSE;
$config['csrf_token_name'] = 'csrf_test_name';
$config['csrf_cookie_name'] = 'csrf_cookie_name';
$config['csrf_expire'] = 7200;
$config['csrf_regenerate'] = TRUE;
$config['csrf_exclude_uris'] = array();

/*
|--------------------------------------------------------------------------
| Output Compression
|--------------------------------------------------------------------------
|
| Enables Gzip output compression for faster page loads.  When enabled,
| the output class will test whether your server supports Gzip.
| Even if it does, however, not all browsers support compression
| so enable only if you are reasonably sure your visitors can handle it.
|
| Only used if zlib.output_compression is turned off in your php.ini.
| Please do not use it together with httpd-level output compression.
|
| VERY IMPORTANT:  If you are getting a blank page when compression is enabled it
| means you are prematurely outputting something to your browser. It could
| even be a line of whitespace at the end of one of your scripts.  For
| compression to work, nothing can be sent before the output buffer is called
| by the output class.  Do not 'echo' any values with compression enabled.
|
*/
$config['compress_output'] = FALSE;

/*
|--------------------------------------------------------------------------
| Master Time Reference
|--------------------------------------------------------------------------
|
| Options are 'local' or any PHP supported timezone. This preference tells
| the system whether to use your server's local time as the master 'now'
| reference, or convert it to the configured one timezone. See the 'date
| helper' page of the user guide for information regarding date handling.
|
*/
$config['time_reference'] = 'local';

/*
|--------------------------------------------------------------------------
| Rewrite PHP Short Tags
|--------------------------------------------------------------------------
|
| If your PHP installation does not have short tag support enabled CI
| can rewrite the tags on-the-fly, enabling you to utilize that syntax
| in your view files.  Options are TRUE or FALSE (boolean)
|
| Note: You need to have eval() enabled for this to work.
|
*/
$config['rewrite_short_tags'] = FALSE;

/*
| permission to write config file at front end by admin
| 1 for  admin & super admin (if you have super admin version)
| 2 for suadmin only  (if you have super admin version)
*/
$config['frontend_write_admin']=1;
/*
|--------------------------------------------------------------------------
| Reverse Proxy IPs
|--------------------------------------------------------------------------
|
| If your server is behind a reverse proxy, you must whitelist the proxy
| IP addresses from which CodeIgniter should trust headers such as
| HTTP_X_FORWARDED_FOR and HTTP_CLIENT_IP in order to properly identify
| the visitor's IP address.
|
| You can use both an array or a comma-separated list of proxy addresses,
| as well as specifying whole subnets. Here are a few examples:
|
| Comma-separated:	'10.0.1.200,192.168.5.0/24'
| Array:		array('10.0.1.200', '192.168.5.0/24')
*/
$config['proxy_ips'] = '';

if(isset($sq_dbname)){
// Create connection
$conn = new mysqli($sq_hostname, $sq_dbusername, $sq_dbpassword, $sq_dbname);
// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}
 
$sql = " select * from savsoftquiz_setting";
$result_config = $conn->query($sql);
 $csetting=array();
	 foreach($result_config as $k => $val){
		$csetting[$val['setting_name']]=$val['setting_value']; 
	 }
 
 
 
 
 
  
// language direction ( ltr or rtl )
$config['direction']=$csetting['Language_direction'];


// enable webcam js ( true or false )
$config['webcam']=$csetting['Enable_web_cam'];



// google chart ( true or false )
$config['google_chart']=$csetting['Enable_google_chart'];

// google chart ( true or false )
$config['dompdf']=$csetting['Enable_dompdf'];

 
// Allow registration ( true or false )
$config['user_registration']=$csetting['Enable_user_registration'];

// verify email address ( true or false )
$config['verify_email']=$csetting['Verify_user_email'];

// tinymce editor ( true or false )
$config['tinymce']=$csetting['Tinymce_editor'];
// eqneditor plugin in tinymce ( true or false )
$config['eqneditor']=$csetting['Tinymce_eqneditor_plugin'];
// eqneditor plugin in tinymce ( true or false )
$config['wiris']=$csetting['Tinymce_wiris_plugin'];


// enable mathjax
$config['mathjax']=$csetting['Mathjax'];;

// default group id
$config['default_gid']=$csetting['Default_group_id'];

  
// Allow open quiz( true or false )
$config['open_quiz']=$csetting['Enable_open_quiz'];

 
// enable sharethis (true or false)
$config['sharethis']=$csetting['Enable_sharethis'];
// property key
$config['sharethis_property']=$csetting['Sharethis_property_id'];

  
 
// display advertisement after X number of seconds of starting quiz
//$config['showadvertisement_after']=$csetting['Advertisement_display_after_seconds'];
// display advertisement during quiz for seconds
//$config['showadvertisement_sec']=$csetting['Advertisement_display_for_seconds'];

  
 

// API key for android app
$config['api_key']=$csetting['Android_API_key'];




// allow user to change their group. use true or false
$config['allow_switch_group']=true;
// default free group id - gid
$config['default_group']=1;


// Use wordpress userdatabase to login. use true or false
$config['wp-login']=false;
// wp path to wp-blog-header.php
$config['wp-path']='../wp/wp-blog-header.php';



// email sending protocol mail or smtp
$config['protocol']=$csetting['Email_protocol'];

/*
| SMTP configuration to send email to user just after submitting quiz
| This feature is under testing version, We are not responsible if it does not work with any devices or browsers.
*/

// smtp hostname eg. smtp.gmail.com
$config['smtp_hostname'] = $csetting['SMTP_hostname'];
// smtp username
$config['smtp_username'] = $csetting['SMTP_username'];
// smtp password
$config['smtp_password'] = $csetting['SMTP_password'];
// smtp outgoing port. eg for gmail its 465, outlook 587, yahoo 465 for other contact your mailing administrator
$config['smtp_port'] = $csetting['SMTP_port'];
// smtp timeout default 5 seconds
$config['smtp_timeout'] = "5";
// smtp tls
$config['starttls'] = TRUE;
// new line
$config['newline'] = "\r\n";
// email message content text of html. 
// In html email make sure you don't have any relative links or relative image paths otherwise they will not work.
$config['smtp_mailtype'] = $csetting['SMTP_mailtype'];


// activation email subject
$config['activation_subject'] = $csetting['Activation_email_subject'];
// activation email message
$config['activation_message'] = $csetting['Activation_email_message'];


// password reset email subject
$config['password_subject'] = $csetting['Password_change_subject'];
// password reset email message
$config['password_message'] = $csetting['Password_change_message'];


// enable or disable result email. use true or false
$config['allow_result_email']=$csetting['Send_result_email'];


// Default result message
// you can use below tags and system replace it with related variables. 
// [username] [email] [first_name] [last_name] [score_obtained] [percentage_obtained] [result_status] [quiz_name] [current_date]
$config['result_message'] = $csetting['Result_email_message'];
// result email subject
$config['result_subject'] = $csetting['Result_email_subject'];




// email send from
$config['fromemail']=$csetting['SMTP_username'];
// from name
$config['fromname']="Ajatus_placement_exam";




// payment gateway


$config['base_currency_prefix']=$csetting['Base_currency_prefix'];
$config['base_currency_sufix']=$csetting['Base_currency_sufix'];
$pga=explode(',',$csetting['Payment_gateways']);
$config['payment_gateways']=array('paypal','checkout','payumoney','paytm');
$config['default_gateway']=$csetting['Default_gateway'];

// enable - disable paypal gateway
$config['paypal']=$csetting['Enable_paypal'];
// environment empty for real and sandbox. for testing (don't forget dot at end of sandbox)
$config['paypal_environment']=$csetting['Paypal_environment'];
$config['paypal_receiver']=$csetting['Paypal_receiver'];
$config['paypal_currency_prefix']=$csetting['Paypal_currency_prefix'];
$config['paypal_currency_sufix']=$csetting['Paypal_currency_sufix'];
// 1 unit of paypal currency = how many unit of base currency
$config['paypal_conversion']=$csetting['Paypal_conversion'];


// enable - disable 2checkout gateway
$config['checkout']=$csetting['Enable_checkout'];
// environment empty for real and sandbox. for testing (don't forget dot at end of sandbox)
$config['checkout_environment']=$csetting['Checkout_environment'];
$config['checkout_sid']=$csetting['Checkout_sid'];
$config['checkout_SecretWord']=$csetting['Checkout_SecretWord'];
$config['checkout_receiver']=$csetting['Checkout_receiver'];
$config['checkout_currency_prefix']=$csetting['Checkout_currency_prefix'];
$config['checkout_currency_sufix']=$csetting['Checkout_currency_sufix'];
// 1 unit of checkout currency = how many unit of base currency
$config['checkout_conversion']=$csetting['Checkout_conversion'];


 
// enable - disable payumoney gateway
$config['payumoney']=$csetting['Enable_payumoney'];
// payu merchant key
$config['payu_merchant_key']=$csetting['Payu_merchant_key'];
// payu salt
$config['payu_salt']=$csetting['Payu_salt'];
$config['payumoney_currency_prefix']=$csetting['Payumoney_currency_prefix'];
$config['payumoney_currency_sufix']=$csetting['Payumoney_currency_sufix'];
// 1 unit of payumoney currency = how many unit of base currency
$config['payumoney_conversion']=$csetting['Payumoney_conversion'];




// enable - disable paytm gateway
$config['paytm']=$csetting['Enable_paytm'];
// environment TEST or PROD 
$config['paytm_environment']=$csetting['Paytm_environment'];
// paytm merchant key
$config['paytm_merchant_key']=$csetting['Paytm_merchant_key'];
// paytm merchant mid
$config['paytm_merchant_id']=$csetting['Paytm_merchant_id'];
// paytm merchant website
$config['paytm_merchant_website']=$csetting['Paytm_merchant_website'];
$config['paytm_currency_prefix']=$csetting['Paytm_currency_prefix'];
$config['paytm_currency_sufix']=$csetting['Paytm_currency_sufix'];
// 1 unit of paytm currency = how many unit of base currency
$config['paytm_conversion']=$csetting['Paytm_conversion'];




// Firebase notification https://firebase.google.com/
/*
browsers support firebase notification
Chrome: 50+
Firefox: 44+
Opera Mobile: 37+
*/
$config['firebase_apiKey']="";
$config['firebase_authDomain']="";
$config['firebase_databaseURL']="";
$config['firebase_projectId']="";
$config['firebase_storageBucket']="";
$config['firebase_messagingSenderId']="";
// auth key or server key. find in https://console.firebase.google.com 
// go to project setting then cloud messaging
$config['firebase_serverkey']="";
$config['firebase_topic']="SavsoftQuiz";


$config['quiz_templates']=array('Default','Practice');
$config['question_lang']=array('English');

$config['master_password']=$csetting['Master_password'];
 
 
}
 


