<?php
add_shortcode('teetime_booking', 'teetime_booking_shortcode');

function teetime_booking_shortcode($atts) {
    // Extract shortcode attributes, default event_id is null
    $atts = shortcode_atts(array(
        'event_id' => null,
    ), $atts);

    // If event_id is not passed in shortcode, check if it's in the URL query parameters
    if (!$atts['event_id'] && isset($_GET['event_id'])) {
        $atts['event_id'] = intval($_GET['event_id']);
    }

    // If event_id is still not found, return an error message
    if (!$atts['event_id']) {
        return 'Invalid Golf Event ID';
    }

    // Use the event_id to get event meta data from the post
    $event_id = $atts['event_id'];

    // Get the post object using the event ID
    $post = get_post($event_id);
    if (!$post) {
        return 'Event not found.';
    }

    // Fetching the event times using the post ID
    $start_time = get_post_meta($post->ID, '_golf_club_start_time', true); // e.g., '06:00'
    $end_time = get_post_meta($post->ID, '_golf_club_end_time', true); // e.g., '18:00'
    
    // Convert stored times to timestamps
    $start_time_timestamp = strtotime(date('Y-m-d') . ' ' . $start_time); // 'YYYY-MM-DD 06:00'
    $end_time_timestamp = strtotime(date('Y-m-d') . ' ' . $end_time); // 'YYYY-MM-DD 18:00'

    $duration = get_post_meta($post->ID, '_golf_club_duration', true);

    // If duration is not set or not a valid number, default to 10 minutes
    if (!$duration || !is_numeric($duration)) {
        $duration = 10; // Default duration in minutes
    }

    // $price_per_player = get_post_meta($post->ID, '_golf_club_price_per_player', true); // Get price per player
    $golf_club_capacity = get_post_meta($post->ID, '_golf_club_capacity', true); // Get price per player

    // HTML Form
    ob_start(); // Start output buffering
    ?>
    <style>

        .teetime-booking-form {
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            padding: 20px;
            max-width: 600px;
            margin: 0 auto;
        }

        /* Step Styles */
        .step {
            margin-bottom: 20px;
        }

        .step label {
            display: block;
            font-weight: bold;
            margin-bottom: 5px;
        }

        .step input[type="text"],
        .step input[type="email"],
        .step input[type="tel"],
        .step input[type="number"],
        .step input[type="date"],
        .step select {
            width: calc(100% - 20px);
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 4px;
            margin-bottom: 10px;
            box-sizing: border-box;
        }

        /* Button Styles */
        .next-btn,
        .pay-now-btn {
            background-color: #28a745;
            color: white;
            border: none;
            border-radius: 5px;
            padding: 10px 15px;
            cursor: pointer;
            font-size: 16px;
        }

        .next-btn:hover,
        .pay-now-btn:hover {
            background-color: #218838;
        }

        /* Price Details */
        #price-details,
        #total-amount {
            font-weight: bold;
            margin-top: 10px;
        }
        .checkbox-name{
            font-weight: 500 !important; 
        }

        /* Responsive Styles */
        @media (max-width: 600px) {
            .teetime-booking-form {
                padding: 15px;
            }

            .step input[type="text"],
            .step input[type="email"],
            .step input[type="tel"],
            .step input[type="number"],
            .step input[type="date"],
            .step select {
                width: 100%;
            }
        }

    </style>
     <div class="teetime-booking-form" id="teetime-booking-form"> 
        <!-- Step 1: Date Selection -->
        <div class="step step-1">
            <label for="holes-selection"><?php _e('Select Holes:', 'teetime'); ?></label>
            <select id="holes-selection" required>
                <option value="18"><?php _e('18 Holes', 'teetime'); ?></option>
                <option value="9"><?php _e('9 Holes', 'teetime'); ?></option>
            </select>

            <label for="booking-date"><?php _e('Select a Date:', 'teetime'); ?></label>
            <input type="date" id="booking-date" min="<?php echo date('Y-m-d', strtotime('+1 day')); ?>" required />
        </div>
        <!-- Step 2: Show available time slots after date is selected -->
        <div class="step step-2" style="display:none;">
            <label for="time-slots"><?php _e('Available Time Slots:', 'teetime'); ?></label>
            <select id="time-slots" required></select>
            <button type="button" class="next-btn" style="display:none;text-align:right;"><?php _e('Next', 'teetime'); ?></button>
        </div>

        <!-- Step 3: Fill Details -->
        <div class="step step-3" style="display:none;">
            <h3><?php _e('Fill in Your Details:', 'teetime'); ?></h3>
            <label for="name"><?php _e('Name:', 'teetime'); ?></label>
            <input type="text" id="name" required />
            <div style="display:flex">
                <div style="flex:0 0 50%">
                    <label for="email"><?php _e('Email:', 'teetime'); ?></label>
                    <input type="email" id="email" required />
                </div>
                <div style="flex:0 0 50%">
                    <label for="phone"><?php _e('Phone:', 'teetime'); ?></label>
                    <input type="tel" id="phone" required />
                </div>
            </div>
            <div style="display:flex">
                <div style="flex:0 0 50%">
                    <label for="location"><?php _e('Location:', 'teetime'); ?></label>
                    <input type="text" id="location" required />
                </div>
                <div style="flex:0 0 50%">
                    <label for="accompany"><?php _e('Number of Players:', 'teetime'); ?></label>
                    <input type="number" id="accompany" value="1" min="1" max="<?php echo $golf_club_capacity?>" required />
                </div>
            </div>
            <div style="display:flex;justify-content: space-around;">
                <!-- Price Details moved to Step 3 -->
                <p id="price-details" style="font-weight: bold;"></p>
                <p id="total-amount" style="font-weight: bold;"></p>
            </div>
            <div style="text-align: right;">
                <button type="button" class="back-btn-3"><?php _e('Back', 'teetime'); ?></button>
                <button type="submit" class="pay-now-btn"><?php _e('Payment', 'teetime'); ?></button>
            </div>
        </div>
        <!-- Step 4: Payment Confirmation -->
        <div class="step step-4" style="display:none;">
            <h3><?php _e('Payment Options:', 'teetime'); ?></h3>
                <input type="radio" name="payment-option" id="pay-locally" value="pay-locally" />
                <?php _e('Pay Locally', 'teetime'); ?>
            <!-- Add the PDPA compliance checkbox -->
            <div>
            <input type="checkbox" id="pdpa-checkbox" />
            <?php _e('I agree to the ', 'teetime'); ?>
            <a href="https://mockups.ajatus.co.in/TTP/pdpa-compliance-guidelines-and-consent-form-for-tee-time-pro/" target="_blank">
                <?php _e('PDPA Compliance Guidelines and Consent Form', 'teetime'); ?>
            </a><?php _e(' for Tee Time Pro', 'teetime'); ?>
            </div>

            <div style="text-align: right;">
                <button type="button" class="back-btn-4"><?php _e('Back', 'teetime'); ?></button>
                <button type="button" class="book-btn" disabled><?php _e('Book', 'teetime'); ?></button>
            </div>
            <div class="success-message" style="display:none;"></div>
        </div>
    </div>
    <script type="text/javascript">
        // Format time in 12-hour format
        function formatTime(date) {
            const hours = date.getHours();
            const minutes = date.getMinutes();
            const ampm = hours >= 12 ? 'PM' : 'AM';
            const formattedHours = hours % 12 || 12;
            const formattedMinutes = minutes < 10 ? '0' + minutes : minutes;
            return formattedHours + ':' + formattedMinutes + ' ' + ampm;
        }

        document.addEventListener('DOMContentLoaded', function() {
            const holesSelection = document.getElementById('holes-selection'); 
            const bookingDateInput = document.getElementById('booking-date');
            const timeSlotsSelect = document.getElementById('time-slots');
            const priceDetails = document.getElementById('price-details');
            const accompanyInput = document.getElementById('accompany');
            const totalAmountDisplay = document.getElementById('total-amount');
            const bookNowButton = document.querySelector('.pay-now-btn');
            const nextButton = document.querySelector('.next-btn');
            const backButton3 = document.querySelector('.back-btn-3');
            const backButton4 = document.querySelector('.back-btn-4');
            const bookButton = document.querySelector('.book-btn');
            const successMessage = document.querySelector('.success-message');
            const payLocallyOption = document.getElementById('pay-locally');
            const pdpaCheckbox = document.getElementById('pdpa-checkbox');
            
            let pricePerPlayer = 1000;
            let totalAmount = 0;
            
            bookingDateInput.addEventListener('change', function() {
                const selectedDate = bookingDateInput.value;
                if (selectedDate) {
                    let startTime = new Date(<?php echo json_encode(date('Y-m-d H:i:s', $start_time_timestamp)); ?>);
                    let endTime = new Date(<?php echo json_encode(date('Y-m-d H:i:s', $end_time_timestamp)); ?>);
                    let duration = <?php echo $duration; ?> * 60 * 1000;
                    
                    timeSlotsSelect.innerHTML = '';
                    let slot = new Date(startTime);

                    while (slot.getTime() < endTime.getTime()) {
                        const nextSlot = new Date(slot.getTime() + duration);
                        if (nextSlot.getTime() <= endTime.getTime()) {
                            let option = document.createElement('option');
                            
                            // Format the slot times as "6:00 AM - 6:10 AM"
                            let formattedSlot = formatTime(slot) + ' - ' + formatTime(nextSlot);

                            // Set the value and display text
                            option.value = formattedSlot; 
                            option.textContent = formattedSlot;

                            timeSlotsSelect.appendChild(option);
                        }
                        slot = nextSlot; // Move to the next slot
                    }

                    document.querySelector('.step-2').style.display = 'block';
                    nextButton.style.display = 'inline-block';
                }
            });
           // Extract the shared logic into a function
            function fetchTeeTimePrice() {
                const selectedTimeslot = timeSlotsSelect.value;
                const holeId = holesSelection.value;  // Assuming Hole ID is selected
                const bookingDate = bookingDateInput.value; // Get the selected booking date
                console.log(selectedTimeslot, holeId, bookingDate);
                
                if (holeId && selectedTimeslot && bookingDate) {
                    jQuery.ajax({
                        url: "<?php echo admin_url('admin-ajax.php'); ?>",
                        method: 'POST',
                        data: {
                            action: 'fetch_teetime_price',
                            Hole_id: holeId,
                            timeslot: selectedTimeslot,
                            booking_date: bookingDate
                        },
                        success: function(response) {
                            if (response.success) {
                                pricePerPlayer = response.data.price;
                                updateTotalAmount();
                                priceDetails.textContent = `Price per Player: $${pricePerPlayer}`;
                            } else {
                                Swal.fire({
                                    title: 'Error!',
                                    text: response.data.error,
                                    icon: 'error',
                                    confirmButtonText: 'OK'
                                });
                            }
                        },
                        error: function() {
                            Swal.fire({
                                title: 'Error!',
                                text: 'Unable to fetch price at this time.',
                                icon: 'error',
                                confirmButtonText: 'OK'
                            });
                        }
                    });
                }
            }

            // Add event listeners for both the timeSlotsSelect and holesSelection
            timeSlotsSelect.addEventListener('change', fetchTeeTimePrice);
            holesSelection.addEventListener('change', fetchTeeTimePrice);
            bookingDateInput.addEventListener('change', fetchTeeTimePrice);

            accompanyInput.addEventListener('input', updateTotalAmount);

            function updateTotalAmount() {
                const numberOfPlayers = accompanyInput.value;
                const totalAmount = pricePerPlayer * numberOfPlayers;
                totalAmountDisplay.textContent = `Total Amount: $${totalAmount}`;
            }

            nextButton.addEventListener('click', function() {
                document.querySelector('.step-1').style.display = 'none';
                document.querySelector('.step-2').style.display = 'none';
                document.querySelector('.step-3').style.display = 'block';

                const numberOfPlayers = accompanyInput.value;
                totalAmount = pricePerPlayer * numberOfPlayers;
                priceDetails.textContent = `Price per Player: $${pricePerPlayer}`;
                totalAmountDisplay.textContent = `Total Amount: $${totalAmount}`;
            });

            accompanyInput.addEventListener('input', function() {
                const numberOfPlayers = accompanyInput.value;
                if (numberOfPlayers < 1) {
                    accompanyInput.value = 1;
                }
                totalAmount = pricePerPlayer * numberOfPlayers;
                if (document.querySelector('.step-3').style.display === 'block') {
                    totalAmountDisplay.textContent = `Total Amount: $${totalAmount}`;
                }
            });

            backButton3.addEventListener('click', function() {
                document.querySelector('.step-3').style.display = 'none';
                document.querySelector('.step-2').style.display = 'block';
                document.querySelector('.step-1').style.display = 'block';
            });

            backButton4.addEventListener('click', function() {
                document.querySelector('.step-4').style.display = 'none';
                document.querySelector('.step-3').style.display = 'block';
            });

            bookNowButton.addEventListener('click', function() {
                document.querySelector('.step-3').style.display = 'none';
                document.querySelector('.step-4').style.display = 'block';
            });

            // Function to check both pay locally and PDPA checkbox
            function updateBookButtonState() {
                if (payLocallyOption.checked && pdpaCheckbox.checked) {
                    bookButton.disabled = false;
                } else {
                    bookButton.disabled = true;
                }
            }

            // Add event listeners for both radio and checkbox
            payLocallyOption.addEventListener('change', updateBookButtonState);
            pdpaCheckbox.addEventListener('change', updateBookButtonState);
            bookButton.addEventListener('click', function() {
                const bookingDetails = {
                    event_id: <?php echo $event_id; ?>,
                    date: bookingDateInput.value,
                    time_slot: timeSlotsSelect.value,
                    name: document.getElementById('name').value,
                    email: document.getElementById('email').value,
                    phone: document.getElementById('phone').value,
                    location: document.getElementById('location').value,
                    accompany: accompanyInput.value,
                    total_amount: totalAmount
                };

                // Disable the book button and show loader
                bookButton.disabled = true;
                bookButton.textContent = 'Booking...'; // Change text to "Booking..."

                // AJAX request to submit the booking
                jQuery.ajax({
                    url: "<?php echo admin_url('admin-ajax.php'); ?>",
                    method: 'POST',
                    data: {
                        action: 'teetime_booking_submit',
                        booking_data: bookingDetails
                    },
                    success: function(response) {
                        if (response.success) {
                            Swal.fire({
                                title: 'Success!',
                                text: response.data.message,
                                icon: 'success',
                                confirmButtonText: 'OK'
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    // Optionally redirect after SweetAlert confirmation
                                    window.location.href = "<?php echo home_url(); ?>";
                                }
                            });

                            // Clear the form fields
                            document.getElementById('booking-date').value = '';
                            timeSlotsSelect.innerHTML = ''; // Clear time slots
                            document.getElementById('name').value = '';
                            document.getElementById('email').value = '';
                            document.getElementById('phone').value = '';
                            document.getElementById('location').value = '';
                            accompanyInput.value = 1; // Reset number of players
                            priceDetails.textContent = '';
                            totalAmountDisplay.textContent = '';

                            // Reset to step 1
                            document.querySelector('.step-1').style.display = 'block';
                            document.querySelector('.step-2').style.display = 'none';
                            document.querySelector('.step-3').style.display = 'none';
                            document.querySelector('.step-4').style.display = 'none';
                        } else {
                            Swal.fire({
                                title: 'Error!',
                                text: response.data.error,
                                icon: 'error',
                                confirmButtonText: 'OK'
                            });
                        }
                    },
                    error: function() {
                        Swal.fire({
                            title: 'Error!',
                            text: 'There was an error processing the booking.',
                            icon: 'error',
                            confirmButtonText: 'OK'
                        });
                    },
                    complete: function() {
                        // Re-enable the book button and reset the text after AJAX completes
                        bookButton.disabled = false;
                        bookButton.textContent = 'Book Now'; // Change text back to "Book Now"
                    }
                });
            });
        });
    </script>
    <?php
    return ob_get_clean(); // Return the buffered content
}
function fetch_teetime_price() {
    global $wpdb;

    // Get the Hole_id and timeslot from the AJAX request
    $hole_id_raw = isset($_POST['Hole_id']) ? intval($_POST['Hole_id']) : null;
    $timeslot = isset($_POST['timeslot']) ? sanitize_text_field($_POST['timeslot']) : null;
    $booking_date = isset($_POST['booking_date']) ? sanitize_text_field($_POST['booking_date']) : null;

    // Validate the inputs
    if (is_null($hole_id_raw) || is_null($timeslot) || is_null($booking_date)) {
        wp_send_json_error(['error' => 'Missing required parameters.']);
        return;
    }

    // Set Hole_id based on the raw value (1 for 18 holes, 2 for others)
    $hole_id = ($hole_id_raw == 18) ? 1 : 2;

    // Determine Day_type_id based on the booking date (1 for weekends, 2 for weekdays)
    $day_of_week = date('N', strtotime($booking_date)); // N returns 1 for Monday, 7 for Sunday
    $day_type_id = ($day_of_week == 6 || $day_of_week == 7) ? 1 : 2;

    // Extract the start time from the timeslot (e.g., '8:00 AM - 8:08 AM' => '8:00 AM')
    $timeslot_start = explode(' - ', $timeslot)[0];

    // Convert timeslot start time to 24-hour format for comparison (e.g., '8:00 AM' => '08:00:00')
    $timeslot_start_24hr = date('H:i:s', strtotime($timeslot_start));

    // Query the wp_teetime_pricing table for the price
    $query = $wpdb->prepare("
        SELECT Price 
        FROM wp_teetime_pricing 
        WHERE Hole_id = %d 
        AND Day_type_id = %d
        AND %s BETWEEN Starttime AND Endtime
    ", $hole_id, $day_type_id, $timeslot_start_24hr);

    // Fetch the result
    $price = $wpdb->get_var($query);

    // If price is found, return it, otherwise return an error
    if ($price !== null) {
        wp_send_json_success(['price' => $price]);
    } else {
        wp_send_json_error(['error' => 'No price found for the selected time slot.']);
    }
}

// Hook this function to handle the AJAX request
add_action('wp_ajax_fetch_teetime_price', 'fetch_teetime_price');
add_action('wp_ajax_nopriv_fetch_teetime_price', 'fetch_teetime_price');

add_action('wp_ajax_teetime_booking_submit', 'teetime_booking_submit');
add_action('wp_ajax_nopriv_teetime_booking_submit', 'teetime_booking_submit');

function teetime_booking_submit() {
    global $wpdb;

    // Validate and sanitize inputs
    $event_id = intval($_POST['booking_data']['event_id']);
    $date = sanitize_text_field($_POST['booking_data']['date']);
    $time_slot = sanitize_text_field($_POST['booking_data']['time_slot']);
    $name = sanitize_text_field($_POST['booking_data']['name']);
    $email = sanitize_email($_POST['booking_data']['email']);
    $phone = sanitize_text_field($_POST['booking_data']['phone']);
    $location = sanitize_text_field($_POST['booking_data']['location']);
    $accompany = intval($_POST['booking_data']['accompany']);
    $total_amount = floatval($_POST['booking_data']['total_amount']);

    // Perform necessary validations
    if (empty($event_id) || empty($date) || empty($time_slot) || empty($name) || empty($email)) {
        wp_send_json_error(['error' => 'Missing required fields.']);
        return;
    }

    // Set current time for creation and update timestamps
    $current_time = current_time('mysql');

    // Insert booking into `wp_teetime_booking` table
    $booking_data = array(
        'Name' => $name,
        'Email' => $email,
        'Gold_Course_id' => $event_id,
        'Accompany' => $accompany,
        'Phone' => $phone,
        'Date' => $date,
        'Location' => $location,
        'timeslot' => $time_slot,
        'Creationtime' => $current_time,
        'updatetime' => $current_time
    );

    $insert_booking = $wpdb->insert(
        $wpdb->prefix . 'teetime_booking',
        $booking_data,
        array('%s', '%s', '%d', '%d', '%s', '%s', '%s', '%s', '%s', '%s')
    );

    // Check if booking insertion was successful
    if ($insert_booking) {
        $booking_id = $wpdb->insert_id;

        // Insert payment data into `wp_teetime_payment` table
        $payment_data = array(
            'booking_id' => $booking_id,
            'payment_type' => "Cash", 
            'amount' => $total_amount,
            'Creationtime' => $current_time,
            'updatetime' => $current_time
        );

        $insert_payment = $wpdb->insert(
            $wpdb->prefix . 'teetime_payment',
            $payment_data,
            array('%d', '%s', '%f', '%s', '%s')
        );

        if ($insert_payment) {
            // Send emails to customer and admin
            send_booking_confirmation_email($booking_id,$email, $name, $date, $time_slot, $location, $accompany, $total_amount);
            send_admin_notification_email($booking_id,$name, $email, $phone, $date, $time_slot, $location, $accompany, $total_amount);

            wp_send_json_success(['message' => 'Booking and payment successfully created!']);
        } else {
            wp_send_json_error(['error' => 'Failed to record payment.']);
        }
    } else {
        wp_send_json_error(['error' => 'Failed to create booking.']);
    }

    wp_die(); // Required to terminate immediately and return a proper response
}
function send_booking_confirmation_email($booking_id, $email, $name, $date, $time_slot, $location, $accompany, $total_amount) {
    $subject = "Your Tee Time Booking is Successful!";
    $message = "
    <html>
    <head>
        <style>
            .parentdiv { 
                font-family: Arial, sans-serif; 
                color: #333; 
                text-align: center;
                background: #f6e9ff;
                padding: 15px;
                width: fit-content;
                height: fit-content;
                margin: 10px auto;
                border: 1px solid #f6e9ff;
                border-radius: 10px;
                box-shadow: 0 0 10px 2px #aa2eff69;
            }
            h2 { color: #4CAF50; }
            p { font-size: 14px; }
            .booking-details { 
                background-color: #f9f9f9;
                padding: 15px;
                border: 1px solid #ddd;
                width: fit-content;
                margin: 0 auto;
                border-radius: 10px;
            }
            ul { list-style: none; padding: 0; text-align: left !important;}
            ul li { margin-bottom: 8px; }
            .logo {
                margin-top: 20px;
            }
        </style>
    </head>
    <body>
        <div class='parentdiv'>
            <h2>Booking Confirmation (#$booking_id)</h2>
            <p>Dear {$name},</p>
            <p>Thank you for booking your tee time with us. Here are your booking details:</p>
            <div class='booking-details'>
                <ul>
                    <li><strong>Booking Id:</strong> {$booking_id}</li>
                    <li><strong>Date:</strong> {$date}</li>
                    <li><strong>Time Slot:</strong> {$time_slot}</li>
                    <li><strong>Location:</strong> {$location}</li>
                    <li><strong>Accompanying Players:</strong> {$accompany}</li>
                    <li><strong>Total Amount:</strong> {$total_amount}</li>
                </ul>
            </div>
            <p>We're looking forward to welcoming you to our golf course soon!</p>
            <p><strong>Best regards,</strong><br>The Golf Course Team</p>
            
            <!-- Add the logo below -->
            <div class='logo'>
                <img src='https://mockups.ajatus.co.in/TTP/wp-content/uploads/2024/09/TTP-Logo-MASTER.jpg' alt='Golf Course Logo' style='width:150px;'>
            </div>
        </div>
    </body>
    </html>";

    $headers = array('Content-Type: text/html; charset=UTF-8');
    wp_mail($email, $subject, $message, $headers);
}

function send_admin_notification_email($booking_id, $name, $email, $phone, $date, $time_slot, $location, $accompany, $total_amount) {
    $admin_email = get_option('admin_email');
    $subject = "New Tee Time Booking Received";
    $message = "
    <html>
    <head>
        <style>
            .parentdiv { 
                font-family: Arial, sans-serif; 
                color: #333; 
                text-align: center;
                background: #f6e9ff;
                padding: 15px;
                width: fit-content;
                height: fit-content;
                margin: 10px auto;
                border: 1px solid #f6e9ff;
                border-radius: 10px;
                box-shadow: 0 0 10px 2px #aa2eff69;
            }
            h2 { color: #4CAF50; }
            p { font-size: 14px; }
            .booking-details { 
                background-color: #f9f9f9;
                padding: 15px;
                border: 1px solid #ddd;
                width: fit-content;
                margin: 0 auto;
                border-radius: 10px;
            }
            ul { list-style: none; padding: 0; }
            ul li { margin-bottom: 8px; }
            .logo {
                margin-top: 20px;
            }
        </style>
    </head>
    <body>
        <div class='parentdiv'>
            <h2>New Tee Time Booking-#$booking_id</h2>
            <p>A new tee time booking has been made with the following details:</p>
            <div class='booking-details'>
                <ul>
                    <li><strong>Booking Id:</strong> {$booking_id}</li>
                    <li><strong>Name:</strong> {$name}</li>
                    <li><strong>Email:</strong> {$email}</li>
                    <li><strong>Phone:</strong> {$phone}</li>
                    <li><strong>Date:</strong> {$date}</li>
                    <li><strong>Time Slot:</strong> {$time_slot}</li>
                    <li><strong>Location:</strong> {$location}</li>
                    <li><strong>Accompanying Players:</strong> {$accompany}</li>
                    <li><strong>Total Amount:</strong> {$total_amount}</li>
                </ul>
            </div>
            <p><strong>Please check the booking details in your dashboard.</strong></p>
            <!-- Add the logo below -->
            <div class='logo'>
                <img src='https://mockups.ajatus.co.in/TTP/wp-content/uploads/2024/09/TTP-Logo-MASTER.jpg' alt='Golf Course Logo' style='width:150px;'>
            </div>
        </div>
    </body>
    </html>";

    $headers = array('Content-Type: text/html; charset=UTF-8');
    wp_mail($admin_email, $subject, $message, $headers);
}


// function enqueue_jquery() {
//     wp_enqueue_script('jquery');
// }
// add_action('wp_enqueue_scripts', 'enqueue_jquery');
