<?php
get_header(); // Include the header

if (have_posts()) :
    while (have_posts()) : the_post(); ?>
<style>
    .golf_club-container {
        display: flex;
        margin-top: 20px;
    }
    .golf_club-image img {
        max-width: 100%;
        height: 80%;
    }

    .golf_club-details {
        padding-left: 20px;
    }

    .golf_club-description {
        margin: 20px 0;
    }

    .golf_club-meta {
        display: flex;
        gap: 20px;
        margin-top: 10px;
    }
    .golf_club-meta p{
        margin:0;
    }
    .golf_club-booknow-btn {
        display: inline-block;
        margin-top: 20px;
        padding: 10px 20px;
        background-color: #28a745;
        color: #fff;
        text-decoration: none;
        border-radius: 5px;
    }

    .golf_club-booknow-btn:hover {
        background-color: #218838;
    }
</style>

<div class="golf_club-container" style="display: flex; margin: 5% auto;width:90%;">
    <!-- Featured Image (Left) -->
    <div class="golf_club-image" style="flex: 0 0 45%;">
        <?php if (has_post_thumbnail()) : ?>
            <img src="<?php the_post_thumbnail_url('large'); ?>" alt="<?php the_title(); ?>">
        <?php endif; ?>
    </div>

    <!-- Event Details (Right) -->
    <div class="golf_club-details" style="flex: 0 0 55%; padding-left: 20px;">
        <h1><?php the_title(); ?></h1>

        <!-- Description -->
        <div class="golf_club-description">
            <?php the_content(); ?>
        </div>

        <!-- Price Per Player and Capacity Per Slot in One Line -->
        <div class="golf_club-meta">
            <!-- <p><strong><?php _e('Price Per Player:', 'teetime'); ?></strong> $<?php echo get_post_meta(get_the_ID(), '_golf_club_price_per_player', true); ?></p> -->
            <p><strong><?php _e('Capacity:', 'teetime'); ?></strong> <?php echo esc_html(get_post_meta(get_the_ID(), '_golf_club_capacity', true)); ?> players</p>
        </div>

        <!-- Start and End Time in One Line -->
        <div class="golf_club-meta">
            <p><strong><?php _e('Time:', 'teetime'); ?></strong> 
                <?php 
                $start_time = esc_html(get_post_meta(get_the_ID(), '_golf_club_start_time', true)); 
                $end_time = esc_html(get_post_meta(get_the_ID(), '_golf_club_end_time', true)); 
                echo $start_time . ' - ' . $end_time; 
                ?>
            </p>
             <!-- Duration Between Slots -->
             <p><strong><?php _e('Duration Between Slots:', 'teetime'); ?></strong> 
            <?php echo esc_html(get_post_meta(get_the_ID(), '_golf_club_duration', true)); ?> minutes</p>

        </div>

        <!-- Book Now Button -->
        <a href="<?php echo home_url('/book-now/'); ?>?event_id=<?php echo get_the_ID(); ?>" class="golf_club-booknow-btn">
            <?php _e('Book Now', 'teetime'); ?>
        </a>
    </div>
</div>

<?php endwhile;
endif;

get_footer();
