<?php
// Add Shortcode for the newsletter form
function thsn_newsletter_shortcode() {
    ob_start();
    ?>
    <style>
        .thsn-footer-boxes-cont {
            width: 100%;
            display: flex;
            flex-wrap: wrap; /* Allow wrapping for smaller screens */
            justify-content: space-between;
            align-items: center;
            margin: 0 auto; /* Center the content */
        }
        .thsn-footer-boxes {
            flex: 0 0 50%; /* Default to full width */
            /* max-width: 500px; Limit maximum width */
            margin-bottom: 20px; /* Add space between boxes */
        }
        h3.thsn-news-title {
            color: #fff;
            font-family: Amiri, sans-serif;
            font-weight: 500;
            position: relative;
            padding-left: 70px;
            font-size: 30px;
            line-height: 40px;
        }
        .thsn-news-title {
            display: flex;
            justify-content: left;
            align-items: center;
        }
        .thsn-footer-newslatter {
            width: 100%;
            display: flex;
            justify-content: left;
            align-items: center;
        }
        .thsn-footer-newslatter input[type="email"] {
            padding: 22px 180px 20px 20px;
            /* margin-bottom: 20px; */
            font-weight: 400;
            width: 100%;
            background-color: #fff;
            font-size: 16px;
            box-sizing: border-box; /* Include padding in width */
        }
        .thsn-footer-newslatter button {
            background-color: #ffd763;
            color: #fff;
            padding: 17px 40px;
            height: 69px;
            display: inline-block;
            font-weight: 700;
            text-decoration: none !important;
            letter-spacing: 1px;
            font-size: 14px;
        }
        .thsn-footer-boxes-cont:after {
            content: "";
            width: 100%;
            height: 1px;
            position: absolute;
            bottom: 0;
            left: 0;
            background-color: rgba(255, 255, 255, .15);
        }

        /* Media Queries for Responsive Design */
        @media (max-width: 768px) {
            .thsn-footer-boxes {
                flex: 0 0 100%; /* Take full width */
                max-width: 100%; /* Remove max-width on small screens */
            }
            h3.thsn-news-title {
                font-size: 24px; /* Adjust font size for smaller screens */
            }
        }

        @media (max-width: 480px) {
            .thsn-footer-boxes-cont {
                width: 100%;
                display: inline;
                flex-wrap: wrap; /* Allow wrapping for smaller screens */
                justify-content: space-between;
                align-items: center;
                margin: 0 auto; /* Center the content */
            }
            .thsn-footer-newslatter {
                width: 100%;
                display: flex;
                justify-content: left;
                align-items: center;
                flex-direction: column;
            }
            h3.thsn-news-title {
                font-size: 20px;
                padding: 0 !important; /* Further adjust font size */
            }
            .thsn-footer-newslatter input[type="email"] {
                padding: 16px; /* Reduce padding on very small screens */
                margin-bottom: 10px;
            }
            .thsn-footer-newslatter button {
                padding: 15px 30px; /* Adjust button padding */
            }
        }
    </style>
    <div class="row thsn-footer-boxes-cont align-items-center">
        <div class="thsn-footer-boxes thsn-footer-boxes-1 col-md-6">
            <h3 class="thsn-news-title">
                <i class="fas fa-newspaper" style="color: #d5b665; font-size: 50px; margin-right: 10px;"></i>
                Sign Up to get Latest Updates
            </h3>
        </div>
        <div class="thsn-footer-boxes thsn-footer-boxes-2 col-md-6">
            <form id="mc4wp-form-1" class="mc4wp-form mc4wp-form-14276" method="post" data-id="14276" data-name="Newsletter Form">
                <div class="mc4wp-form-fields">
                    <div class="thsn-footer-newslatter">
                        <input type="email" name="EMAIL" placeholder="Your email address" required="">
                        <button type="submit" value="Sign up">SUBSCRIBE NOW</button>
                    </div>
                </div>
                <!-- <label style="display: none !important;">Leave this field empty if you're human: 
                    <input type="text" name="_mc4wp_honeypot" value="" tabindex="-1" autocomplete="off">
                </label>
                <input type="hidden" name="_mc4wp_timestamp" value="1727668203">
                <input type="hidden" name="_mc4wp_form_id" value="14276">
                <input type="hidden" name="_mc4wp_form_element_id" value="mc4wp-form-1">
                <div class="mc4wp-response"></div> -->
            </form>
        </div>
        <br>
    </div>
    <?php
    return ob_get_clean();
}

// Add Shortcode for the contact widget
function thsn_contact_widget_shortcode() {
    ob_start();
    ?>
    <style>
        .thsn-contact-widget-line{
            display: flex;
            justify-content: flex-start;
            align-items: center;
        }
        .thsn-contact-widget-line i{
            flex: 0 0 12%;
        }
        .thsn-contact-widget-line a{
            font-family: "Source Sans Pro", sans-serif;
            font-weight: normal;
            font-size: 14px;
            line-height: 2;
            color: #fff;
            text-transform: none;
            font-style: normal;
        }
        .thsn-contact-widget-line a:hover{
            color:#d5b665;
            text-decoration: none !important;
        }
        .thsn-contact-widget-lines:after {
            content: "";
            position: absolute;
            width: 1px;
            height: 100%;
            right: 0;
            top: 0;
            background-color: rgba(255, 255, 255, .15);
        }
        @media (max-width: 1020px) {
            .thsn-contact-widget-lines:after{
                display: none;
            }
            .thsn-contact-widget-lines{
                margin-left: 35%;
            }
        }
        
        @media (max-width: 480px) {
            .thsn-contact-widget-lines:after{
                display: none;
            }
            .thsn-contact-widget-lines{
                margin-left: 25%;
            }
        }
    </style>
    <div class="thsn-contact-widget-lines"><br>
        <div class="thsn-contact-widget-line thsn-contact-widget-address">
            <i class="fas fa-map-marker-alt" style="color: #d5b665; margin-right: 8px; font-size:32px;"></i>
            <a> Our Location<br>
            Phuket, Thailand</a>
        </div><br>
        <div class="thsn-contact-widget-line thsn-contact-widget-email">
            <i class="fas fa-envelope" style="color: #d5b665; margin-right: 8px; font-size:32px;"></i>
            <a>Email Address<br>
            andrew@lotusagency.asia</a>
        </div><br>
        <div class="thsn-contact-widget-line thsn-contact-widget-phone">
            <i class="fas fa-phone" style="color: #d5b665; margin-right: 8px; font-size:32px;"></i>
            <a>Phone Number<br>
               123-4506-0987</a>
        </div>
    </div>
    <?php
    return ob_get_clean();
}

// Register the shortcode
add_shortcode('thsn_contact_widget', 'thsn_contact_widget_shortcode');

// Add Shortcode for the services menu
function thsn_services_menu_shortcode() {
    ob_start();
    ?>
    <style>
        .menu-services-menu-container .row {
            width: 100%;
            display: flex;
            justify-content: space-evenly;
            align-items: flex-start;
        }
        .menu-services-menu-container {
            margin: 30px auto 0;
        }
        .menu-services-menu-container li {
            font-family: "Source Sans Pro", sans-serif;
            font-weight: normal;
            font-size: 14px;
            color: #fff;
            text-transform: none;
            font-style: normal;
            list-style: none !important;
            line-height: 2.4;
        }
        .menu-services-menu-container a {
            color: #fff; /* Ensure links inherit the text color */
            text-decoration: none; /* Optional: Remove underline from links */
        }
        .menu-services-menu-container a:hover {
            color: #d5b665; /* Ensure links inherit the text color */
            text-decoration: none; /* Optional: Add underline on hover */
        }
    </style>
    <div class="menu-services-menu-container">
        <div class="row">
            <div class="col-md-6">
                <ul id="menu-services-menu" class="menu">
                    <li id="menu-item-14770" class="menu-item menu-item-type-custom menu-item-object-custom menu-item-14770"><a href="#">Course Flyover</a></li>
                    <li id="menu-item-14771" class="menu-item menu-item-type-custom menu-item-object-custom menu-item-14771"><a href="#">Scorecard</a></li>
                    <li id="menu-item-14777" class="menu-item menu-item-type-custom menu-item-object-custom menu-item-14777"><a href="#">Events</a></li>
<!--                     <li id="menu-item-14772" class="menu-item menu-item-type-custom menu-item-object-custom menu-item-14772"><a href="#">Copa Card</a></li>
                    <li id="menu-item-14778" class="menu-item menu-item-type-custom menu-item-object-custom menu-item-14778"><a href="#">Group Golf Events</a></li> -->
                </ul>
            </div>
            <div class="col-md-6">
                <ul id="menu-services-menu" class="menu">
                    <li id="menu-item-14773" class="menu-item menu-item-type-custom menu-item-object-custom menu-item-14773"><a href="#">Links</a></li>
					<li id="menu-item-14774" class="menu-item menu-item-type-custom menu-item-object-custom menu-item-14774"><a href="#">Membership</a></li>
                    <li id="menu-item-14776" class="menu-item menu-item-type-custom menu-item-object-custom menu-item-14776"><a href="https://mockups.ajatus.co.in/TTP/pdpa-compliance-guidelines-and-consent-form-for-tee-time-pro/">PDPA Compliance Guidelines</a></li>					
<!--                     <li id="menu-item-14779" class="menu-item menu-item-type-custom menu-item-object-custom menu-item-14779"><a href="#">2020 Saguaro</a></li>
                    <li id="menu-item-14775" class="menu-item menu-item-type-custom menu-item-object-custom menu-item-14775"><a href="#">Weddings</a></li>
                    <li id="menu-item-14780" class="menu-item menu-item-type-custom menu-item-object-custom menu-item-14780"><a href="#">Weddings &amp; Events</a></li> -->
                </ul>
            </div>
        </div>
    </div>
    <?php
    return ob_get_clean();
}

// Register the shortcode
add_shortcode('thsn_services_menu', 'thsn_services_menu_shortcode');

?>
