import workflowImg from "@assets/Screenshot 2025-10-17 154654.png";
import { CheckCircle2 } from "lucide-react";

const capabilities = [
  "Predictive Analysis - Leverage machine learning to anticipate customer needs and optimize workflows",
  "Discover - What We Launched: Explore new automation solutions tailored for insurers",
  "Scale - Extend beyond basic automation to scale processes across the enterprise",
  "Configure - Flexible setup and configuration to match your unique business requirements",
  "Design - Intuitive design tools and templates that speed up deployment",
  "SME - Business user-friendly, empowering subject matter experts to drive automation",
  "Business-Specific Knowledge Router - Domain insights fuel for models built exactly for your industry"
];

export default function WhyNeutrinos() {
  return (
    <section className="py-16 md:py-24">
      <div className="container mx-auto px-4 md:px-8">
        <div className="text-center mb-12">
          <h2 className="text-3xl md:text-4xl lg:text-5xl font-bold tracking-tight mb-4">
            Why Neutrinos?
          </h2>
          <p className="text-lg md:text-xl text-muted-foreground max-w-3xl mx-auto">
            The Neutrinos Library Framework powers intelligent automation across your enterprise
          </p>
        </div>

        <div className="grid md:grid-cols-2 gap-12 items-center">
          <div className="relative h-[300px] md:h-[350px]">
            <img
              src={workflowImg}
              alt="Neutrinos Library Framework"
              className="w-full h-full object-contain rounded-lg"
              data-testid="img-framework"
            />
          </div>

          <div className="space-y-4">
            {capabilities.map((capability, index) => {
              const [title, description] = capability.split(' - ');
              return (
                <div key={index} className="flex gap-3" data-testid={`capability-${index}`}>
                  <CheckCircle2 className="h-6 w-6 text-chart-3 flex-shrink-0 mt-0.5" />
                  <div>
                    <span className="font-semibold">{title}</span>
                    {description && <span className="text-muted-foreground"> - {description}</span>}
                  </div>
                </div>
              );
            })}
          </div>
        </div>
      </div>
    </section>
  );
}
