const metrics = [
  { value: "500+", label: "professionals as employees" },
  { value: "15+", label: "countries served" },
  { value: "25+", label: "enterprise insurers and banks" },
  { value: "120+", label: "prebuilt insurance accelerators" }
];

export default function MetricsSection() {
  return (
    <section className="py-8 md:py-12 bg-card">
      <div className="container mx-auto px-4 md:px-8">
        <div className="text-center mb-12">
          <h2 className="text-3xl md:text-4xl lg:text-5xl font-bold tracking-tight mb-4">
            Trusted Globally
          </h2>
          <p className="text-lg md:text-xl text-muted-foreground max-w-3xl mx-auto">
            Leading the insurance automation revolution across the world
          </p>
        </div>

        <div className="grid grid-cols-2 md:grid-cols-4 gap-8 max-w-5xl mx-auto">
          {metrics.map((metric, index) => (
            <div key={index} className="text-center space-y-2">
              <div className="text-4xl md:text-5xl lg:text-6xl font-bold text-primary" data-testid={`text-metric-${index}`}>
                {metric.value}
              </div>
              <div className="text-sm md:text-base text-muted-foreground" data-testid={`text-label-${index}`}>
                {metric.label}
              </div>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
}
