import { Card, CardContent } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Zap, Link2, Sparkles, ArrowRight } from "lucide-react";

const features = [
  {
    icon: Zap,
    title: "Accelerate",
    subtitle: "Automate complex processes",
    description: "Speed business agility, fast-track digital initiatives, and accelerate time-to-market & revenue. Automate complex processes like underwriting, claims, and more.",
  },
  {
    icon: Link2,
    title: "Integrate",
    subtitle: "Eliminate silos and unify your technology",
    description: "Connect your ecosystem technology landscape across core systems, data sources, and third party tools. Unify data across the insurance value chain.",
  },
  {
    icon: Sparkles,
    title: "Innovate",
    subtitle: "Rapidly prototype and deploy",
    description: "Empower business users to launch products faster and deliver modern experiences, at the speed you want. Test and deploy new automations quickly.",
  },
];

export default function FeaturesSection() {
  return (
    <section className="py-16 md:py-24 bg-card">
      <div className="container mx-auto px-4 md:px-8">
        <div className="text-center mb-12">
          <h2 className="text-3xl md:text-4xl lg:text-5xl font-bold tracking-tight mb-4">
            Key Features of Our Platform
          </h2>
          <p className="text-lg md:text-xl text-muted-foreground max-w-3xl mx-auto">
            An intelligent automation platform that's built to transform your insurance operations
          </p>
        </div>

        <div className="grid md:grid-cols-3 gap-8">
          {features.map((feature, index) => (
            <Card key={index} className="hover-elevate" data-testid={`card-feature-${index}`}>
              <CardContent className="p-6 space-y-4">
                <div className="w-12 h-12 rounded-lg bg-primary/10 flex items-center justify-center">
                  <feature.icon className="h-6 w-6 text-primary" />
                </div>
                <h3 className="text-2xl font-semibold">{feature.title}</h3>
                <p className="text-sm font-medium text-muted-foreground">{feature.subtitle}</p>
                <p className="text-muted-foreground leading-relaxed">{feature.description}</p>
                <Button variant="ghost" className="gap-2 px-0" data-testid={`button-learn-${index}`}>
                  Learn more <ArrowRight className="h-4 w-4" />
                </Button>
              </CardContent>
            </Card>
          ))}
        </div>
      </div>
    </section>
  );
}
