<?php get_header(); global $post; ?>
<section class="single-page-sec">
   <div class="container">
      <div class="row">
         <div class="col-lg-3">
            <aside class="widget widget-author">
               <h5 class="widget-title">About The Author</h5>
               <div class="author-deatils">
                  <?php
                     $author_id=$post->post_author;
                     //echo get_avatar(get_the_author_meta($author_id));
                     $user_info = get_userdata($author_id);
                     ?>
                  <div class="author-img"><img src="<?php echo esc_url( get_avatar_url( $author_id,['size' => '300'] ) ); ?>" class="img-fluid"></div>
                  <div class="author-title">
                     <h4><?php echo $user_info->first_name .  " " . $user_info->last_name; ?></h4>
                     <span>(<?php echo date('d/m/Y',strtotime(get_user_meta($author_id,'dob',true))); ?>)</span>
                  </div>
                  <div class="author-desc">
                     <p><?php echo wp_trim_words($user_info->description,20,'...'); ?><a href="<?php echo get_author_posts_url($author_id); ?>">Read More</a></p>
                  </div>
               </div>
            </aside>
            <aside class="widget widget-feature-sec">
               <h5 class="widget-title">You May also Like:</h5>
               <div class="feature-sec-container">

               <?php 
               $blogusers = get_users( array( 'role__in' => array( 'author' ) ) );
               foreach ( $blogusers as $user ) {

                 // print_r($user);
               ?>
                  <div class="feature-sec-item">
                     <div class="feature-sec-img">
                        <img src="<?php echo esc_url( get_avatar_url( $user->id,['size' => '300'] ) ); ?>" class="img-fluid">
                     </div>
                     <div class="feature-sec-desc">
                        <h4><a href="<?php echo get_author_posts_url($user->id); ?>"><?php echo $user->display_name; ?></a></h4>
                        <ul>
                           <li><i class="fa fa-star" aria-hidden="true"></i></li>
                           <li><i class="fa fa-star" aria-hidden="true"></i></li>
                           <li><i class="fa fa-star" aria-hidden="true"></i></li>
                           <li><i class="fa fa-star" aria-hidden="true"></i></li>
                           <li><i class="fa fa-star-half-o" aria-hidden="true"></i></li>
                        </ul>
                     </div>
                  </div>
               <?php } ?> 
               </div>
            </aside>
         </div>
         <div class="col-lg-6">
            <article class="audio-post">
               <div class="row audio-post-row-sec">
                  <div class="col-lg-6">
                     <div class="audio-post-thumb">
                        <?php the_post_thumbnail('full',array('class' => 'img-fluid')); ?>
                     </div>
                  </div>
                  <div class="col-lg-6">
                     <div class="library-btn hvr-bounce-to-right"> Add to Library <i class="fa fa-bookmark-o" aria-hidden="true"></i></div>
                     <div class="library-btn hvr-bounce-to-right"> Read <i class="fa fa-file-text-o" aria-hidden="true"></i></div>
                     <div class="library-btn audio-post-audio-btn embed-responsive embed-responsive-4by3">
                        <audio controls controlsList="nodownload" class="embed-responsive-item">
                           <source src="<?php echo get_post_meta($post->ID,'bookaudio',true);?>" type="audio/mpeg">
                        </audio>
                     </div>
                  </div>
               </div>
               <h3 class="audio-post-meta-title"><?php the_title();?><span>Year of Publication : <?php echo get_post_meta($post->ID,'publication',true);?></span></h3>
               <div class="audio-post-meta-sec">
                  <ul class="audio-post-meta-info">
                     <li class="audio-post-reads"><i class="fa fa-book"></i>2500 Reads</li>
                     <li class="audio-post-share"><i class="fa fa-share-square-o" aria-hidden="true"></i>Share: 1.1k</li>
                  </ul>
                  <ul class="audio-post-autor-info">
                     <?php 
                        $recent_author = get_user_by( 'ID', $post->post_author );
                        ?>
                     <li class="audio-post-by"><i class="fa fa-user"></i> By: <a href="<?php echo get_author_posts_url( $post->post_author ); ?>"><?php echo $recent_author->display_name; ?></a></li>
                     <li class="audio-post-rating">Rating: <i class="fa fa-star" aria-hidden="true"></i><i class="fa fa-star" aria-hidden="true"></i><i class="fa fa-star" aria-hidden="true"></i><i class="fa fa-star" aria-hidden="true"></i><i class="fa fa-star" aria-hidden="true"></i></li>
                  </ul>
               </div>
               <div class="audio-post-content">
                  <?php the_content();?>
               </div>
               <div class="audio-post-tag-share">
                  <div class="row">
                     <div class="col-md-6">
                        <h5>Like It? Share with Your Friends</h5>
                     </div>
                     <div class="col-md-6">
                        <ul class="audio-post-share-icon text-center text-md-right">
                           <li><a href="#"  target="_blank"><i class="fa fa-twitter"></i></a></a></li>
                           <li><a href="#"  target="_blank"><i class="fa fa-whatsapp" aria-hidden="true"></i></a></li>
                           <li> <a href="#"  target="_blank"><i class="fa fa-facebook-f"></i></a></li>
                           <li>  <a href="#"  target="_blank"><i class="fa fa-instagram"></i></a></li>
                           <li>  <a href="#"  target="_blank"><i class="fa fa-link" aria-hidden="true"></i></a></li>
                        </ul>
                     </div>
                  </div>
               </div>
               
               <div class="row">
                  <div class="col-lg-12">
                     <div class="audio-comments-area">
                     <?php comments_template(); ?> 
                     </div>
                  </div>
               </div>
            </article>
         </div>
         <div class="col-lg-3">
            <aside class="widget widget-sponsor">
               <h5 class="widget-title">Sponsor</h5>
               <div class="sponsor-item-sec">
                <?php
                $term_list = wp_get_post_terms( $post->ID, 'sponsors', array( 'fields' => 'all' ) );
                //print_r( $term_list );
                 
                 foreach($term_list as $term) {
                  $term_link = get_term_link( $term );
                ?>
                  <div class="sponsor-item">
                     <a href="<?php echo $term_link; ?>"><?php echo $term->name; ?></a>
                     <p><?php echo $term->description; ?></p>
                  </div>
                 <?php } ?>
               </div>
            </aside>
            <aside class="widget widget-tag">
               <h5 class="widget-title">Tags</h5>
               <ul class="tags">
               <?php
               $tag_list = wp_get_post_terms( $post->ID, 'book-tag', array( 'fields' => 'all' ) );
                  
                 foreach($tag_list as $tags) {
                  $term_links = get_term_link( $tags );
                ?>
                  <li><a href="<?php echo $term_links; ?>"><?php echo $tags->name; ?></a></li>
               <?php } ?>
               </ul>
            </aside>
            <aside class="widget widget-vocabulary">
               <h5 class="widget-title">Vocabulary guide</h5>
               <ul>
                  <li><a href="#">Genitive <i class="fa fa-long-arrow-right"></i></a></li>
                  <li><a href="#">Word Order <i class="fa fa-long-arrow-right"></i></a></li>
                  <li><a href="#">Pronounce <i class="fa fa-long-arrow-right"></i></a></li>
                  <li><a href="#">Singular & Plural <i class="fa fa-long-arrow-right"></i></a></li>
                  <li><a href="#">Compounds<i class="fa fa-long-arrow-right"></i></a></li>
                  <li><a href="#">Preposition<i class="fa fa-long-arrow-right"></i></a></li>
                  <li><a href="#">Punctuation<i class="fa fa-long-arrow-right"></i></a></li>
                  <li><a href="#">Split Infinitive<i class="fa fa-long-arrow-right"></i></a></li>
               </ul>
            </aside>
         </div>
      </div>
   </div>
</section>
<?php get_footer();?>