<?php get_header(); ?>
<section class="cat-sec">
         <div class="container">

         <?php
           
            
            $terms = get_terms( array(
                'taxonomy' => 'book-category',
                'hide_empty' => true,
                'orderby' => 'name'
            ) );

            foreach($terms as $term) {
                $termlink = get_term_link($term);
         ?>
            <div class="row" style="margin-bottom:50px;">
               <div class="col-lg-12">
                  <div class="innere-heading-sec">
                     <h2><?php echo $term->name; ?></h2>
                  </div>
                  <a href="<?php echo $termlink; ?>" class="hvr-bounce-to-right cat-btn">View More</a>
               </div>
               <div class="owl-carousel audio-book-carousel">
               <?php 
                     $args = array(
                        'posts_per_page' => -1,
                        'post_type' => 'book',
                        'order'  => 'DESC',
                        'tax_query' => array(
                         array(
                         'taxonomy' => 'book-category', 
                         'field' => 'term_id',
                         'terms' => $term->term_id
                          )
                       )
                     );						
                    $loop = new WP_Query( $args );						
                   if($loop->have_posts()) : while($loop->have_posts()) : $loop->the_post();
               ?>
                  <div class="item">
                     <div class="flip-card">
                        <div class="flip-card-inner">
                           <div class="flip-card-front">
                           <?php the_post_thumbnail('full',array('class' => 'img-fluid')); ?>
                              <div class="audio-book-title-sec">
                                 <h4><?php the_title(); ?></h4>
                              </div>
                           </div>
                           <div class="flip-card-back">
                              <div class="audio-book-hover-sec" >
                                 <div class="short-desc">
                                    <h5><?php the_title(); ?></h5>
                                    <div class="short-author"><i class="fa fa-user" aria-hidden="true"></i> <?php the_author(); ?></div>
                                    <ul>
                                       <li><i class="fa fa-star" aria-hidden="true"></i></li>
                                       <li><i class="fa fa-star" aria-hidden="true"></i></li>
                                       <li><i class="fa fa-star" aria-hidden="true"></i></li>
                                       <li><i class="fa fa-star" aria-hidden="true"></i></li>
                                       <li><i class="fa fa-star" aria-hidden="true"></i></li>
                                    </ul>
                                    <div class="description">
                                    <p><?php echo wp_trim_words( get_the_content(), 6, '...' ); ?></p>
                                       <a href="<?php the_permalink(); ?>" class="short-desc-btn">Read More</a>
                                    </div>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
                  <?php endwhile; endif; wp_reset_postdata(); ?> 
               </div>
               <a href="<?php echo $termlink; ?>" class="hvr-bounce-to-right mobile-search-sec cat-btn">View More</a>
            </div>
         <?php } ?> 
         </div>
      </section>
      
<?php get_footer(); ?>