<?php

function ajatus_posttype() {

register_post_type( 'book',
array(
  'labels' => array(
   'name' => __( 'Book' ),
   'singular_name' => __( 'Book' ),
  ),
  'rewrite' => array('slug' => 'book'),
  'supports'            => array( 'title', 'editor','comments', 'thumbnail','author' ),
  'hierarchical'        => false,
  'public'              => true,
  'show_ui'             => true,
  'show_in_menu'        => true,
  'show_in_nav_menus'   => true,
  'show_in_admin_bar'   => true,
  'menu_position'       => 5,
  'can_export'          => true,
  'has_archive'         => true,
  'exclude_from_search' => false,
  'publicly_queryable'  => true,
  'capability_type'     => 'post',
  'show_in_rest' => true,
  'menu_icon'           => 'dashicons-book-alt'
 )
);
register_taxonomy(
        'book-category',
        'book',
        array(
            'label' => __( 'Category' ),
            'public' => true,
            'rewrite' => true,
            'show_ui' => true,
            'show_in_rest' => true,
            'show_admin_column' => true,
            'query_var' => true,
            'hierarchical' => true,
        )
    );

    

    register_taxonomy(
      'sponsors',
      'book',
      array(
          'labels' => array(
            'name' => _x( 'Sponsors', 'taxonomy general name' ),
            'singular_name' => _x( 'Sponsors', 'taxonomy singular name' ),
            'search_items' =>  __( 'Search Sponsors' ),
            'all_items' => __( 'All Sponsors' ),
            'parent_item' => __( 'Parent Sponsor' ),
            'parent_item_colon' => __( 'Parent Sponsor:' ),
            'edit_item' => __( 'Edit Sponsor' ), 
            'update_item' => __( 'Update Sponsor' ),
            'add_new_item' => __( 'Add New Sponsor' ),
            'new_item_name' => __( 'New Sponsor Name' ),
            'menu_name' => __( 'Sponsors' ),
          ),
          'public' => true,
          'rewrite' => true,
          'show_ui' => true,
          'show_in_rest' => true,
          'show_admin_column' => true,
          'query_var' => true,
          'hierarchical' => true,
      )
  );

  register_taxonomy(
    'book-tag',
    'book',
    array(
        'label' => __( 'Tags' ),
        'public' => true,
        'rewrite' => true,
        'show_ui' => true,
        'show_in_rest' => true,
        'show_admin_column' => true,
        'query_var' => true,
        'hierarchical' => false,
    )
);
  //flush_rewrite_rules();

  }
 
add_action( 'init', 'ajatus_posttype' );



?>