<?php
add_action('admin_enqueue_scripts', 'my_admin_scripts');

function my_admin_scripts() {
    
        wp_enqueue_media();
        wp_register_script('my-admin-js', get_stylesheet_directory_uri().'/assets/js/media-upload.js', array('jquery'));
        wp_enqueue_script('my-admin-js');
   
}

add_action( 'add_meta_boxes', 'cd_meta_box_add' );
function cd_meta_box_add()
{
	add_meta_box( 'my-meta-box-id', 'Information', 'cd_meta_box_cb', 'book', 'normal', 'high' );
}

function cd_meta_box_cb( $post )
{
	$values = get_post_custom( $post->ID );
	$text = isset( $values['bookaudio'] ) ? esc_attr( $values['bookaudio'][0] ) : '';
	$publication = isset( $values['publication'] ) ? esc_attr( $values['publication'][0] ) : '';
	
	wp_nonce_field( 'my_meta_box_nonce', 'meta_box_nonce' );
	?>
	<p style="border: 4px dashed #999;padding: 10px;text-align: center;">
		
		<input type="hidden" name="bookaudio" id="bookaudio" value="<?php echo $text; ?>" />
        <?php if($text) { ?>
        <audio controls controlsList="nodownload"><source src="<?php echo $text; ?>" type="audio/mpeg"></audio><br><br>
        <?php } ?>
        <input type="button" id="frontend-button" class="button button-primary button-large" value="Upload MP3"><span id="showa" style="color: #2fbb16; text-transform: uppercase;padding: 9px 12px;margin-left: 10px;"></span>
	</p>

	<p>
	   <label for="publication">Year of Publication</label><br>
	   <input type="number" name="publication" id="publication" value="<?php echo $publication; ?>" class="regular-text" placeholder="Ex - 1985" >
	</p>
	
	
	<?php	
}


add_action( 'save_post', 'cd_meta_box_save' );
function cd_meta_box_save( $post_id )
{
	// Bail if we're doing an auto save
	if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
	
	// if our nonce isn't there, or we can't verify it, bail
	if( !isset( $_POST['meta_box_nonce'] ) || !wp_verify_nonce( $_POST['meta_box_nonce'], 'my_meta_box_nonce' ) ) return;
	
	// if our current user can't edit this post, bail
	if( !current_user_can( 'edit_post' ) ) return;
	
	
	// Probably a good idea to make sure your data is set
	if( isset( $_POST['bookaudio'] ) )
		update_post_meta( $post_id, 'bookaudio', esc_attr( $_POST['bookaudio'] ) );

		if( isset( $_POST['publication'] ) )
		update_post_meta( $post_id, 'publication', esc_attr( $_POST['publication'] ) );
		
	
}
?>
