<?php

add_action('after_setup_theme','mythemesetup');
function mythemesetup() {
    register_nav_menus(
        array(
          'primary-menu' => __( 'Priafmary Menu' ),
          'footer-menu' => __( 'Footer Menu' )
        )
      );
       add_theme_support('post-thumbnails');
       add_theme_support( 'post-formats' );
    }

require get_template_directory().'/inc/post-type.php';
require get_template_directory().'/inc/metabox.php';
require get_template_directory().'/inc/restapi.php';

function custom_login_logo() {
	echo '<style type="text/css">
	h1 a { background-image: url('.get_bloginfo('template_directory').'/assets/img/logo.png) !important; background-size: 100% !important; height:59px !important; width:185px !important; }
    body {
        background-image: url('.get_bloginfo('template_directory').'/assets/img/loginbg.jpg);
        background-repeat: no-repeat;
        background-position: center;
        background-size: cover;
        background-attachment: fixed;
    }
    .login #nav {
        margin: 0 0 0 0 !important;
        background: #000 !important;
        padding: 10px;
    }
   .login #nav a {
      text-decoration: none;
      color: #000 !important;
  }
  .login #backtoblog a, .login #nav a {
   text-decoration: none;
   color: #fff !important;
}
#login {
    width: 500px !important;
    padding: 8% 0 0;
    margin: auto;
}
	</style>';
}
add_action('login_head', 'custom_login_logo');

function remove_core_updates(){
    global $wp_version;return(object) array('last_checked'=> time(),'version_checked'=> $wp_version,);
    }
    add_filter('pre_site_transient_update_core','remove_core_updates');
    add_filter('pre_site_transient_update_plugins','remove_core_updates');
    add_filter('pre_site_transient_update_themes','remove_core_updates');

add_action( 'register_form', 'myplugin_register_form' );
function myplugin_register_form() {

$first_name = ( ! empty( $_POST['first_name'] ) ) ? trim( $_POST['first_name'] ) : '';
$last_name = ( ! empty( $_POST['last_name'] ) ) ? trim( $_POST['last_name'] ) : '';
$phone = ( ! empty( $_POST['phone'] ) ) ? trim( $_POST['phone'] ) : '';
$dob = ( ! empty( $_POST['dob'] ) ) ? trim( $_POST['dob'] ) : '';
?>
<p>
<label for="first_name"><?php _e( 'First Name', 'mydomain' ) ?><br />
<input type="text" name="first_name" id="first_name" class="input" value="<?php echo esc_attr( wp_unslash( $first_name ) ); ?>" size="25" /></label>
</p>

<p>
<label for="last_name"><?php _e( 'Last Name', 'mydomain' ) ?><br />
<input type="text" name="last_name" id="last_name" class="input" value="<?php echo esc_attr( wp_unslash( $last_name ) ); ?>" size="25" /></label>
</p>

<p>
<label for="phone"><?php _e( 'Phone Number', 'mydomain' ) ?><br />
<input type="text" name="phone" id="phone" class="input" value="<?php echo esc_attr( wp_unslash( $phone ) ); ?>" size="25" /></label>
</p>

<p>
<label for="dob"><?php _e( 'Date of Birth', 'mydomain' ) ?><br />
<input type="date" name="dob" id="dob" class="input" value="<?php echo esc_attr( wp_unslash( $phone ) ); ?>" size="25" /></label>
</p>
<?php }

add_filter( 'registration_errors', 'myplugin_registration_errors', 10, 3 );
function myplugin_registration_errors( $errors, $sanitized_user_login, $user_email ) {

if ( empty( $_POST['first_name'] ) || ! empty( $_POST['first_name'] ) && trim( $_POST['first_name'] ) == '' ) {
$errors->add( 'first_name_error', __( '<strong>Error</strong>: You must include a first name.', 'mydomain' ) );
}
if ( empty( $_POST['last_name'] ) || ! empty( $_POST['last_name'] ) && trim( $_POST['first_name'] ) == '' ) {
$errors->add( 'last_name_error', __( '<strong>Error</strong>: You must include a last name.', 'mydomain' ) );
}
if ( empty( $_POST['phone'] ) || ! empty( $_POST['phone'] ) && trim( $_POST['phone'] ) == '' ) {
$errors->add( 'phone_error', __( '<strong>Error</strong>: You must include a phone number.', 'mydomain' ) );
}
if ( empty( $_POST['dob'] ) || ! empty( $_POST['dob'] ) && trim( $_POST['dob'] ) == '' ) {
$errors->add( 'dob_error', __( '<strong>Error</strong>: You must include date of birth.', 'mydomain' ) );
}
return $errors;
}

add_action( 'user_register', 'myplugin_user_register' );
function myplugin_user_register( $user_id ) {
if ( ! empty( $_POST['first_name'] ) ) {
update_user_meta( $user_id, 'first_name', trim( $_POST['first_name'] ) );
update_user_meta( $user_id, 'last_name', trim( $_POST['last_name'] ) );
update_user_meta( $user_id, 'phone', trim( $_POST['phone'] ) );
update_user_meta( $user_id, 'dob', trim( $_POST['dob'] ) );
}
}

function wps_nav_authors($items, $args){
if( $args->theme_location == 'primary-menu' )
return $items . '<li class="drop-down"><a href="">Self Publication</a><ul class="sub-menu"><li>' . wp_list_authors('show_fullname=1&optioncount=0&orderby=post_count&order=DESC&number=8&echo=0&exclude=1&hide_empty=0') . '</li></ul></li>';
}
add_filter('wp_nav_menu_items','wps_nav_authors', 10, 2);

function donatelinkmenu($navs, $args){
if( $args->theme_location == 'primary-menu' ){
$url = site_url('/recite/contact-us/?reason=Donate');
return $navs . '<li class="donate"><a href="'.$url.'">Donate</a></li>';
}}
add_filter('wp_nav_menu_items','donatelinkmenu', 10, 2);


function sponsorlinkmenu($navs, $args){
if( $args->theme_location == 'primary-menu' ){
$url = site_url('/recite/contact-us/?reason=Sponsor');
return $navs . '<li class="sponsor"><a href="'.$url.'">Sponsor</a></li>';
}}
add_filter('wp_nav_menu_items','sponsorlinkmenu', 10, 2);



/* ====================================== */


add_action( 'wpcf7_init', 'custom_retreat_select' );
function custom_retreat_select() {
wpcf7_add_form_tag( 'retreat_select', 'custom_retreat_handler', array( 'name-attr' => true ) );
}

function load_fontawesome() {
wp_enqueue_style(
'font-awesome',
'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css',
array(),
'6.5.1'
);
}
add_action('wp_enqueue_scripts', 'load_fontawesome');
