<?php

require_once 'config.php';
session_start();

function is_ajax_request() {
    return (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) &&
            strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest') ||
           (isset($_SERVER['HTTP_ACCEPT']) && strpos($_SERVER['HTTP_ACCEPT'], 'application/json') !== false);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action']) && $_POST['action'] === 'check_email' && isset($_POST['email'])) {
        $checkEmail = trim($_POST['email']);
        $stmt = $pdo->prepare('SELECT COUNT(*) FROM customer_responses WHERE email = :email');
        $stmt->execute([':email' => $checkEmail]);
        $exists = (bool) $stmt->fetchColumn();
        header('Content-Type: application/json');
        echo json_encode(['exists' => $exists]);
        exit();
    }
    $name = isset($_POST['name']) ? trim($_POST['name']) : '';
    $phone = isset($_POST['phone']) ? trim($_POST['phone']) : '';
    $email = isset($_POST['email']) ? trim($_POST['email']) : '';
    $address = isset($_POST['address']) ? trim($_POST['address']) : '';
    $car_types = isset($_POST['car_types']) ? (array) $_POST['car_types'] : [];

    $errors = [];

    if ($name === '') {
        $errors[] = 'Name is required';
    } elseif (!preg_match("/^[\p{L} '-]+$/u", $name)) {
        $errors[] = 'Name may contain only letters, spaces, apostrophes and hyphens';
    }

    if ($phone === '') {
        $errors[] = 'Phone number is required';
    } elseif (!preg_match('/^[0-9]{10}$/', $phone)) {
        $errors[] = 'Please enter a valid 10-digit phone number';
    }

    if ($email === '') {
        $errors[] = 'Email is required';
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $errors[] = 'Please enter a valid email address';
    }

    if ($address === '') {
        $errors[] = 'Address is required';
    }

    if (empty($car_types)) {
        $errors[] = 'Please select at least one car type';
    }

    if (empty($errors)) {
        $stmt = $pdo->prepare('SELECT COUNT(*) FROM customer_responses WHERE email = :email');
        $stmt->execute([':email' => $email]);
        if ($stmt->fetchColumn() > 0) {
            $errors[] = 'This email has already been used';
        }

        if (!empty($errors)) {
            if (is_ajax_request()) {
                header('Content-Type: application/json');
                http_response_code(400);
                echo json_encode(['success' => false, 'errors' => $errors]);
                exit();
            } else {
                $_SESSION['errors'] = $errors;
                $_SESSION['form_data'] = $_POST;
                header('Location: index.php');
                exit();
            }
        }
        try {
            $car_types_string = implode(', ', $car_types);

            $sql = 'INSERT INTO customer_responses (name, phone, email, address, car_types) VALUES (:name, :phone, :email, :address, :car_types)';
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                ':name' => $name,
                ':phone' => $phone,
                ':email' => $email,
                ':address' => $address,
                ':car_types' => $car_types_string,
            ]);

            if (is_ajax_request()) {
                header('Content-Type: application/json');
                echo json_encode(['success' => true, 'redirect' => 'viewsubmission.php?success=1']);
            } else {
                header('Location: viewsubmission.php?success=1');
            }
            exit();

        } catch (PDOException $e) {
            $errors[] = 'Error submitting form: ' . $e->getMessage();
        }
    }

    if (!empty($errors)) {
        if (is_ajax_request()) {
            header('Content-Type: application/json');
            http_response_code(400);
            echo json_encode(['success' => false, 'errors' => $errors]);
            exit();
        } else {
            $_SESSION['errors'] = $errors;
            $_SESSION['form_data'] = $_POST;
            header('Location: index.php');
            exit();
        }
    }
}

header('Location: index.php');
exit();
?>