<?php
require_once 'config.php';
$conn = getDBConnection();

// Fetch header settings
$header = $conn->query("SELECT * FROM header_settings LIMIT 1")->fetch_assoc();

// Fetch active banners
$banners = $conn->query("SELECT * FROM banners WHERE is_active = 1 ORDER BY display_order ASC");

// Fetch most searched cars
$most_searched = $conn->query("SELECT * FROM most_searched_cars WHERE is_active = 1 ORDER BY display_order ASC LIMIT 8");

// Fetch latest cars
$latest_cars = $conn->query("SELECT * FROM latest_cars WHERE is_active = 1 ORDER BY display_order ASC LIMIT 8");

// Fetch footer settings
$footer = $conn->query("SELECT * FROM footer_settings LIMIT 1")->fetch_assoc();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $header['logo_text']; ?> - Find Your Dream Car</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <!-- Header -->
    <header class="header">
        <div class="container">
            <div class="header-content">
                <div class="logo">
                    <h1><?php echo $header['logo_text']; ?></h1>
                </div>
                <nav class="nav">
                    <ul class="nav-menu">
                        <li><a href="#home">Home</a></li>
                        <li><a href="#most-searched">Most Searched</a></li>
                        <li><a href="#latest">Latest Cars</a></li>
                        <li><a href="#contact">Contact</a></li>
                        <li><a href="admin/login.php" class="admin-link">Admin</a></li>
                    </ul>
                    <div class="hamburger">
                        <span></span>
                        <span></span>
                        <span></span>
                    </div>
                </nav>
                <div class="header-contact">
                    <i class="fas fa-phone"></i>
                    <span><?php echo $header['phone']; ?></span>
                </div>
            </div>
        </div>
    </header>

    <!-- Banner Section -->
    <section class="banner-section" id="home">
        <div class="banner-slider">
            <?php while($banner = $banners->fetch_assoc()): ?>
            <div class="banner-slide">
                <img src="<?php echo $banner['image_url']; ?>" alt="<?php echo $banner['title']; ?>">
                <div class="banner-overlay">
                    <div class="container">
                        <div class="banner-content">
                            <h2><?php echo $banner['title']; ?></h2>
                            <p><?php echo $banner['subtitle']; ?></p>
                            <?php if($banner['link_url']): ?>
                            <a href="<?php echo $banner['link_url']; ?>" class="btn btn-primary">Explore Now</a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php endwhile; ?>
        </div>
        <button class="slider-btn prev-btn"><i class="fas fa-chevron-left"></i></button>
        <button class="slider-btn next-btn"><i class="fas fa-chevron-right"></i></button>
    </section>

    <!-- Most Searched Cars Section -->
    <section class="most-searched-section" id="most-searched">
        <div class="container">
            <div class="section-header">
                <h2>Most Searched Cars</h2>
                <p>Popular cars that people are looking for</p>
            </div>
            <div class="cars-grid">
                <?php while($car = $most_searched->fetch_assoc()): ?>
                <div class="car-card">
                    <div class="car-image">
                        <img src="<?php echo $car['image_url']; ?>" alt="<?php echo $car['name']; ?>">
                    </div>
                    <div class="car-info">
                        <div class="car-brand"><?php echo $car['brand']; ?></div>
                        <h3><?php echo $car['name']; ?></h3>
                        <div class="car-price"><?php echo $car['price_range']; ?></div>
                        <div class="car-stats">
                            <span><i class="fas fa-search"></i> <?php echo $car['search_count']; ?> searches</span>
                        </div>
                        <button type="button" class="btn btn-secondary view-details"
                            data-type="most"
                            data-name="<?php echo htmlspecialchars($car['name']); ?>"
                            data-brand="<?php echo htmlspecialchars($car['brand']); ?>"
                            data-image="<?php echo htmlspecialchars($car['image_url']); ?>"
                            data-price="<?php echo htmlspecialchars($car['price_range']); ?>"
                            data-search-count="<?php echo htmlspecialchars($car['search_count']); ?>"
                        >View Details</button>
                    </div>
                </div>
                <?php endwhile; ?>
            </div>
        </div>
    </section>

    <!-- Latest Cars Section -->
    <section class="latest-cars-section" id="latest">
        <div class="container">
            <div class="section-header">
                <h2>Latest Cars</h2>
                <p>Recently launched cars in the market</p>
            </div>
            <div class="cars-grid">
                <?php while($car = $latest_cars->fetch_assoc()): ?>
                <div class="car-card">
                    <div class="car-image">
                        <img src="<?php echo $car['image_url']; ?>" alt="<?php echo $car['name']; ?>">
                        <span class="new-badge">NEW</span>
                    </div>
                    <div class="car-info">
                        <div class="car-brand"><?php echo $car['brand']; ?></div>
                        <h3><?php echo $car['name']; ?></h3>
                        <p class="car-description"><?php echo $car['description']; ?></p>
                        <div class="car-price"><?php echo $car['price']; ?></div>
                        <button type="button" class="btn btn-secondary view-details"
                            data-type="latest"
                            data-name="<?php echo htmlspecialchars($car['name']); ?>"
                            data-brand="<?php echo htmlspecialchars($car['brand']); ?>"
                            data-image="<?php echo htmlspecialchars($car['image_url']); ?>"
                            data-price="<?php echo htmlspecialchars($car['price']); ?>"
                            data-description="<?php echo htmlspecialchars($car['description']); ?>"
                            data-launch="<?php echo htmlspecialchars($car['launch_date']); ?>"
                        >View Details</button>
                    </div>
                </div>
                <?php endwhile; ?>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer" id="contact">
        <div class="container">
            <div class="footer-content">
                <div class="footer-col">
                    <h3><?php echo $header['logo_text']; ?></h3>
                    <p><?php echo $footer['about_text']; ?></p>
                    <div class="social-links">
                        <?php if($footer['facebook_url']): ?>
                        <a href="<?php echo $footer['facebook_url']; ?>"><i class="fab fa-facebook"></i></a>
                        <?php endif; ?>
                        <?php if($footer['twitter_url']): ?>
                        <a href="<?php echo $footer['twitter_url']; ?>"><i class="fab fa-twitter"></i></a>
                        <?php endif; ?>
                        <?php if($footer['instagram_url']): ?>
                        <a href="<?php echo $footer['instagram_url']; ?>"><i class="fab fa-instagram"></i></a>
                        <?php endif; ?>
                        <?php if($footer['youtube_url']): ?>
                        <a href="<?php echo $footer['youtube_url']; ?>"><i class="fab fa-youtube"></i></a>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="footer-col">
                    <h4>Quick Links</h4>
                    <ul>
                        <li><a href="#home">Home</a></li>
                        <li><a href="#most-searched">Most Searched</a></li>
                        <li><a href="#latest">Latest Cars</a></li>
                        <li><a href="#contact">Contact</a></li>
                    </ul>
                </div>
                <div class="footer-col">
                    <h4>Contact Us</h4>
                    <ul class="contact-info">
                        <li><i class="fas fa-phone"></i> <?php echo $header['phone']; ?></li>
                        <li><i class="fas fa-envelope"></i> <?php echo $header['email']; ?></li>
                        <li><i class="fas fa-map-marker-alt"></i> <?php echo $footer['address']; ?></li>
                    </ul>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; <?php echo date('Y'); ?> <?php echo $header['logo_text']; ?>. All rights reserved.</p>
            </div>
        </div>
    </footer>

    <!-- Details Modal -->
    <div id="detailsModal" class="details-modal" aria-hidden="true">
        <div class="details-modal-content" role="dialog" aria-modal="true" aria-labelledby="detailsTitle">
            <button class="details-modal-close" aria-label="Close">&times;</button>
            <div class="details-grid">
                <div class="modal-image">
                    <img src="" alt="" id="modalImage">
                </div>
                <div class="modal-body">
                    <h3 id="detailsTitle" class="modal-name"></h3>
                    <p class="modal-brand" id="modalBrand"></p>
                    <p class="modal-price" id="modalPrice"></p>
                    <p class="modal-extra" id="modalExtra"></p>
                    <p class="modal-description" id="modalDescription"></p>
                </div>
            </div>
        </div>
    </div>

    <script src="assets/js/script.js"></script>
</body>
</html>
<?php $conn->close(); ?>