

CREATE DATABASE IF NOT EXISTS carsdekho_db;
USE carsdekho_db;


CREATE TABLE IF NOT EXISTS admin_users (
    id INT PRIMARY KEY AUTO_INCREMENT,
    username VARCHAR(50) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    email VARCHAR(100),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);


INSERT INTO admin_users (username, password, email) VALUES 
('admin', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin@carsdekho.com');

CREATE TABLE IF NOT EXISTS header_settings (
    id INT PRIMARY KEY AUTO_INCREMENT,
    logo_text VARCHAR(100) NOT NULL,
    phone VARCHAR(20),
    email VARCHAR(100),
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

INSERT INTO header_settings (logo_text, phone, email) VALUES 
('CarsDekho', '+91-1234567890', 'info@carsdekho.com');


CREATE TABLE IF NOT EXISTS banners (
    id INT PRIMARY KEY AUTO_INCREMENT,
    title VARCHAR(200) NOT NULL,
    subtitle VARCHAR(300),
    image_url VARCHAR(500) NOT NULL,
    link_url VARCHAR(500),
    display_order INT DEFAULT 0,
    is_active TINYINT(1) DEFAULT 1,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

INSERT INTO banners (title, subtitle, image_url, link_url, display_order) VALUES
('Find Your Dream Car', 'Browse through thousands of verified cars', 'https://images.unsplash.com/photo-1492144534655-ae79c964c9d7?w=1200', '#', 1),
('Best Deals on Used Cars', 'Get the best prices and certified quality', 'https://images.unsplash.com/photo-1549317661-bd32c8ce0db2?w=1200', '#', 2);

-- Most Searched Cars Table
CREATE TABLE IF NOT EXISTS most_searched_cars (
    id INT PRIMARY KEY AUTO_INCREMENT,
    name VARCHAR(100) NOT NULL,
    brand VARCHAR(50) NOT NULL,
    image_url VARCHAR(500) NOT NULL,
    price_range VARCHAR(50),
    search_count INT DEFAULT 0,
    display_order INT DEFAULT 0,
    is_active TINYINT(1) DEFAULT 1,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

INSERT INTO most_searched_cars (name, brand, image_url, price_range, search_count, display_order) VALUES
('Maruti Swift', 'Maruti Suzuki', 'https://images.unsplash.com/photo-1583121274602-3e2820c69888?w=400', '₹5.9 - 8.8 Lakh', 1500, 1),
('Hyundai Creta', 'Hyundai', 'https://images.unsplash.com/photo-1581540222194-0def2dda95b8?w=400', '₹10.4 - 18.7 Lakh', 1200, 2),
('Tata Nexon', 'Tata', 'https://images.unsplash.com/photo-1609521263047-f8f205293f24?w=400', '₹7.8 - 14.5 Lakh', 1100, 3),
('Honda City', 'Honda', 'https://images.unsplash.com/photo-1612825173281-9a193378527e?w=400', '₹11.8 - 15.3 Lakh', 900, 4);

-- Latest Cars Table
CREATE TABLE IF NOT EXISTS latest_cars (
    id INT PRIMARY KEY AUTO_INCREMENT,
    name VARCHAR(100) NOT NULL,
    brand VARCHAR(50) NOT NULL,
    image_url VARCHAR(500) NOT NULL,
    price VARCHAR(50) NOT NULL,
    launch_date DATE,
    description TEXT,
    display_order INT DEFAULT 0,
    is_active TINYINT(1) DEFAULT 1,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

INSERT INTO latest_cars (name, brand, image_url, price, launch_date, description, display_order) VALUES
('Mahindra XUV700', 'Mahindra', 'https://images.unsplash.com/photo-1617814076367-b759c7d7e738?w=400', '₹13.4 - 24.9 Lakh', '2024-01-15', 'Feature-packed SUV with advanced technology', 1),
('Kia Seltos', 'Kia', 'https://images.unsplash.com/photo-1617886903355-9354bb57751f?w=400', '₹10.9 - 19.6 Lakh', '2024-02-10', 'Stylish compact SUV with premium features', 2),
('MG Hector', 'MG Motor', 'https://images.unsplash.com/photo-1605559424843-9e4c228bf1c2?w=400', '₹14.7 - 21.9 Lakh', '2024-01-20', 'Smart connected SUV with spacious interiors', 3),
('Hyundai Venue', 'Hyundai', 'https://images.unsplash.com/photo-1552519507-da3b142c6e3d?w=400', '₹7.9 - 13.5 Lakh', '2024-03-05', 'Compact SUV perfect for city driving', 4);

-- Footer Settings Table
CREATE TABLE IF NOT EXISTS footer_settings (
    id INT PRIMARY KEY AUTO_INCREMENT,
    about_text TEXT,
    facebook_url VARCHAR(200),
    twitter_url VARCHAR(200),
    instagram_url VARCHAR(200),
    youtube_url VARCHAR(200),
    address TEXT,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

INSERT INTO footer_settings (about_text, facebook_url, twitter_url, instagram_url, youtube_url, address) VALUES
('CarsDekho is India\'s leading car search platform. Find new and used cars from certified dealers.', 
'https://facebook.com', 'https://twitter.com', 'https://instagram.com', 'https://youtube.com',
'123 Main Street, New Delhi, India 110001');