
const hamburger = document.querySelector('.hamburger');
const navMenu = document.querySelector('.nav-menu');

if (hamburger) {
    hamburger.addEventListener('click', () => {
        navMenu.classList.toggle('active');
    });
}


let currentSlide = 0;
const slides = document.querySelectorAll('.banner-slide');
const prevBtn = document.querySelector('.prev-btn');
const nextBtn = document.querySelector('.next-btn');

function showSlide(n) {
    slides.forEach(slide => slide.classList.remove('active'));
    
    if (n >= slides.length) {
        currentSlide = 0;
    }
    if (n < 0) {
        currentSlide = slides.length - 1;
    }
    
    if (slides[currentSlide]) {
        slides[currentSlide].classList.add('active');
    }
}

function nextSlide() {
    currentSlide++;
    showSlide(currentSlide);
}

function prevSlide() {
    currentSlide--;
    showSlide(currentSlide);
}


if (slides.length > 0) {
    showSlide(currentSlide);
    
  
    setInterval(nextSlide, 5000);
}


if (nextBtn) {
    nextBtn.addEventListener('click', nextSlide);
}

if (prevBtn) {
    prevBtn.addEventListener('click', prevSlide);
}


document.querySelectorAll('a[href^="#"]').forEach(anchor => {
    anchor.addEventListener('click', function (e) {
        e.preventDefault();
        const target = document.querySelector(this.getAttribute('href'));
        if (target) {
            target.scrollIntoView({
                behavior: 'smooth',
                block: 'start'
            });
            
            navMenu.classList.remove('active');
        }
    });
});


(function(){
    const modal = document.getElementById('detailsModal');
    if (!modal) return;

    const modalImage = document.getElementById('modalImage');
    const modalName = document.querySelector('.modal-name');
    const modalBrand = document.getElementById('modalBrand');
    const modalPrice = document.getElementById('modalPrice');
    const modalExtra = document.getElementById('modalExtra');
    const modalDescription = document.getElementById('modalDescription');
    const closeBtn = modal.querySelector('.details-modal-close');

    function openModalFromButton(btn) {
        const d = btn.dataset;
        modalImage.src = d.image || '';
        modalImage.alt = d.name || '';
        modalName.textContent = d.name || '';
        modalBrand.textContent = d.brand ? 'Brand: ' + d.brand : '';
        modalPrice.textContent = d.price ? (d.type === 'most' ? 'Price Range: ' + d.price : 'Price: ' + d.price) : '';
        if (d.type === 'most') {
            modalExtra.textContent = d.searchCount ? (d.searchCount + ' searches') : '';
            modalDescription.textContent = '';
        } else {
            modalExtra.textContent = d.launch ? ('Launch: ' + d.launch) : '';
            modalDescription.textContent = d.description || '';
        }

        modal.classList.add('open');
        modal.setAttribute('aria-hidden', 'false');
     
    }

    document.addEventListener('click', function(e){
        const btn = e.target.closest('.view-details');
        if (btn) {
            e.preventDefault();
            openModalFromButton(btn);
        }
    });

    closeBtn.addEventListener('click', function(){
        modal.classList.remove('open');
        modal.setAttribute('aria-hidden', 'true');
    });

   
    modal.addEventListener('click', function(e){
        if (e.target === modal) {
            modal.classList.remove('open');
            modal.setAttribute('aria-hidden', 'true');
        }
    });

   
    document.addEventListener('keydown', function(e){
        if (e.key === 'Escape' && modal.classList.contains('open')) {
            modal.classList.remove('open');
            modal.setAttribute('aria-hidden', 'true');
        }
    });
})();